DELIMITER $$
DROP PROCEDURE IF EXISTS V20250520174119__Create_payment_plan_interest_calculation $$
CREATE PROCEDURE V20250520174119__Create_payment_plan_interest_calculation()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='payment_plan_interest_calculation')) THEN 
CREATE TABLE payment_plan_interest_calculation (
id bigint(20) NOT NULL AUTO_INCREMENT,
totalOutstandingAmount  double(20,3) DEFAULT NULL,
studentId bigint(20) DEFAULT NULL,
billHeaderId bigint(20) DEFAULT NULL,
paymentPlanScheduleId bigint(20) DEFAULT NULL,  
creationDateTime datetime DEFAULT NULL,
lastUpdatedBy bigint(20) NOT NULL,
lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP ,
PRIMARY KEY (id),


CONSTRAINT `FK_payment_plan_interest_calculation_FK_studentId` FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`),
CONSTRAINT `FK_payment_plan_interest_calculation_FK_billHeaderId` FOREIGN KEY (`billHeaderId`) REFERENCES `bill_header` (`id`),
CONSTRAINT `FK_payment_plan_interest_calculation_FK_paymentPlanScheduleId` FOREIGN KEY (`paymentPlanScheduleId`) REFERENCES `payment_plan_schedule` (`id`),
CONSTRAINT `FK_payment_plan_interest_calculation_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) ;
END IF; 

END $$
CALL V20250520174119__Create_payment_plan_interest_calculation () $$ 
DROP PROCEDURE IF EXISTS V20250520174119__Create_payment_plan_interest_calculation $$ 
DELIMITER ;