DELIMITER $$
DROP PROCEDURE IF EXISTS V20250520190415__Alter_ProgramWithdrawlMultipleReason $$
CREATE PROCEDURE V20250520190415__Alter_ProgramWithdrawlMultipleReason()
BEGIN

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.COLUMNS 
    WHERE TABLE_SCHEMA = DATABASE() 
      AND TABLE_NAME = 'program_withdrawl_request_multiple_reason' 
      AND COLUMN_NAME = 'programWithdrawalReasonCsmId'
) THEN
    ALTER TABLE program_withdrawl_request_multiple_reason
    ADD COLUMN programWithdrawalReasonCsmId BIGINT DEFAULT NULL;
END IF;

IF NOT EXISTS (
    SELECT * 
    FROM information_schema.referential_constraints 
    WHERE constraint_schema = DATABASE() 
      AND TABLE_NAME = 'program_withdrawl_request_multiple_reason' 
      AND CONSTRAINT_NAME = 'fk_reason_for_withdrawal_from_program'
) THEN
    ALTER TABLE program_withdrawl_request_multiple_reason
    ADD CONSTRAINT fk_reason_for_withdrawal_from_program FOREIGN KEY (programWithdrawalReasonCsmId) REFERENCES reason_for_withdrawal_from_program(id);
END IF; 

INSERT IGNORE INTO reason_for_withdrawal_from_program (id, itemCode, itemValue, withdrawalFromActiveProgram, lastUpdatedBy,lastUpdate)
select dd.id,name,value,b'1',1,now() from drop_down  dd
join program_withdrawl_request_multiple_reason AS strmr on strmr.programWithdrawlReasonId=dd.id group by dd.id;

SET SQL_SAFE_UPDATES=0;
UPDATE program_withdrawl_request_multiple_reason AS strmr
JOIN program_withdrawl_request_multiple_reason AS strmrself
ON strmrself.programWithdrawlRequestDetailId = strmr.programWithdrawlRequestDetailId
SET strmr.programWithdrawalReasonCsmId = strmrself.programWithdrawlReasonId;
SET SQL_SAFE_UPDATES=1;

END $$
CALL V20250520190415__Alter_ProgramWithdrawlMultipleReason() $$
DROP PROCEDURE IF EXISTS V20250520190415__Alter_ProgramWithdrawlMultipleReason $$
DELIMITER ;