DELIMITER $$
DROP PROCEDURE IF EXISTS getHESAModuleEntryDetails $$
CREATE PROCEDURE getHESAModuleEntryDetails(IN programId BIGINT, IN academicTermId BIGINT)
BEGIN

SELECT 
    p.id AS pid,
    ats.id AS atsId,
    c.courseCode AS MODID,
    c.courseCredits AS CRDTPTS,
    cc.categoryName AS CRDTSCM,
    c.moduleHEQSFLevel AS FTE,
    cnl.itemCode AS LEVLPTS,
    c.courseName AS MTITLE,
    d.shortCode AS COSTCN,
    cd.weightage AS COSTCNPROPORTION,
    cmm.weightage AS MODPROPORTION,
    hs.itemCode AS MODSBJ
FROM
    program_courses_period pcp
    LEFT JOIN program_courses pc ON pcp.programCourseId = pc.id
    LEFT JOIN prog_batch_period_config pbpc ON pcp.periodId = pbpc.id
    LEFT JOIN academic_term ats ON pbpc.academicTermId = ats.id
    LEFT JOIN batches b ON pc.programBatchId = b.id
    LEFT JOIN programs p ON b.programId = p.id
    LEFT JOIN courses c ON pc.courseId = c.id
    LEFT JOIN course_nqf_level cnl ON c.courseNQFLevelId = cnl.id
    LEFT JOIN course_category cc ON c.courseCategoryId = cc.id
    LEFT JOIN courses_departments cd ON c.id = cd.courseId
    LEFT JOIN department d ON cd.departmentId = d.id
    LEFT JOIN course_module_mapping cmm ON c.id = cmm.courseId
    LEFT JOIN hesa_subject hs ON cmm.hesaSubjectId = hs.id
WHERE
    p.id IN (programId)
    AND ats.id IN (academicTermId)
GROUP BY 
     c.id,d.id,cmm.id;

END $$ 
DELIMITER ;