DELIMITER $$
DROP PROCEDURE IF EXISTS V20250609160251__Insert_IdentityDocumentDataGrid $$
CREATE PROCEDURE V20250609160251__Insert_IdentityDocumentDataGrid()
BEGIN
    IF NOT EXISTS (
        SELECT 1 
        FROM data_grid 
        WHERE gridName = 'Academia.view.personinfo.common.personalinfo.IdentityDetailsGrid' 
        AND portalId = 1
    ) THEN
        INSERT INTO data_grid (
            gridName, portalId, jsonObject, lastUpdate, lastUpdatedBy
        )
        VALUES (
            'Academia.view.personinfo.common.personalinfo.IdentityDetailsGrid',
            1,
            '[
                {"id":null,"columnName":"ID_TYPE","dataIndex":"identityType","columnVisibility":"SHOW","sequence":1,"mandatory":false},
                {"id":null,"columnName":"ID_NUMBER","dataIndex":"idNumber","columnVisibility":"SHOW","sequence":2,"mandatory":false},
                {"id":null,"columnName":"ISSUING_AUTHORITY","dataIndex":"issuingAuthority","columnVisibility":"SHOW","sequence":3,"mandatory":false},
                {"id":null,"columnName":"COUNTRY_NAME","dataIndex":"country","columnVisibility":"SHOW","sequence":4,"mandatory":false},
                {"id":null,"columnName":"ISSUED_PLACE","dataIndex":"issuedPlace","columnVisibility":"SHOW","sequence":5,"mandatory":false},
                {"id":null,"columnName":"ISSUED_DATE","dataIndex":"studentIssuedDate","columnVisibility":"SHOW","sequence":6,"mandatory":false},
                {"id":null,"columnName":"VALIDTILL_DATE","dataIndex":"studentValidTillDate","columnVisibility":"SHOW","sequence":7,"mandatory":false},
                {"id":null,"columnName":"ACTUAL_FOLLOW_UP_DATE","dataIndex":"studentActualFollowUpDate","columnVisibility":"SHOW","sequence":8,"mandatory":false},
                {"id":null,"columnName":"DOCUMENT","dataIndex":"documents","columnVisibility":"SHOW","sequence":9,"mandatory":false},
                {"id":null,"columnName":"IDENTITY_TYPE_URL","dataIndex":"documentUrl","columnVisibility":"SHOW","sequence":10,"mandatory":false}
            ]',
            NOW(),
            1
        );
    END IF;
END $$
CALL V20250609160251__Insert_IdentityDocumentDataGrid() $$
DROP PROCEDURE IF EXISTS V20250609160251__Insert_IdentityDocumentDataGrid $$
DELIMITER ;