DELIMITER $$
DROP PROCEDURE IF EXISTS getHESAStudentPhaseTwo $$
CREATE PROCEDURE getHESAStudentPhaseTwo(IN programId BIGINT, IN academicTermId BIGINT)
BEGIN

	WITH OneThesis AS (
	    SELECT *
	    FROM (
		        SELECT stt.*,
	       		ROW_NUMBER() OVER (PARTITION BY stt.personId, stt.programId ORDER BY stt.id) AS rn
				FROM student_thesis_title stt
	    ) sub
	    WHERE rn = 1
	),
	
	Phd AS (
	    SELECT *
	    FROM (
		        SELECT stt.*,
	       		ROW_NUMBER() OVER (PARTITION BY stt.personId ORDER BY stt.id) AS rn
				FROM post_doc_info stt
	    ) sub
	    WHERE rn = 1
	)
	
    SELECT DISTINCT
	 ad.Code As ADMISSIONCODE,
	 pbpc.programPeriodName AS SCSESSIONID,
	 pg.programCode AS COURSEID,
	 mody.itemCode AS SCSMODE,
	 pbpc.programPeriodStart AS SCSSTARTDATE,
     uoa.itemCode AS REF2021UNITOFASSESSMENT, 
     tab.itemCode AS SUPALLHESAID ,
     stt.supervisorIdentifier AS SUPALLID ,
     stt.supervisorProportion AS SUPALLPROP,
     apf.itemCode AS APPSPEND,
     fs.financialSupportAmount AS FINSUPAMOUNT,
     fst.itemCode AS FINSUPTYPE,
     dd.name AS STUINITID,
     ##################################### new
     ctry.code AS PERMADDCOUNTRY,
     ebm.itemCode AS PREVIOUSPROVIDER,
     ##################################### Student Course Session
     # pg.programCode AS SCSESSIONID,
     stt.title AS INTENDEDTHESISTITLE,
	 # pg.programCode AS INTERCALATION,
	 ph.doctorateObtainedDate AS PHDSUB,
	 programPhase.itemCode AS PLACEMENT,
	 periodYear.itemCode AS SESSIONYEARID,
     #####################################
     DATEDIFF(campus.startDate, campus.endDate) AS ACTDURATION,
     adt.itemCode AS ACTDURATIONTYPE,
       campus.startDate AS ACTSTARTDATE,
       campus.endDate AS  ACTENDDATE,
       ati.itemCode AS ACTTYPEID,
       cc.countryName AS COUNTRY,
       hosti.itemCode AS HOSTID,
       hit.itemCode AS HOSTIDTYPE,
       mobSch.itemCode AS MOBSCHEME,
       campus.moduleInstanceIdentifier AS MODINSTID,
       campus.campusCode AS OVAID,
       #####################################
       bill.totalAmountSum AS INVOICEFEEAMOUNT
     from
    program_batch_students pbs 
    LEFT JOIN prog_batch_period_config pbpc on pbs.progBatchPeriodConfigId=pbpc.id
    LEFT JOIN batches bs on pbpc.programBatchId=bs.id
    LEFT JOIN programs pg on bs.programId=pg.id
    LEFT JOIN mode_of_delivery mody ON bs.modeOfDeliveryId = mody.id
    LEFT JOIN academic_term ats on pbpc.academicTermId=ats.id
    LEFT JOIN admission ad on pbs.admissionId-ad.id
    LEFT JOIN students st on ad.studentId=st.userId
    LEFT JOIN persons ps on st.personId=ps.id
    
    LEFT JOIN OneThesis stt on pg.id=stt.programId and st.personId=stt.personId
    LEFT JOIN unit_of_assessment uoa on stt.unitOfAssessmentId=uoa.id
    LEFT JOIN thesis_approval_body tab on stt.approvalBody=tab.id
    LEFT JOIN financial_support fs on pg.id= fs.programId and st.userId=fs.studentId
    LEFT JOIN access_and_participation_flag apf on fs.accessAndParticipantFlagId=apf.id
    LEFT JOIN financial_support_type fst on fs.financialSupportTypeId=fst.id
    LEFT JOIN drop_down dd on ps.fieldOfInterest=dd.id and dd.type='fieldOfInterest'
    
    LEFT JOIN person_addresses pad ON ps.id = pad.personId AND pad.whetherDeleted = 0
    LEFT JOIN address addr ON pad.addressId = addr.id
    LEFT JOIN country ctry ON addr.countryId = ctry.id
    
    LEFT JOIN education_histories eh ON eh.personId = ps.id AND eh.whetherDeleted = 0
    LEFT JOIN exam_board_master ebm ON ebm.id = eh.examBoardId
    
    left join program_phase programPhase on programPhase.id=pg.programPhaseId
    left join period_year periodYear on periodYear.id=pbpc.periodYearId
    
    left join Phd ph on ph.personId=ps.id
    
    LEFT JOIN placement_type pts on pbpc.placementTypeId=pts.id
    LEFT JOIN placement_campus campus on pts.id=campus.placementTypeId
    LEFT JOIN activity_duration_type adt on campus.activityDurationTypeId=adt.id
    LEFT JOIN activity_type_identifier ati on campus.activityTypeIdentifierId=ati.id
    LEFT JOIN host_identifier hosti on campus.hostIdentifierId=hosti.id
    LEFT JOIN host_identifier_type hit on campus.hostIdentifierTypeId=hit.id
    LEFT JOIN mobile_scheme mobSch on campus.mobileSchemeId=mobSch.id
    LEFT JOIN country cc on campus.countryId=cc.id
    left join (
    SELECT 
        bh.admissionId,
        SUM(bh.totalAmount) AS totalAmountSum
    FROM 
        student_course_enrollment sce
    JOIN 
        bill_header bh ON sce.billId = bh.id
    GROUP BY 
        bh.admissionId
	) bill ON ad.id = bill.admissionId
    
    WHERE pbpc.academicTermId = academicTermId 
    AND pg.id = programId 
    And pbs.isCurrentPeriod = 1 AND pbs.isCurrentSection = 1 AND pbs.exitDate IS NULL AND ad.activeStatus is true
    GROUP BY ad.id,pg.id;

END $$ 
DELIMITER ;