DELIMITER $$
DROP PROCEDURE IF EXISTS V20251009122132__Alter_AlterAwardMappig $$
CREATE PROCEDURE V20251009122132__Alter_AlterAwardMappig()
BEGIN

-- ========================
-- STEP 1: Drop old foreign key if exists
-- ========================
IF EXISTS (
    SELECT * FROM information_schema.REFERENTIAL_CONSTRAINTS
    WHERE CONSTRAINT_SCHEMA = DATABASE()
      AND CONSTRAINT_NAME = 'FK_progrma_group_finance'
      AND TABLE_NAME = 'program_completion_award_finance_mapping'
) THEN
    ALTER TABLE program_completion_award_finance_mapping
    DROP FOREIGN KEY FK_progrma_group_finance;
END IF;

-- ========================
-- STEP 2: Drop old index if exists
-- ========================
IF EXISTS (
    SELECT * FROM information_schema.statistics
    WHERE table_schema = DATABASE()
      AND table_name = 'program_completion_award_finance_mapping'
      AND index_name = 'FK_progrma_group_finance_idx'
) THEN
    ALTER TABLE program_completion_award_finance_mapping
    DROP INDEX FK_progrma_group_finance_idx;
END IF;

-- ========================
-- STEP 3: Rename column programGroupFinanceId → programCategoryId
-- ========================
IF EXISTS (
    SELECT * FROM information_schema.columns
    WHERE table_schema = DATABASE()
      AND table_name = 'program_completion_award_finance_mapping'
      AND column_name = 'programGroupFinanceId'
) THEN
    ALTER TABLE program_completion_award_finance_mapping
    CHANGE COLUMN programGroupFinanceId programCategoryId BIGINT(20) NOT NULL;
END IF;

-- ========================
-- STEP 4: Add new index if missing
-- ========================
IF NOT EXISTS (
    SELECT * FROM information_schema.statistics
    WHERE table_schema = DATABASE()
      AND table_name = 'program_completion_award_finance_mapping'
      AND index_name = 'FK_program_category_idx'
) THEN
    ALTER TABLE program_completion_award_finance_mapping
    ADD INDEX FK_program_category_idx (programCategoryId);
END IF;

-- ========================
-- STEP 5: Add new foreign key to program_category
-- ========================
IF NOT EXISTS (
    SELECT * FROM information_schema.REFERENTIAL_CONSTRAINTS
    WHERE CONSTRAINT_SCHEMA = DATABASE()
      AND CONSTRAINT_NAME = 'FK_program_category'
      AND TABLE_NAME = 'program_completion_award_finance_mapping'
) THEN
    ALTER TABLE program_completion_award_finance_mapping
    ADD CONSTRAINT FK_program_category
        FOREIGN KEY (programCategoryId)
        REFERENCES program_category (id)
        ON DELETE RESTRICT
        ON UPDATE RESTRICT;
END IF;


END $$
CALL V20251009122132__Alter_AlterAwardMappig() $$
DROP PROCEDURE IF EXISTS V20251009122132__Alter_AlterAwardMappig $$
DELIMITER ;