DELIMITER $$
DROP PROCEDURE IF EXISTS V20251023191202__Update_OfferLetterExpiryDate $$
CREATE PROCEDURE V20251023191202__Update_OfferLetterExpiryDate()
BEGIN
SET SQL_SAFE_UPDATES=0;

IF EXISTS ((select * from `dydt_data_line_item` where `dataSourceCode` = 'OFFER_LETTER_EXPIRY_DATE')) THEN 
SET @dydtDataLineItemId = (select id from `dydt_data_line_item` where `dataSourceCode` = 'OFFER_LETTER_EXPIRY_DATE');

UPDATE `dydt_data_line_item` 
SET `sqlSelectQueryDef`=
"SELECT 
    DATE_FORMAT(apd.expiryDate, '%e %b %Y') AS offer_exp_date,
    DATE_FORMAT(pp.admissionOfferStartDate, '%e %b %Y') AS offer_letter_start_date,
    pp.offerLetterAcceptDaysLimit AS offer_letter_accept_day_limit,
    DATE_FORMAT(ap.offerLetterIssueDate, '%e %b %Y') AS offer_letter_issue_date,
    
    -- Calculated expiry date logic
    DATE_FORMAT(
        LEAST(
            apd.expiryDate,
            DATE_ADD(ap.offerLetterIssueDate, INTERVAL pp.offerLetterAcceptDaysLimit DAY)
        ), 
        '%e %b %Y'
    ) AS calculated_expire_date

FROM prog_slctn_process_admisn_conf AS pp
LEFT JOIN program_selection_process AS psp 
    ON pp.programSelectionProcessId = psp.id
LEFT JOIN application_program AS ap 
    ON ap.progBatchSeatConfigId = psp.programBatchSeatConfigId
LEFT JOIN application_program_detail AS apd 
    ON apd.applicationProgramId = ap.id
", 
`resultColumnsDef`='offer_exp_date,offer_letter_start_date,offer_letter_end_date, calculated_expire_date'
WHERE `id` = @dydtDataLineItemId;

IF NOT EXISTS ((select * from `dydt_templateparams_translations` where `translationCode` = 'calculated_expire_date')) THEN
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`, `dataProviderLineItemId`) 
VALUES ('calculated_expire_date', 'Calculated expiry date', @dydtDataLineItemId);
END IF;

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251023191202__Update_OfferLetterExpiryDate () $$
DROP PROCEDURE IF EXISTS V20251023191202__Update_OfferLetterExpiryDate $$
DELIMITER ;