DELIMITER $$
DROP PROCEDURE IF EXISTS V20251107104236__Update_StudentMedicalDetailsDataProvider $$
CREATE PROCEDURE V20251107104236__Update_StudentMedicalDetailsDataProvider()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT 1 FROM dydt_data_line_item WHERE dataSourceCode='STUDENT_MEDICAL_CONDITION_INFO')) THEN 
update dydt_data_line_item set  sqlSelectQueryDef = 'SELECT 
        mct.itemCode as CONDITION_TYPE,
        mh.medicalCondition as MEDICAL_CONDITION,
        mh.remarks AS PRECAUTION_MEDICATION
 FROM admission adm 
    LEFT JOIN users u 
         ON u.id=adm.studentId
    LEFT JOIN students stud 
         ON stud.userId=u.id
    LEFT JOIN  medical_history mh 
         ON mh.personId = stud.personId
    LEFT JOIN  medical_condition_types mct 
         ON mct.id = mh.medicalConditonId'

where dataSourceCode='STUDENT_MEDICAL_CONDITION_INFO';

END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20251107104236__Update_StudentMedicalDetailsDataProvider () $$
DROP PROCEDURE IF EXISTS V20251107104236__Update_StudentMedicalDetailsDataProvider $$
DELIMITER ;