-- add a new table leave_status
CREATE TABLE `leave_status` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `leaveStatus` VARCHAR(45) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_new_table_userid_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_new_table_userid`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
   
-- standard master entry for leave status
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO standard_master(`id`, `tableName`, `masterName`, `whetherChild`, `whetherParent`,`lastUpdatedBy`, `lastUpdate`)
 VALUES (@standardMasterMaxId + 1, 'leave_status', 'LEAVE_STATUS', 0, 0, '1', SYSDATE());


SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
VALUES ('leaveStatus', 'LEAVE_STATUS', @standardMasterMaxId + 1, 'varchar', '1', 0, 0, 0, 1, '1', SYSDATE());

-- some default value in leave status
INSERT INTO `leave_status` (`leaveStatus`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('Applied', sysdate(), '1');

INSERT INTO `leave_status` (`leaveStatus`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('Approved', sysdate(), '1');


INSERT INTO `leave_status` (`leaveStatus`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('Rejected', sysdate(), '1');


INSERT INTO `leave_status` (`leaveStatus`, `lastUpdate`, `lastUpdatedBy`)
VALUES ('Unauthorized Absence', sysdate(), '1');

 


-- drop the column facultyId and admissionId

ALTER TABLE `leave_report`
DROP FOREIGN KEY `fk_leave_report_facultyId`,
DROP FOREIGN KEY `fk_leave_report_admissionId`,
DROP COLUMN `admissionId`,
DROP COLUMN `facultyId`,
DROP INDEX `fk_leave_report_admissionId_idx` ,
DROP INDEX `fk_leave_report_facultyId_idx` ;


-- add a new column personId and userGroupId

ALTER TABLE `leave_report`
ADD COLUMN `personId` BIGINT(20) NOT NULL AFTER `sectionId`,
ADD COLUMN `userGroupId` BIGINT(20) NOT NULL AFTER `sectionId`;


-- make a FOREIGN key

ALTER TABLE `leave_report`
ADD CONSTRAINT `fk_leave_report_personId`
  FOREIGN KEY (`personId`)
  REFERENCES `persons` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_leave_report_userGroupId`
  FOREIGN KEY (`userGroupId`)
  REFERENCES `user_groups` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

  -- change the column leaveStatus(varchar) to leaveStatusId(FK long)
  ALTER TABLE `leave_report`
    CHANGE COLUMN `leaveStatus` `leaveStatusId` BIGINT(20) NOT NULL ,
    ADD INDEX `fk_leave_report_leaveStatus_idx` (`leaveStatusId` ASC);
ALTER TABLE `leave_report`
ADD CONSTRAINT `fk_leave_report_leaveStatus`
  FOREIGN KEY (`leaveStatusId`)
  REFERENCES `leave_status` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;