ALTER TABLE `payment_header` 
DROP FOREIGN KEY `Refbill_header1545`;
ALTER TABLE `payment_header` 
DROP COLUMN `toBeDeleted`,
DROP COLUMN `billId`,
CHANGE COLUMN `integratedWithTally` `integratedWithTally` BIT(1) NULL AFTER `transactionDate`,
CHANGE COLUMN `tallyVoucherId` `tallyVoucherId` INT(11) NULL ,
ADD COLUMN `sponsorId` BIGINT(20) NULL DEFAULT NULL AFTER `tallyVoucherId`,
ADD COLUMN `applicantId` BIGINT(20) NULL DEFAULT NULL AFTER `sponsorId`,
ADD COLUMN `thirdPartyId` BIGINT(20) NULL DEFAULT NULL AFTER `applicantId`,
ADD COLUMN `userId` BIGINT(20) NULL DEFAULT NULL AFTER `thirdPartyId`,
ADD COLUMN `studentId` BIGINT(20) NULL DEFAULT NULL AFTER `userId`,
ADD COLUMN `paymentNo` VARCHAR(200) NOT NULL AFTER `studentId`,
ADD COLUMN `paymentUniqueNumber` INT(20) NOT NULL AFTER `paymentNo`,
ADD COLUMN `iauId` BIGINT(20) NULL DEFAULT NULL AFTER `paymentUniqueNumber`,
ADD COLUMN `currencyId` BIGINT(20) NULL DEFAULT NULL AFTER `iauId`,
ADD COLUMN `amount` DOUBLE NULL DEFAULT NULL AFTER `currencyId`,
ADD COLUMN `narration` TEXT NULL DEFAULT NULL AFTER `amount`,
ADD COLUMN `status` VARCHAR(80) NULL DEFAULT NULL AFTER `narration`,
ADD COLUMN `paymentBank` BIGINT(11) NULL DEFAULT NULL AFTER `status`,
ADD COLUMN `paymentCash` BIGINT(11) NULL DEFAULT NULL AFTER `paymentBank`,
ADD COLUMN `voucherMode` VARCHAR(45) NULL DEFAULT NULL AFTER `paymentCash`,
DROP INDEX `Refbill_header1545` ;

ALTER TABLE`payment_header` 
CHANGE COLUMN `integratedWithTally` `integratedWithTally` BIT(1) NOT NULL ;
ALTER TABLE `payment_header` 
CHANGE COLUMN `paymentNo` `paymentVoucherNo` VARCHAR(200) NOT NULL ;



ALTER TABLE `payment_header` 
CHANGE COLUMN `voucherMode` `voucherMode` VARCHAR(45) NULL DEFAULT NULL AFTER `integratedWithTally`,
ADD INDEX `Refuser6541_idx` (`userId` ASC),
ADD INDEX `Reffeethirdparties2341_idx` (`thirdPartyId` ASC),
ADD INDEX `Refcurrency34571_idx` (`currencyId` ASC);
ALTER TABLE `payment_header` 
ADD CONSTRAINT `Refuser6541`
  FOREIGN KEY (`userId`)
  REFERENCES `users` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `Refapplicaion3241`
  FOREIGN KEY (`applicantId`)
  REFERENCES `application` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `Reffeethirdparties2341`
  FOREIGN KEY (`thirdPartyId`)
  REFERENCES `fee_third_parties` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `Refcurrency34571`
  FOREIGN KEY (`currencyId`)
  REFERENCES `currency` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;


ALTER TABLE `payment_header` 
ADD INDEX `Refsponsor7567_idx` (`sponsorId` ASC),
ADD INDEX `Reforganizationunits3458_idx` (`iauId` ASC);
ALTER TABLE `payment_header` 
ADD CONSTRAINT `Refsponsor7567`
  FOREIGN KEY (`sponsorId`)
  REFERENCES `sponsors` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `Reforganizationunits3458`
  FOREIGN KEY (`iauId`)
  REFERENCES `organization_units` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;


ALTER TABLE `payment_header` 
CHANGE COLUMN `transactionDate` `transactionDate` DATE NOT NULL ,
CHANGE COLUMN `amount` `amount` DOUBLE NOT NULL ,
ADD UNIQUE INDEX `paymentVoucherNo_UNIQUE` (`paymentVoucherNo` ASC),
ADD UNIQUE INDEX `paymentUniqueNumber_UNIQUE` (`paymentUniqueNumber` ASC);





ALTER TABLE `receipt_payment_instrument` 
ADD COLUMN `paymentHeaderId` BIGINT(20) NULL AFTER `receiptHeaderId`,
ADD INDEX `Refpaymentheader5674_idx` (`paymentHeaderId` ASC);
ALTER TABLE `receipt_payment_instrument` 
ADD CONSTRAINT `Refpaymentheader5674`
  FOREIGN KEY (`paymentHeaderId`)
  REFERENCES `payment_header` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;


ALTER TABLE `payment_header` 
ADD INDEX `Refbank2342_idx` (`paymentBank` ASC),
ADD INDEX `Refcahsledger643_idx` (`paymentCash` ASC);
ALTER TABLE `payment_header` 
ADD CONSTRAINT `Refbank2342`
  FOREIGN KEY (`paymentBank`)
  REFERENCES `bank` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,
ADD CONSTRAINT `Refcahsledger643`
  FOREIGN KEY (`paymentCash`)
  REFERENCES `fee_ledger_master` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;