

DROP VIEW IF EXISTS `pnc_dashboard_program_with_vacants_seats`;
CREATE VIEW `pnc_dashboard_program_with_vacants_seats` AS 
select
    concat(academy_location.academyName, " - ", academy_location.locationName) as `AcademyLocation`,
    programs.programCode,
    academy_location.id as academyLocationId,
    programs.programName,
    batches.id,
    batches.batchName,
    batches.seatCapacity,
    (batches.seatCapacity - count(*)) seatVacant
from
    admission
left outer join
    batches on admission.batchId = batches.id
left outer join
    programs on batches.programId = programs.id
left outer join 
    academy_location on admission.academyLocationId = academy_location.id  -- added join
group by
    batchId;


DROP VIEW IF EXISTS `pnc_dashboard_top_and_bottom_program_absenteeism`;
CREATE VIEW `pnc_dashboard_top_and_bottom_program_absenteeism` AS
select 
        `programs`.`id` AS `programId`,
         concat(academy_location.academyName, " - ", academy_location.locationName) as `AcademyLocation`,  
        `batches`.`id` AS `batchId`,
        `programs`.`programCode` AS `programCode`,
        `programs`.`programNameToBePrint` AS `programNameToBePrint`,
        `batches`.`batchName` AS `batchName`,
        `sections`.`sectionCode` AS `sectionCode`,
        `student_attendance_dashboard_section_wise`.`academyLocationId` AS `academyLocationId`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `student_attendance_dashboard_section_wise`.`sectionId` AS `sectionId`,
        sum(`student_attendance_dashboard_section_wise`.`totalRecords`) AS `total`,
        sum(`student_attendance_dashboard_section_wise`.`presentRecords`) AS `present`,
        sum(`student_attendance_dashboard_section_wise`.`absentRecords`) AS `absent`,
        round(((sum(`student_attendance_dashboard_section_wise`.`presentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100),
                0) AS `presentPercent`,
        round(((sum(`student_attendance_dashboard_section_wise`.`absentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100),
                0) AS `absentPercent`
    from
        `student_attendance_dashboard_section_wise`
        left join `sections` ON `student_attendance_dashboard_section_wise`.`sectionId` = `sections`.`id`
        left join `prog_batch_period_config` ON `sections`.`periodId` = `prog_batch_period_config`.`id`
        left join `batches` ON `prog_batch_period_config`.`programBatchId` = `batches`.`id`
        left join `programs` ON `batches`.`programId` = `programs`.`id`
        left join academy_location on student_attendance_dashboard_section_wise.academyLocationId = academy_location.id
    where
        `sections`.`periodId` is not null
    group by `student_attendance_dashboard_section_wise`.`sectionId`;


DROP VIEW IF EXISTS `pnc_dashboard_most_least_popular_course_pbs`;
CREATE VIEW `pnc_dashboard_most_least_popular_course_pbs` AS
select
    concat(academy_location.academyName, " - ", academy_location.locationName) as `AcademyLocation`,
    academy_location.id as academyLocationId,
    programs.id as programId,
    prog_batch_period_config.programBatchId,
    prog_batch_period_config.id as periodId,
    courses.id as courseId,
    programs.programName,
    batches.batchName,
    prog_batch_period_config.programPeriodName,
    courses.courseCode,
    courses.courseName,
    count(case when whetherRequirementReceived = 1 then whetherRequirementReceived end) "Applied",
    count(case when whetherEnrolled = 1 then whetherEnrolled end) "Enrolled",
    (select sum(maxCapacity) from sections where sections.id in (select id from sections where sections.periodId = pbcd.programBatchPeriodConfigId)) as capacity
from
    prog_batch_course_details pbcd
left outer join
    prog_batch_period_config on pbcd.programBatchPeriodConfigId = prog_batch_period_config.id
left outer join
    batches on prog_batch_period_config.programBatchId = batches.id
left outer join
    programs on batches.programId = programs.id
left outer join
    course_variants on pbcd.courseVarientId = course_variants.id
left outer join
    courses on course_variants.courseId = courses.id
left outer join
    sections on pbcd.sectionId = sections.id
left outer join
    academy_location on programs.academyLocationId = academy_location.id
where
    whetherOptional = 1 and
    courses.assignSectionType = "ProgramBatchSection"
group by
    prog_batch_period_config.id;


DROP VIEW IF EXISTS `pnc_dashboard_most_least_popular_course_cbs`;
CREATE VIEW `pnc_dashboard_most_least_popular_course_cbs` AS
select
    concat(academy_location.academyName, " - ", academy_location.locationName) as `AcademyLocation`,
    academy_location.id as academyLocationId,
    courses.id as courseId,
    courses.courseCode,
    courses.courseName,
    count(case when whetherRequirementReceived = 1 then whetherRequirementReceived end) "Applied",
    count(case when whetherEnrolled = 1 then whetherEnrolled end) "Enrolled",
    (select sum(maxCapacity) from sections where sections.id in (select id from sections where sections.courseVariantId in (select id from course_variants where courseId = courses.id))) as capacity
from
    prog_batch_course_details pbcd
left outer join
    course_variants on pbcd.courseVarientId = course_variants.id
left outer join
    courses on course_variants.courseId = courses.id
left outer join
    sections on pbcd.sectionId = sections.id
left outer join
    course_academy_location on course_academy_location.courseId = courses.id
left join 
    academy_location on academy_location.id = course_academy_location.academyLocationId
where
    whetherOptional = 1 and
    courses.assignSectionType = "CourseSection"
group by
    courses.id;


DROP VIEW IF EXISTS `pnc_dashboard_top_and_bottom_course_absenteeism`;
CREATE VIEW `pnc_dashboard_top_and_bottom_course_absenteeism` AS
 select 
        concat(academy_location.academyName, " - ", academy_location.locationName) as `AcademyLocation`,
        courses.courseCode, courses.courseName,
        course_variants.courseVariantCode,     
        `student_attendance_dashboard_section_wise`.`academyLocationId` AS `academyLocationId`,
        `student_attendance_dashboard_section_wise`.`courseId` AS `courseId`,
        `student_attendance_dashboard_section_wise`.`sectionId` AS `sectionId`,
        `student_attendance_dashboard_section_wise`.`courseVariantId` AS `courseVariantId`,
        sum(`student_attendance_dashboard_section_wise`.`totalRecords`) AS `total`,
        sum(`student_attendance_dashboard_section_wise`.`presentRecords`) AS `present`,
        sum(`student_attendance_dashboard_section_wise`.`absentRecords`) AS `absent`,
        round(((sum(`student_attendance_dashboard_section_wise`.`presentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100),
                0) AS `presentPercent`,
        round(((sum(`student_attendance_dashboard_section_wise`.`absentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100),
                0) AS `absentPercent`
    from
        `student_attendance_dashboard_section_wise`
        left join courses on student_attendance_dashboard_section_wise.courseId = courses.id
        left join course_variants on student_attendance_dashboard_section_wise.courseVariantId = course_variants.id
        left join academy_location on student_attendance_dashboard_section_wise.academyLocationId = academy_location.id
    where
        (`student_attendance_dashboard_section_wise`.`courseVariantId` is not null)
    group by `student_attendance_dashboard_section_wise`.`courseVariantId`;



DROP VIEW IF EXISTS `pnc_dashboard_top_and_bottom_attendance_student`;
CREATE VIEW `pnc_dashboard_top_and_bottom_attendance_student` AS
 select     
        programs.id as programId,
        batches.id as batchId,
        prog_batch_period_config.id as periodId,
        sections.id as sectionId,
        admission.code as studentId,
        users.printName as studentName,
        programs.programNameToBePrint as programName,
        batches.batchName,        
        `student_attendance_dashboard_student_wise`.`academyLocationId` AS `academyLocationId`,
        `student_attendance_dashboard_student_wise`.`admissionId` AS `admissionId`,
        sum(`student_attendance_dashboard_student_wise`.`presentRecords`) AS `presentReocrds`,
        sum(`student_attendance_dashboard_student_wise`.`absentRecords`) AS `absentReocrds`,
        sum(`student_attendance_dashboard_student_wise`.`totalRecords`) AS `totalReocrds`,
        round(((sum(`student_attendance_dashboard_student_wise`.`presentRecords`) / sum(`student_attendance_dashboard_student_wise`.`totalRecords`)) * 100),
                0) AS `presentPercentage`,
        round(((sum(`student_attendance_dashboard_student_wise`.`absentRecords`) / sum(`student_attendance_dashboard_student_wise`.`totalRecords`)) * 100),
                0) AS `absentPercentage`
    from
        `student_attendance_dashboard_student_wise`
    left join admission on  student_attendance_dashboard_student_wise.admissionId = admission.id
    left join programs on programs.id = admission.programId
    left join users on admission.studentId = users.id
    left join batches on admission.batchId = batches.id
    left join prog_batch_period_config on prog_batch_period_config.programBatchId = batches.id
    left join sections on sections.periodId = prog_batch_period_config.id
    group by `student_attendance_dashboard_student_wise`.`admissionId`;



DROP VIEW IF EXISTS `pnc_dashboard_top_and_bottom_attendance_faculty`;
CREATE VIEW `pnc_dashboard_top_and_bottom_attendance_faculty` AS
select
    concat(academy_location.academyName, " - ", academy_location.locationName) as `AcademyLocation`,
    academy_location.id as academyLocationId,
    faculty_attendance_dashboard_faculty_wise.id,  
    users.code as facultyID,
    users.printName as facultyName,
    department.deptName,
    subDept.deptName as subdept,   
    faculty_attendance_dashboard_faculty_wise.presentPercentage as overallPercentage,
    department.id as departmentId,
    subDept.id as subDeptId
    
from
    faculty_attendance_dashboard_faculty_wise
        left join
    staffs ON faculty_attendance_dashboard_faculty_wise.facultyId = staffs.userId
        left join
    users ON staffs.userId = users.id
        left join
    department ON staffs.departmentId = department.id
        left join
    department as subDept ON staffs.subDepartmentId = subDept.id
        left join 
    academy_location on faculty_attendance_dashboard_faculty_wise.academyLocationId = academy_location.id;




drop view if exists `pnc_dashboard_faculty_utilication`;
create view `pnc_dashboard_faculty_utilication` as
select
     concat(academy_location.academyName, " - ", academy_location.locationName) as `AcademyLocation`,
    academy_location.id as academyLocationId,
    users.printName,
    round(2400/60, 1) as "scheduledHours",
    dateOfAttendance,
    round(((sum(timestampdiff(MINUTE,faculty_course_attendance.fromTime, faculty_course_attendance.toTime))/2400)*100), 1) as "Utilization"
from
    faculty_course_attendance_details
left outer join
    faculty_course_attendance on faculty_course_attendance_details.attendanceId = faculty_course_attendance.id
left outer join
    users on faculty_course_attendance_details.facultyId = users.id
left outer join
    user_academy_locations on user_academy_locations.userId = users.id
left outer join 
    academy_location on user_academy_locations.academyLocationId = academy_location.id
group by
    facultyId;
