set Foreign_key_checks=0;
DROP TABLE IF EXISTS `course_coverage_plan`;
CREATE TABLE `course_coverage_plan` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `courseId` bigint(20) DEFAULT NULL,
  `sectionId` bigint(20) DEFAULT NULL,
  `programBatchId` bigint(20) DEFAULT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `courseVariantId` bigint(20) DEFAULT NULL,
  `courseTopicId` bigint(20) DEFAULT NULL,
  `sessionNumber` int(11) DEFAULT NULL,
  `sessionDate` date DEFAULT NULL,
  `slotFrom` tinyint(4) DEFAULT NULL,
  `slotTo` tinyint(4) DEFAULT NULL,
  `facultyId` bigint(20) DEFAULT NULL,
  `additionalFacultyOne` bigint(20) DEFAULT NULL,
  `optionalSession` bit(1) DEFAULT NULL,
  `whetherAttendanceToBeEntered` bit(1) DEFAULT NULL,
  `sessionStatus` varchar(45) DEFAULT NULL COMMENT 'Active,Cancelled,Rescheduled  default-Active',
  `whetherPlannedSession` bit(1) DEFAULT NULL,
  `roomId` bigint(20) DEFAULT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `additionalFacultyTwo` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Refbatches1902` (`programBatchId`),
  KEY `Refcourses179` (`courseId`),
  KEY `Refsections829` (`sectionId`),
  KEY `Refperiod101_idx` (`periodId`),
  KEY `Refcoursevariant102_idx` (`courseVariantId`),
  KEY `Refcoursetopic103_idx` (`courseTopicId`),
  KEY `Reffaculty104_idx` (`facultyId`),
  KEY `Refadditionalfacultyone105_idx` (`additionalFacultyOne`),
  KEY `Refadditionalfacultytwo106_idx` (`additionalFacultyTwo`),
  KEY `Refroom107_idx` (`roomId`),
  CONSTRAINT `Refbatches1902` FOREIGN KEY (`programBatchId`) REFERENCES `batches` (`id`),
  CONSTRAINT `Refperiod101` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refcoursevariant102` FOREIGN KEY (`courseVariantId`) REFERENCES `course_variants` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refcoursetopic103` FOREIGN KEY (`courseTopicId`) REFERENCES `course_topics` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Reffaculty104` FOREIGN KEY (`facultyId`) REFERENCES `faculties` (`personId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refadditionalfacultyone105` FOREIGN KEY (`additionalFacultyOne`) REFERENCES `faculties` (`personId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refadditionalfacultytwo106` FOREIGN KEY (`additionalFacultyTwo`) REFERENCES `faculties` (`personId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refroom107` FOREIGN KEY (`roomId`) REFERENCES `internal_resources` (`resourceId`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `Refcourses179` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`),
  CONSTRAINT `Refsections829` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
set Foreign_key_checks=1;