DROP VIEW IF EXISTS `pnc_dashboard_most_least_popular_courses`;
DROP VIEW IF EXISTS `pnc_dashboard_most_least_popular_course_cbs`;
DROP VIEW IF EXISTS `pnc_dashboard_most_least_popular_course_pbs`;

CREATE VIEW `pnc_dashboard_most_least_popular_courses` AS
    select 
        concat(`academy_location`.`academyName`,
                ' - ',
                `academy_location`.`locationName`) AS `AcademyLocation`,
        `academy_location`.`id` AS `academyLocationId`,
        `programs`.`id` AS `programId`,
        `prog_batch_period_config`.`programBatchId` AS `programBatchId`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `courses`.`id` AS `courseId`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `prog_batch_period_config`.`programPeriodName` AS `programPeriodName`,
        `courses`.`courseCode` AS `courseCode`,
        `courses`.`courseName` AS `courseName`,
        count((case
            when (`pbcd`.`whetherRequirementReceived` = 1) then `pbcd`.`whetherRequirementReceived`
        end)) AS `Applied`,
        count((case
            when (`pbcd`.`whetherEnrolled` = 1) then `pbcd`.`whetherEnrolled`
        end)) AS `Enrolled`,
        (select 
                sum(`sections`.`maxCapacity`)
            from
                `sections`
            where
                `sections`.`id` in (select 
                        `sections`.`id`
                    from
                        `sections`
                    where
                        `sections`.`courseVariantId` in (select 
                                `course_variants`.`id`
                            from
                                `course_variants`
                            where
                                (`course_variants`.`courseId` = `courses`.`id`)))) AS `capacity`
    from
        ((((((((`prog_batch_course_details` `pbcd`
        left join `prog_batch_period_config` ON ((`pbcd`.`programBatchPeriodConfigId` = `prog_batch_period_config`.`id`)))
        left join `batches` ON ((`prog_batch_period_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `course_variants` ON ((`pbcd`.`courseVarientId` = `course_variants`.`id`)))
        left join `courses` ON ((`course_variants`.`courseId` = `courses`.`id`)))
        left join `sections` ON ((`pbcd`.`sectionId` = `sections`.`id`)))
        left join `course_academy_location` ON ((`course_academy_location`.`courseId` = `courses`.`id`)))
        left join `academy_location` ON ((`academy_location`.`id` = `course_academy_location`.`academyLocationId`)))
    where
        ((`pbcd`.`whetherOptional` = 1)
            and (`courses`.`assignSectionType` = 'CourseSection'))
    group by `courses`.`id` 
    union select 
        concat(`academy_location`.`academyName`,
                ' - ',
                `academy_location`.`locationName`) AS `AcademyLocation`,
        `academy_location`.`id` AS `academyLocationId`,
        `programs`.`id` AS `programId`,
        `prog_batch_period_config`.`programBatchId` AS `programBatchId`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `courses`.`id` AS `courseId`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `prog_batch_period_config`.`programPeriodName` AS `programPeriodName`,
        `courses`.`courseCode` AS `courseCode`,
        `courses`.`courseName` AS `courseName`,
        count((case
            when (`pbcd`.`whetherRequirementReceived` = 1) then `pbcd`.`whetherRequirementReceived`
        end)) AS `Applied`,
        count((case
            when (`pbcd`.`whetherEnrolled` = 1) then `pbcd`.`whetherEnrolled`
        end)) AS `Enrolled`,
        (select 
                sum(`sections`.`maxCapacity`)
            from
                `sections`
            where
                `sections`.`id` in (select 
                        `sections`.`id`
                    from
                        `sections`
                    where
                        (`sections`.`periodId` = `pbcd`.`programBatchPeriodConfigId`))) AS `capacity`
    from
        (((((((`prog_batch_course_details` `pbcd`
        left join `prog_batch_period_config` ON ((`pbcd`.`programBatchPeriodConfigId` = `prog_batch_period_config`.`id`)))
        left join `batches` ON ((`prog_batch_period_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `course_variants` ON ((`pbcd`.`courseVarientId` = `course_variants`.`id`)))
        left join `courses` ON ((`course_variants`.`courseId` = `courses`.`id`)))
        left join `sections` ON ((`pbcd`.`sectionId` = `sections`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
    where
        ((`pbcd`.`whetherOptional` = 1)
            and (`courses`.`assignSectionType` = 'ProgramBatchSection'))
    group by `prog_batch_period_config`.`id`