DROP TABLE IF EXISTS `promotion`;

CREATE TABLE `promotion` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `fromRecordId` bigint(20) NOT NULL,
  `toRecordId` bigint(20) NULL,
  `status` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `promotionType` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
  `approver` bigint(20) NULL,
  `remarks` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `approvalDate` timestamp NULL DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_student_promotion_7_idx` (`approver`),
  KEY `fk_student_promotion_8_idx` (`lastUpdatedBy`),
  KEY `fk_promotion_1_idx` (`fromRecordId`),
  KEY `fk_promotion_2_idx` (`toRecordId`),
  CONSTRAINT `fk_promotion_2` FOREIGN KEY (`toRecordId`) REFERENCES `program_batch_students` (`id`),
  CONSTRAINT `fk_promotion_1` FOREIGN KEY (`fromRecordId`) REFERENCES `program_batch_students` (`id`),
  CONSTRAINT `fk_student_promotion_7` FOREIGN KEY (`approver`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_student_promotion_8` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);
