/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.CriteriaBuilderConfigurer;

import in.serosoft.CriteriaBuilderConfigurer.ConfigUtil;
import in.serosoft.CriteriaBuilderConfigurer.PropertiesFileManager;
import in.serosoft.cb.model.SavedSearchDTO;
import in.serosoft.cb.model.SavedSearchesDTO;
import in.serosoft.cb.service.SearchConfiguratonService;
import in.serosoft.cb.xmlParser.ConfigurationReader;
import in.serosoft.cb.xmlParser.DBSchemaReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SavedSearchConfigurationApp {
    static Set<String> dbSavedSearchList = new HashSet<String>();

    public static void main(String[] args) {
        Path fileName = PropertiesFileManager.getSourceDirPath("XMLParser/savedSearches");
        SavedSearchConfigurationApp.backup(fileName);
    }

    public static void backup(Path path) {
        ApplicationContext appContext = ConfigUtil.getApplicationContext();
        SearchConfiguratonService searchConfiguratonService = appContext.getBean(SearchConfiguratonService.class);
        SavedSearchesDTO savedSearchDTOs = searchConfiguratonService.readSavedSearches();
        if (savedSearchDTOs.getSavedSearchDTOs() != null) {
            for (SavedSearchDTO searchDTO : savedSearchDTOs.getSavedSearchDTOs()) {
                try {
                    SavedSearchesDTO searchesDTO = new SavedSearchesDTO();
                    ArrayList<SavedSearchDTO> dtos = new ArrayList<SavedSearchDTO>();
                    dtos.add(searchDTO);
                    searchesDTO.setSavedSearchDTOs(dtos);
                    String searchFileName = searchDTO.getSearchName().replace(" ", "_").replace("/", "_").replaceAll("[-+.^:,]", "_");
                    Path filePath = path.resolve(searchFileName + ".xml");
                    Files.deleteIfExists(filePath);
                    DBSchemaReader.readSchemaToWriteXmlFile(searchesDTO, Files.newOutputStream(filePath, new OpenOption[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        ((ConfigurableApplicationContext)appContext).close();
    }

    public static void restore(List<Path> dbSavedSearchPaths) {
        ApplicationContext appContext = ConfigUtil.getApplicationContext();
        SearchConfiguratonService searchConfiguratonService = appContext.getBean(SearchConfiguratonService.class);
        SavedSearchesDTO mainSavedSearcheDTO = new SavedSearchesDTO();
        ArrayList<SavedSearchDTO> dtos = new ArrayList<SavedSearchDTO>();
        dbSavedSearchPaths.stream().filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".xml")).forEach(file -> SavedSearchConfigurationApp.restoringXml(dtos, file, dbSavedSearchList));
        mainSavedSearcheDTO.setSavedSearchDTOs(dtos);
        searchConfiguratonService.configureSavedSearch(mainSavedSearcheDTO);
        ((ConfigurableApplicationContext)appContext).close();
    }

    public static void restoreDefault(Path savedSearchesPath) {
        ApplicationContext appContext = ConfigUtil.getApplicationContext();
        SearchConfiguratonService searchConfiguratonService = appContext.getBean(SearchConfiguratonService.class);
        SavedSearchesDTO mainSavedSearcheDTO = new SavedSearchesDTO();
        ArrayList<SavedSearchDTO> dtos = new ArrayList<SavedSearchDTO>();
        try {
            Files.walk(savedSearchesPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".xml")).filter(path -> !dbSavedSearchList.contains(path.getFileName().toString())).forEach(file -> SavedSearchConfigurationApp.restoringXml(dtos, file, dbSavedSearchList));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        mainSavedSearcheDTO.setSavedSearchDTOs(dtos);
        searchConfiguratonService.configureSavedSearch(mainSavedSearcheDTO);
        ((ConfigurableApplicationContext)appContext).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoringXml(List<SavedSearchDTO> dtos, Path file, Set<String> dbSavedSearchList) {
        block7: {
            try {
                InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
                if (inputStream == null) break block7;
                try {
                    SavedSearchesDTO savedSearcheDTO = ConfigurationReader.readSavedSearchXmlFile(inputStream);
                    dtos.addAll(savedSearcheDTO.getSavedSearchDTOs());
                    dbSavedSearchList.add(file.getFileName().toString());
                }
                catch (Exception e) {
                    System.out.println("Error in file during saved search restore: " + file.getFileName().toString());
                    e.printStackTrace();
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

