/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.licensegen.ciphers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.Security;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.misc.BASE64Decoder;

public class RSADecryptFile {
    public static void main(String[] args) {
        String privateKeyFilename = null;
        String encryptedFilename = null;
        String outputFilename = null;
        RSADecryptFile rsaDecryptFile = new RSADecryptFile();
        if (args.length < 3) {
            System.err.println("Usage: java " + rsaDecryptFile.getClass().getName() + " Private_Key_Filename Encrypted_Filename Output_Filename");
            System.exit(1);
        }
        privateKeyFilename = args[0].trim();
        encryptedFilename = args[1].trim();
        outputFilename = args[2].trim();
        rsaDecryptFile.decrypt(privateKeyFilename, encryptedFilename, outputFilename);
    }

    private void decrypt(String privateKeyFilename, String encryptedFilename, String outputFilename) {
        try {
            Security.addProvider(new BouncyCastleProvider());
            String value = "";
            String key = RSADecryptFile.readFileAsString(privateKeyFilename);
            BASE64Decoder b64 = new BASE64Decoder();
            AsymmetricKeyParameter privateKey = PrivateKeyFactory.createKey(b64.decodeBuffer(key));
            AsymmetricBlockCipher e = new RSAEngine();
            e = new PKCS1Encoding(e);
            e.init(false, privateKey);
            String inputdata = RSADecryptFile.readFileAsString(encryptedFilename);
            byte[] messageBytes = RSADecryptFile.hexStringToByteArray(inputdata);
            int len = e.getInputBlockSize();
            for (int i = 0; i < messageBytes.length; i += e.getInputBlockSize()) {
                if (i + len > messageBytes.length) {
                    len = messageBytes.length - i;
                }
                byte[] hexEncodedCipher = e.processBlock(messageBytes, i, len);
                value = value + new String(hexEncodedCipher);
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(outputFilename));
            out.write(value);
            out.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static String getHexString(byte[] b) throws Exception {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    private static String readFileAsString(String filePath) throws IOException {
        StringBuilder fileData = new StringBuilder(1000);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }
}

