/*
 * Decompiled with CFR 0.152.
 */
package in.serosoft.licensegen.ciphers;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.security.Security;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.misc.BASE64Decoder;

public class RSAEncryption {
    public static void main(String[] args) {
        String publicKeyFilename = null;
        String inputData = null;
        RSAEncryption rsaEncryption = new RSAEncryption();
        if (args.length < 2) {
            System.err.println("Usage: java " + rsaEncryption.getClass().getName() + " Public_Key_Filename Input_String_data");
            System.exit(1);
        }
        publicKeyFilename = args[0].trim();
        inputData = args[1].trim();
        rsaEncryption.encrypt(publicKeyFilename, inputData);
    }

    private String encrypt(String publicKeyFilename, String inputData) {
        String encryptedData = null;
        try {
            Security.addProvider(new BouncyCastleProvider());
            BASE64Decoder b64 = new BASE64Decoder();
            String key = RSAEncryption.readFileAsString(publicKeyFilename);
            AsymmetricKeyParameter publicKey = PublicKeyFactory.createKey(b64.decodeBuffer(key));
            AsymmetricBlockCipher e = new RSAEngine();
            e = new PKCS1Encoding(e);
            e.init(true, publicKey);
            byte[] messageBytes = inputData.getBytes();
            byte[] hexEncodedCipher = e.processBlock(messageBytes, 0, messageBytes.length);
            encryptedData = RSAEncryption.getHexString(hexEncodedCipher);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return encryptedData;
    }

    public static String getHexString(byte[] b) throws Exception {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    private static String readFileAsString(String filePath) throws IOException {
        StringBuilder fileData = new StringBuilder(1000);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }
}

