DELIMITER $$

DROP PROCEDURE IF EXISTS V202001071826__AlterGenderHistory $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001071826__AlterGenderHistory()

BEGIN
  
  -- Add the email_address column to the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='gender_history' 
  AND column_name in('isDeletable','isEditable'))) THEN

    ALTER TABLE gender_history 
    ADD COLUMN `isDeletable` BIT(1) NOT NULL DEFAULT 1 AFTER `lastUpdatedBy`,
    ADD COLUMN `isEditable` BIT(1) NOT NULL DEFAULT 1 AFTER `isDeletable`;

  END IF;

END $$

-- Execute the stored procedure
CALL V202001071826__AlterGenderHistory() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001071826__AlterGenderHistory $$
 
DELIMITER ;