DELIMITER $$

DROP PROCEDURE IF EXISTS V202001151612__CreateCurrencyExchangeHistoryAudit $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001151612__CreateCurrencyExchangeHistoryAudit()

BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='currency_exchange_history_audit' )) THEN

CREATE TABLE `currency_exchange_history_audit` (
  `id` bigint(20) NOT NULL,
  `REV` int(11) NOT NULL,
  `REVTYPE` tinyint(4) DEFAULT NULL,
  `fromCurrencyId` bigint(20) DEFAULT NULL,
  `toCurrencyId` bigint(20) DEFAULT NULL,
  `exchangeRate` double(20,2) DEFAULT NULL,
  `applicableFrom` date DEFAULT NULL,
  `applicableTill` date DEFAULT NULL,
  `currencyExchangeId` bigint(20) DEFAULT NULL,
  `changedTime` timestamp NULL DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT NULL,
  `lastUpdatedBy` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`REV`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  END IF;

END $$

-- Execute the stored procedure
CALL V202001151612__CreateCurrencyExchangeHistoryAudit() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001151612__CreateCurrencyExchangeHistoryAudit $$
 
DELIMITER ;