DELIMITER $$
DROP PROCEDURE IF EXISTS V20240508165548__Create_exam_sunshine_time_table_history $$
CREATE PROCEDURE V20240508165548__Create_exam_sunshine_time_table_history()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_course_resource_mapping_history')) THEN 
CREATE TABLE `exam_course_resource_mapping_history` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `REV` INT(11) NOT NULL,
  `REVTYPE` TINYINT(4) NULL,
  `courseId` BIGINT NOT NULL,
  `eventId` BIGINT NOT NULL,
  `resourceId` BIGINT NOT NULL,
  `status` BIT(1) NOT NULL DEFAULT b'0',
  `lastUpdatedBy` BIGINT NOT NULL DEFAULT 1,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`, `REV`));
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_result_resource_mapping_history')) THEN 
CREATE TABLE `exam_result_resource_mapping_history` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `REV` INT(11) NOT NULL,
  `REVTYPE` TINYINT(4) NULL,
  `examinationResultId` bigint NOT NULL,
  `courseResourceMappingId` bigint NOT NULL,
  `concessionType` varchar(50) DEFAULT NULL,
  `publishStatus` BIT(1) NOT NULL DEFAULT b'0',
  `lastUpdatedBy` bigint NOT NULL DEFAULT '1',
   `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`, `REV`));
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_external_invigilator_master_data_history')) THEN 
CREATE TABLE `exam_external_invigilator_master_data_history` (
	`id` BIGINT NOT NULL AUTO_INCREMENT,
	`REV` INT(11) NOT NULL,
	`REVTYPE` TINYINT(4) NULL,
	`position` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`gender` VARCHAR(45) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`firstName` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`lastName` VARCHAR(255) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`nationality` VARCHAR(45) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`identificationNumber` VARCHAR(45) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`emailId` VARCHAR(100) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`phoneNumber` VARCHAR(25) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`address` VARCHAR(512) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`race` VARCHAR(20) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`highestEducationQualification` VARCHAR(45) NULL DEFAULT NULL COLLATE 'utf8mb4_0900_ai_ci',
	`status` BIT(1) NOT NULL DEFAULT b'0',
    `lastUpdatedBy` bigint NOT NULL DEFAULT '1',
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	 PRIMARY KEY (`id`, `REV`));
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_course_resource_invigilator_mapping_history')) THEN 
CREATE TABLE `exam_course_resource_invigilator_mapping_history` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `REV` INT(11) NOT NULL,
  `REVTYPE` TINYINT(4) NULL,
  `seniorInvigilatorId` bigint DEFAULT NULL,
  `firstInvigilatorId` bigint DEFAULT NULL,
  `secondInvigilatorId` bigint DEFAULT NULL,
  `thirdInvigilatorId` bigint DEFAULT NULL,
  `courseResourceMappingId` bigint NOT NULL,
  `status` BIT(1) NOT NULL DEFAULT b'0',
  `lastUpdatedBy` bigint NOT NULL DEFAULT '1',
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`, `REV`));
END IF; 

END $$
CALL V20240508165548__Create_exam_sunshine_time_table_history () $$ 
DROP PROCEDURE IF EXISTS V20240508165548__Create_exam_sunshine_time_table_history $$ 
DELIMITER ;