--
--ER/Studio 6.0 SQL Code Generation
-- Project :      ACADEMIA_MYSQLDB.dm1
--
-- Date Created : Wednesday, February 26, 2014 14:39:40
-- Target DBMS : Oracle 9i
--


-- 
-- TABLE: aca_leave_request 
--

CREATE TABLE aca_leave_request(
    id                    NUMBER(38, 0)    NOT NULL,
    requestId             NUMBER(38, 0),
    requestFrom           DATE,
    requestTo             DATE,
    executionRequestId    NUMBER(38, 0),
    followupCommonId      DATE,
    updatedBy             NUMBER(38, 0)    NOT NULL,
    updatedDte            TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK70_1_1_1_1_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: acad_loc_purpose_setting 
--

CREATE TABLE acad_loc_purpose_setting(
    id                          NUMBER(38, 0)    NOT NULL,
    academyLocationPurposeId    NUMBER(38, 0)    NOT NULL,
    entitySettingId             NUMBER(38, 0)    NOT NULL,
    purposeSettingValue         VARCHAR2(50)     NOT NULL,
    lastUpdate                  TIMESTAMP(6)     NOT NULL,
    lastUpdatedBy               NUMBER(38, 0)    NOT NULL,
    CONSTRAINT PK13 PRIMARY KEY (id)
)
;



-- 
-- TABLE: academy 
--

CREATE TABLE academy(
    id                  NUMBER(38, 0)    NOT NULL,
    academicTypeCode    VARCHAR2(10)     NOT NULL,
    academyName         VARCHAR2(100)    NOT NULL,
    organizationId      NUMBER(38, 0)    NOT NULL,
    shortCode           VARCHAR2(10)     NOT NULL,
    startDate           DATE             NOT NULL,
    tillDate            DATE,
    status              NUMBER(1, 0)     NOT NULL,
    lastUpdate          TIMESTAMP(6)     NOT NULL,
    lastUpdatedBy       NUMBER(38, 0)    NOT NULL,
    CONSTRAINT PK4_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: academy_location 
--

CREATE TABLE academy_location(
    id                            NUMBER(38, 0)    NOT NULL,
    academyId                     NUMBER(38, 0)    NOT NULL,
    locationId                    NUMBER(38, 0)    NOT NULL,
    academicYearId                NUMBER(38, 0)    NOT NULL,
    currentAcademyYearTenureId    NUMBER(38, 0)    NOT NULL,
    currentTransactionDate        DATE             NOT NULL,
    lastUpdate                    TIMESTAMP(6)     NOT NULL,
    lastUpdatedBy                 NUMBER(38, 0)    NOT NULL,
    CONSTRAINT PK9 PRIMARY KEY (id)
)
;



-- 
-- TABLE: academy_location_purpose 
--

CREATE TABLE academy_location_purpose(
    id                   NUMBER(38, 0)    NOT NULL,
    academyLocationId    NUMBER(38, 0)    NOT NULL,
    purposeCode          VARCHAR2(50)     NOT NULL,
    calendarId           NUMBER(38, 0),
    facultyFeePlanId     NUMBER(38, 0)    NOT NULL,
    ownerId              NUMBER(38, 0)    NOT NULL,
    startDate            DATE             NOT NULL,
    tillDate             DATE,
    lastUpdate           TIMESTAMP(6)     NOT NULL,
    lastUpdatedBy        NUMBER(38, 0)    NOT NULL,
    CONSTRAINT PK11 PRIMARY KEY (id)
)
;



-- 
-- TABLE: academy_location_setting 
--

CREATE TABLE academy_location_setting(
    id                      NUMBER(38, 0)    NOT NULL,
    academyLocationId       NUMBER(38, 0)    NOT NULL,
    entitySettingId         NUMBER(38, 0)    NOT NULL,
    locationSettingValue    VARCHAR2(50)     NOT NULL,
    lastUpdate              TIMESTAMP(6)     NOT NULL,
    lastUpdatedBy           NUMBER(38, 0)    NOT NULL,
    CONSTRAINT PK12 PRIMARY KEY (id)
)
;



-- 
-- TABLE: academy_year 
--

CREATE TABLE academy_year(
    id               NUMBER(38, 0)    NOT NULL,
    yearName         VARCHAR2(255)    NOT NULL,
    description      VARCHAR2(255)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    CONSTRAINT PK22_3 PRIMARY KEY (id)
)
;



-- 
-- TABLE: academy_year_tenure 
--

CREATE TABLE academy_year_tenure(
    id               NUMBER(38, 0)    NOT NULL,
    academyYearId    NUMBER(38, 0)    NOT NULL,
    tenureName       VARCHAR2(255)    NOT NULL,
    startDate        DATE             NOT NULL,
    tillDate         DATE,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    CONSTRAINT PK22_1_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: address 
--

CREATE TABLE address(
    id                  NUMBER(38, 0)    NOT NULL,
    code                CHAR(10),
    addressText         VARCHAR2(50),
    phoneNo             VARCHAR2(15),
    phoneCountryCode    NUMBER(38, 0),
    phoneAreaCode       NUMBER(38, 0),
    cellNo              BLOB,
    cellCountryCode     CHAR(10),
    primaryeEmailId     VARCHAR2(20),
    alternateEmailId    VARCHAR2(20),
    countryRegionId     NUMBER(38, 0),
    cityId              NUMBER(38, 0),
    addressTypeId       NUMBER(38, 0),
    parentRegionId      NUMBER(38, 0),
    lastUpdatedBy       NUMBER(38, 0),
    lastUpdate          TIMESTAMP(6),
    CONSTRAINT PK22_1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: address_type 
--

CREATE TABLE address_type(
    id                 NUMBER(38, 0)    NOT NULL,
    code               CHAR(10),
    addressTypeName    VARCHAR2(20),
    addressCategory    VARCHAR2(20),
    lastUpdatedBy      NUMBER(38, 0),
    lastUpdate         TIMESTAMP(6),
    CONSTRAINT PK22_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: admission_enq_details 
--

CREATE TABLE admission_enq_details(
    id                        NUMBER(19, 0)    NOT NULL,
    enqStudentDetailsId       NUMBER(19, 0),
    academyId                 NUMBER(38, 0),
    locationId                NUMBER(38, 0),
    programId                 NUMBER(38, 0),
    batchId                   NUMBER(38, 0),
    seatType                  VARCHAR2(1),
    deleteFlag                NUMBER(38, 0),
    enquiryClosureReasonId    NUMBER(38, 0),
    enquiryReopenReasonId     NUMBER(38, 0),
    lastUpdatedBy             NUMBER(38, 0)    NOT NULL,
    lastUpdate                TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK274 PRIMARY KEY (id)
)
;



-- 
-- TABLE: admission_form_preference 
--

CREATE TABLE admission_form_preference(
    id               NUMBER(38, 0)    NOT NULL,
    saleFormId       NUMBER(38, 0),
    selFormId        NUMBER(38, 0)    NOT NULL,
    programId        NUMBER(38, 0),
    academyId        NUMBER(38, 0),
    locationId       NUMBER(38, 0),
    feeAmount        NUMBER(18, 5),
    lateFee          NUMBER(18, 5),
    seateTypeId      NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK34_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: admission_form_sale 
--

CREATE TABLE admission_form_sale(
    id                        NUMBER(38, 0)    NOT NULL,
    applicationCode           NUMBER(38, 0),
    collectedBy               VARCHAR2(18),
    saleDate                  TIMESTAMP(6),
    collectedByFName          VARCHAR2(35),
    collectedByMName          VARCHAR2(35),
    collectedByLName          VARCHAR2(35),
    collectedByCountryCode    CHAR(3),
    collectedByPhoneNo        CHAR(10),
    collectedByLandlineNo     CHAR(10),
    emailId                   VARCHAR2(35),
    addressId                 NUMBER(38, 0),
    studentFName              VARCHAR2(35),
    studentMName              VARCHAR2(35),
    studentLName              VARCHAR2(35),
    token                     VARCHAR2(10),
    selectionProcess          VARCHAR2(2),
    applicationStatus         CHAR(1),
    lastUpdatedBy             NUMBER(38, 0),
    lastUpdate                TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK31_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: alternate_faculty 
--

CREATE TABLE alternate_faculty(
    id                    NUMBER(38, 0)    NOT NULL,
    facultyTopicId        NUMBER(38, 0),
    employeeId            NUMBER(38, 0),
    assignNoOfSections    NUMBER(38, 0),
    updatedBy             NUMBER(38, 0)    NOT NULL,
    updatedDate           TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK3_4_1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: batch 
--

CREATE TABLE batch(
    id                              NUMBER(38, 0)     NOT NULL,
    batchName                       VARCHAR2(18),
    academicYearId                  NUMBER(38, 0),
    seatCapacity                    NUMBER(38, 0),
    startDate                       DATE,
    endDate                         DATE,
    programPeriodId                 NUMBER(38, 0),
    maxPeriod                       VARCHAR2(15),
    minPeriod                       VARCHAR2(15),
    isAdditionalRequirement         NUMBER(1, 0)      NOT NULL,
    additionalRequirementDetails    VARCHAR2(4000),
    isSpecializationPossible        NUMBER(1, 0)      NOT NULL,
    programMinCredits               NUMBER(38, 0),
    programMincourses               NUMBER(38, 0),
    isPartTime                      NUMBER(1, 0)      NOT NULL,
    minCompulsoryCourses            NUMBER(38, 0),
    minOptionalCourses              NUMBER(38, 0),
    programMinAge                   NUMBER(38, 0),
    programMaxAge                   NUMBER(38, 0),
    adOnDate                        DATE,
    calendarId                      NUMBER(38, 0),
    programEntryCreteria            VARCHAR2(4000),
    programExitCreteria             VARCHAR2(4000),
    isPlacementProcessRequired      NUMBER(1, 0)      NOT NULL,
    isInheritProgramPeriod          NUMBER(1, 0)      NOT NULL,
    isInheritProgramPeriodBreak     NUMBER(1, 0)      NOT NULL,
    inheritProgramId                NUMBER(38, 0),
    inheritFromBatch                NUMBER(38, 0),
    updatedBy                       NUMBER(38, 0)     NOT NULL,
    updatedDate                     TIMESTAMP(6)      NOT NULL,
    CONSTRAINT PK5_2_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: calendar 
--

CREATE TABLE calendar(
    id                           NUMBER(38, 0)    NOT NULL,
    code                         VARCHAR2(2)      NOT NULL,
    calenderName                 VARCHAR2(35),
    calendarDesc                 VARCHAR2(100),
    status                       NUMBER(1, 0)     NOT NULL,
    weekStart                    VARCHAR2(10),
    calendarInitSetupComplete    CHAR(1),
    lastUpdatedBy                NUMBER(38, 0)    NOT NULL,
    lastUpdate                   TIMESTAMP(6),
    CONSTRAINT PK1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: calendar_academylocation 
--

CREATE TABLE calendar_academylocation(
    id                   NUMBER(38, 0)    NOT NULL,
    calendarId           NUMBER(38, 0),
    academyLocationId    NUMBER(38, 0),
    lastUpdatedBy        NUMBER(38, 0)    NOT NULL,
    lastUpdate           TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK6_1_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: calendar_holidays 
--

CREATE TABLE calendar_holidays(
    id               NUMBER(38, 0)    NOT NULL,
    calendarId       NUMBER(38, 0),
    fromDate         DATE             NOT NULL,
    toDate           DATE,
    holidayReason    VARCHAR2(100),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: calendar_specialday 
--

CREATE TABLE calendar_specialday(
    id                NUMBER(38, 0)    NOT NULL,
    calendarId        NUMBER(38, 0),
    fromDate          DATE             NOT NULL,
    toDate            DATE,
    startTime         VARCHAR2(8),
    endTime           VARCHAR2(8),
    specialDayDesc    VARCHAR2(100),
    slots             NUMBER(38, 0),
    slotType          VARCHAR2(6),
    lastUpdatedBy     NUMBER(38, 0)    NOT NULL,
    lastUpdate        TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK6_1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: calendar_weektimings 
--

CREATE TABLE calendar_weektimings(
    id               NUMBER(38, 0)    NOT NULL,
    calendarId       NUMBER(38, 0),
    isWeekStart      NUMBER(1, 0)     NOT NULL,
    isWeekEnd        NUMBER(1, 0)     NOT NULL,
    weekDay          VARCHAR2(15),
    startTime        VARCHAR2(8),
    endTime          VARCHAR2(8),
    slots            NUMBER(38, 0),
    slotType         VARCHAR2(6),
    breakType        VARCHAR2(35),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK6_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: camp_coverage_user 
--

CREATE TABLE camp_coverage_user(
    id                    NUMBER(38, 0)    NOT NULL,
    campaignCoverageId    NUMBER(38, 0),
    userId                NUMBER(38, 0),
    deleteFlag            CHAR(10),
    lastUpdatedBy         NUMBER(38, 0),
    lastUpdate            TIMESTAMP(6),
    CONSTRAINT PK19 PRIMARY KEY (id)
)
;



-- 
-- TABLE: campaign 
--

CREATE TABLE campaign(
    id               NUMBER(38, 0)     NOT NULL,
    code             VARCHAR2(6)       NOT NULL,
    campaignName     VARCHAR2(10),
    campaignDesc     VARCHAR2(100),
    budgetAmount     NUMBER(38, 0),
    actualAmount     NUMBER(38, 0),
    userId           NUMBER(38, 0),
    fromDate         DATE,
    toDate           DATE,
    remarks          VARCHAR2(4000),
    deleteFlag       NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0)     NOT NULL,
    lastUpdate       TIMESTAMP(6)       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK262 PRIMARY KEY (id)
)
;



-- 
-- TABLE: campaign_coverage 
--

CREATE TABLE campaign_coverage(
    id                 NUMBER(38, 0)      NOT NULL,
    campaignId         NUMBER(38, 0),
    locationId         NUMBER(38, 0),
    academyId          NUMBER(38, 0),
    programId          NUMBER(38, 0),
    coverageRemarks    VARCHAR2(4000),
    userId             NUMBER(38, 0),
    deleteFlag         CHAR(10),
    lastUpdatedBy      NUMBER(38, 0)      NOT NULL,
    lastUpdate         TIMESTAMP(6)        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK272 PRIMARY KEY (id)
)
;



-- 
-- TABLE: campaign_media 
--

CREATE TABLE campaign_media(
    id               NUMBER(38, 0)    NOT NULL,
    campaignId       NUMBER(38, 0),
    mediaId          NUMBER(38, 0),
    deleteFlag       NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK271 PRIMARY KEY (id)
)
;



-- 
-- TABLE: category_options 
--

CREATE TABLE category_options(
    id                NUMBER(38, 0)    NOT NULL,
    applnCategory     VARCHAR2(1),
    applnCategory1    VARCHAR2(1),
    applnCategory2    VARCHAR2(1),
    applnCategory3    VARCHAR2(1),
    applnCategory4    VARCHAR2(1),
    lastUpdatedBy     NUMBER(38, 0),
    lastUpdate        TIMESTAMP(6),
    CONSTRAINT PK3_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: city 
--

CREATE TABLE city(
    id               NUMBER(38, 0)    NOT NULL,
    code             CHAR(10),
    cityName         VARCHAR2(20),
    countryId        NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0),
    lastUpdate       TIMESTAMP(6),
    CONSTRAINT PK27 PRIMARY KEY (id)
)
;



-- 
-- TABLE: closure_reason 
--

CREATE TABLE closure_reason(
    id               NUMBER(38, 0)    NOT NULL,
    reasonCode       VARCHAR2(3),
    status           VARCHAR2(10),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK261 PRIMARY KEY (id)
)
;



-- 
-- TABLE: country 
--

CREATE TABLE country(
    id               NUMBER(38, 0)    NOT NULL,
    code             CHAR(10),
    countryName      VARCHAR2(20),
    isdCode          CHAR(10),
    lastUpdatedBy    NUMBER(38, 0),
    lastUpdate       TIMESTAMP(6),
    CONSTRAINT PK22 PRIMARY KEY (id)
)
;



-- 
-- TABLE: country_region 
--

CREATE TABLE country_region(
    id                   NUMBER(38, 0)    NOT NULL,
    code                 CHAR(10),
    countryRegionName    VARCHAR2(20),
    countryRegionType    VARCHAR2(20),
    parentRegionId       NUMBER(38, 0),
    countryId            NUMBER(38, 0),
    lastUpdatedBy        NUMBER(38, 0),
    lastUpdate           TIMESTAMP(6),
    CONSTRAINT PK22_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: course 
--

CREATE TABLE course(
    id                          NUMBER(38, 0)    NOT NULL,
    courseCode                  VARCHAR2(10),
    courseName                  VARCHAR2(100)    NOT NULL,
    courseShortName             VARCHAR2(35),
    nameToBePriented            VARCHAR2(35),
    departmentId                NUMBER(38, 0),
    subDepartmentId             NUMBER(38, 0),
    courseSyllabus              BLOB             NOT NULL,
    courseContent               VARCHAR2(255)    NOT NULL,
    isEvaluationExternal        NUMBER(38, 0),
    courseMarksGrades           CHAR(1),
    courseCutOff                VARCHAR2(3),
    courseMaxMark               NUMBER(38, 0),
    courseCredits               NUMBER(3, 0),
    deficiencyStatus            NUMBER(1, 0)     NOT NULL,
    courseDeficits              CHAR(2),
    courseDeficitsPoint         CHAR(2)          NOT NULL,
    courseShortDescription      VARCHAR2(8)      NOT NULL,
    courseCoordinator           NUMBER(38, 0),
    courseRankConsidered        VARCHAR2(1),
    assignSectionType           VARCHAR2(35),
    courseEntryCreteriaQuery    VARCHAR2(255),
    courseExitCreteriaQuery     VARCHAR2(255),
    stageId                     NUMBER(38, 0),
    isRepeatable                NUMBER(1, 0)     NOT NULL,
    lastUpdatedBy               NUMBER(38, 0)    NOT NULL,
    lastUpdate                  TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK15_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_components 
--

CREATE TABLE course_components(
    id                 NUMBER(38, 0)    NOT NULL,
    courseId           NUMBER(38, 0),
    componentName      VARCHAR2(4)      NOT NULL,
    componentDesc      VARCHAR2(35)     NOT NULL,
    componentStatus    NUMBER(38, 0),
    componentCredit    NUMBER(3, 0),
    lastUpdatedBy      NUMBER(38, 0)    NOT NULL,
    lastUpdate         TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK145 PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_coverage_plan 
--

CREATE TABLE course_coverage_plan(
    id               NUMBER(38, 0)    NOT NULL,
    programId        NUMBER(38, 0),
    batchId          NUMBER(38, 0),
    courseId         NUMBER(38, 0),
    sectionId        NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK148_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_coverage_plan_details 
--

CREATE TABLE course_coverage_plan_details(
    id                              NUMBER(38, 0)     NOT NULL,
    courseCoveragePlanId            NUMBER(38, 0),
    topicId                         NUMBER(38, 0),
    sessionDate                     DATE,
    slotFrom                        NUMBER(3, 0),
    slotTo                          NUMBER(3, 0),
    faculty                         VARCHAR2(6)       NOT NULL,
    facultyAdditional               VARCHAR2(6),
    alternateFaculty                VARCHAR2(6),
    facultyAdditional1              VARCHAR2(6),
    sessionDateSlotTimetoSpndMts    NUMBER(38, 0),
    sessionisOptional               CHAR(1),
    sessionAttendancetoEnter        CHAR(1),
    readingName                     VARCHAR2(255),
    sessionStatus                   CHAR(1),
    sessionPlanned                  CHAR(1),
    reason                          VARCHAR2(4000),
    roomAssignment                  NUMBER(38, 0),
    lastUpdatedBy                   NUMBER(38, 0)     NOT NULL,
    lastUpdate                      TIMESTAMP(6)      NOT NULL,
    CONSTRAINT PK148 PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_equivalence 
--

CREATE TABLE course_equivalence(
    id                      NUMBER(38, 0)    NOT NULL,
    courseComponentId       NUMBER(38, 0),
    courseEquivalentName    VARCHAR2(35),
    equivalentComponent     NUMBER(38, 0),
    isActive                CHAR(1),
    lastUpdatedBy           NUMBER(38, 0)    NOT NULL,
    lastUpdate              TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK146 PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_group 
--

CREATE TABLE course_group(
    id                    NUMBER(38, 0)    NOT NULL,
    code                  VARCHAR2(10),
    isRegular             NUMBER(1, 0)     NOT NULL,
    isSpecialized         NUMBER(1, 0)     NOT NULL,
    isAudit               NUMBER(1, 0)     NOT NULL,
    isMandatory           NUMBER(1, 0)     NOT NULL,
    groupName             VARCHAR2(35),
    minCourses            NUMBER(38, 0),
    maxCourses            NUMBER(38, 0),
    optionalMaxCourses    NUMBER(38, 0),
    optionalMinCourses    NUMBER(38, 0),
    maxCredits            NUMBER(38, 0),
    minCredits            NUMBER(38, 0),
    lastUpdatedBy         NUMBER(38, 0)    NOT NULL,
    lastUpdate            TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK7_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_isu_link 
--

CREATE TABLE course_isu_link(
    id               NUMBER(38, 0)    NOT NULL,
    courseId         NUMBER(38, 0),
    courseCodeId     NUMBER(38, 0),
    isuCode          VARCHAR2(4),
    locationCode     VARCHAR2(4),
    instCode         VARCHAR2(4),
    yesNo            CHAR(1),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK17_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_reading 
--

CREATE TABLE course_reading(
    id                    NUMBER(38, 0)    NOT NULL,
    academicYear          NUMBER(38, 0),
    courseId              NUMBER(38, 0),
    topicId               NUMBER(38, 0),
    bookName              VARCHAR2(50),
    distrubutionModeId    NUMBER(38, 0),
    isCompulsory          NUMBER(1, 0)     NOT NULL,
    topicType             VARCHAR2(35),
    lastUpdatedBy         NUMBER(38, 0)    NOT NULL,
    lastUpdate            TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK37_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_reading_documents 
--

CREATE TABLE course_reading_documents(
    id                 NUMBER(38, 0)    NOT NULL,
    topicId            NUMBER(38, 0),
    courseReadingId    NUMBER(38, 0),
    docName            VARCHAR2(50),
    lastUpdatedBy      NUMBER(38, 0)    NOT NULL,
    lastUpdate         TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK37_1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_settings 
--

CREATE TABLE course_settings(
    id                    NUMBER(38, 0)    NOT NULL,
    courseId              NUMBER(38, 0),
    entitySettingId       NUMBER(38, 0),
    courseSettingValue    VARCHAR2(15),
    lastUpdatedBy         NUMBER(38, 0),
    lastUpdate            TIMESTAMP(6),
    CONSTRAINT PK27_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_topic_assignment 
--

CREATE TABLE course_topic_assignment(
    id               NUMBER(38, 0)    NOT NULL,
    courseId         NUMBER(38, 0),
    programId        NUMBER(38, 0),
    batchId          NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK3_4_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_topic_section 
--

CREATE TABLE course_topic_section(
    id               NUMBER(38, 0)    NOT NULL,
    courseTopicId    NUMBER(38, 0),
    sectionId        NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK3_4_1_3 PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_topics 
--

CREATE TABLE course_topics(
    id                        NUMBER(38, 0)    NOT NULL,
    courseComponentId         NUMBER(38, 0),
    topicSequence             NUMBER(3, 0),
    topicName                 VARCHAR2(35)     NOT NULL,
    topicHours                NUMBER(38, 0),
    topicDepth                VARCHAR2(10),
    isCompulsory              NUMBER(38, 0),
    sessionNoFrom             NUMBER(5, 0),
    isTemporaryIgnoreTopic    NUMBER(1, 0)     NOT NULL,
    lastUpdatedBy             NUMBER(38, 0)    NOT NULL,
    lastUpdate                TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK144 PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_variants 
--

CREATE TABLE course_variants(
    id                               NUMBER(38, 0)    NOT NULL,
    courseId                         NUMBER(38, 0),
    courseVariantCode                VARCHAR2(10),
    courseVariantDescription         VARCHAR2(100)    NOT NULL,
    courseVariantShortDescription    VARCHAR2(8)      NOT NULL,
    courseVariantHWFileLocation      VARCHAR2(255),
    courseVariantFileDwlLoc          VARCHAR2(255),
    calendarId                       NUMBER(38, 0),
    lastUpdatedBy                    NUMBER(38, 0)    NOT NULL,
    lastUpdate                       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK16_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: courses_groups 
--

CREATE TABLE courses_groups(
    id               NUMBER(38, 0)    NOT NULL,
    courseGroupId    NUMBER(38, 0),
    courseId         NUMBER(38, 0),
    isMandatory      NUMBER(1, 0)     NOT NULL,
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK5_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: currency 
--

CREATE TABLE currency(
    id    NUMBER(38, 0)    NOT NULL,
    CONSTRAINT PK89 PRIMARY KEY (id)
)
;



-- 
-- TABLE: documents_submitted 
--

CREATE TABLE documents_submitted(
    id                     NUMBER(38, 0)    NOT NULL,
    serviceRequestId       NUMBER(38, 0),
    changeDocumentsName    VARCHAR2(40),
    lastUpdatedBy          NUMBER(38, 0)    NOT NULL,
    lastUpdate             TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK70_1_1_1_1_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: emp_data_change_request 
--

CREATE TABLE emp_data_change_request(
    id                           NUMBER(38, 0)     NOT NULL,
    employeeId                   NUMBER(38, 0),
    requestDate                  DATE,
    dataGrouptoChange            VARCHAR2(2),
    approvedBy                   VARCHAR2(6),
    remarks                      VARCHAR2(4000),
    closedOn                     DATE,
    closureReason                VARCHAR2(3),
    changeDays                   NUMBER(3, 0),
    changes                      VARCHAR2(4000),
    changeStatusActive           NUMBER(1, 0)      NOT NULL,
    changeDocumentsProofReqd     NUMBER(1, 0)      NOT NULL,
    changeDocumentsProofGiven    NUMBER(1, 0)      NOT NULL,
    changeDocuments              VARCHAR2(40),
    lastUpdatedBy                NUMBER(38, 0)     NOT NULL,
    lastUpdate                   TIMESTAMP(6)       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK4_4 PRIMARY KEY (id)
)
;



-- 
-- TABLE: emp_docs 
--

CREATE TABLE emp_docs(
    id                          NUMBER(38, 0)    NOT NULL,
    employeeId                  NUMBER(38, 0)    NOT NULL,
    userId                      NUMBER(38, 0)    NOT NULL,
    docName                     VARCHAR2(6),
    dateGiven                   DATE,
    imageFileLocn               VARCHAR2(35)     NOT NULL,
    isElectronic                NUMBER(1, 0)     NOT NULL,
    isInspection                NUMBER(1, 0)     NOT NULL,
    withEmployee                VARCHAR2(6),
    docInspectedApprovedDate    DATE,
    isToBeReturned              NUMBER(1, 0)     NOT NULL,
    docReturnedDate             DATE,
    docReturnedBy               VARCHAR2(6),
    docReturnedTo               VARCHAR2(35),
    isToBeGiven                 NUMBER(1, 0)     NOT NULL,
    lastUpdatedBy               NUMBER(38, 0)    NOT NULL,
    lastUpdate                  TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK5_4 PRIMARY KEY (id)
)
;



-- 
-- TABLE: emp_perform_parameters 
--

CREATE TABLE emp_perform_parameters(
    id                NUMBER(38, 0)    NOT NULL,
    parameterName     VARCHAR2(100),
    parameterValue    VARCHAR2(30)     NOT NULL,
    lastUpdatedBy     NUMBER(38, 0)    NOT NULL,
    lastUpdate        TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK10_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: emp_performance 
--

CREATE TABLE emp_performance(
    id                    NUMBER(38, 0)    NOT NULL,
    employeeId            NUMBER(38, 0),
    performanceParamId    NUMBER(38, 0),
    assessmentYear        CHAR(10),
    assessmentStatus      CHAR(10),
    lastUpdatedBy         NUMBER(38, 0)    NOT NULL,
    lastUpdate            TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK10_1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: employee 
--

CREATE TABLE employee(
    id                   NUMBER(38, 0)    NOT NULL,
    empFName             VARCHAR2(20),
    empMName             VARCHAR2(20),
    empLName             VARCHAR2(20),
    nameToBePrinted      CHAR(15),
    gender               CHAR(10),
    addressId            NUMBER(38, 0),
    categoryOptionsId    NUMBER(38, 0),
    employeeId           VARCHAR2(10)     NOT NULL,
    castCategory         VARCHAR2(1),
    calendarId           NUMBER(38, 0),
    designation          VARCHAR2(50),
    facultyUserType      CHAR(1),
    maritalStatus        CHAR(1),
    empQualification     VARCHAR2(35),
    departmentId         NUMBER(38, 0)    NOT NULL,
    prevOrganization     VARCHAR2(100),
    yearsOfExperience    NUMBER(38, 0),
    dateOfJoining        DATE,
    dateOfExit           DATE,
    isFaculty            NUMBER(38, 0),
    lastUpdatedBy        NUMBER(38, 0)    NOT NULL,
    lastUpdate           TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK9_5 PRIMARY KEY (id)
)
;



-- 
-- TABLE: enq_address 
--

CREATE TABLE enq_address(
    id                 NUMBER(38, 0)    NOT NULL,
    enquiryId          NUMBER(19, 0),
    addressId          NUMBER(38, 0),
    addressCategory    VARCHAR2(20),
    lastUpdatedBy      NUMBER(38, 0)    NOT NULL,
    lastUpdate         TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK273 PRIMARY KEY (id)
)
;



-- 
-- TABLE: enq_closure_reason 
--

CREATE TABLE enq_closure_reason(
    id                       NUMBER(38, 0)     NOT NULL,
    enquiryId                NUMBER(19, 0),
    closureReasonId          NUMBER(38, 0),
    closureDate              DATE              NOT NULL,
    reasonRemarks            VARCHAR2(4000),
    deleteFlag               NUMBER(38, 0),
    lastUpdatedBy            NUMBER(38, 0)     NOT NULL,
    lastUpdate               TIMESTAMP(6)       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    enqStudentDetailsId      NUMBER(19, 0),
    enqAdmissionDetailsId    NUMBER(19, 0),
    CONSTRAINT PK261_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: enq_exams_details 
--

CREATE TABLE enq_exams_details(
    id                     NUMBER(19, 0)    NOT NULL,
    enquiryId              NUMBER(19, 0),
    programExamType        VARCHAR2(35),
    qualifyingProgramId    NUMBER(38, 0),
    programCondectedBy     VARCHAR2(100),
    programYear            NUMBER(38, 0),
    examResult             VARCHAR2(10),
    examStatus             VARCHAR2(5),
    deleteFlag             NUMBER(38, 0),
    lastUpdatedBy          NUMBER(38, 0)    NOT NULL,
    lastUpdate             TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK21_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: enq_followup 
--

CREATE TABLE enq_followup(
    id                    NUMBER(38, 0)      NOT NULL,
    userId                NUMBER(38, 0),
    enquiryId             NUMBER(19, 0),
    followUpNo            NUMBER(5, 0)       NOT NULL,
    followUpDate          DATE,
    actualFollowUpDate    DATE,
    deleteFlag            NUMBER(38, 0),
    remarks               VARCHAR2(4000),
    assignTo              VARCHAR2(6),
    lastUpdatedBy         NUMBER(38, 0)      NOT NULL,
    lastUpdate            TIMESTAMP(6)        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK267 PRIMARY KEY (id)
)
;



-- 
-- TABLE: enq_reopen_reason 
--

CREATE TABLE enq_reopen_reason(
    id                       NUMBER(38, 0)     NOT NULL,
    enquiryId                NUMBER(19, 0),
    reopenReasonId           NUMBER(38, 0),
    reopenDate               DATE              NOT NULL,
    reasonRemarks            VARCHAR2(4000),
    deleteFlag               NUMBER(38, 0),
    lastUpdatedBy            NUMBER(38, 0)     NOT NULL,
    lastUpdate               TIMESTAMP(6)       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    enqStudentDetailsId      NUMBER(19, 0),
    enqAdmissionDetailsId    NUMBER(19, 0),
    CONSTRAINT PK261_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: enq_student_details 
--

CREATE TABLE enq_student_details(
    id                       NUMBER(19, 0)    NOT NULL,
    enquiryId                NUMBER(19, 0),
    studentFName             VARCHAR2(20),
    studentMName             VARCHAR2(20),
    studentLName             VARCHAR2(20),
    studentGender            CHAR(2),
    studentDOB               DATE,
    gender                   CHAR(5),
    fatherFName              VARCHAR2(35),
    fatherMName              VARCHAR2(35),
    fatherLName              VARCHAR2(35),
    motherFName              VARCHAR2(35),
    motherMName              VARCHAR2(35),
    motherLName              VARCHAR2(35),
    isFatheremployed         NUMBER(1, 0)     NOT NULL,
    fatherEmployeeId         NUMBER(38, 0),
    isMotherEmployed         NUMBER(1, 0)     NOT NULL,
    motherEmployeed          NUMBER(38, 0),
    reservationCategoryId    NUMBER(38, 0),
    bloodGroup               CHAR(10),
    applnAcademicYearFor     VARCHAR2(8),
    isSiblingStudying        NUMBER(1, 0)     NOT NULL,
    sibiling1AdmissionId     NUMBER(38, 0)    NOT NULL,
    sibiling2AdmissionId     NUMBER(38, 0),
    sibiling3AdmissionId     NUMBER(38, 0),
    addressId                NUMBER(38, 0),
    familyIncome             NUMBER(38, 0),
    deleteFlag               NUMBER(38, 0),
    lastUpdatedBy            NUMBER(38, 0)    NOT NULL,
    lastUpdate               TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK19_5 PRIMARY KEY (id)
)
;



-- 
-- TABLE: enquiry 
--

CREATE TABLE enquiry(
    id                   NUMBER(19, 0)      NOT NULL,
    campaignId           NUMBER(38, 0),
    enquiryTypeId        NUMBER(38, 0),
    userId               NUMBER(38, 0),
    enquirerId           CHAR(10),
    code                 VARCHAR2(10),
    sourceCode           CHAR(10),
    registeredBy         CHAR(5),
    firstName            VARCHAR2(35)       NOT NULL,
    lastName             VARCHAR2(35)       NOT NULL,
    middleName           VARCHAR2(35),
    cellCountrycode      VARCHAR2(6),
    cellNumber           VARCHAR2(15),
    phoneCountryCode     NUMBER(38, 0),
    areaCode             VARCHAR2(10),
    regdPhoneNo          NUMBER(19, 0),
    regdEmail            VARCHAR2(50),
    enquiryDate          DATE,
    followUpDate         DATE,
    followUpUser         VARCHAR2(6),
    remarks              VARCHAR2(4000)    NOT NULL,
    status               VARCHAR2(1),
    admissioNo           NUMBER(38, 0),
    notificationError    VARCHAR2(1),
    deleteFlag           NUMBER(38, 0),
    lastUpdatedBy        NUMBER(38, 0)      NOT NULL,
    lastUpdate           TIMESTAMP(6)        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK259_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: enquiry_type 
--

CREATE TABLE enquiry_type(
    id                 NUMBER(38, 0)    NOT NULL,
    code               VARCHAR2(5),
    enquiryTypeName    VARCHAR2(10),
    lastUpdatedBy      NUMBER(38, 0),
    lastUpdate         TIMESTAMP(6),
    CONSTRAINT PK14 PRIMARY KEY (id)
)
;



-- 
-- TABLE: entity_setting 
--

CREATE TABLE entity_setting(
    id                   NUMBER(38, 0)    NOT NULL,
    fieldDataTypeCode    VARCHAR2(10)     NOT NULL,
    fieldLabel           VARCHAR2(50)     NOT NULL,
    fieldCode            VARCHAR2(50)     NOT NULL,
    mandatory            NUMBER(1, 0)     NOT NULL,
    displayOrder         NUMBER(38, 0)    NOT NULL,
    typeCode             CHAR(3)          NOT NULL,
    defaultValue         VARCHAR2(50),
    lastUpdate           DATE             NOT NULL,
    lastUpdatedBy        NUMBER(38, 0),
    CONSTRAINT PK2_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: examination_request 
--

CREATE TABLE examination_request(
    id                    NUMBER(38, 0)    NOT NULL,
    serviceRequestId      NUMBER(38, 0),
    examRequestType       NUMBER(38, 0),
    executionRequestId    NUMBER(38, 0),
    followupCommonId      NUMBER(38, 0),
    lastUpdatedBy         NUMBER(38, 0)    NOT NULL,
    lastUpdate            TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK70_1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: execution_request 
--

CREATE TABLE execution_request(
    id                      NUMBER(38, 0)     NOT NULL,
    userId                  NUMBER(38, 0),
    requestExecutionOn      DATE,
    requestExecutionMode    NUMBER(38, 0),
    closureReason           NUMBER(38, 0),
    closureRemarks          VARCHAR2(4000),
    feePlanId               NUMBER(38, 0),
    followupCommonId        NUMBER(38, 0),
    lastUpdatedBy           NUMBER(38, 0)     NOT NULL,
    lastUpdate              TIMESTAMP(6)       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK70_1_1_1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: faculty_fee_plan 
--

CREATE TABLE faculty_fee_plan(
    id    NUMBER(38, 0)    NOT NULL,
    CONSTRAINT PK32 PRIMARY KEY (id)
)
;



-- 
-- TABLE: faculty_payment_settings 
--

CREATE TABLE faculty_payment_settings(
    id               NUMBER(38, 0)    NOT NULL,
    employeeId       NUMBER(38, 0),
    academicYear     NUMBER(38, 0),
    courseCodeId     NUMBER(38, 0),
    paymentBasic     VARCHAR2(15),
    rate             NUMBER(38, 0),
    billDate         DATE,
    dueDate          DATE,
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK3_4_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: faculty_program 
--

CREATE TABLE faculty_program(
    id                   NUMBER(38, 0)    NOT NULL,
    employeeId           NUMBER(38, 0),
    courseId             NUMBER(38, 0),
    programId            NUMBER(38, 0),
    alternateFaculty     NUMBER(38, 0),
    courseComponentId    NUMBER(38, 0),
    batchId              NUMBER(38, 0),
    sectionId            NUMBER(38, 0),
    periodId             NUMBER(38, 0),
    topicId              NUMBER(38, 0),
    lastUpdatedBy        NUMBER(38, 0)    NOT NULL,
    lastUpdate           TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK3_4_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: faculty_topic_assignment 
--

CREATE TABLE faculty_topic_assignment(
    id                    NUMBER(38, 0)    NOT NULL,
    courseTopicId         NUMBER(38, 0),
    facultyId             NUMBER(38, 0),
    isAlternateFaculty    NUMBER(1, 0)     NOT NULL,
    alternateFacultyId    NUMBER(38, 0),
    lastUpdatedBy         NUMBER(38, 0)    NOT NULL,
    lastUpdate            TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK3_4_1_1_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: faculty_work_exp 
--

CREATE TABLE faculty_work_exp(
    id               NUMBER(38, 0)     NOT NULL,
    employeeId       NUMBER(38, 0)     NOT NULL,
    expSeqNo         NUMBER(3, 0),
    expCompany       VARCHAR2(35)      NOT NULL,
    expProfile       VARCHAR2(500)     NOT NULL,
    department       VARCHAR2(35),
    program          VARCHAR2(10),
    expMonths        NUMBER(5, 0)      NOT NULL,
    yearOfJoining    NUMBER(38, 0),
    expType          CHAR(1),
    expRemarks       VARCHAR2(4000),
    lastUpdatedBy    NUMBER(38, 0)     NOT NULL,
    lastUpdate       TIMESTAMP(6)       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK7_4 PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_config 
--

CREATE TABLE fee_config(
    id                    NUMBER(38, 0)     NOT NULL,
    feeStageId            NUMBER(38, 0),
    feeHeadId             NUMBER(38, 0),
    iauId                 NUMBER(38, 0),
    feeAmount             NUMBER(38, 0),
    isSplitPayment        NUMBER(1, 0)      NOT NULL,
    paymentPeriod         VARCHAR2(35),
    isInstallPostDated    NUMBER(1, 0)      NOT NULL,
    remarks               VARCHAR2(4000),
    lastUpdatedBy         NUMBER(38, 0)     NOT NULL,
    lastUpdate            TIMESTAMP(6)      NOT NULL,
    feeManageId           NUMBER(38, 0),
    CONSTRAINT PK59_2_1_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_config_modes 
--

CREATE TABLE fee_config_modes(
    id               NUMBER(38, 0)    NOT NULL,
    feeManageId      NUMBER(38, 0),
    modeOfPayment    VARCHAR2(35),
    isRefundMode     NUMBER(1, 0)     NOT NULL,
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK59_2_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_heads 
--

CREATE TABLE fee_heads(
    id               NUMBER(38, 0)    NOT NULL,
    feeHeadName      VARCHAR2(35),
    status           NUMBER(1, 0)     NOT NULL,
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK59_3 PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_installments 
--

CREATE TABLE fee_installments(
    id                 NUMBER(38, 0)    NOT NULL,
    feeConfigId        NUMBER(38, 0),
    installmentType    VARCHAR2(35),
    installmentName    VARCHAR2(35),
    billDay            NUMBER(38, 0),
    BillMonth          VARCHAR2(10),
    dueDay             NUMBER(38, 0),
    dueMonth           VARCHAR2(10),
    amount             NUMBER(38, 0),
    lastUpdatedBy      NUMBER(38, 0)    NOT NULL,
    lastUpdate         TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK59_2_1_2_1_1_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_notifications 
--

CREATE TABLE fee_notifications(
    id                  NUMBER(38, 0)    NOT NULL,
    feePlanId           NUMBER(38, 0),
    notificationType    VARCHAR2(4),
    templateId          NUMBER(38, 0),
    lastUpdatedBy       NUMBER(38, 0)    NOT NULL,
    lastUpdate          TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK59_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_plan 
--

CREATE TABLE fee_plan(
    id               NUMBER(38, 0)    NOT NULL,
    feePlanName      VARCHAR2(35),
    feePlanType      NUMBER(38, 0),
    currencyId       NUMBER(38, 0),
    feePlanStatus    CHAR(1),
    validTill        DATE,
    approver         NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK59 PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_refunds 
--

CREATE TABLE fee_refunds(
    id                NUMBER(38, 0)    NOT NULL,
    feeConfigId       NUMBER(38, 0),
    feeManageId       NUMBER(38, 0),
    refund            VARCHAR2(35),
    refundRules       VARCHAR2(255),
    natureOfRefund    VARCHAR2(35),
    lastUpdatedBy     NUMBER(38, 0)    NOT NULL,
    lastUpdate        TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK59_2_1_2_1_1_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_rule_documents 
--

CREATE TABLE fee_rule_documents(
    id               NUMBER(38, 0)    NOT NULL,
    feeRuleId        NUMBER(38, 0),
    documentId       NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK59_2_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_rules 
--

CREATE TABLE fee_rules(
    id               NUMBER(38, 0)    NOT NULL,
    feePlanId        NUMBER(38, 0),
    feeRuleName      VARCHAR2(35),
    feeRuleDesc      VARCHAR2(255),
    rule             VARCHAR2(35),
    status           CHAR(1),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK59_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_stage_wise 
--

CREATE TABLE fee_stage_wise(
    id                      NUMBER(38, 0)    NOT NULL,
    stageId                 NUMBER(38, 0),
    feePlanId               NUMBER(38, 0),
    status                  CHAR(1),
    isAllowMultiPayments    NUMBER(1, 0)     NOT NULL,
    lastUpdatedBy           NUMBER(38, 0)    NOT NULL,
    lastUpdate              TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK59_2_1_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: form_fee_payment 
--

CREATE TABLE form_fee_payment(
    id                   NUMBER(38, 0)     NOT NULL,
    receiptId            NUMBER(38, 0),
    saleFormId           NUMBER(38, 0),
    selFormId            NUMBER(38, 0),
    paidBy               VARCHAR2(35),
    collectedBy          NUMBER(38, 0),
    collectedName        VARCHAR2(100),
    paymentModeId        NUMBER(38, 0),
    feePlanId            NUMBER(38, 0),
    instrumentNo         VARCHAR2(20),
    instrumentDate       DATE,
    instrumentAmount     NUMBER(18, 5),
    InstrumentDrawnOn    VARCHAR2(35),
    reasonForRefund      VARCHAR2(100),
    remarks              VARCHAR2(100),
    programId            NUMBER(38, 0),
    locationId           NUMBER(38, 0),
    instituteId          NUMBER(38, 0),
    seatTypeId           NUMBER(38, 0),
    lastUpdatedBy        NUMBER(38, 0)     NOT NULL,
    lastUpdate           TIMESTAMP(6)       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK35_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: free_format_request 
--

CREATE TABLE free_format_request(
    id                    NUMBER(38, 0)    NOT NULL,
    serviceRequestId      NUMBER(38, 0),
    requestType           VARCHAR2(12),
    requestSubTypeId      NUMBER(38, 0),
    requestDetails        VARCHAR2(35),
    executionRequestId    NUMBER(38, 0),
    followupCommonId      DATE,
    lastUpdatedBy         NUMBER(38, 0)    NOT NULL,
    lastUpdate            TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK70_1_1_1_1_2_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: gen_fee_discount 
--

CREATE TABLE gen_fee_discount(
    id                     NUMBER(38, 0)    NOT NULL,
    feeConfigId            NUMBER(38, 0),
    isNoDiscount           NUMBER(1, 0)     NOT NULL,
    isDiscountinPercent    NUMBER(1, 0)     NOT NULL,
    percentAmt             VARCHAR2(4),
    discountRule           VARCHAR2(15),
    rule                   VARCHAR2(100),
    isFixedAmount          NUMBER(1, 0)     NOT NULL,
    fixedAmount            NUMBER(38, 0),
    isAdhoc                NUMBER(1, 0)     NOT NULL,
    updatedBy              NUMBER(38, 0)    NOT NULL,
    updatedDate            TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK59_2_1_2_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: guestfaculty_sessions 
--

CREATE TABLE guestfaculty_sessions(
    id                       NUMBER(38, 0)    NOT NULL,
    userId                   NUMBER(38, 0)    NOT NULL,
    courseVariantId          NUMBER(38, 0),
    feeType                  CHAR(1),
    sessionDate              DATE,
    sessionDateSlot          NUMBER(3, 0),
    sessionAmount            NUMBER(38, 0),
    sessionAmountCurrency    VARCHAR2(10),
    voucherRef               VARCHAR2(10),
    payVoucherRef            VARCHAR2(10),
    lastUpdatedBy            NUMBER(38, 0)    NOT NULL,
    lastUpdate               TIMESTAMP(6)    DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK189 PRIMARY KEY (id)
)
;



-- 
-- TABLE: income_slab 
--

CREATE TABLE income_slab(
    id               NUMBER(38, 0)    NOT NULL,
    fromAmount       NUMBER(18, 0),
    toAmount         NUMBER(18, 0),
    lastUpdatedBy    NUMBER(38, 0),
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK7_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: location 
--

CREATE TABLE location(
    id                NUMBER(38, 0)    NOT NULL,
    organizationId    NUMBER(38, 0)    NOT NULL,
    shortCode         VARCHAR2(10)     NOT NULL,
    locationName      VARCHAR2(255)    NOT NULL,
    startDate         DATE             NOT NULL,
    tillDate          DATE,
    status            NUMBER(1, 0)     NOT NULL,
    lastUpdate        TIMESTAMP(6)     NOT NULL,
    lastUpdatedBy     NUMBER(38, 0)    NOT NULL,
    CONSTRAINT PK6 PRIMARY KEY (id)
)
;



-- 
-- TABLE: location_address 
--

CREATE TABLE location_address(
    id               NUMBER(38, 0)    NOT NULL,
    addressId        NUMBER(38, 0),
    locationId       NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    lastUpdatedBy    DATE             NOT NULL,
    CONSTRAINT PK7 PRIMARY KEY (id)
)
;



-- 
-- TABLE: manage_modes 
--

CREATE TABLE manage_modes(
    id             NUMBER(38, 0)    NOT NULL,
    updatedBy      NUMBER(38, 0)    NOT NULL,
    updatedDate    TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK59_2_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: media 
--

CREATE TABLE media(
    id               NUMBER(38, 0)    NOT NULL,
    code             VARCHAR2(3),
    mediaName        VARCHAR2(35),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK260_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: medical_history 
--

CREATE TABLE medical_history(
    id                 NUMBER(38, 0)     NOT NULL,
    studentId          NUMBER(38, 0)     NOT NULL,
    stuIssueType       VARCHAR2(6),
    stuIssueDate       DATE,
    stuIssueDoctor     VARCHAR2(100),
    stuIssueRemarks    VARCHAR2(4000),
    lastUpdatedBy      NUMBER(38, 0)     NOT NULL,
    lastUpdate         TIMESTAMP(6)       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK8_3 PRIMARY KEY (id)
)
;



-- 
-- TABLE: modules 
--

CREATE TABLE modules(
    id               NUMBER(38, 0)    NOT NULL,
    moduleName       VARCHAR2(20)     NOT NULL,
    moduleDesc       VARCHAR2(35),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK1_7_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: organization 
--

CREATE TABLE organization(
    id               NUMBER(38, 0)    NOT NULL,
    currencyId       NUMBER(38, 0),
    typeCode         VARCHAR2(15)     NOT NULL,
    orgName          VARCHAR2(255)    NOT NULL,
    archiveDBPath    VARCHAR2(255)    NOT NULL,
    activeDBPath     VARCHAR2(255)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    calendarId       NUMBER(38, 0),
    CONSTRAINT PK1_1_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: organization_setting 
--

CREATE TABLE organization_setting(
    id                 NUMBER(38, 0)    NOT NULL,
    organizationId     NUMBER(38, 0),
    entitySettingId    NUMBER(38, 0)    NOT NULL,
    orgSettingvalue    VARCHAR2(25)     NOT NULL,
    lastUpdate         TIMESTAMP(6)     NOT NULL,
    lastUpdatedBy      NUMBER(38, 0)    NOT NULL,
    CONSTRAINT PK3_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: organization_supervisory_unit 
--

CREATE TABLE organization_supervisory_unit(
    id                        NUMBER(19, 0)    NOT NULL,
    unitName                  VARCHAR2(10),
    shortCode                 VARCHAR2(15),
    status                    NUMBER(38, 0),
    organizationUnitTypeId    NUMBER(38, 0),
    organizationId            NUMBER(38, 0),
    note                      VARCHAR2(255),
    structureTypeCode         VARCHAR2(10)     NOT NULL,
    lastUpdate                TIMESTAMP(6)     NOT NULL,
    lastUpdatedBy             NUMBER(38, 0)    NOT NULL,
    CONSTRAINT PK22_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: organization_unit 
--

CREATE TABLE organization_unit(
    id                               NUMBER(38, 0)    NOT NULL,
    organizationSupervisoryUnitId    NUMBER(19, 0),
    currencyId                       NUMBER(38, 0),
    parentOrganizationUnitId         NUMBER(38, 0),
    code                             VARCHAR2(255)    NOT NULL,
    unitName                         VARCHAR2(255)    NOT NULL,
    startDate                        DATE             NOT NULL,
    tillDate                         DATE,
    Status                           NUMBER(1, 0)     NOT NULL,
    ownerId                          NUMBER(38, 0)    NOT NULL,
    lastUpdate                       TIMESTAMP(6)     NOT NULL,
    lastUpdatedBy                    NUMBER(38, 0)    NOT NULL,
    CONSTRAINT PK22_1_1_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: organization_unit_alp 
--

CREATE TABLE organization_unit_alp(
    id                           NUMBER(38, 0)    NOT NULL,
    academyLocationPuirposeId    NUMBER(38, 0)    NOT NULL,
    organizationUnitId           NUMBER(38, 0)    NOT NULL,
    startDate                    DATE             NOT NULL,
    tillDate                     DATE,
    lastUpdate                   TIMESTAMP(6)     NOT NULL,
    lastUpdatedBy                NUMBER(38, 0)    NOT NULL,
    CONSTRAINT PK12_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: organization_unit_setting 
--

CREATE TABLE organization_unit_setting(
    id                           NUMBER(38, 0)    NOT NULL,
    academyLocationPuirposeId    NUMBER(38, 0)    NOT NULL,
    entitySettingId              NUMBER(38, 0)    NOT NULL,
    unitSettingValue             VARCHAR2(50)     NOT NULL,
    lastUpdate                   TIMESTAMP(6)     NOT NULL,
    lastUpdatedBy                NUMBER(38, 0)    NOT NULL,
    CONSTRAINT PK12_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: organization_unit_type 
--

CREATE TABLE organization_unit_type(
    id               NUMBER(38, 0)    NOT NULL,
    typeName         VARCHAR2(255)    NOT NULL,
    description      VARCHAR2(255)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    CONSTRAINT PK22_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: password_policy_notifiy 
--

CREATE TABLE password_policy_notifiy(
    id                      NUMBER(38, 0)    NOT NULL,
    modeId                  NUMBER(38, 0),
    passwordPolicyId        NUMBER(38, 0),
    sendNotificationDays    NUMBER(38, 0),
    lastUpdatedBy           NUMBER(38, 0)    NOT NULL,
    lastUpdate              TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK1_4_2_1_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: portal 
--

CREATE TABLE portal(
    id               NUMBER(38, 0)    NOT NULL,
    portalName       VARCHAR2(35)     NOT NULL,
    portalDesc       VARCHAR2(20),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK1_7_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: privilege 
--

CREATE TABLE privilege(
    id               NUMBER(38, 0)    NOT NULL,
    privilegeName    CHAR(10),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK1_7_1_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: program 
--

CREATE TABLE program(
    id                      NUMBER(38, 0)    NOT NULL,
    programCode             VARCHAR2(10)     NOT NULL,
    programName             VARCHAR2(35)     NOT NULL,
    programShortName        VARCHAR2(35),
    programNameToBePrint    VARCHAR2(35),
    isuId                   NUMBER(38, 0),
    locationId              NUMBER(38, 0),
    academyId               NUMBER(38, 0),
    approver                VARCHAR2(35)     NOT NULL,
    status                  CHAR(1),
    programGroupId          NUMBER(38, 0),
    programDepartmentId     NUMBER(38, 0),
    subDeptId               NUMBER(38, 0),
    programMarkGrade        VARCHAR2(1),
    isSucceedingProgram     NUMBER(1, 0)     NOT NULL,
    succeedingProgramId     NUMBER(38, 0),
    isCreateNewAdmission    NUMBER(38, 0),
    remarks                 VARCHAR2(255),
    categoryOptionId        NUMBER(38, 0),
    lastUpdatedBy           NUMBER(38, 0)    NOT NULL,
    lastUpdate              TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK1_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_assign_centers 
--

CREATE TABLE program_assign_centers(
    id               NUMBER(38, 0)    NOT NULL,
    examCenterId     NUMBER(38, 0),
    centerId         NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK3_2_1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_batch_period 
--

CREATE TABLE program_batch_period(
    id                                NUMBER(38, 0)     NOT NULL,
    programId                         NUMBER(38, 0),
    batchId                           NUMBER(38, 0),
    programPeriodSeq                  NUMBER(38, 0),
    programPeriodName                 VARCHAR2(10),
    programPeriodStart                DATE,
    programPeriodEnd                  DATE,
    programPeriodAutoPromotion        CHAR(1),
    programPeriodExternalPromotion    CHAR(1),
    programPeriodStartNotify          CHAR(1),
    programPeriodStartMessageType     VARCHAR2(4),
    programPeriodResponsible          VARCHAR2(6),
    programPeriodEndNotify            CHAR(1),
    programPeriodEndMessageType       VARCHAR2(4),
    programPeriodRankBasis            CHAR(1),
    minCourses                        NUMBER(38, 0),
    maxCourses                        NUMBER(38, 0),
    minCredits                        NUMBER(38, 0),
    maxCredit                         NUMBER(38, 0),
    entryCriteriaQuery                VARCHAR2(4000),
    exitCriteriaQuery                 VARCHAR2(4000),
    isPlacementPeriod                 NUMBER(1, 0)      NOT NULL,
    lastUpdatedBy                     NUMBER(38, 0)     NOT NULL,
    lastUpdate                        TIMESTAMP(6)      NOT NULL,
    CONSTRAINT PK9_3 PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_batch_seattype 
--

CREATE TABLE program_batch_seattype(
    id                     NUMBER(38, 0)    NOT NULL,
    programCodeId          NUMBER(38, 0),
    batchId                NUMBER(38, 0),
    enqSeatType            CHAR(1),
    seatCapacity           NUMBER(5, 0)     NOT NULL,
    selectionProcessId     NUMBER(38, 0),
    seatsFilled            NUMBER(5, 0)     NOT NULL,
    selProcessNote         VARCHAR2(255),
    selProcessStartDate    TIMESTAMP(6),
    selProcessEndDate      TIMESTAMP(6),
    lastUpdatedBy          NUMBER(38, 0)    NOT NULL,
    lastUpdate             TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK8_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_course 
--

CREATE TABLE program_course(
    id               NUMBER(38, 0)    NOT NULL,
    programId        NUMBER(38, 0),
    batchId          NUMBER(38, 0),
    courseId         NUMBER(38, 0),
    isOptional       NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK2_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_course_faculty_fee 
--

CREATE TABLE program_course_faculty_fee(
    id                   NUMBER(38, 0)    NOT NULL,
    courseId             NUMBER(38, 0),
    programId            NUMBER(38, 0),
    batchId              NUMBER(38, 0),
    userId               NUMBER(38, 0)    NOT NULL,
    feeType              CHAR(1),
    feeAmount            NUMBER(38, 0),
    feeAmountCurrency    NUMBER(38, 0),
    feeEffFrom           TIMESTAMP(6),
    lastUpdatedBy        NUMBER(38, 0)    NOT NULL,
    lastUpdate           TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK190 PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_course_group 
--

CREATE TABLE program_course_group(
    id                 NUMBER(38, 0)    NOT NULL,
    coursesGroupsId    NUMBER(38, 0),
    programId          NUMBER(38, 0),
    batchId            NUMBER(38, 0),
    courseId           NUMBER(38, 0),
    lastUpdatedBy      NUMBER(38, 0)    NOT NULL,
    lastUpdate         TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK3_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_course_section_req 
--

CREATE TABLE program_course_section_req(
    id                    NUMBER(38, 0)    NOT NULL,
    serviceRequestId      NUMBER(38, 0),
    fromProgramId         NUMBER(38, 0),
    toProgramId           NUMBER(38, 0),
    fromCourseId          NUMBER(38, 0),
    toCourseId            NUMBER(38, 0),
    programId             NUMBER(38, 0),
    courseId              NUMBER(38, 0),
    fromSectionId         NUMBER(38, 0),
    toSectionId           NUMBER(38, 0),
    executionRequestId    NUMBER(38, 0),
    followupCommonId      NUMBER(38, 0),
    lastUpdatedBy         NUMBER(38, 0)    NOT NULL,
    lastUpdate            TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK70_1_1_1_1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_exam_centers 
--

CREATE TABLE program_exam_centers(
    id                NUMBER(38, 0)    NOT NULL,
    batchId           NUMBER(38, 0),
    selectionStage    VARCHAR2(35),
    centerTypeId      NUMBER(38, 0),
    lastUpdatedBy     NUMBER(38, 0)    NOT NULL,
    lastUpdate        TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK3_2_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_period_breaks 
--

CREATE TABLE program_period_breaks(
    id                      NUMBER(38, 0)    NOT NULL,
    programId               NUMBER(38, 0),
    batchId                 NUMBER(38, 0),
    programBatchPeriodId    NUMBER(38, 0),
    programBreakStart       TIMESTAMP(6),
    programBreakEnd         TIMESTAMP(6),
    programBreakName        VARCHAR2(20)     NOT NULL,
    programBreakType        CHAR(1),
    programBreakStatus      CHAR(1),
    lastUpdatedBy           NUMBER(38, 0)    NOT NULL,
    lastUpdate              TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK10_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_related_course 
--

CREATE TABLE program_related_course(
    id               NUMBER(38, 0)    NOT NULL,
    batchId          NUMBER(38, 0),
    programId        NUMBER(38, 0),
    setRelation      NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK3_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_set_deadlines 
--

CREATE TABLE program_set_deadlines(
    id                      NUMBER(38, 0)    NOT NULL,
    programBatchPeriodId    NUMBER(38, 0),
    programId               NUMBER(38, 0),
    courseStartDate         DATE,
    courseEndDate           DATE,
    enrollmentLastDate      DATE,
    requestStartDate        DATE,
    requestEndDate          DATE,
    lastUpdatedBy           NUMBER(38, 0)    NOT NULL,
    lastUpdate              TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK8_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_specialization 
--

CREATE TABLE program_specialization(
    id                    NUMBER(38, 0)    NOT NULL,
    batchId               NUMBER(38, 0),
    programId             NUMBER(38, 0),
    specializationCode    VARCHAR2(10)     NOT NULL,
    lastUpdateBy          NUMBER(38, 0)    NOT NULL,
    lastUpdate            TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK6_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: reopen_reason 
--

CREATE TABLE reopen_reason(
    id               NUMBER(38, 0)    NOT NULL,
    reasonCode       VARCHAR2(3),
    status           VARCHAR2(10),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK261_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: reservation_category 
--

CREATE TABLE reservation_category(
    id               NUMBER(38, 0)    NOT NULL,
    categoryCode     VARCHAR2(10),
    categoryDesc     VARCHAR2(20),
    lastUpdatedBy    NUMBER(38, 0),
    lastUpdate       TIMESTAMP(6),
    CONSTRAINT PK18 PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_academy_locations 
--

CREATE TABLE resource_academy_locations(
    id                    NUMBER(38, 0)    NOT NULL,
    academyLocationsId    CHAR(10),
    resourceId            NUMBER(38, 0),
    lastUpdatedBy         NUMBER(38, 0),
    lastUpdate            TIMESTAMP(6),
    CONSTRAINT PK36 PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_booking 
--

CREATE TABLE resource_booking(
    id                      NUMBER(19, 0)    NOT NULL,
    sessionDate             DATE,
    isCompleteDay           NUMBER(1, 0)     NOT NULL,
    sessionDateSlot         NUMBER(3, 0),
    timeFrom                TIMESTAMP(6),
    timeTill                TIMESTAMP(6),
    isRecurring             NUMBER(1, 0)     NOT NULL,
    toDate                  DATE,
    status                  CHAR(1),
    eventName               VARCHAR2(15),
    userId                  NUMBER(38, 0),
    resourceCategoryCode    CHAR(10),
    purpose                 VARCHAR2(30),
    purposeDesc             VARCHAR2(200),
    noOfParticipants        NUMBER(38, 0),
    bookingRemark           VARCHAR2(50),
    approverRemark          VARCHAR2(50),
    feedback                VARCHAR2(100),
    approverId              NUMBER(38, 0),
    lastUpdatedBy           NUMBER(38, 0)    NOT NULL,
    lastUpdate              TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK45 PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_booking_details 
--

CREATE TABLE resource_booking_details(
    id                   NUMBER(19, 0)    NOT NULL,
    reourceId            NUMBER(38, 0),
    courseId             NUMBER(38, 0),
    programId            CHAR(10),
    batchId              NUMBER(38, 0),
    academyLocationId    CHAR(10),
    resourceBookingId    NUMBER(19, 0),
    userGroupId          NUMBER(38, 0),
    sectionId            NUMBER(38, 0),
    resouceGroupId       NUMBER(38, 0),
    userId               NUMBER(38, 0),
    resourceTypeId       NUMBER(38, 0),
    topicId              NUMBER(38, 0),
    fromTime             CHAR(10),
    toTime               CHAR(10),
    lastUpdatedBy        NUMBER(38, 0)    NOT NULL,
    lastUpdate           TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK45_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_courses 
--

CREATE TABLE resource_courses(
    id               NUMBER(38, 0)    NOT NULL,
    courseId         NUMBER(38, 0),
    resourceId       NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0),
    lastUpdate       TIMESTAMP(6),
    CONSTRAINT PK36_1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_group 
--

CREATE TABLE resource_group(
    id               NUMBER(38, 0)    NOT NULL,
    code             CHAR(10),
    groupName        VARCHAR2(20),
    lastUpdatedBy    NUMBER(38, 0),
    lastUpdate       TIMESTAMP(6),
    CONSTRAINT PK29 PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_program_batch 
--

CREATE TABLE resource_program_batch(
    id                   NUMBER(38, 0)    NOT NULL,
    batchId              NUMBER(38, 0),
    resourceProgramId    NUMBER(38, 0),
    lastUpdatedBy        NUMBER(38, 0),
    lastUpdate           TIMESTAMP(6),
    CONSTRAINT PK36_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_programs 
--

CREATE TABLE resource_programs(
    id               NUMBER(38, 0)    NOT NULL,
    programId        NUMBER(38, 0),
    resourceId       NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0),
    lastUpdate       TIMESTAMP(6),
    CONSTRAINT PK36_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_settings 
--

CREATE TABLE resource_settings(
    id                      NUMBER(38, 0)    NOT NULL,
    resourceId              NUMBER(38, 0),
    entitySettingId         NUMBER(38, 0),
    resourceSettingValue    VARCHAR2(15),
    lastUpdatedBy           NUMBER(38, 0),
    lastUpdate              TIMESTAMP(6),
    CONSTRAINT PK27_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_type 
--

CREATE TABLE resource_type(
    id                 NUMBER(38, 0)    NOT NULL,
    code               CHAR(10),
    typeName           VARCHAR2(20),
    resourceGroupId    NUMBER(38, 0),
    lastUpdatedBy      NUMBER(38, 0),
    lastUpdate         TIMESTAMP(6),
    CONSTRAINT PK29_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_unavailability 
--

CREATE TABLE resource_unavailability(
    id                NUMBER(38, 0)    NOT NULL,
    resourceTypeId    NUMBER(38, 0),
    fromDate          DATE,
    toDate            DATE,
    isCompleteDay     NUMBER(1, 0)     NOT NULL,
    timeFrom          TIMESTAMP(6),
    timeTill          TIMESTAMP(6),
    status            CHAR(1),
    reason            VARCHAR2(20),
    isPlanned         NUMBER(38, 0),
    lastUpdatedBy     NUMBER(38, 0)    NOT NULL,
    lastUpdate        TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK45_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: resources 
--

CREATE TABLE resources(
    id                          NUMBER(38, 0)    NOT NULL,
    code                        CHAR(10),
    resourceName                VARCHAR2(20),
    shortName                   VARCHAR2(15),
    resourceDesc                VARCHAR2(50),
    seatCapacity                NUMBER(38, 0),
    categoryCode                CHAR(10),
    landMark                    VARCHAR2(20),
    isConflictAcceptable        NUMBER(38, 0),
    isSharingPossible           NUMBER(38, 0),
    isDependent                 NUMBER(38, 0),
    hasParent                   NUMBER(38, 0),
    hasChild                    NUMBER(38, 0),
    parentResourceId            CHAR(10),
    isBookingAvailable          NUMBER(38, 0),
    status                      CHAR(10),
    resourceGroupId             NUMBER(38, 0),
    resourceTypeId              NUMBER(38, 0),
    nameToBePrinted             VARCHAR2(10),
    primaryAcademyLocationId    NUMBER(38, 0),
    hasSharedAcadLoc            NUMBER(38, 0),
    calenderId                  NUMBER(38, 0),
    lastUpdatedBy               NUMBER(38, 0),
    lastUpdate                  TIMESTAMP(6),
    CONSTRAINT PK29_1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: role_module_ovrride 
--

CREATE TABLE role_module_ovrride(
    id             NUMBER(38, 0)    NOT NULL,
    userRoleId     NUMBER(38, 0),
    privilegeId    NUMBER(38, 0),
    grantAccess    NUMBER(38, 0)    NOT NULL,
    updatedBy      NUMBER(38, 0)    NOT NULL,
    updatedDate    TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK1_4_1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: role_portal_access 
--

CREATE TABLE role_portal_access(
    id             NUMBER(38, 0)    NOT NULL,
    roleId         NUMBER(38, 0),
    portalId       NUMBER(38, 0),
    updatedBy      NUMBER(38, 0)    NOT NULL,
    updatedDate    TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: role_portal_module_details 
--

CREATE TABLE role_portal_module_details(
    id                    NUMBER(38, 0)    NOT NULL,
    rolePortalAccessId    NUMBER(38, 0),
    moduleId              NUMBER(38, 0),
    widgetId              NUMBER(38, 0),
    privilegeId           NUMBER(38, 0),
    grantAccess           NUMBER(1, 0)     NOT NULL,
    lastUpdatedBy         NUMBER(38, 0)    NOT NULL,
    lastUpdate            TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK1_3_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: role_wdgt_override 
--

CREATE TABLE role_wdgt_override(
    id             NUMBER(38, 0)    NOT NULL,
    userRoleId     NUMBER(38, 0),
    moduleId       NUMBER(38, 0),
    widgetId       NUMBER(38, 0),
    grantAccess    LONG RAW         NOT NULL,
    updatedBy      NUMBER(38, 0)    NOT NULL,
    updatedDate    TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK1_4_1_1_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: role_widget_access 
--

CREATE TABLE role_widget_access(
    id               NUMBER(38, 0)    NOT NULL,
    widgetId         NUMBER(38, 0),
    userRoleId       NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK1_1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: roles_core 
--

CREATE TABLE roles_core(
    id               NUMBER(38, 0)    NOT NULL,
    roleName         VARCHAR2(35)     NOT NULL,
    roleDesc         VARCHAR2(20),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK1_7 PRIMARY KEY (id)
)
;



-- 
-- TABLE: sel_seat_type 
--

CREATE TABLE sel_seat_type(
    id              NUMBER(38, 0)    NOT NULL,
    seatType        VARCHAR2(35),
    seatTypeDesc    VARCHAR2(35),
    updatedBy       NUMBER(38, 0)    NOT NULL,
    updatedDate     TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK37_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: selection_marks 
--

CREATE TABLE selection_marks(
    id               NUMBER(38, 0)    NOT NULL,
    selectStageId    NUMBER(38, 0),
    applicationId    NUMBER(38, 0),
    subject          VARCHAR2(15),
    marks            NUMBER(38, 0),
    latUpdatedBy     NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK37_2_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: selection_override 
--

CREATE TABLE selection_override(
    id                   NUMBER(38, 0)    NOT NULL,
    selectStageId        NUMBER(38, 0),
    isOverrideQuota      NUMBER(1, 0)     NOT NULL,
    isTransSeatType      NUMBER(1, 0)     NOT NULL,
    seatTypeId           NUMBER(38, 0),
    reasonForOverride    VARCHAR2(255),
    dateOfOverride       DATE,
    approvedBy           NUMBER(38, 0),
    lastUpdatedBy        NUMBER(38, 0)    NOT NULL,
    lastUpdate           TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK37_2_2_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: service_request 
--

CREATE TABLE service_request(
    id                    NUMBER(38, 0)     NOT NULL,
    userId                NUMBER(38, 0),
    studentId             NUMBER(38, 0),
    requestBy             NUMBER(38, 0),
    requestorTypeId       NUMBER(38, 0),
    requestId             NUMBER(38, 0),
    requestDate           DATE,
    requestStatus         NUMBER(1, 0)      NOT NULL,
    requestRemarks        VARCHAR2(4000),
    requestReason         VARCHAR2(255),
    executionRequestId    NUMBER(38, 0),
    followupCommonId      NUMBER(38, 0),
    lastUpdatedBy         NUMBER(38, 0)     NOT NULL,
    lastUpdate            TIMESTAMP(6)       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK70_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: stu_account_receipts 
--

CREATE TABLE stu_account_receipts(
    id                 NUMBER(38, 0)      NOT NULL,
    stuAdmissionId     NUMBER(38, 0),
    debitCredit        CHAR(1),
    documentNo         NUMBER(38, 0),
    documentDate       DATE,
    payMode            CHAR(1),
    instNo             VARCHAR2(10),
    instDate           DATE,
    instAmt            NUMBER(18, 2),
    instDrawnOn        VARCHAR2(35),
    ourBankAccount     VARCHAR2(10),
    narration          VARCHAR2(4000),
    currencyId         NUMBER(38, 0),
    currencyBaseId     NUMBER(38, 0),
    currencyBaseAmt    NUMBER(18, 2),
    accountDesc        VARCHAR2(35),
    lastUpdatedBy      NUMBER(38, 0),
    lastUpdate         TIMESTAMP(6),
    CONSTRAINT PK18_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: stu_category 
--

CREATE TABLE stu_category(
    id               NUMBER(38, 0)     NOT NULL,
    categoryDesc     VARCHAR2(100)    NOT NULL,
    lastUpdatedBy    NUMBER(38, 0),
    lastUpdate       TIMESTAMP(6),
    CONSTRAINT PK2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: stu_community 
--

CREATE TABLE stu_community(
    id               NUMBER(38, 0)     NOT NULL,
    studentId        NUMBER(38, 0),
    communityName    VARCHAR2(35),
    dateOfJoining    DATE,
    remarks          VARCHAR2(4000),
    updatedBy        NUMBER(38, 0),
    updatedDate      TIMESTAMP(6),
    CONSTRAINT PK25_1_1_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: stu_extra_curricular 
--

CREATE TABLE stu_extra_curricular(
    id               NUMBER(38, 0)      NOT NULL,
    activityId       NUMBER(38, 0),
    conducting       VARCHAR2(100)     NOT NULL,
    activityYear     DATE               NOT NULL,
    remarks          VARCHAR2(4000),
    lastUpdatedBy    NUMBER(38, 0),
    lastUpdate       TIMESTAMP(6),
    CONSTRAINT PK22_4 PRIMARY KEY (id)
)
;



-- 
-- TABLE: stu_incident_report 
--

CREATE TABLE stu_incident_report(
    id                NUMBER(38, 0)     NOT NULL,
    studentId         NUMBER(38, 0),
    incidentName      NUMBER(38, 0),
    incidentType      NUMBER(38, 0),
    reportedBy        VARCHAR2(35),
    dateOfIncident    DATE,
    actionTaken       VARCHAR2(35),
    remarks           VARCHAR2(4000),
    lastUpdatedBy     NUMBER(38, 0),
    lastUpdate        TIMESTAMP(6),
    CONSTRAINT PK25_1_1_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: stu_request_followup 
--

CREATE TABLE stu_request_followup(
    id                  NUMBER(38, 0)     NOT NULL,
    followupCommonId    NUMBER(38, 0),
    plannedFlwupDate    DATE,
    actualFlwDate       DATE,
    followUpRemarks     VARCHAR2(255),
    nextFollowUpDate    DATE,
    approverId          NUMBER(38, 0),
    approverRemarks     VARCHAR2(4000),
    lastUpdatedBy       NUMBER(38, 0)     NOT NULL,
    lastUpdate          TIMESTAMP(6)       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK70_1_1_1_1_2_1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: stu_request_followup_common 
--

CREATE TABLE stu_request_followup_common(
    id                  NUMBER(38, 0)    NOT NULL,
    serviceRequestId    NUMBER(38, 0),
    lastUpdatedBy       NUMBER(38, 0)    NOT NULL,
    lastUpdate          TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK70_1_1_1_1_2_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: stu_work_exp 
--

CREATE TABLE stu_work_exp(
    id               NUMBER(38, 0)      NOT NULL,
    studentId        NUMBER(38, 0),
    company          VARCHAR2(35)      NOT NULL,
    designation      VARCHAR2(35)      NOT NULL,
    isFullTime       NUMBER(1, 0)       NOT NULL,
    expMonths        NUMBER(38, 0)      NOT NULL,
    joiningYear      VARCHAR2(10),
    remarks          VARCHAR2(4000),
    lastUpdatedBy    NUMBER(38, 0),
    lastUpdate       TIMESTAMP(6),
    CONSTRAINT PK14_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: student 
--

CREATE TABLE student(
    id                        NUMBER(38, 0)      NOT NULL,
    admissionId               NUMBER(38, 0)      NOT NULL,
    studentFName              VARCHAR2(25),
    studentMName              VARCHAR2(25),
    studentLName              VARCHAR2(25),
    nameToBePrinted           VARCHAR2(40),
    academicYearFor           VARCHAR2(8)       NOT NULL,
    ageOverrideAppbyId        NUMBER(38, 0),
    isHostel                  NUMBER(1, 0)       NOT NULL,
    addressId                 NUMBER(38, 0),
    statusId                  NUMBER(38, 0),
    statusReasonId            NUMBER(38, 0),
    outstanding               NUMBER(18, 2)      NOT NULL,
    lastReceiptId             NUMBER(38, 0),
    incomeSlabId              NUMBER(38, 0),
    distanceTravel            NUMBER(18, 2),
    instituteId               NUMBER(38, 0),
    locationId                NUMBER(38, 0),
    programId                 NUMBER(38, 0),
    primaryAdmissionNo        VARCHAR2(10),
    isTrial                   NUMBER(1, 0)       NOT NULL,
    trialClosureDate          DATE,
    trialRejectDate           DATE,
    trialClosureReasonsId     NUMBER(38, 0),
    validTillDate             DATE,
    offerDate                 DATE,
    offerAcceptDate           DATE,
    joinDate                  DATE,
    admissionConfirmation     VARCHAR2(4),
    placementEligible         NUMBER(1, 0)       NOT NULL,
    advisorId                 NUMBER(38, 0),
    accountCode               VARCHAR2(10),
    additionalReqDetails      VARCHAR2(4000),
    additionalReqCompleted    NUMBER(1, 0)       NOT NULL,
    categoryOptionId          NUMBER(38, 0),
    lastUpdate                TIMESTAMP(6)       NOT NULL,
    lastUpdatedBy             NUMBER(38, 0)      NOT NULL,
    CONSTRAINT PK1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_attendance_details 
--

CREATE TABLE student_attendance_details(
    id                NUMBER(38, 0)    NOT NULL,
    attendanceId      NUMBER(38, 0),
    isPresent         CHAR(3),
    stuAdmissionId    NUMBER(38, 0)    NOT NULL,
    lastUpdatedBy     NUMBER(38, 0)    NOT NULL,
    lastUpdate        TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK38_3_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_attendance_record 
--

CREATE TABLE student_attendance_record(
    id                 NUMBER(38, 0)    NOT NULL,
    isCourseSection    NUMBER(1, 0)     NOT NULL,
    stuAdmissionId     NUMBER(38, 0),
    programId          NUMBER(38, 0),
    courseId           NUMBER(38, 0),
    sectionId          NUMBER(38, 0),
    batchId            NUMBER(38, 0),
    courseVariantId    NUMBER(38, 0),
    attendanceType     VARCHAR2(35),
    lastUpdatedBy      NUMBER(38, 0)    NOT NULL,
    lastUpdate         TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK38 PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_attendance_slots 
--

CREATE TABLE student_attendance_slots(
    id                       NUMBER(38, 0)    NOT NULL,
    attendanceId             NUMBER(38, 0),
    timeSlot                 VARCHAR2(10),
    inheritSameAttendance    NUMBER(1, 0)     NOT NULL,
    lastUpdatedBy            NUMBER(38, 0)    NOT NULL,
    lastUpdate               TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK38_3_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_cert_request 
--

CREATE TABLE student_cert_request(
    id                       NUMBER(38, 0)    NOT NULL,
    serviceRequestId         NUMBER(38, 0),
    certificateCategoryId    NUMBER(38, 0),
    certificateTypeId        NUMBER(38, 0),
    requestIsOrginal         NUMBER(1, 0)     NOT NULL,
    executionRequestId       NUMBER(38, 0),
    feePlanId                NUMBER(38, 0),
    followupCommonId         NUMBER(38, 0),
    lastUpdatedBy            NUMBER(38, 0)    NOT NULL,
    lastUpdate               TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK70_1_1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_course_enrollment 
--

CREATE TABLE student_course_enrollment(
    id                 NUMBER(38, 0)    NOT NULL,
    programId          NUMBER(38, 0),
    batchId            NUMBER(38, 0),
    stuAdmissionId     NUMBER(38, 0),
    courseGroupId      NUMBER(38, 0),
    courseVarientId    NUMBER(38, 0),
    isOptional         NUMBER(38, 0)    NOT NULL,
    isAudit            NUMBER(38, 0)    NOT NULL,
    isSpecialized      NUMBER(38, 0)    NOT NULL,
    lastUpdatedBy      NUMBER(38, 0)    NOT NULL,
    lastUpdate         TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK6_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_course_hw_asignmt 
--

CREATE TABLE student_course_hw_asignmt(
    id                         NUMBER(38, 0)    NOT NULL,
    batchId                    NUMBER(38, 0),
    evaluationPlanId           NUMBER(38, 0),
    evaluationGroupId          NUMBER(38, 0),
    programBatchPeriodId       NUMBER(38, 0),
    evaluationSequenceId       NUMBER(38, 0),
    detailSequence             VARCHAR2(35),
    sectionId                  NUMBER(38, 0),
    topicId                    NUMBER(38, 0),
    assignmentName             VARCHAR2(35),
    assignmentType             VARCHAR2(2),
    dateGiven                  DATE             NOT NULL,
    dateSubmitted              DATE,
    dateResubmitted            DATE,
    datetoSubmit               DATE,
    marks                      NUMBER(38, 0),
    grades                     VARCHAR2(4),
    hWRemarks                  VARCHAR2(255),
    hWOnlineSubmission         CHAR(1),
    hWOnlineSubmissionGroup    CHAR(1),
    lastUpdatedBy              NUMBER(38, 0)    NOT NULL,
    lastUpdate                 TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK40 PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_exam 
--

CREATE TABLE student_exam(
    id               NUMBER(38, 0)    NOT NULL,
    studentId        NUMBER(38, 0),
    examPassed       VARCHAR2(35),
    examResult       VARCHAR2(8)     NOT NULL,
    conductedBy      VARCHAR2(35)    NOT NULL,
    passingYear      DATE,
    studentType      VARCHAR2(35),
    enrollmentNo     VARCHAR2(10),
    lastUpdatedBy    NUMBER(38, 0),
    lastUpdate       TIMESTAMP(6),
    CONSTRAINT PK13_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_exam_subject 
--

CREATE TABLE student_exam_subject(
    id               NUMBER(38, 0)    NOT NULL,
    studentExamId    NUMBER(38, 0),
    studentId        NUMBER(38, 0),
    subjectsName     VARCHAR2(30),
    lastUpdatedBy    NUMBER(38, 0),
    lastUpdate       TIMESTAMP(6),
    CONSTRAINT PK13_1_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_faculty 
--

CREATE TABLE student_faculty(
    id               NUMBER(38, 0)    NOT NULL,
    attendanceId     NUMBER(38, 0),
    employeeId       NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK38_3 PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_hw_files 
--

CREATE TABLE student_hw_files(
    id                  NUMBER(38, 0)    NOT NULL,
    studentHwGroupId    NUMBER(38, 0),
    hWFile              VARCHAR2(100),
    lastUpdatedBy       NUMBER(38, 0)    NOT NULL,
    lastUpdate          TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK41 PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_hw_group 
--

CREATE TABLE student_hw_group(
    id                NUMBER(38, 0)    NOT NULL,
    studentId         NUMBER(38, 0),
    hwAssignmentId    NUMBER(38, 0),
    readingName       VARCHAR2(255),
    markesGrade       VARCHAR2(3),
    lastUpdatedBy     NUMBER(38, 0)    NOT NULL,
    lastUpdate        TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK39 PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_medical_history 
--

CREATE TABLE student_medical_history(
    id                  NUMBER(38, 0)      NOT NULL,
    studentId           NUMBER(38, 0),
    medicalCondition    VARCHAR2(15),
    sinceDate           DATE,
    consultingDoctor    VARCHAR2(35),
    remarks             VARCHAR2(4000),
    lastUpdatedBy       NUMBER(38, 0),
    lastUpdate          TIMESTAMP(6),
    CONSTRAINT PK15 PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_parent 
--

CREATE TABLE student_parent(
    id                NUMBER(38, 0)    NOT NULL,
    studentId         NUMBER(38, 0),
    parentType        CHAR(1)          NOT NULL,
    firstName         VARCHAR2(25),
    lastName          VARCHAR2(25),
    middleName        VARCHAR2(25),
    addressId         NUMBER(38, 0),
    status            CHAR(1),
    occupationId      NUMBER(38, 0),
    relationshipId    NUMBER(38, 0),
    incomeId          NUMBER(38, 0),
    maritalStatus     CHAR(1),
    lastUpdatedBy     NUMBER(38, 0),
    lastUpdate        TIMESTAMP(6),
    CONSTRAINT PK8_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_trans_terminate 
--

CREATE TABLE student_trans_terminate(
    id                    NUMBER(38, 0)    NOT NULL,
    studentId             NUMBER(38, 0),
    isTermination         NUMBER(1, 0)     NOT NULL,
    isTransfer            NUMBER(1, 0)     NOT NULL,
    isDebarment           NUMBER(1, 0)     NOT NULL,
    reasonId              NUMBER(38, 0),
    remarks               VARCHAR2(255),
    studentRemark         VARCHAR2(255),
    initiatedBy           NUMBER(38, 0),
    requestFollowUpId     NUMBER(38, 0),
    executionRequestId    NUMBER(38, 0),
    programCodeId         NUMBER(38, 0),
    courseCodeId          NUMBER(38, 0),
    debarmentFrom         DATE,
    debarmentTo           DATE,
    lastUpdatedBy         NUMBER(38, 0)    NOT NULL,
    lastUpdate            TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK70_1_1_1_1_2_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: study_material_distribution 
--

CREATE TABLE study_material_distribution(
    id                     NUMBER(38, 0)    NOT NULL,
    topicId                NUMBER(38, 0),
    courseId               NUMBER(38, 0),
    stuAdmissionId         NUMBER(38, 0),
    academicYear           NUMBER(38, 0),
    topicReadingType       VARCHAR2(2),
    sentDate               DATE,
    ackDate                DATE,
    sentBy                 VARCHAR2(6),
    sentDetails            VARCHAR2(255),
    serviceProviderName    VARCHAR2(35),
    isMe                   CHAR(10),
    lastUpdatedBy          NUMBER(38, 0)    NOT NULL,
    lastUpdate             TIMESTAMP(6)     NOT NULL,
    CONSTRAINT PK62 PRIMARY KEY (id)
)
;



-- 
-- TABLE: timeslots 
--

CREATE TABLE timeslots(
    id                          NUMBER(38, 0)    NOT NULL,
    resourceUnavailabilityId    NUMBER(38, 0),
    timeFrom                    VARCHAR2(15),
    timeTo                      VARCHAR2(15),
    lastUpdatedBy               NUMBER(38, 0),
    lastUpdate                  TIMESTAMP(6),
    CONSTRAINT PK27_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: user_academylocation 
--

CREATE TABLE user_academylocation(
    id                   NUMBER(38, 0)    NOT NULL,
    userId               NUMBER(38, 0),
    academyLocationId    NUMBER(38, 0),
    isPrimary            NUMBER(1, 0)     NOT NULL,
    fromDate             DATE,
    toDate               DATE,
    lastUpdatedBy        NUMBER(38, 0)    NOT NULL,
    lastUpdate           TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK1_4_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: user_courses 
--

CREATE TABLE user_courses(
    id               NUMBER(38, 0)    NOT NULL,
    userProgramId    NUMBER(38, 0),
    courseGroupId    NUMBER(38, 0),
    courseId         NUMBER(38, 0),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK1_4_2_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: user_password_policy 
--

CREATE TABLE user_password_policy(
    id                              NUMBER(38, 0)    NOT NULL,
    passwordMinLength               NUMBER(38, 0),
    passwordMaxLength               NUMBER(38, 0),
    minSpecialChars                 NUMBER(38, 0),
    minDigits                       NUMBER(38, 0)    NOT NULL,
    isAlphabetsReq                  NUMBER(1, 0)     NOT NULL,
    isUpperCaseReq                  NUMBER(1, 0)     NOT NULL,
    minUppercase                    CHAR(10),
    isLowerCaseReq                  NUMBER(1, 0)     NOT NULL,
    minLowercase                    NUMBER(38, 0),
    isPreventPasswordReuse          NUMBER(1, 0)     NOT NULL,
    isPreventUsernamePart           NUMBER(1, 0)     NOT NULL,
    isPreventFirstCharAsDigit       NUMBER(1, 0)     NOT NULL,
    isPreventFirstCharAsSpecSymb    NUMBER(1, 0)     NOT NULL,
    isPasswordNeverExpires          NUMBER(1, 0)     NOT NULL,
    maxPasswordAge                  NUMBER(38, 0),
    isLockUotUser                   NUMBER(1, 0)     NOT NULL,
    lockedAttempts                  NUMBER(38, 0),
    isAutomaticUnlockPassword       NUMBER(1, 0)     NOT NULL,
    lastUpdatedBy                   NUMBER(38, 0)    NOT NULL,
    lastUpdate                      TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK1_4_2_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: user_programs 
--

CREATE TABLE user_programs(
    id                   NUMBER(38, 0)    NOT NULL,
    academyLocationId    NUMBER(38, 0),
    programId            NUMBER(38, 0),
    lastUpdatedBy        NUMBER(38, 0)    NOT NULL,
    lastUpdate           TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK1_4_2_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: user_roles 
--

CREATE TABLE user_roles(
    id                    NUMBER(38, 0)    NOT NULL,
    userAcadLocationId    NUMBER(38, 0),
    roleId                NUMBER(38, 0),
    fromDate              DATE,
    toDate                DATE,
    lastUpdatedBy         NUMBER(38, 0)    NOT NULL,
    lastUpdate            TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK1_4_1_1 PRIMARY KEY (id)
)
;



-- 
-- TABLE: users 
--

CREATE TABLE users(
    id                    NUMBER(38, 0)    NOT NULL,
    code                  CHAR(10),
    salutation            CHAR(5),
    firstName             VARCHAR2(20),
    miNameddl             VARCHAR2(20),
    lastName              VARCHAR2(20),
    shortName             VARCHAR2(20),
    nameToBePrinted       VARCHAR2(60),
    status                CHAR(10),
    userCategory          CHAR(10),
    password              VARCHAR2(20),
    lockedOn              TIMESTAMP(6),
    lastTimeReleasedOn    TIMESTAMP(6),
    noOfTimesLocked       NUMBER(38, 0),
    noOfLoginFailed       NUMBER(38, 0),
    calendarId            CHAR(10),
    userGroup             CHAR(10),
    departmentId          NUMBER(38, 0),
    subDepartmentId       NUMBER(38, 0),
    lastLoggedIn          TIMESTAMP(6),
    lastUpdatedBy         NUMBER(38, 0),
    lastUpdate            TIMESTAMP(6),
    CONSTRAINT PK21 PRIMARY KEY (id)
)
;



-- 
-- TABLE: widget 
--

CREATE TABLE widget(
    id               NUMBER(38, 0)    NOT NULL,
    widgetName       CHAR(10),
    widgetDesc       VARCHAR2(20),
    lastUpdatedBy    NUMBER(38, 0)    NOT NULL,
    lastUpdate       TIMESTAMP(6)      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    CONSTRAINT PK1_7_1_2 PRIMARY KEY (id)
)
;



-- 
-- TABLE: acad_loc_purpose_setting 
--

ALTER TABLE acad_loc_purpose_setting ADD CONSTRAINT Refentity_setting98 
    FOREIGN KEY (entitySettingId)
    REFERENCES entity_setting(id)
;

ALTER TABLE acad_loc_purpose_setting ADD CONSTRAINT Refacademy_location_purpose130 
    FOREIGN KEY (academyLocationPurposeId)
    REFERENCES academy_location_purpose(id)
;


-- 
-- TABLE: academy 
--

ALTER TABLE academy ADD CONSTRAINT Reforganization132 
    FOREIGN KEY (organizationId)
    REFERENCES organization(id)
;


-- 
-- TABLE: academy_location 
--

ALTER TABLE academy_location ADD CONSTRAINT Refacademy_year_tenure119 
    FOREIGN KEY (currentAcademyYearTenureId)
    REFERENCES academy_year_tenure(id)
;

ALTER TABLE academy_location ADD CONSTRAINT Refacademy_year120 
    FOREIGN KEY (academicYearId)
    REFERENCES academy_year(id)
;

ALTER TABLE academy_location ADD CONSTRAINT Reflocation125 
    FOREIGN KEY (locationId)
    REFERENCES location(id)
;

ALTER TABLE academy_location ADD CONSTRAINT Refacademy133 
    FOREIGN KEY (academyId)
    REFERENCES academy(id)
;


-- 
-- TABLE: academy_location_purpose 
--

ALTER TABLE academy_location_purpose ADD CONSTRAINT Refacademy_location126 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;

ALTER TABLE academy_location_purpose ADD CONSTRAINT Reffaculty_fee_plan134 
    FOREIGN KEY (facultyFeePlanId)
    REFERENCES faculty_fee_plan(id)
;

ALTER TABLE academy_location_purpose ADD CONSTRAINT Refcalendar139 
    FOREIGN KEY (calendarId)
    REFERENCES calendar(id)
;


-- 
-- TABLE: academy_location_setting 
--

ALTER TABLE academy_location_setting ADD CONSTRAINT Refentity_setting101 
    FOREIGN KEY (entitySettingId)
    REFERENCES entity_setting(id)
;

ALTER TABLE academy_location_setting ADD CONSTRAINT Refacademy_location128 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;


-- 
-- TABLE: academy_year_tenure 
--

ALTER TABLE academy_year_tenure ADD CONSTRAINT Refacademy_year105 
    FOREIGN KEY (academyYearId)
    REFERENCES academy_year(id)
;


-- 
-- TABLE: address 
--

ALTER TABLE address ADD CONSTRAINT Refcountry_region32 
    FOREIGN KEY (countryRegionId)
    REFERENCES country_region(id)
;

ALTER TABLE address ADD CONSTRAINT Refaddress_type33 
    FOREIGN KEY (addressTypeId)
    REFERENCES address_type(id)
;

ALTER TABLE address ADD CONSTRAINT Refcity37 
    FOREIGN KEY (cityId)
    REFERENCES city(id)
;

ALTER TABLE address ADD CONSTRAINT Refcountry_region38 
    FOREIGN KEY (parentRegionId)
    REFERENCES country_region(id)
;


-- 
-- TABLE: admission_enq_details 
--

ALTER TABLE admission_enq_details ADD CONSTRAINT Refenq_student_details24 
    FOREIGN KEY (enqStudentDetailsId)
    REFERENCES enq_student_details(id)
;

ALTER TABLE admission_enq_details ADD CONSTRAINT Refenq_closure_reason55 
    FOREIGN KEY (enquiryClosureReasonId)
    REFERENCES enq_closure_reason(id)
;

ALTER TABLE admission_enq_details ADD CONSTRAINT Refenq_reopen_reason56 
    FOREIGN KEY (enquiryReopenReasonId)
    REFERENCES enq_reopen_reason(id)
;


-- 
-- TABLE: admission_form_preference 
--

ALTER TABLE admission_form_preference ADD CONSTRAINT Refadmission_form_sale220 
    FOREIGN KEY (saleFormId)
    REFERENCES admission_form_sale(id)
;


-- 
-- TABLE: alternate_faculty 
--

ALTER TABLE alternate_faculty ADD CONSTRAINT Reffaculty_topic_assignment177 
    FOREIGN KEY (facultyTopicId)
    REFERENCES faculty_topic_assignment(id)
;


-- 
-- TABLE: calendar_academylocation 
--

ALTER TABLE calendar_academylocation ADD CONSTRAINT Refcalendar70 
    FOREIGN KEY (calendarId)
    REFERENCES calendar(id)
;


-- 
-- TABLE: calendar_holidays 
--

ALTER TABLE calendar_holidays ADD CONSTRAINT Refcalendar66 
    FOREIGN KEY (calendarId)
    REFERENCES calendar(id)
;


-- 
-- TABLE: calendar_specialday 
--

ALTER TABLE calendar_specialday ADD CONSTRAINT Refcalendar69 
    FOREIGN KEY (calendarId)
    REFERENCES calendar(id)
;


-- 
-- TABLE: calendar_weektimings 
--

ALTER TABLE calendar_weektimings ADD CONSTRAINT Refcalendar68 
    FOREIGN KEY (calendarId)
    REFERENCES calendar(id)
;


-- 
-- TABLE: camp_coverage_user 
--

ALTER TABLE camp_coverage_user ADD CONSTRAINT Refcampaign_coverage20 
    FOREIGN KEY (campaignCoverageId)
    REFERENCES campaign_coverage(id)
;

ALTER TABLE camp_coverage_user ADD CONSTRAINT Refusers22 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;


-- 
-- TABLE: campaign 
--

ALTER TABLE campaign ADD CONSTRAINT Refusers23 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;


-- 
-- TABLE: campaign_coverage 
--

ALTER TABLE campaign_coverage ADD CONSTRAINT Refcampaign3 
    FOREIGN KEY (campaignId)
    REFERENCES campaign(id)
;

ALTER TABLE campaign_coverage ADD CONSTRAINT Refusers21 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;


-- 
-- TABLE: campaign_media 
--

ALTER TABLE campaign_media ADD CONSTRAINT Refmedia1 
    FOREIGN KEY (mediaId)
    REFERENCES media(id)
;

ALTER TABLE campaign_media ADD CONSTRAINT Refcampaign2 
    FOREIGN KEY (campaignId)
    REFERENCES campaign(id)
;


-- 
-- TABLE: city 
--

ALTER TABLE city ADD CONSTRAINT Refcountry_region39 
    FOREIGN KEY (countryId)
    REFERENCES country_region(id)
;


-- 
-- TABLE: country_region 
--

ALTER TABLE country_region ADD CONSTRAINT Refcountry31 
    FOREIGN KEY (countryId)
    REFERENCES country(id)
;


-- 
-- TABLE: course_components 
--

ALTER TABLE course_components ADD CONSTRAINT Refcourse164 
    FOREIGN KEY (courseId)
    REFERENCES course(id)
;


-- 
-- TABLE: course_coverage_plan 
--

ALTER TABLE course_coverage_plan ADD CONSTRAINT Refcourse179 
    FOREIGN KEY (courseId)
    REFERENCES course(id)
;


-- 
-- TABLE: course_coverage_plan_details 
--

ALTER TABLE course_coverage_plan_details ADD CONSTRAINT Refcourse_coverage_plan178 
    FOREIGN KEY (courseCoveragePlanId)
    REFERENCES course_coverage_plan(id)
;


-- 
-- TABLE: course_equivalence 
--

ALTER TABLE course_equivalence ADD CONSTRAINT Refcourse_components161 
    FOREIGN KEY (courseComponentId)
    REFERENCES course_components(id)
;


-- 
-- TABLE: course_isu_link 
--

ALTER TABLE course_isu_link ADD CONSTRAINT Refcourse165 
    FOREIGN KEY (courseId)
    REFERENCES course(id)
;


-- 
-- TABLE: course_reading 
--

ALTER TABLE course_reading ADD CONSTRAINT Refcourse_topics158 
    FOREIGN KEY (topicId)
    REFERENCES course_topics(id)
;

ALTER TABLE course_reading ADD CONSTRAINT Refcourse159 
    FOREIGN KEY (courseId)
    REFERENCES course(id)
;


-- 
-- TABLE: course_reading_documents 
--

ALTER TABLE course_reading_documents ADD CONSTRAINT Refcourse_reading180 
    FOREIGN KEY (courseReadingId)
    REFERENCES course_reading(id)
;


-- 
-- TABLE: course_settings 
--

ALTER TABLE course_settings ADD CONSTRAINT Refcourse174 
    FOREIGN KEY (courseId)
    REFERENCES course(id)
;


-- 
-- TABLE: course_topic_assignment 
--

ALTER TABLE course_topic_assignment ADD CONSTRAINT Refcourse176 
    FOREIGN KEY (courseId)
    REFERENCES course(id)
;


-- 
-- TABLE: course_topic_section 
--

ALTER TABLE course_topic_section ADD CONSTRAINT Refcourse_topics175 
    FOREIGN KEY (courseTopicId)
    REFERENCES course_topics(id)
;


-- 
-- TABLE: course_topics 
--

ALTER TABLE course_topics ADD CONSTRAINT Refcourse_components160 
    FOREIGN KEY (courseComponentId)
    REFERENCES course_components(id)
;


-- 
-- TABLE: course_variants 
--

ALTER TABLE course_variants ADD CONSTRAINT Refcourse163 
    FOREIGN KEY (courseId)
    REFERENCES course(id)
;


-- 
-- TABLE: courses_groups 
--

ALTER TABLE courses_groups ADD CONSTRAINT Refcourse_group162 
    FOREIGN KEY (courseGroupId)
    REFERENCES course_group(id)
;

ALTER TABLE courses_groups ADD CONSTRAINT Refcourse166 
    FOREIGN KEY (courseId)
    REFERENCES course(id)
;


-- 
-- TABLE: documents_submitted 
--

ALTER TABLE documents_submitted ADD CONSTRAINT Refservice_request245 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_request(id)
;


-- 
-- TABLE: emp_data_change_request 
--

ALTER TABLE emp_data_change_request ADD CONSTRAINT Refemployee248 
    FOREIGN KEY (employeeId)
    REFERENCES employee(id)
;


-- 
-- TABLE: emp_docs 
--

ALTER TABLE emp_docs ADD CONSTRAINT Refemployee239 
    FOREIGN KEY (employeeId)
    REFERENCES employee(id)
;


-- 
-- TABLE: emp_performance 
--

ALTER TABLE emp_performance ADD CONSTRAINT Refemployee246 
    FOREIGN KEY (employeeId)
    REFERENCES employee(id)
;

ALTER TABLE emp_performance ADD CONSTRAINT Refemp_perform_parameters247 
    FOREIGN KEY (performanceParamId)
    REFERENCES emp_perform_parameters(id)
;


-- 
-- TABLE: enq_address 
--

ALTER TABLE enq_address ADD CONSTRAINT Refenquiry13 
    FOREIGN KEY (enquiryId)
    REFERENCES enquiry(id)
;

ALTER TABLE enq_address ADD CONSTRAINT Refaddress34 
    FOREIGN KEY (addressId)
    REFERENCES address(id)
;


-- 
-- TABLE: enq_closure_reason 
--

ALTER TABLE enq_closure_reason ADD CONSTRAINT Refenq_student_details149 
    FOREIGN KEY (enqStudentDetailsId)
    REFERENCES enq_student_details(id)
;

ALTER TABLE enq_closure_reason ADD CONSTRAINT Refadmission_enq_details150 
    FOREIGN KEY (enqAdmissionDetailsId)
    REFERENCES admission_enq_details(id)
;

ALTER TABLE enq_closure_reason ADD CONSTRAINT Refenquiry50 
    FOREIGN KEY (enquiryId)
    REFERENCES enquiry(id)
;

ALTER TABLE enq_closure_reason ADD CONSTRAINT Refclosure_reason51 
    FOREIGN KEY (closureReasonId)
    REFERENCES closure_reason(id)
;


-- 
-- TABLE: enq_exams_details 
--

ALTER TABLE enq_exams_details ADD CONSTRAINT Refenquiry14 
    FOREIGN KEY (enquiryId)
    REFERENCES enquiry(id)
;


-- 
-- TABLE: enq_followup 
--

ALTER TABLE enq_followup ADD CONSTRAINT Refenquiry5 
    FOREIGN KEY (enquiryId)
    REFERENCES enquiry(id)
;


ALTER TABLE enq_followup ADD CONSTRAINT Refusers35 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;


-- 
-- TABLE: enq_reopen_reason 
--

ALTER TABLE enq_reopen_reason ADD CONSTRAINT Refenq_student_details151 
    FOREIGN KEY (enqStudentDetailsId)
    REFERENCES enq_student_details(id)
;

ALTER TABLE enq_reopen_reason ADD CONSTRAINT Refadmission_enq_details152 
    FOREIGN KEY (enqAdmissionDetailsId)
    REFERENCES admission_enq_details(id)
;

ALTER TABLE enq_reopen_reason ADD CONSTRAINT Refenquiry52 
    FOREIGN KEY (enquiryId)
    REFERENCES enquiry(id)
;

ALTER TABLE enq_reopen_reason ADD CONSTRAINT Refreopen_reason53 
    FOREIGN KEY (reopenReasonId)
    REFERENCES reopen_reason(id)
;


-- 
-- TABLE: enq_student_details 
--

ALTER TABLE enq_student_details ADD CONSTRAINT Refenquiry17 
    FOREIGN KEY (enquiryId)
    REFERENCES enquiry(id)
;

ALTER TABLE enq_student_details ADD CONSTRAINT Refaddress40 
    FOREIGN KEY (addressId)
    REFERENCES address(id)
;

ALTER TABLE enq_student_details ADD CONSTRAINT Refreservation_category48 
    FOREIGN KEY (reservationCategoryId)
    REFERENCES reservation_category(id)
;


-- 
-- TABLE: enquiry 
--

ALTER TABLE enquiry ADD CONSTRAINT Refenquiry_type15 
    FOREIGN KEY (enquiryTypeId)
    REFERENCES enquiry_type(id)
;

ALTER TABLE enquiry ADD CONSTRAINT Refcampaign10 
    FOREIGN KEY (campaignId)
    REFERENCES campaign(id)
;

ALTER TABLE enquiry ADD CONSTRAINT Refusers47 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;


-- 
-- TABLE: examination_request 
--

ALTER TABLE examination_request ADD CONSTRAINT Refservice_request229 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_request(id)
;


-- 
-- TABLE: faculty_payment_settings 
--

ALTER TABLE faculty_payment_settings ADD CONSTRAINT Refemployee240 
    FOREIGN KEY (employeeId)
    REFERENCES employee(id)
;


-- 
-- TABLE: faculty_program 
--

ALTER TABLE faculty_program ADD CONSTRAINT Refemployee241 
    FOREIGN KEY (employeeId)
    REFERENCES employee(id)
;


-- 
-- TABLE: faculty_work_exp 
--

ALTER TABLE faculty_work_exp ADD CONSTRAINT Refemployee237 
    FOREIGN KEY (employeeId)
    REFERENCES employee(id)
;


-- 
-- TABLE: fee_config 
--

ALTER TABLE fee_config ADD CONSTRAINT Refmanage_modes252 
    FOREIGN KEY (feeManageId)
    REFERENCES manage_modes(id)
;

ALTER TABLE fee_config ADD CONSTRAINT Reffee_stage_wise255 
    FOREIGN KEY (feeStageId)
    REFERENCES fee_stage_wise(id)
;

ALTER TABLE fee_config ADD CONSTRAINT Reffee_heads260 
    FOREIGN KEY (feeHeadId)
    REFERENCES fee_heads(id)
;


-- 
-- TABLE: fee_config_modes 
--

ALTER TABLE fee_config_modes ADD CONSTRAINT Refmanage_modes251 
    FOREIGN KEY (feeManageId)
    REFERENCES manage_modes(id)
;

-- 
-- TABLE: fee_installments 
--

ALTER TABLE fee_installments ADD CONSTRAINT Reffee_config256 
    FOREIGN KEY (feeConfigId)
    REFERENCES fee_config(id)
;


-- 
-- TABLE: fee_notifications 
--

ALTER TABLE fee_notifications ADD CONSTRAINT Reffee_plan258 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;


-- 
-- TABLE: fee_refunds 
--

ALTER TABLE fee_refunds ADD CONSTRAINT Refmanage_modes253 
    FOREIGN KEY (feeManageId)
    REFERENCES manage_modes(id)
;

ALTER TABLE fee_refunds ADD CONSTRAINT Reffee_config257 
    FOREIGN KEY (feeConfigId)
    REFERENCES fee_config(id)
;


-- 
-- TABLE: fee_rule_documents 
--

ALTER TABLE fee_rule_documents ADD CONSTRAINT Reffee_rules249 
    FOREIGN KEY (feeRuleId)
    REFERENCES fee_rules(id)
;


-- 
-- TABLE: fee_rules 
--

ALTER TABLE fee_rules ADD CONSTRAINT Reffee_plan250 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;


-- 
-- TABLE: fee_stage_wise 
--

ALTER TABLE fee_stage_wise ADD CONSTRAINT Reffee_plan259 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;


-- 
-- TABLE: form_fee_payment 
--

ALTER TABLE form_fee_payment ADD CONSTRAINT Refadmission_form_sale221 
    FOREIGN KEY (saleFormId)
    REFERENCES admission_form_sale(id)
;


-- 
-- TABLE: free_format_request 
--

ALTER TABLE free_format_request ADD CONSTRAINT Refservice_request231 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_request(id)
;


-- 
-- TABLE: gen_fee_discount 
--

ALTER TABLE gen_fee_discount ADD CONSTRAINT Reffee_config254 
    FOREIGN KEY (feeConfigId)
    REFERENCES fee_config(id)
;


-- 
-- TABLE: guestfaculty_sessions 
--

ALTER TABLE guestfaculty_sessions ADD CONSTRAINT Refemployee234 
    FOREIGN KEY (userId)
    REFERENCES employee(id)
;


-- 
-- TABLE: location 
--

ALTER TABLE location ADD CONSTRAINT Reforganization135 
    FOREIGN KEY (organizationId)
    REFERENCES organization(id)
;


-- 
-- TABLE: location_address 
--

ALTER TABLE location_address ADD CONSTRAINT Reflocation123 
    FOREIGN KEY (locationId)
    REFERENCES location(id)
;

ALTER TABLE location_address ADD CONSTRAINT Refaddress138 
    FOREIGN KEY (addressId)
    REFERENCES address(id)
;


-- 
-- TABLE: organization 
--

ALTER TABLE organization ADD CONSTRAINT Refcalendar140 
    FOREIGN KEY (calendarId)
    REFERENCES calendar(id)
;

ALTER TABLE organization ADD CONSTRAINT Refcurrency142 
    FOREIGN KEY (currencyId)
    REFERENCES currency(id)
;


-- 
-- TABLE: organization_setting 
--

ALTER TABLE organization_setting ADD CONSTRAINT Refentity_setting99 
    FOREIGN KEY (entitySettingId)
    REFERENCES entity_setting(id)
;

ALTER TABLE organization_setting ADD CONSTRAINT Reforganization121 
    FOREIGN KEY (organizationId)
    REFERENCES organization(id)
;


-- 
-- TABLE: organization_supervisory_unit 
--

ALTER TABLE organization_supervisory_unit ADD CONSTRAINT Reforganization_unit_type263 
    FOREIGN KEY (organizationUnitTypeId)
    REFERENCES organization_unit_type(id)
;

ALTER TABLE organization_supervisory_unit ADD CONSTRAINT Reforganization265 
    FOREIGN KEY (organizationId)
    REFERENCES organization(id)
;


-- 
-- TABLE: organization_unit 
--

ALTER TABLE organization_unit ADD CONSTRAINT Reforganization_unit96 
    FOREIGN KEY (parentOrganizationUnitId)
    REFERENCES organization_unit(id)
;

ALTER TABLE organization_unit ADD CONSTRAINT Refcurrency141 
    FOREIGN KEY (currencyId)
    REFERENCES currency(id)
;

ALTER TABLE organization_unit ADD CONSTRAINT Reforganization_supervisory264 
    FOREIGN KEY (organizationSupervisoryUnitId)
    REFERENCES organization_supervisory_unit(id)
;


-- 
-- TABLE: organization_unit_alp 
--

ALTER TABLE organization_unit_alp ADD CONSTRAINT Refacademy_location_purpose94 
    FOREIGN KEY (academyLocationPuirposeId)
    REFERENCES academy_location_purpose(id)
;

ALTER TABLE organization_unit_alp ADD CONSTRAINT Reforganization_unit97 
    FOREIGN KEY (organizationUnitId)
    REFERENCES organization_unit(id)
;


-- 
-- TABLE: organization_unit_setting 
--

ALTER TABLE organization_unit_setting ADD CONSTRAINT Refacademy_location_purpose93 
    FOREIGN KEY (academyLocationPuirposeId)
    REFERENCES academy_location_purpose(id)
;

ALTER TABLE organization_unit_setting ADD CONSTRAINT Refentity_setting103 
    FOREIGN KEY (entitySettingId)
    REFERENCES entity_setting(id)
;


-- 
-- TABLE: password_policy_notifiy 
--

ALTER TABLE password_policy_notifiy ADD CONSTRAINT Refuser_password_policy215 
    FOREIGN KEY (passwordPolicyId)
    REFERENCES user_password_policy(id)
;


-- 
-- TABLE: program_assign_centers 
--

ALTER TABLE program_assign_centers ADD CONSTRAINT Refprogram_exam_centers191 
    FOREIGN KEY (examCenterId)
    REFERENCES program_exam_centers(id)
;


-- 
-- TABLE: program_batch_period 
--

ALTER TABLE program_batch_period ADD CONSTRAINT Refprogram184 
    FOREIGN KEY (programId)
    REFERENCES program(id)
;


-- 
-- TABLE: program_batch_seattype 
--

ALTER TABLE program_batch_seattype ADD CONSTRAINT Refprogram185 
    FOREIGN KEY (programCodeId)
    REFERENCES program(id)
;


-- 
-- TABLE: program_course 
--

ALTER TABLE program_course ADD CONSTRAINT Refcourse186 
    FOREIGN KEY (courseId)
    REFERENCES course(id)
;

ALTER TABLE program_course ADD CONSTRAINT Refprogram190 
    FOREIGN KEY (programId)
    REFERENCES program(id)
;


-- 
-- TABLE: program_course_faculty_fee 
--

ALTER TABLE program_course_faculty_fee ADD CONSTRAINT Refemployee235 
    FOREIGN KEY (userId)
    REFERENCES employee(id)
;


-- 
-- TABLE: program_course_group 
--

ALTER TABLE program_course_group ADD CONSTRAINT Refprogram183 
    FOREIGN KEY (programId)
    REFERENCES program(id)
;

ALTER TABLE program_course_group ADD CONSTRAINT Refcourse187 
    FOREIGN KEY (courseId)
    REFERENCES course(id)
;

ALTER TABLE program_course_group ADD CONSTRAINT Refcourse_group188 
    FOREIGN KEY (coursesGroupsId)
    REFERENCES course_group(id)
;

ALTER TABLE program_course_group ADD CONSTRAINT Refcourses_groups189 
    FOREIGN KEY (coursesGroupsId)
    REFERENCES courses_groups(id)
;


-- 
-- TABLE: program_course_section_req 
--

ALTER TABLE program_course_section_req ADD CONSTRAINT Refservice_request230 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_request(id)
;


-- 
-- TABLE: program_exam_centers 
--

ALTER TABLE program_exam_centers ADD CONSTRAINT Refbatch207 
    FOREIGN KEY (batchId)
    REFERENCES batch(id)
;


-- 
-- TABLE: program_period_breaks 
--

ALTER TABLE program_period_breaks ADD CONSTRAINT Refprogram_batch_period181 
    FOREIGN KEY (programBatchPeriodId)
    REFERENCES program_batch_period(id)
;

ALTER TABLE program_period_breaks ADD CONSTRAINT Refprogram182 
    FOREIGN KEY (programId)
    REFERENCES program(id)
;


-- 
-- TABLE: program_related_course 
--

ALTER TABLE program_related_course ADD CONSTRAINT Refprogram_batch_period195 
    FOREIGN KEY (programId)
    REFERENCES program_batch_period(id)
;

ALTER TABLE program_related_course ADD CONSTRAINT Refbatch199 
    FOREIGN KEY (batchId)
    REFERENCES batch(id)
;


-- 
-- TABLE: program_set_deadlines 
--

ALTER TABLE program_set_deadlines ADD CONSTRAINT Refprogram_batch_period193 
    FOREIGN KEY (programBatchPeriodId)
    REFERENCES program_batch_period(id)
;

ALTER TABLE program_set_deadlines ADD CONSTRAINT Refprogram194 
    FOREIGN KEY (programId)
    REFERENCES program(id)
;


-- 
-- TABLE: program_specialization 
--

ALTER TABLE program_specialization ADD CONSTRAINT Refprogram192 
    FOREIGN KEY (programId)
    REFERENCES program(id)
;


-- 
-- TABLE: resource_academy_locations 
--

ALTER TABLE resource_academy_locations ADD CONSTRAINT Refresources57 
    FOREIGN KEY (resourceId)
    REFERENCES resources(id)
;


-- 
-- TABLE: resource_booking 
--

ALTER TABLE resource_booking ADD CONSTRAINT Refusers148 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE resource_booking ADD CONSTRAINT Refusers154 
    FOREIGN KEY (approverId)
    REFERENCES users(id)
;


-- 
-- TABLE: resource_booking_details 
--

ALTER TABLE resource_booking_details ADD CONSTRAINT Refresource_booking79 
    FOREIGN KEY (resourceBookingId)
    REFERENCES resource_booking(id)
;

ALTER TABLE resource_booking_details ADD CONSTRAINT Refresources90 
    FOREIGN KEY (reourceId)
    REFERENCES resources(id)
;

ALTER TABLE resource_booking_details ADD CONSTRAINT Refresource_group91 
    FOREIGN KEY (resouceGroupId)
    REFERENCES resource_group(id)
;

ALTER TABLE resource_booking_details ADD CONSTRAINT Refresource_type92 
    FOREIGN KEY (resourceTypeId)
    REFERENCES resource_type(id)
;

ALTER TABLE resource_booking_details ADD CONSTRAINT Refusers80 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;


-- 
-- TABLE: resource_courses 
--

ALTER TABLE resource_courses ADD CONSTRAINT Refresources60 
    FOREIGN KEY (resourceId)
    REFERENCES resources(id)
;


-- 
-- TABLE: resource_program_batch 
--

ALTER TABLE resource_program_batch ADD CONSTRAINT Refresource_programs77 
    FOREIGN KEY (resourceProgramId)
    REFERENCES resource_programs(id)
;


-- 
-- TABLE: resource_programs 
--

ALTER TABLE resource_programs ADD CONSTRAINT Refresources59 
    FOREIGN KEY (resourceId)
    REFERENCES resources(id)
;


-- 
-- TABLE: resource_settings 
--

ALTER TABLE resource_settings ADD CONSTRAINT Refresources143 
    FOREIGN KEY (resourceId)
    REFERENCES resources(id)
;

ALTER TABLE resource_settings ADD CONSTRAINT Refentity_setting144 
    FOREIGN KEY (entitySettingId)
    REFERENCES entity_setting(id)
;


-- 
-- TABLE: resource_type 
--

ALTER TABLE resource_type ADD CONSTRAINT Refresource_group46 
    FOREIGN KEY (resourceGroupId)
    REFERENCES resource_group(id)
;


-- 
-- TABLE: resource_unavailability 
--

ALTER TABLE resource_unavailability ADD CONSTRAINT Refresource_type145 
    FOREIGN KEY (resourceTypeId)
    REFERENCES resource_type(id)
;


-- 
-- TABLE: resources 
--

ALTER TABLE resources ADD CONSTRAINT Refresource_group42 
    FOREIGN KEY (resourceGroupId)
    REFERENCES resource_group(id)
;

ALTER TABLE resources ADD CONSTRAINT Refresource_type43 
    FOREIGN KEY (resourceTypeId)
    REFERENCES resource_type(id)
;


-- 
-- TABLE: role_module_ovrride 
--

ALTER TABLE role_module_ovrride ADD CONSTRAINT Refuser_roles167 
    FOREIGN KEY (userRoleId)
    REFERENCES user_roles(id)
;

ALTER TABLE role_module_ovrride ADD CONSTRAINT Refprivilege171 
    FOREIGN KEY (privilegeId)
    REFERENCES privilege(id)
;


-- 
-- TABLE: role_portal_access 
--

ALTER TABLE role_portal_access ADD CONSTRAINT Refroles_core84 
    FOREIGN KEY (roleId)
    REFERENCES roles_core(id)
;

ALTER TABLE role_portal_access ADD CONSTRAINT Refportal87 
    FOREIGN KEY (portalId)
    REFERENCES portal(id)
;


-- 
-- TABLE: role_portal_module_details 
--

ALTER TABLE role_portal_module_details ADD CONSTRAINT Refrole_portal_access82 
    FOREIGN KEY (rolePortalAccessId)
    REFERENCES role_portal_access(id)
;

ALTER TABLE role_portal_module_details ADD CONSTRAINT Refwidget88 
    FOREIGN KEY (widgetId)
    REFERENCES widget(id)
;

ALTER TABLE role_portal_module_details ADD CONSTRAINT Refprivilege89 
    FOREIGN KEY (privilegeId)
    REFERENCES privilege(id)
;

ALTER TABLE role_portal_module_details ADD CONSTRAINT Refmodules86 
    FOREIGN KEY (moduleId)
    REFERENCES modules(id)
;


-- 
-- TABLE: role_wdgt_override 
--

ALTER TABLE role_wdgt_override ADD CONSTRAINT Refuser_roles168 
    FOREIGN KEY (userRoleId)
    REFERENCES user_roles(id)
;

ALTER TABLE role_wdgt_override ADD CONSTRAINT Refmodules169 
    FOREIGN KEY (moduleId)
    REFERENCES modules(id)
;

ALTER TABLE role_wdgt_override ADD CONSTRAINT Refwidget170 
    FOREIGN KEY (widgetId)
    REFERENCES widget(id)
;


-- 
-- TABLE: role_widget_access 
--

ALTER TABLE role_widget_access ADD CONSTRAINT Refuser_roles172 
    FOREIGN KEY (userRoleId)
    REFERENCES user_roles(id)
;

ALTER TABLE role_widget_access ADD CONSTRAINT Refwidget173 
    FOREIGN KEY (widgetId)
    REFERENCES widget(id)
;


-- 
-- TABLE: selection_marks 
--

ALTER TABLE selection_marks ADD CONSTRAINT Refadmission_form_sale226 
    FOREIGN KEY (applicationId)
    REFERENCES admission_form_sale(id)
;


-- 
-- TABLE: stu_community 
--

ALTER TABLE stu_community ADD CONSTRAINT Refstudent242 
    FOREIGN KEY (studentId)
    REFERENCES student(id)
;


-- 
-- TABLE: stu_incident_report 
--

ALTER TABLE stu_incident_report ADD CONSTRAINT Refstudent244 
    FOREIGN KEY (studentId)
    REFERENCES student(id)
;


-- 
-- TABLE: stu_request_followup 
--

ALTER TABLE stu_request_followup ADD CONSTRAINT Refstu_request_followup_com232 
    FOREIGN KEY (followupCommonId)
    REFERENCES stu_request_followup_common(id)
;


-- 
-- TABLE: stu_work_exp 
--

ALTER TABLE stu_work_exp ADD CONSTRAINT Refstudent218 
    FOREIGN KEY (studentId)
    REFERENCES student(id)
;


-- 
-- TABLE: student 
--

ALTER TABLE student ADD CONSTRAINT Refincome_slab224 
    FOREIGN KEY (incomeSlabId)
    REFERENCES income_slab(id)
;


-- 
-- TABLE: student_attendance_details 
--

ALTER TABLE student_attendance_details ADD CONSTRAINT Refstudent_attendance_recor198 
    FOREIGN KEY (attendanceId)
    REFERENCES student_attendance_record(id)
;


-- 
-- TABLE: student_attendance_record 
--

ALTER TABLE student_attendance_record ADD CONSTRAINT Refprogram202 
    FOREIGN KEY (programId)
    REFERENCES program(id)
;

ALTER TABLE student_attendance_record ADD CONSTRAINT Refbatch203 
    FOREIGN KEY (batchId)
    REFERENCES batch(id)
;

ALTER TABLE student_attendance_record ADD CONSTRAINT Refcourse204 
    FOREIGN KEY (courseId)
    REFERENCES course(id)
;

ALTER TABLE student_attendance_record ADD CONSTRAINT Refcourse_variants205 
    FOREIGN KEY (courseVariantId)
    REFERENCES course_variants(id)
;


-- 
-- TABLE: student_attendance_slots 
--

ALTER TABLE student_attendance_slots ADD CONSTRAINT Refstudent_attendance_recor197 
    FOREIGN KEY (attendanceId)
    REFERENCES student_attendance_record(id)
;


-- 
-- TABLE: student_cert_request 
--

ALTER TABLE student_cert_request ADD CONSTRAINT Refservice_request228 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_request(id)
;


-- 
-- TABLE: student_course_enrollment 
--

ALTER TABLE student_course_enrollment ADD CONSTRAINT Refprogram210 
    FOREIGN KEY (programId)
    REFERENCES program(id)
;

ALTER TABLE student_course_enrollment ADD CONSTRAINT Refbatch211 
    FOREIGN KEY (batchId)
    REFERENCES batch(id)
;

ALTER TABLE student_course_enrollment ADD CONSTRAINT Refcourse_group212 
    FOREIGN KEY (courseGroupId)
    REFERENCES course_group(id)
;

ALTER TABLE student_course_enrollment ADD CONSTRAINT Refcourse_variants213 
    FOREIGN KEY (courseVarientId)
    REFERENCES course_variants(id)
;


-- 
-- TABLE: student_course_hw_asignmt 
--

ALTER TABLE student_course_hw_asignmt ADD CONSTRAINT Refprogram_batch_period200 
    FOREIGN KEY (programBatchPeriodId)
    REFERENCES program_batch_period(id)
;

ALTER TABLE student_course_hw_asignmt ADD CONSTRAINT Refbatch206 
    FOREIGN KEY (batchId)
    REFERENCES batch(id)
;


-- 
-- TABLE: student_exam 
--

ALTER TABLE student_exam ADD CONSTRAINT Refstudent216 
    FOREIGN KEY (studentId)
    REFERENCES student(id)
;


-- 
-- TABLE: student_exam_subject 
--

ALTER TABLE student_exam_subject ADD CONSTRAINT Refstudent_exam217 
    FOREIGN KEY (studentExamId)
    REFERENCES student_exam(id)
;

ALTER TABLE student_exam_subject ADD CONSTRAINT Refstudent219 
    FOREIGN KEY (studentId)
    REFERENCES student(id)
;


-- 
-- TABLE: student_faculty 
--

ALTER TABLE student_faculty ADD CONSTRAINT Refstudent_attendance_recor196 
    FOREIGN KEY (attendanceId)
    REFERENCES student_attendance_record(id)
;


-- 
-- TABLE: student_hw_files 
--

ALTER TABLE student_hw_files ADD CONSTRAINT Refstudent_hw_group208 
    FOREIGN KEY (studentHwGroupId)
    REFERENCES student_hw_group(id)
;


-- 
-- TABLE: student_hw_group 
--

ALTER TABLE student_hw_group ADD CONSTRAINT Refstudent_course_hw_asignm209 
    FOREIGN KEY (hwAssignmentId)
    REFERENCES student_course_hw_asignmt(id)
;


-- 
-- TABLE: student_medical_history 
--

ALTER TABLE student_medical_history ADD CONSTRAINT Refstudent225 
    FOREIGN KEY (studentId)
    REFERENCES student(id)
;


-- 
-- TABLE: student_parent 
--

ALTER TABLE student_parent ADD CONSTRAINT Refstudent227 
    FOREIGN KEY (studentId)
    REFERENCES student(id)
;


-- 
-- TABLE: study_material_distribution 
--

ALTER TABLE study_material_distribution ADD CONSTRAINT Refcourse201 
    FOREIGN KEY (courseId)
    REFERENCES course(id)
;


-- 
-- TABLE: timeslots 
--

ALTER TABLE timeslots ADD CONSTRAINT Refresource_unavailability146 
    FOREIGN KEY (resourceUnavailabilityId)
    REFERENCES resource_unavailability(id)
;


-- 
-- TABLE: user_academylocation 
--

ALTER TABLE user_academylocation ADD CONSTRAINT Refusers72 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;


-- 
-- TABLE: user_courses 
--

ALTER TABLE user_courses ADD CONSTRAINT Refuser_programs75 
    FOREIGN KEY (userProgramId)
    REFERENCES user_programs(id)
;


-- 
-- TABLE: user_roles 
--

ALTER TABLE user_roles ADD CONSTRAINT Refroles_core73 
    FOREIGN KEY (roleId)
    REFERENCES roles_core(id)
;

ALTER TABLE user_roles ADD CONSTRAINT Refuser_academylocation74 
    FOREIGN KEY (userAcadLocationId)
    REFERENCES user_academylocation(id)
;



