CREATE TABLE `course_topic_coverage_status` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `courseId` bigint(20) NOT NULL,
  `sectionId` bigint(20) NOT NULL,
  `variantId` bigint(20) NOT NULL,
  `courseTopicId` bigint(20) NOT NULL,
  `status` varchar(45) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_course_coverage_status_1_idx` (`courseId`),
  KEY `fk_course_coverage_status_2_idx` (`sectionId`),
  KEY `fk_course_coverage_status_3_idx` (`variantId`),
  KEY `fk_course_coverage_status_4_idx` (`lastUpdatedBy`),
  KEY `fk_course_coverage_status_5_idx` (`courseTopicId`),
  CONSTRAINT `fk_course_coverage_status_5` FOREIGN KEY (`courseTopicId`) REFERENCES `course_topics` (`id`),
  CONSTRAINT `fk_course_coverage_status_1` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`),
  CONSTRAINT `fk_course_coverage_status_2` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`),
  CONSTRAINT `fk_course_coverage_status_3` FOREIGN KEY (`variantId`) REFERENCES `course_variants` (`id`),
  CONSTRAINT `fk_course_coverage_status_4` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `faculty_course_attendance` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `courseId` bigint(20) NOT NULL,
  `sectionId` bigint(20) NOT NULL,
  `variantId` bigint(20) NOT NULL,
  `dateOfAttendance` date NOT NULL,
  `fromTime` time NOT NULL,
  `toTime` time NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_faculty_course_attendance_1_idx` (`courseId`),
  KEY `fk_faculty_course_attendance_2_idx` (`sectionId`),
  KEY `fk_faculty_course_attendance_3_idx` (`variantId`),
  KEY `fk_faculty_course_attendance_4_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_faculty_course_attendance_4` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_faculty_course_attendance_1` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_faculty_course_attendance_2` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`),
  CONSTRAINT `fk_faculty_course_attendance_3` FOREIGN KEY (`variantId`) REFERENCES `course_variants` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `course_topic_coverage` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `courseId` bigint(20) NOT NULL,
  `sectionId` bigint(20) NOT NULL,
  `courseTopicId` bigint(20) NOT NULL,
  `date` date NOT NULL,
  `timeSpent` time NOT NULL DEFAULT '00:00:00',
  `attendanceId` bigint(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_course_topic_coverage_1_idx` (`courseTopicId`),
  KEY `fk_course_topic_coverage_2_idx` (`lastUpdatedBy`),
  KEY `fk_course_topic_coverage_3_idx` (`courseId`),
  KEY `fk_course_topic_coverage_4_idx` (`sectionId`),
  KEY `fk_course_topic_coverage_5_idx` (`courseId`),
  KEY `fk_course_topic_coverage_6_idx` (`sectionId`),
  KEY `fk_course_topic_coverage_5_idx1` (`attendanceId`),
  CONSTRAINT `fk_course_topic_coverage_5` FOREIGN KEY (`attendanceId`) REFERENCES `faculty_course_attendance` (`id`),
  CONSTRAINT `fk_course_topic_coverage_1` FOREIGN KEY (`courseTopicId`) REFERENCES `course_topics` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_course_topic_coverage_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_course_topic_coverage_3` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_course_topic_coverage_4` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `faculty_course_attendance_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `attendanceId` bigint(20) NOT NULL,
  `facultyId` bigint(20) NOT NULL,
  `attendanceStatus` varchar(45) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_faculty_course_attendance_details_1_idx` (`attendanceId`),
  KEY `fk_faculty_course_attendance_details_2_idx` (`facultyId`),
  KEY `fk_faculty_course_attendance_details_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_faculty_course_attendance_details_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_faculty_course_attendance_details_1` FOREIGN KEY (`attendanceId`) REFERENCES `faculty_course_attendance` (`id`),
  CONSTRAINT `fk_faculty_course_attendance_details_2` FOREIGN KEY (`facultyId`) REFERENCES `faculties` (`personId`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

ALTER TABLE `course_topic_coverage` 
ADD COLUMN `variantId` BIGINT(20) NOT NULL AFTER `sectionId`;
ALTER TABLE `course_topic_coverage` 
ADD INDEX `fk_course_topic_coverage_6_idx1` (`variantId` ASC);
ALTER TABLE `course_topic_coverage` 
ADD CONSTRAINT `fk_course_topic_coverage_6`
  FOREIGN KEY (`variantId`)
  REFERENCES `course_variants` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

