-- 
-- TABLE: acad_loc_purpose_setting 
--

CREATE TABLE acad_loc_purpose_setting(
    id                          BIGINT         AUTO_INCREMENT,
    academyLocationPurposeId    BIGINT         NOT NULL,
    entitySettingId             BIGINT         NOT NULL,
    purposeSettingValue         VARCHAR(50)    NOT NULL,
    lastUpdate                  TIMESTAMP      NOT NULL,
    lastUpdatedBy               BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: academies 
--

CREATE TABLE academies(
    id                  BIGINT          AUTO_INCREMENT,
    academicTypeCode    VARCHAR(50)     NOT NULL,
    academyName         VARCHAR(100)    NOT NULL,
    organizationId      BIGINT          NOT NULL,
    shortCode           VARCHAR(10)     NOT NULL,
    startDate           DATE            NOT NULL,
    tillDate            DATE,
    status              BIT             NOT NULL,
    lastUpdate          TIMESTAMP       NOT NULL,
    lastUpdatedBy       BIGINT,
    version             BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: academy_cf_data 
--

CREATE TABLE academy_cf_data(
    id                       BIGINT          AUTO_INCREMENT,
    academyId                BIGINT,
    entityFieldMetaDataId    BIGINT,
    data                     VARCHAR(255),
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: academy_location 
--

CREATE TABLE academy_location(
    id                        BIGINT          AUTO_INCREMENT,
    academyId                 BIGINT          NOT NULL,
    academyName               VARCHAR(100)    NOT NULL,
    locationId                BIGINT          NOT NULL,
    locationName              VARCHAR(100)    NOT NULL,
    currentTransactionDate    DATE            NOT NULL,
    lastUpdate                TIMESTAMP       NOT NULL,
    lastUpdatedBy             BIGINT,
    version                   BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: academy_location_purpose 
--

CREATE TABLE academy_location_purpose(
    id                      BIGINT         AUTO_INCREMENT,
    academyLocationId       BIGINT         NOT NULL,
    purposeCode             VARCHAR(50)    NOT NULL,
    calendarId              BIGINT,
    facultyFeePlanId        BIGINT,
    ownerId                 BIGINT         NOT NULL,
    academicYearId          BIGINT,
    academicYearTenureId    BIGINT,
    startDate               DATE           NOT NULL,
    tillDate                DATE,
    lastUpdate              TIMESTAMP      NOT NULL,
    lastUpdatedBy           BIGINT,
    version                 BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: academy_location_setting 
--

CREATE TABLE academy_location_setting(
    id                      BIGINT         AUTO_INCREMENT,
    academyLocationId       BIGINT         NOT NULL,
    entitySettingId         BIGINT         NOT NULL,
    locationSettingValue    VARCHAR(50)    NOT NULL,
    lastUpdate              TIMESTAMP      NOT NULL,
    lastUpdatedBy           BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: academy_year 
--

CREATE TABLE academy_year(
    id               BIGINT          AUTO_INCREMENT,
    yearName         VARCHAR(255)    NOT NULL,
    description      VARCHAR(255)    NOT NULL,
    lastUpdate       TIMESTAMP       NOT NULL,
    lastUpdatedBy    BIGINT,
    version          BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: academy_year_tenure 
--

CREATE TABLE academy_year_tenure(
    id               BIGINT          AUTO_INCREMENT,
    academyYearId    BIGINT          NOT NULL,
    tenureName       VARCHAR(255)    NOT NULL,
    startDate        DATE            NOT NULL,
    tillDate         DATE,
    lastUpdate       TIMESTAMP       NOT NULL,
    lastUpdatedBy    BIGINT,
    version          BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: account_config 
--

CREATE TABLE account_config(
    id                         BIGINT          AUTO_INCREMENT,
    createdBy                  BIGINT,
    configName                 VARCHAR(100),
    configDesc                 VARCHAR(255),
    validTill                  DATE,
    modeOfTransaction          VARCHAR(10),
    whetherBatch               BIT             NOT NULL,
    batchMode                  VARCHAR(35),
    whetherDataImportEnable    BIT             NOT NULL,
    currencyId                 BIGINT,
    errorLogPath               VARCHAR(100),
    lastUpdatedBy              BIGINT          NOT NULL,
    lastUpdate                 TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: account_config_batch_sch 
--

CREATE TABLE account_config_batch_sch(
    id                 BIGINT         AUTO_INCREMENT,
    accountConfigId    BIGINT,
    mon                BIT            NOT NULL,
    tue                BIT            NOT NULL,
    wed                BIT            NOT NULL,
    thu                BIT            NOT NULL,
    fri                BIT            NOT NULL,
    sat                BIT            NOT NULL,
    sun                BIT            NOT NULL,
    scheduleTime       VARCHAR(10),
    lastUpdatedBy      BIGINT         NOT NULL,
    lastUpdate         TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: account_config_import_sch 
--

CREATE TABLE account_config_import_sch(
    id                 BIGINT         AUTO_INCREMENT,
    accountConfigId    BIGINT,
    mon                BIT            NOT NULL,
    tue                BIT            NOT NULL,
    wed                BIT            NOT NULL,
    thu                BIT            NOT NULL,
    fri                BIT            NOT NULL,
    sat                BIT            NOT NULL,
    sun                BIT            NOT NULL,
    importTime         VARCHAR(10),
    lastUpdatedBy      BIGINT         NOT NULL,
    lastUpdate         TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: activity 
--

CREATE TABLE activity(
    id               BIGINT         AUTO_INCREMENT,
    activityName     VARCHAR(10),
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: address 
--

CREATE TABLE address(
    id                  BIGINT          AUTO_INCREMENT,
    code                CHAR(10),
    addressText         VARCHAR(255),
    cityId              BIGINT          NOT NULL,
    phoneNo             VARCHAR(15),
    phoneCountryCode    VARCHAR(10),
    phoneAreaCode       INT,
    cellNo              BIGINT,
    cellCountryCode     CHAR(10),
    primaryeEmailId     VARCHAR(100),
    alternateEmailId    VARCHAR(100),
    countryRegionId     BIGINT,
    addressTypeId       BIGINT,
    parentRegionId      BIGINT,
    lastUpdatedBy       BIGINT          NOT NULL,
    lastUpdate          TIMESTAMP,
    version             BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: address_to_be_changed 
--

CREATE TABLE address_to_be_changed(
    id                   BIGINT       NOT NULL,
    whetherDeleted       BIT,
    lastUpdatedBy        BIGINT       NOT NULL,
    lastUpdate           TIMESTAMP,
    addressId            BIGINT       NOT NULL,
    addressTypeId        BIGINT       NOT NULL,
    dataToBeChangedId    BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: address_type 
--

CREATE TABLE address_type(
    id                 BIGINT         AUTO_INCREMENT,
    code               CHAR(10),
    addressTypeName    VARCHAR(20),
    addressCategory    VARCHAR(20),
    lastUpdatedBy      BIGINT         NOT NULL,
    lastUpdate         TIMESTAMP,
    version            BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: admission 
--

CREATE TABLE admission(
    id                            BIGINT            AUTO_INCREMENT,
    applicationId                 BIGINT,
    academyLocationId             BIGINT,
    personId                      DECIMAL(0, 0)     NOT NULL,
    studentId                     BIGINT            NOT NULL,
    programBatchPeriodConfigId    BIGINT,
    programBatchSeatConfigId      BIGINT,
    academicYearFor               VARCHAR(10),
    distanceTravel                VARCHAR(10),
    whetherTrialAdmission         BIT,
    trialClosureDate              DATE,
    trialRejectDate               DATE,
    offerDate                     DATE,
    offerValidity                 DATE,
    whetherOfferLetterAccepted    BIT,
    joiningDate                   DATE,
    age                           INT,
    admissionStatus               VARCHAR(100),
    statusReason                  VARCHAR(18),
    additionalReqDetails          VARCHAR(4000),
    additionalReqCompleted        INT,
    approverId                    BIGINT,
    outstandingAmount             DECIMAL(18, 0),
    admissionConfirmed            INT,
    lastReceiptId                 BIGINT,
    activeTillDate                DATE,
    code                          VARCHAR(30)       NOT NULL,
    suspendedTillDate             DATE,
    lastUpdatedBy                 BIGINT            NOT NULL,
    lastUpdate                    TIMESTAMP         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: admission_enq_details 
--

CREATE TABLE admission_enq_details(
    id                        BIGINT       AUTO_INCREMENT,
    enqStudentDetailsId       BIGINT,
    academyId                 BIGINT       NOT NULL,
    locationId                BIGINT       NOT NULL,
    programId                 BIGINT       NOT NULL,
    batchId                   BIGINT       NOT NULL,
    progBatchSeatConfigId     BIGINT,
    whetherDeleted            BIT,
    enquiryClosureReasonId    BIGINT,
    enquiryReopenReasonId     BIGINT,
    lastUpdatedBy             BIGINT       NOT NULL,
    lastUpdate                TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: admission_program_course 
--

CREATE TABLE admission_program_course(
    id               BIGINT          AUTO_INCREMENT,
    admissionId      BIGINT          NOT NULL,
    courseId         BIGINT          NOT NULL,
    courseName       VARCHAR(100)    NOT NULL,
    description      VARCHAR(255),
    marksOrGrade     VARCHAR(100),
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdated      TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: admission_status 
--

CREATE TABLE admission_status(
    id               BIGINT          AUTO_INCREMENT,
    admissionId      BIGINT          NOT NULL,
    status           VARCHAR(100)    NOT NULL,
    remark           VARCHAR(255),
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdated      TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: against_bill_request_types 
--

CREATE TABLE against_bill_request_types(
    requestTypeId    BIGINT         NOT NULL,
    billCategory     VARCHAR(20),
    PRIMARY KEY (requestTypeId)
)
;



-- 
-- TABLE: against_feehead_request_types 
--

CREATE TABLE against_feehead_request_types(
    requestTypeId      BIGINT         NOT NULL,
    feeHeadCategory    VARCHAR(20),
    PRIMARY KEY (requestTypeId)
)
;



-- 
-- TABLE: app_extra_curricular 
--

CREATE TABLE app_extra_curricular(
    id               BIGINT          AUTO_INCREMENT,
    applicantId      BIGINT          NOT NULL,
    activityName     VARCHAR(50),
    conductedBy      BIGINT,
    activityYear     DATE            NOT NULL,
    remarks          VARCHAR(255),
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       DATETIME,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: app_selection_replacement 
--

CREATE TABLE app_selection_replacement(
    id                            BIGINT       AUTO_INCREMENT,
    processStageId                BIGINT,
    applicationId                 BIGINT,
    applicantId                   BIGINT,
    academyLocationId             BIGINT,
    quotaId                       BIGINT,
    programBatchPeriodConfigId    BIGINT,
    programBatchSeatConfigId      BIGINT,
    toBeReplacedAppId             BIGINT,
    replacedAppId                 BIGINT,
    lastUpdatedBy                 BIGINT       NOT NULL,
    lastUpdate                    TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: applicant 
--

CREATE TABLE applicant(
    id                   BIGINT       AUTO_INCREMENT,
    personId             BIGINT       NOT NULL,
    applicationFormId    BIGINT       NOT NULL,
    lastUpdatedBy        BIGINT       NOT NULL,
    lastUpdated          TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: applicant_cf_data 
--

CREATE TABLE applicant_cf_data(
    id                BIGINT         AUTO_INCREMENT,
    applicantId       BIGINT,
    fieldId           BIGINT,
    strFieldValue     VARCHAR(20),
    dateFieldValue    VARCHAR(20),
    txtFieldValue     VARCHAR(20),
    lastUpdatedBy     BIGINT,
    lastUpdate        TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: applicant_classification 
--

CREATE TABLE applicant_classification(
    id                     BIGINT         AUTO_INCREMENT,
    applicantId            BIGINT,
    classificationName     VARCHAR(18)    NOT NULL,
    classificationValue    VARCHAR(15),
    lastUpdatedBy          BIGINT         NOT NULL,
    lastUpdate             TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: applicant_doc_link 
--

CREATE TABLE applicant_doc_link(
    id                       BIGINT          AUTO_INCREMENT,
    applicationDocumentId    BIGINT,
    appDocLink               VARCHAR(100),
    lastUpdatedBy            BIGINT          NOT NULL,
    lastUpdate               TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: applicant_documents 
--

CREATE TABLE applicant_documents(
    id                           BIGINT         AUTO_INCREMENT,
    applicationId                BIGINT,
    academyLocationId            BIGINT,
    programBatchPeriodId         BIGINT,
    programBatchSeatId           BIGINT,
    stageId                      BIGINT,
    documentsName                VARCHAR(40),
    documentSubmissionDate       DATE,
    whetherElectronicDocument    BIT,
    employeeId                   BIGINT,
    whetherInspectionRequired    BIT,
    inspectionDoneBy             BIGINT,
    inspectionDoneDate           DATE,
    whetherDocumentReturnable    BIT,
    returnedDate                 DATE,
    returnedBy                   BIGINT,
    modeOfReturn                 VARCHAR(10),
    returnedTo                   BIGINT,
    lastUpdatedBy                BIGINT         NOT NULL,
    lastUpdate                   TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: applicant_prev_exam 
--

CREATE TABLE applicant_prev_exam(
    id               BIGINT         AUTO_INCREMENT,
    applicantId      BIGINT         NOT NULL,
    examPassed       VARCHAR(35),
    examResult       VARCHAR(8)     NOT NULL,
    conductedBy      VARCHAR(35)    NOT NULL,
    passingYear      DATE,
    studentType      VARCHAR(35),
    enrollmentNo     VARCHAR(10),
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: application 
--

CREATE TABLE application(
    id                        BIGINT          AUTO_INCREMENT,
    applicationFormId         BIGINT          NOT NULL,
    code                      VARCHAR(100),
    currentStatusId           VARCHAR(50)     NOT NULL,
    lastUpdatedBy             BIGINT          NOT NULL,
    lastUpdate                TIMESTAMP       NOT NULL,
    existingStudentId         BIGINT,
    personId                  BIGINT,
    enquiryStudentDetailId    BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: application_fee_payment 
--

CREATE TABLE application_fee_payment(
    id                       BIGINT            AUTO_INCREMENT,
    receiptId                BIGINT,
    applicationId            BIGINT,
    paidBy                   VARCHAR(35),
    collectedBy              BIGINT,
    collectedName            VARCHAR(100),
    paymentMode              VARCHAR(15),
    feePlanId                BIGINT,
    instrumentNo             VARCHAR(20),
    instrumentDate           DATE,
    instrumentAmount         DECIMAL(18, 5),
    InstrumentDrawnOn        VARCHAR(35),
    reasonForRefund          VARCHAR(100),
    remark                   VARCHAR(255),
    academyLocationId        BIGINT,
    programId                BIGINT,
    progBatchSeatConfigId    BIGINT,
    lastUpdatedBy            BIGINT            NOT NULL,
    lastUpdate               TIMESTAMP          DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: application_form 
--

CREATE TABLE application_form(
    id                        BIGINT          AUTO_INCREMENT,
    collectedBy               VARCHAR(100),
    saleDate                  DATETIME,
    collectedByFirstName      VARCHAR(35),
    collectedByMiddleName     VARCHAR(35),
    collectedByLastName       VARCHAR(35),
    collectedByCountryCode    VARCHAR(10),
    collectedByPhoneNo        VARCHAR(10),
    collectedByLandlineNo     VARCHAR(10),
    collectedByEmail          VARCHAR(50),
    collectedByAddress        VARCHAR(255),
    handedOverToApplicant     VARCHAR(35),
    handedOverToEnquirer      VARCHAR(35),
    token                     VARCHAR(20),
    lastUpdatedBy             BIGINT          NOT NULL,
    lastUpdate                TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: application_prog_stage 
--

CREATE TABLE application_prog_stage(
    id                                BIGINT          AUTO_INCREMENT,
    applicationProgramId              BIGINT          NOT NULL,
    programSelectionProcessStageId    BIGINT          NOT NULL,
    currentStatus                     VARCHAR(100),
    rank                              INT,
    quotaRank                         INT,
    lastUpdatedBy                     BIGINT          NOT NULL,
    lastUpdate                        TIMESTAMP,
    version                           BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: application_prog_stage_marks 
--

CREATE TABLE application_prog_stage_marks(
    id                                BIGINT       AUTO_INCREMENT,
    applicationProgramStageId         BIGINT       NOT NULL,
    evaluationParameterWeightageId    BIGINT       NOT NULL,
    marksObtained                     INT,
    lastUpdatedBy                     BIGINT       NOT NULL,
    lastUpdate                        TIMESTAMP,
    version                           BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: application_prog_stage_status 
--

CREATE TABLE application_prog_stage_status(
    id                           BIGINT          AUTO_INCREMENT,
    applicationProgramStageId    BIGINT          NOT NULL,
    status                       VARCHAR(100)    NOT NULL,
    remark                       VARCHAR(255),
    lastUpdatedBy                BIGINT          NOT NULL,
    lastUpdated                  TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: application_program 
--

CREATE TABLE application_program(
    id                       BIGINT            AUTO_INCREMENT,
    applicationId            BIGINT            NOT NULL,
    progBatchSeatConfigId    BIGINT,
    academyLocationId        BIGINT,
    programId                BIGINT,
    currentStageId           BIGINT,
    currentStatus            VARCHAR(100)      NOT NULL,
    priority                 INT               NOT NULL,
    feeAmount                DECIMAL(18, 5),
    lateFee                  DECIMAL(18, 5),
    lastUpdatedBy            BIGINT            NOT NULL,
    lastUpdate               TIMESTAMP         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: application_program_group_conf 
--

CREATE TABLE application_program_group_conf(
    id                               BIGINT         AUTO_INCREMENT,
    programGroupId                   BIGINT         NOT NULL,
    applMechanism                    VARCHAR(35),
    appFormStartDate                 DATE,
    appFormEndDate                   DATE,
    onlineSalePermitted              BIT            NOT NULL,
    appFormSubmitStartDate           DATE,
    appFormSubmitEndDate             DATE,
    onlineSubmissionAllowed          BIT            NOT NULL,
    whetherLimitedNoOfFullProgram    BIT            NOT NULL,
    limitedPrograms                  INT,
    whetherLimitedNoOfPartProgram    BIT            NOT NULL,
    limitedPartTimePrograms          INT,
    lastUpdatedBy                    BIGINT         NOT NULL,
    lastUpdate                       TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    version                          BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: application_program_services 
--

CREATE TABLE application_program_services(
    id                      BIGINT       AUTO_INCREMENT,
    applicationProcessId    BIGINT       NOT NULL,
    serviceId               BIGINT,
    lastUpdatedBy           BIGINT       NOT NULL,
    lastUpdate              TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: application_program_status 
--

CREATE TABLE application_program_status(
    id                      BIGINT          AUTO_INCREMENT,
    applicationProgramId    BIGINT          NOT NULL,
    status                  VARCHAR(100)    NOT NULL,
    reasonRemark            VARCHAR(255),
    lastUpdatedBy           BIGINT          NOT NULL,
    lastUpdated             TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: application_references 
--

CREATE TABLE application_references(
    id               BIGINT          AUTO_INCREMENT,
    applicationId    BIGINT          NOT NULL,
    referenceName    VARCHAR(100),
    designation      VARCHAR(100),
    contactNo        VARCHAR(50),
    remark           VARCHAR(255),
    lastUpdate       TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: application_status 
--

CREATE TABLE application_status(
    id               BIGINT          AUTO_INCREMENT,
    applicationId    BIGINT          NOT NULL,
    status           VARCHAR(100)    NOT NULL,
    remark           VARCHAR(255),
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdated      TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: approval_details 
--

CREATE TABLE approval_details(
    id                         BIGINT          AUTO_INCREMENT,
    approvalDate               TIMESTAMP,
    whetherDeleted             BIT             NOT NULL,
    lastUpdatedBy              BIGINT          NOT NULL,
    lastUpdate                 TIMESTAMP       NOT NULL,
    remarks                    VARCHAR(255),
    status                     VARCHAR(20),
    version                    BIGINT          NOT NULL,
    serviceRequestId           BIGINT          NOT NULL,
    userId                     BIGINT          NOT NULL,
    escalatedApproverUserId    BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: assignment 
--

CREATE TABLE assignment(
    id                BIGINT         AUTO_INCREMENT,
    assignmentName    VARCHAR(30),
    lastUpdatedBy     BIGINT         NOT NULL,
    lastUpdate        TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: assignment_topics 
--

CREATE TABLE assignment_topics(
    id               BIGINT       AUTO_INCREMENT,
    assignmentId     BIGINT,
    courseTopicId    BIGINT,
    lastUpdatedBy    BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: bank 
--

CREATE TABLE bank(
    id               BIGINT          AUTO_INCREMENT,
    academyId        BIGINT,
    locationId       BIGINT,
    bankCode         VARCHAR(20),
    ifscCode         VARCHAR(20),
    accountNo        VARCHAR(30),
    bankName         VARCHAR(30),
    branchName       VARCHAR(30),
    branchAddress    VARCHAR(300),
    bankStatus       VARCHAR(6),
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: bank_account_detail 
--

CREATE TABLE bank_account_detail(
    id                        BIGINT          AUTO_INCREMENT,
    configControlAccountId    BIGINT,
    accountingConfigId        BIGINT,
    bankName                  VARCHAR(100),
    branchName                VARCHAR(100),
    accountNumber             INT,
    controlAccount            VARCHAR(10),
    lastUpdatedBy             BIGINT          NOT NULL,
    lastUpdate                TIME            NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: bank_contact_person 
--

CREATE TABLE bank_contact_person(
    id               BIGINT         AUTO_INCREMENT,
    bankId           BIGINT,
    personName       VARCHAR(20),
    designation      VARCHAR(10),
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: bank_details 
--

CREATE TABLE bank_details(
    id                BIGINT          AUTO_INCREMENT,
    whetherDeleted    BIT             NOT NULL,
    version           BIGINT          NOT NULL,
    lastUpdatedby     BIGINT          NOT NULL,
    branchName        CHAR(100)       NOT NULL,
    accountNumber     VARCHAR(50)     NOT NULL,
    personId          BIGINT          NOT NULL,
    lastUpdate        TIMESTAMP       NOT NULL,
    IFSCode           VARCHAR(50)     NOT NULL,
    bankName          VARCHAR(100)    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: bank_person_address 
--

CREATE TABLE bank_person_address(
    id               BIGINT       AUTO_INCREMENT,
    bankPersonId     BIGINT,
    addressId        BIGINT,
    lastUpdatedBy    BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: basic_search_config 
--

CREATE TABLE basic_search_config(
    id                BIGINT          AUTO_INCREMENT,
    searchConfigId    BIGINT          NOT NULL,
    configCode        VARCHAR(100),
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: basic_search_config_param 
--

CREATE TABLE basic_search_config_param(
    id                          BIGINT         AUTO_INCREMENT,
    basicSearchConfigId         BIGINT         NOT NULL,
    searchTableColumnId         BIGINT         NOT NULL,
    searchCriteriaOperatorId    BIGINT         NOT NULL,
    searchConfigTableId         BIGINT         NOT NULL,
    paramCode                   VARCHAR(50),
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: batches 
--

CREATE TABLE batches(
    id                              BIGINT           AUTO_INCREMENT,
    inheritFromBatch                BIGINT,
    programId                       BIGINT,
    programPeriodBreakInherited     BIT,
    ProgramPeriodInherited          BIT,
    inheritProgramId                BIGINT,
    batchName                       VARCHAR(18),
    academicYear                    INT,
    seatCapacity                    INT,
    startDate                       DATE,
    tillDate                        DATE,
    programPeriodTypeId             BIGINT,
    maxPeriod                       VARCHAR(15),
    minPeriod                       VARCHAR(15),
    hasAdditionalRequirement        BIT              NOT NULL,
    additionalRequirementDetails    VARCHAR(255),
    specializationPossible          BIT              NOT NULL,
    minProgramCredits               INT,
    maxProgramCredits               INT,
    minProgramCourses               INT,
    maxProgramCourses               INT,
    batchPartTime                   BIT              NOT NULL,
    minCompulsoryCourses            INT,
    maxCompulsoryCourses            INT,
    minOptionalCourses              INT,
    maxOptionalCourses              INT,
    programMinAge                   INT,
    programMaxAge                   INT,
    ageVerificationDate             DATE,
    calendarId                      BIGINT,
    programEntryCreteria            VARCHAR(4000),
    programExitCreteria             VARCHAR(4000),
    placementProcessRequired        BIT              NOT NULL,
    lastUpdatedBy                   BIGINT           NOT NULL,
    lastUpdate                      TIMESTAMP        NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: bill_faculty_covered 
--

CREATE TABLE bill_faculty_covered(
    id               BIGINT       AUTO_INCREMENT,
    billId           BIGINT,
    facultyId        BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP,
    lastUpdatedBy    BIGINT,
    personId         BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: bill_faculty_payment 
--

CREATE TABLE bill_faculty_payment(
    id               BIGINT       AUTO_INCREMENT,
    billId           BIGINT,
    facultyId        BIGINT       NOT NULL,
    paymentDate      DATE,
    lastUpdatedBy    BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    personId         BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: bill_faculty_sessions 
--

CREATE TABLE bill_faculty_sessions(
    id               BIGINT       AUTO_INCREMENT,
    billFacultyId    BIGINT,
    courseId         BIGINT,
    noOfSessions     INT,
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: bill_fee_concessions 
--

CREATE TABLE bill_fee_concessions(
    id                      BIGINT          AUTO_INCREMENT,
    feeStageHeadConfigId    BIGINT,
    billId                  BIGINT,
    concessionAmount        FLOAT,
    actualBillAmount        FLOAT,
    remark                  VARCHAR(255),
    reasonOfConcession      VARCHAR(40),
    lastUpdatedBy           BIGINT,
    lastUpdate              TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: bill_fee_installments 
--

CREATE TABLE bill_fee_installments(
    id                      BIGINT       AUTO_INCREMENT,
    feeStageHeadConfigId    BIGINT,
    billId                  BIGINT,
    concessionAmount        FLOAT,
    installmentAmount       FLOAT,
    installmentDate         DATE,
    lastUpdatedBy           BIGINT,
    lastUpdate              TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: bill_fee_plan_rule_stage 
--

CREATE TABLE bill_fee_plan_rule_stage(
    id                      BIGINT        NOT NULL,
    billId                  BIGINT,
    feeStageHeadConfigId    BIGINT,
    feeSequenceId           BIGINT,
    feeAmount               FLOAT,
    discountAmount          FLOAT,
    allowAmountOverride     BIT           NOT NULL,
    billableAmount          FLOAT,
    amountPaid              FLOAT,
    billStatus              VARCHAR(6),
    lastUpdatedBy           BIGINT        NOT NULL,
    lastUpdate              TIMESTAMP      DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: bill_header 
--

CREATE TABLE bill_header(
    id                     BIGINT          NOT NULL,
    sequenceId             BIGINT,
    stageId                BIGINT,
    sponsorId              BIGINT,
    installments           INT,
    totalAmount            FLOAT,
    allowAmountOverride    BIT             NOT NULL,
    billNo                 VARCHAR(15)     NOT NULL,
    billType               VARCHAR(35),
    billingDate            DATE,
    dueDate                DATE,
    reasonForManualBill    VARCHAR(255),
    lastUpdatedBy          BIGINT          NOT NULL,
    lastUpdate             TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: bill_refund_fee_plan 
--

CREATE TABLE bill_refund_fee_plan(
    id               BIGINT       AUTO_INCREMENT,
    billRefundId     BIGINT,
    feeHeadId        BIGINT,
    refundAmount     INT,
    lastUpdatedBy    BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: bill_refund_header 
--

CREATE TABLE bill_refund_header(
    id                  BIGINT       AUTO_INCREMENT,
    billId              BIGINT,
    paymentHeaderId     BIGINT,
    refundableAmount    FLOAT,
    lastUpdatedBy       BIGINT       NOT NULL,
    lastUpdate          TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: bill_student_sessions 
--

CREATE TABLE bill_student_sessions(
    id               BIGINT       AUTO_INCREMENT,
    billStudentId    BIGINT,
    courseId         BIGINT,
    noOfSessions     INT,
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: bill_students_covered 
--

CREATE TABLE bill_students_covered(
    id               BIGINT           AUTO_INCREMENT,
    billId           BIGINT,
    personId         DECIMAL(0, 0)    NOT NULL,
    studentId        BIGINT           NOT NULL,
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: booking_purposes 
--

CREATE TABLE booking_purposes(
    id               BIGINT         AUTO_INCREMENT,
    code             CHAR(10)       NOT NULL,
    value            VARCHAR(50),
    lastUpdatedBy    BIGINT,
    lastUpdate       DATE           NOT NULL,
    version          INT            NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: calendar_academy_locations 
--

CREATE TABLE calendar_academy_locations(
    id                   BIGINT      AUTO_INCREMENT,
    calendarId           BIGINT,
    academyLocationId    BIGINT,
    lastUpdatedBy        BIGINT,
    lastUpdate           DATETIME    NOT NULL,
    version              INT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: calendar_breaks 
--

CREATE TABLE calendar_breaks(
    id                   BIGINT         AUTO_INCREMENT,
    calendarWeekdayId    BIGINT,
    breakName            VARCHAR(15),
    startTime            DATETIME,
    endTime              DATETIME,
    lastUpdatedBy        BIGINT,
    lastUpdate           TIMESTAMP,
    version              BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: calendar_holidays 
--

CREATE TABLE calendar_holidays(
    id               BIGINT          AUTO_INCREMENT,
    calendarId       BIGINT,
    fromDate         DATE            NOT NULL,
    toDate           DATE,
    holidayReason    VARCHAR(255),
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP       NOT NULL,
    version          BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: calendar_special_days 
--

CREATE TABLE calendar_special_days(
    calendarWeekdayId    BIGINT          NOT NULL,
    startDate            DATE            NOT NULL,
    tillDate             DATE,
    description          VARCHAR(255),
    calendarId           BIGINT,
    PRIMARY KEY (calendarWeekdayId)
)
;



-- 
-- TABLE: calendar_weekdays 
--

CREATE TABLE calendar_weekdays(
    id               BIGINT         AUTO_INCREMENT,
    weekDay          VARCHAR(15),
    startTime        DATETIME,
    endTime          DATETIME,
    slot             VARCHAR(10),
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP      NOT NULL,
    version          BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: calendar_weeklyoffs 
--

CREATE TABLE calendar_weeklyoffs(
    id               BIGINT         AUTO_INCREMENT,
    weekday          VARCHAR(15),
    calendarId       BIGINT,
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP      NOT NULL,
    version          BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: calendar_working_weekdays 
--

CREATE TABLE calendar_working_weekdays(
    calendarWeekdayId    BIGINT    NOT NULL,
    calendarId           BIGINT,
    PRIMARY KEY (calendarWeekdayId)
)
;



-- 
-- TABLE: calendars 
--

CREATE TABLE calendars(
    id                           BIGINT          AUTO_INCREMENT,
    code                         VARCHAR(10)     NOT NULL,
    calenderName                 VARCHAR(35),
    calendarDesc                 VARCHAR(100),
    status                       VARCHAR(20)     NOT NULL,
    weekStart                    VARCHAR(10),
    calendarInitSetupComplete    CHAR(1),
    lastUpdatedBy                BIGINT,
    lastUpdate                   TIMESTAMP,
    version                      BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: campaign 
--

CREATE TABLE campaign(
    id                BIGINT          AUTO_INCREMENT,
    code              VARCHAR(6)      NOT NULL,
    campaignName      VARCHAR(30)     NOT NULL,
    campaignDesc      VARCHAR(255),
    budgetAmount      INT,
    actualAmount      INT,
    userId            BIGINT,
    fromDate          DATE,
    toDate            DATE,
    remarks           VARCHAR(255),
    whetherDeleted    BIT              DEFAULT 0 NOT NULL,
    lastUpdatedBy     BIGINT          NOT NULL,
    lastUpdate        TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: campaign_coverage 
--

CREATE TABLE campaign_coverage(
    id                 BIGINT          AUTO_INCREMENT,
    campaignId         BIGINT,
    locationId         BIGINT,
    academyId          BIGINT,
    programId          BIGINT,
    coverageRemarks    VARCHAR(255),
    userId             BIGINT,
    whetherDeleted     BIT,
    lastUpdatedBy      BIGINT          NOT NULL,
    lastUpdate         TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: campaign_media 
--

CREATE TABLE campaign_media(
    id                BIGINT       AUTO_INCREMENT,
    campaignId        BIGINT,
    mediaId           BIGINT,
    whetherDeleted    BIT,
    lastUpdatedBy     BIGINT       NOT NULL,
    lastUpdate        TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: caste_categories 
--

CREATE TABLE caste_categories(
    id               BIGINT          AUTO_INCREMENT,
    itemCode         VARCHAR(255)    NOT NULL,
    itemValue        VARCHAR(255)    NOT NULL,
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: category_field_items 
--

CREATE TABLE category_field_items(
    id                    BIGINT         AUTO_INCREMENT,
    categoryMetaDataId    BIGINT,
    itemCode              VARCHAR(10),
    itemValue             VARCHAR(20),
    displayOrder          INT,
    lastUpdatedBy         BIGINT,
    lastUpdate            TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: category_field_meta_data 
--

CREATE TABLE category_field_meta_data(
    id               BIGINT         AUTO_INCREMENT,
    entityTypeId     BIGINT,
    fieldName        VARCHAR(30),
    labelName        VARCHAR(30),
    dbColumn         VARCHAR(30),
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: center_allocation 
--

CREATE TABLE center_allocation(
    id               BIGINT         AUTO_INCREMENT,
    examCenterId     BIGINT,
    allocateDate     DATE,
    timeSlot         VARCHAR(15),
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: center_room_details 
--

CREATE TABLE center_room_details(
    id                   BIGINT         AUTO_INCREMENT,
    allocatedCenterId    BIGINT,
    roomNo               VARCHAR(8)     NOT NULL,
    roomLocation         VARCHAR(35),
    roomCapacity         INT,
    lastUpdatedBy        BIGINT         NOT NULL,
    lastUpdate           TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: centre_unavailability_date 
--

CREATE TABLE centre_unavailability_date(
    id                 BIGINT         AUTO_INCREMENT,
    centerType         VARCHAR(18),
    centerId           BIGINT,
    unavailableFrom    VARCHAR(12),
    fromDate           DATE,
    tillDate           DATE,
    lastUpdatedBy      BIGINT         NOT NULL,
    lastUpdate         TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: centre_unavailability_time 
--

CREATE TABLE centre_unavailability_time(
    id                      BIGINT         AUTO_INCREMENT,
    unavailabilityDateId    BIGINT,
    unavailableDay          DATE,
    fromTime                VARCHAR(10),
    tillTime                VARCHAR(10),
    lastUpdate              TIMESTAMP      NOT NULL,
    lastUpdatedBy           BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: certificate 
--

CREATE TABLE certificate(
    id                       BIGINT          AUTO_INCREMENT,
    certificateCategoryId    BIGINT,
    certificateName          VARCHAR(25),
    certificateType          CHAR(10),
    certRule                 VARCHAR(20),
    ruleDescription          VARCHAR(255),
    lastUpdatedBy            BIGINT          NOT NULL,
    lastUpdate               TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: certificate_category 
--

CREATE TABLE certificate_category(
    id               BIGINT          AUTO_INCREMENT,
    categoryName     BIGINT,
    categoryDesc     VARCHAR(255),
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: certificate_request_details 
--

CREATE TABLE certificate_request_details(
    detailId             BIGINT          NOT NULL,
    copies               INT,
    whetherOriginal      BIT,
    certificateStatus    VARCHAR(30),
    reason               VARCHAR(255),
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: certificates 
--

CREATE TABLE certificates(
    requestTypeId          BIGINT         NOT NULL,
    whetherActive          BIT,
    certificateCategory    VARCHAR(20),
    PRIMARY KEY (requestTypeId)
)
;



-- 
-- TABLE: city 
--

CREATE TABLE city(
    id               BIGINT         AUTO_INCREMENT,
    countryId        BIGINT,
    code             CHAR(10),
    cityName         VARCHAR(50),
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: classifications 
--

CREATE TABLE classifications(
    id                    BIGINT         AUTO_INCREMENT,
    code                  CHAR(10),
    classificationName    VARCHAR(50),
    lastUpdatedBy         BIGINT,
    lastUpdate            DATE           NOT NULL,
    version               BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: closure_reason 
--

CREATE TABLE closure_reason(
    id               BIGINT          AUTO_INCREMENT,
    reasonCode       VARCHAR(255),
    status           VARCHAR(255),
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: community 
--

CREATE TABLE community(
    id               BIGINT         AUTO_INCREMENT,
    communityCode    VARCHAR(8),
    communityName    VARCHAR(15),
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: community_locations 
--

CREATE TABLE community_locations(
    id                          BIGINT       AUTO_INCREMENT,
    communityId                 BIGINT,
    programBatchSeatConfigId    BIGINT,
    lastUpdatedBy               BIGINT       NOT NULL,
    lastUpdate                  TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: complaint_details 
--

CREATE TABLE complaint_details(
    detailId                    BIGINT          NOT NULL,
    against                     VARCHAR(20),
    facilityCode                VARCHAR(100),
    facilityDescription         VARCHAR(255),
    name                        VARCHAR(255),
    status                      VARCHAR(10),
    complaintAgainstPersonId    BIGINT          NOT NULL,
    complaintTypeSettingId      BIGINT          NOT NULL,
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: complaint_type_settings 
--

CREATE TABLE complaint_type_settings(
    id                       BIGINT       AUTO_INCREMENT,
    sla                      INT,
    whetherDeleted           BIT          NOT NULL,
    lastUpdatedBy            BIGINT       NOT NULL,
    lastUpdate               TIMESTAMP    NOT NULL,
    version                  BIGINT       NOT NULL,
    complaintTypeId          BIGINT       NOT NULL,
    academyLocationId        BIGINT       NOT NULL,
    defaultAssigneeUserId    BIGINT,
    defaultApproverUserId    BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: complaint_types 
--

CREATE TABLE complaint_types(
    id               BIGINT          NOT NULL,
    itemCode         VARCHAR(255),
    itemValue        VARCHAR(255),
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: completion_certificates 
--

CREATE TABLE completion_certificates(
    id               BIGINT       AUTO_INCREMENT,
    programId        BIGINT,
    batchId          BIGINT,
    certificateId    BIGINT,
    lastUpdatedBy    BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: completion_check_list 
--

CREATE TABLE completion_check_list(
    id                          BIGINT         AUTO_INCREMENT,
    programId                   BIGINT,
    batchId                     BIGINT,
    checkListItem               VARCHAR(35),
    applicableForPassedOut      BIT            NOT NULL,
    applicableForWithdrawal     BIT            NOT NULL,
    applicableForTransfer       BIT            NOT NULL,
    applicableForTermination    BIT            NOT NULL,
    lastUpdatedBy               BIGINT         NOT NULL,
    lastUpdate                  TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: completion_docs 
--

CREATE TABLE completion_docs(
    id               BIGINT       AUTO_INCREMENT,
    transactionId    BIGINT,
    checkListId      BIGINT,
    documentId       BIGINT,
    lastUpdatedBy    BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: completion_termination 
--

CREATE TABLE completion_termination(
    id                     BIGINT          AUTO_INCREMENT,
    transactionId          BIGINT,
    checkListId            BIGINT,
    effectiveFromDate      DATE,
    terminationTillDate    DATE,
    terminationReason      INT,
    remark                 VARCHAR(255),
    approvedBy             BIGINT,
    lastUpdatedBy          BIGINT          NOT NULL,
    lastUpdate             TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: completion_transaction_details 
--

CREATE TABLE completion_transaction_details(
    id                      BIGINT          AUTO_INCREMENT,
    checkListId             BIGINT,
    transactionId           BIGINT,
    uploadDoc               VARCHAR(100),
    physicalDoc             VARCHAR(100),
    whetherReturnableDoc    BIT             NOT NULL,
    returnDate              DATE,
    returnBy                INT,
    returnTo                INT,
    inspectionRequired      BIT             NOT NULL,
    inspectionDoneBy        BIGINT,
    inspectionDate          DATE,
    whetherElectronic       BIT             NOT NULL,
    lastUpdatedBy           BIGINT          NOT NULL,
    lastUpdate              TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: completion_transactions 
--

CREATE TABLE completion_transactions(
    id                     BIGINT       AUTO_INCREMENT,
    programId              BIGINT,
    batchId                BIGINT,
    effectiveFromDate      DATE,
    admissionId            BIGINT,
    whetherMessage         BIT          NOT NULL,
    whetherNotification    BIT          NOT NULL,
    whetherPassedOut       BIT          NOT NULL,
    whetherWithdrawal      BIT          NOT NULL,
    whetherTransfer        BIT          NOT NULL,
    whetherTermination     BIT          NOT NULL,
    lastUpdatedBy          BIGINT       NOT NULL,
    lastUpdate             TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: component_type 
--

CREATE TABLE component_type(
    id               BIGINT         AUTO_INCREMENT,
    componentType    VARCHAR(30)    NOT NULL,
    lastUpdate       TIMESTAMP      NOT NULL,
    lastUpdatedBy    BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: config_control_account 
--

CREATE TABLE config_control_account(
    id                              BIGINT         AUTO_INCREMENT,
    iauAccountingId                 BIGINT,
    accountingType                  VARCHAR(18),
    whetherDefaultControlAccount    BIT,
    lastUpdatedBy                   BIGINT,
    lastUpdate                      TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: config_control_head_detail 
--

CREATE TABLE config_control_head_detail(
    id                        BIGINT         AUTO_INCREMENT,
    configControlAccountId    BIGINT,
    feeHeadId                 BIGINT,
    accountingConfigId        BIGINT,
    controlAccount            VARCHAR(10),
    lastUpdatedBy             BIGINT,
    lastUpdate                TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: config_control_head_plan 
--

CREATE TABLE config_control_head_plan(
    id                        BIGINT         AUTO_INCREMENT,
    configControlAccountId    BIGINT,
    accountConfigId           BIGINT,
    feeHeadId                 BIGINT,
    feePlanId                 BIGINT,
    controlAccount            VARCHAR(35),
    debitNarration            VARCHAR(30),
    creditNarration           VARCHAR(30),
    lastUpdateBy              BIGINT         NOT NULL,
    lastUpdate                TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: config_control_plan_detail 
--

CREATE TABLE config_control_plan_detail(
    id                        BIGINT         AUTO_INCREMENT,
    configControlAccountId    BIGINT,
    accountingConfigId        BIGINT,
    feePlanId                 BIGINT,
    feePlanRuleStageId        BIGINT,
    feeSeqId                  BIGINT,
    controlAccount            VARCHAR(10),
    debitNarration            VARCHAR(30),
    creditNarration           VARCHAR(30),
    lastUpdatedBy             BIGINT,
    lastUpdate                TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: country 
--

CREATE TABLE country(
    id               BIGINT         AUTO_INCREMENT,
    code             CHAR(10),
    countryName      VARCHAR(20),
    isdCode          CHAR(10),
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: country_region 
--

CREATE TABLE country_region(
    id                   BIGINT         AUTO_INCREMENT,
    countryId            BIGINT,
    parentRegionId       BIGINT,
    code                 CHAR(10),
    countryRegionName    VARCHAR(20),
    countryRegionType    VARCHAR(20),
    lastUpdatedBy        BIGINT         NOT NULL,
    lastUpdate           TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_academy_location 
--

CREATE TABLE course_academy_location(
    id                   BIGINT       AUTO_INCREMENT,
    courseId             BIGINT,
    academyLocationId    BIGINT,
    lastUpdatedBy        BIGINT       NOT NULL,
    lastUpdate           TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_cf_data 
--

CREATE TABLE course_cf_data(
    id                BIGINT         AUTO_INCREMENT,
    courseId          BIGINT,
    fieldId           BIGINT,
    strFieldValue     VARCHAR(20),
    dateFieldValue    VARCHAR(20),
    txtFieldValue     VARCHAR(20),
    lastUpdatedBy     BIGINT,
    lastUpdate        TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_components 
--

CREATE TABLE course_components(
    id                 BIGINT          AUTO_INCREMENT,
    courseId           BIGINT,
    componentDesc      VARCHAR(255)    NOT NULL,
    componentStatus    BIT,
    componentCredit    TINYINT,
    lastUpdatedBy      BIGINT          NOT NULL,
    lastUpdate         TIMESTAMP       NOT NULL,
    componentTypeId    BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_coverage_plan 
--

CREATE TABLE course_coverage_plan(
    id                BIGINT      AUTO_INCREMENT,
    courseId          BIGINT,
    sectionId         BIGINT,
    lastUpdatedBy     BIGINT      NOT NULL,
    lastUpdate        DATETIME    NOT NULL,
    programBatchId    BIGINT      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_coverage_plan_details 
--

CREATE TABLE course_coverage_plan_details(
    id                              BIGINT          AUTO_INCREMENT,
    courseCoveragePlanId            BIGINT,
    courseTopicId                   BIGINT,
    sessionDate                     DATE,
    slotFrom                        TINYINT,
    slotTo                          TINYINT,
    facultyId                       BIGINT          NOT NULL,
    additionalFaculty               BIGINT          NOT NULL,
    alternateFaculty                BIGINT          NOT NULL,
    facultyAdditional1              BIGINT          NOT NULL,
    timeToSpend                     INT,
    optionalSession                 BIT,
    whetherAttendanceToBeEntered    BIT,
    readingName                     VARCHAR(255),
    sessionStatus                   CHAR(1),
    whetherPlannedSession           BIT,
    reason                          VARCHAR(255),
    roomAssignment                  BIT,
    lastUpdatedBy                   BIGINT          NOT NULL,
    lastUpdate                      DATETIME        NOT NULL,
    personId                        BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_distribution_list 
--

CREATE TABLE course_distribution_list(
    id                    BIGINT      AUTO_INCREMENT,
    distributionListId    BIGINT,
    courseVariantId       BIGINT,
    lastUpdatedBy         BIGINT,
    lastUpdate            DATETIME    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_equivalence 
--

CREATE TABLE course_equivalence(
    id                      BIGINT         AUTO_INCREMENT,
    courseComponentId       BIGINT,
    courseEquivalentName    VARCHAR(35),
    equivalentComponent     BIGINT,
    whetherActive           BIT,
    lastUpdatedBy           BIGINT         NOT NULL,
    lastUpdate              TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_evaluation_que_paper 
--

CREATE TABLE course_evaluation_que_paper(
    id                      BIGINT          AUTO_INCREMENT,
    evalSequenceDetailId    BIGINT,
    questionPaperId         BIGINT,
    fromDate                TIMESTAMP,
    tillDate                TIMESTAMP,
    remark                  VARCHAR(255),
    lastUpdatedBy           BIGINT          NOT NULL,
    lastUpdate              TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_group 
--

CREATE TABLE course_group(
    id                         BIGINT         AUTO_INCREMENT,
    code                       VARCHAR(30),
    whetherRegularGroup        BIT            NOT NULL,
    whetherSpecializedGroup    BIT            NOT NULL,
    whetherAuditGroup          BIT            NOT NULL,
    groupName                  VARCHAR(35),
    minCourses                 INT,
    maxCourses                 INT,
    optionalMaxCourses         INT,
    optionalMinCourses         INT,
    maxCredits                 INT,
    minCredits                 INT,
    lastUpdatedBy              BIGINT         NOT NULL,
    lastUpdate                 TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_groups_course 
--

CREATE TABLE course_groups_course(
    id                  BIGINT       AUTO_INCREMENT,
    courseGroupId       BIGINT,
    courseId            BIGINT,
    whetherMandatory    BIT          NOT NULL,
    lastUpdatedBy       BIGINT       NOT NULL,
    lastUpdate          TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_history_one 
--

CREATE TABLE course_history_one(
    id                         BIGINT       AUTO_INCREMENT,
    progBatchPeriodConfigId    BIGINT,
    courseId                   BIGINT,
    courseGroupId              BIGINT,
    noOfStudentEnrolled        INT,
    minCapacity                INT,
    maxCapacity                BIGINT,
    lastUpdatedBy              BIGINT,
    lastUpdate                 TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_history_two 
--

CREATE TABLE course_history_two(
    id                      BIGINT        AUTO_INCREMENT,
    courseHistoryOneId      BIGINT,
    courseVariantId         BIGINT,
    faculty1                BIGINT,
    faculty2                BIGINT,
    faculty3                BIGINT,
    enrolmentReqReceived    INT,
    enrolmentReqRejected    INT,
    studentEnrolled         INT,
    studentPassed           INT,
    minMarkOfAny            INT,
    maxMarkOfAny            INT,
    minGradeOfAny           VARCHAR(6),
    maxGradeOfAny           VARCHAR(6),
    minMarkForCourse        INT,
    maxMarkForCourse        INT,
    minGradeForCourse       VARCHAR(6),
    maxGradeForCourse       VARCHAR(6),
    lastUpdatedBy           BIGINT,
    lastUpdate              TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_hw_asignment 
--

CREATE TABLE course_hw_asignment(
    id                            BIGINT          NOT NULL,
    batchId                       BIGINT,
    assignmentId                  BIGINT,
    evaluationPlanId              BIGINT,
    evaluationGroupId             BIGINT,
    programBatchPeriodConfigId    BIGINT,
    evaluationSequenceId          BIGINT,
    evaluationDetailSequenceId    BIGINT,
    sectionId                     BIGINT,
    assignmentType                VARCHAR(2),
    dateGiven                     DATE            NOT NULL,
    dateSubmitted                 DATE,
    dateResubmitted               DATE,
    submissionDate                DATE,
    marks                         INT,
    grades                        VARCHAR(4),
    hWRemarks                     VARCHAR(255),
    hWOnlineSubmission            CHAR(1),
    hWOnlineSubmissionGroup       CHAR(1),
    lastUpdatedBy                 BIGINT          NOT NULL,
    lastUpdate                    TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_read_distribution 
--

CREATE TABLE course_read_distribution(
    id                    BIGINT      AUTO_INCREMENT,
    distributionListId    BIGINT,
    courseReadingId       BIGINT,
    lastUpdatedBy         BIGINT,
    lastUpdate            DATETIME    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_read_type 
--

CREATE TABLE course_read_type(
    id                 BIGINT         AUTO_INCREMENT,
    readingTypeName    VARCHAR(20),
    lastUpdatedBy      BIGINT         NOT NULL,
    lastUpdate         TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_reading 
--

CREATE TABLE course_reading(
    id                    BIGINT          AUTO_INCREMENT,
    linkPath              TEXT,
    academicYear          INT,
    courseId              BIGINT,
    courseReadTypeId      BIGINT,
    distributionModeId    BIGINT,
    readingName           VARCHAR(255),
    author                VARCHAR(60),
    whetherCompulsory     BIT             NOT NULL,
    topicType             VARCHAR(35),
    lastUpdatedBy         BIGINT          NOT NULL,
    lastUpdate            DATETIME        NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_reading_links 
--

CREATE TABLE course_reading_links(
    id                     BIGINT          AUTO_INCREMENT,
    courseReadingId        BIGINT,
    mediaLinks             VARCHAR(300),
    whetherDownloadable    BIT,
    lastUpdatedBy          BIGINT          NOT NULL,
    lastUpdate             DATETIME        NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_reading_period_details 
--

CREATE TABLE course_reading_period_details(
    id                 BIGINT       AUTO_INCREMENT,
    lastUpdate         TIMESTAMP    NOT NULL,
    courseReadingId    BIGINT,
    programId          BIGINT,
    batchId            BIGINT,
    periodId           BIGINT,
    lastUpdatedBy      BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_reading_topics 
--

CREATE TABLE course_reading_topics(
    id                 BIGINT      AUTO_INCREMENT,
    courseTopicId      BIGINT,
    courseReadingId    BIGINT,
    lastUpdatedBy      BIGINT      NOT NULL,
    lastUpdate         DATETIME    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_reading_variant 
--

CREATE TABLE course_reading_variant(
    id                 BIGINT      AUTO_INCREMENT,
    courseReadingId    BIGINT,
    courseVariantId    BIGINT,
    lastUpdatedBy      BIGINT      NOT NULL,
    lastUpdate         DATETIME    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_relation_history 
--

CREATE TABLE course_relation_history(
    id                                BIGINT         AUTO_INCREMENT,
    programBatchId                    BIGINT,
    relationType                      VARCHAR(10),
    courseId                          BIGINT,
    relatedCourseId                   BIGINT,
    whetherRelatedCourseMandatory     BIT,
    whetherRelatedCourseIndepedent    BIT,
    lastUpdatedBy                     BIGINT,
    lastUpdate                        TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_req_detail_courses 
--

CREATE TABLE course_req_detail_courses(
    courseWithdrawReqDetailId    BIGINT    NOT NULL,
    courseId                     BIGINT    NOT NULL,
    PRIMARY KEY (courseWithdrawReqDetailId, courseId)
)
;



-- 
-- TABLE: course_topic_session 
--

CREATE TABLE course_topic_session(
    id                   BIGINT          AUTO_INCREMENT,
    courseTopicId        BIGINT,
    courseVariantId      BIGINT,
    session              INT,
    activitiesCovered    VARCHAR(255),
    lastUpdatedBy        BIGINT,
    lastUpdate           TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_topics 
--

CREATE TABLE course_topics(
    id                             BIGINT          AUTO_INCREMENT,
    courseComponentId              BIGINT          NOT NULL,
    topicSequence                  TINYINT         NOT NULL,
    topicName                      VARCHAR(255)    NOT NULL,
    topicHours                     INT,
    topicDepth                     BIGINT,
    whetherCompulsory              BIT             NOT NULL,
    noOfSessions                   INT             NOT NULL,
    whetherTemporaryIgnoreTopic    BIT             NOT NULL,
    topicPlanDocumentPath          VARCHAR(255),
    lastUpdatedBy                  BIGINT          NOT NULL,
    lastUpdate                     TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_variants 
--

CREATE TABLE course_variants(
    id                               BIGINT          AUTO_INCREMENT,
    courseId                         BIGINT,
    courseVariantCode                VARCHAR(30),
    courseVariantDescription         VARCHAR(100)    NOT NULL,
    courseVariantShortDescription    VARCHAR(30)     NOT NULL,
    courseVariantHWFileLocation      VARCHAR(255),
    courseVariantFileDwlLoc          VARCHAR(255),
    calendarId                       BIGINT,
    courseStatus                     BIT,
    courseVariantStatus              VARCHAR(30),
    lastUpdatedBy                    BIGINT          NOT NULL,
    version                          BIGINT          NOT NULL,
    lastUpdate                       DATETIME        NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: course_withdraw_req_details 
--

CREATE TABLE course_withdraw_req_details(
    detailId     BIGINT    NOT NULL,
    programId    BIGINT    NOT NULL,
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: course_xfer_request_details 
--

CREATE TABLE course_xfer_request_details(
    detailId        BIGINT    NOT NULL,
    toCourseId      BIGINT    NOT NULL,
    fromCourseId    BIGINT    NOT NULL,
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: courses 
--

CREATE TABLE courses(
    id                             BIGINT           AUTO_INCREMENT,
    assignSectionType              VARCHAR(35),
    courseCode                     VARCHAR(10),
    courseName                     VARCHAR(100)     NOT NULL,
    courseShortName                VARCHAR(35),
    whetherCourseCanBeExemption    BIT               DEFAULT 0 NOT NULL,
    nameToBePrinted                VARCHAR(100),
    departmentId                   BIGINT           NOT NULL,
    subDepartmentId                BIGINT,
    hasCourseComponents            BIT               DEFAULT FALSE NOT NULL,
    courseSyllabus                 VARCHAR(4000)    NOT NULL,
    whetherEvaluationExternal      BIT,
    courseMarksGrades              CHAR(1),
    courseCutOff                   VARCHAR(3),
    courseMaxMark                  VARCHAR(5),
    courseCredits                  TINYINT,
    deficiencyStatus               BIT              NOT NULL,
    whetherFixed                   BIT,
    courseDeficits                 CHAR(2),
    courseDeficitsPoint            INT              NOT NULL,
    courseShortDescription         VARCHAR(255)     NOT NULL,
    courseCoordinator              BIGINT,
    courseRankConsidered           VARCHAR(1),
    sectionType                    VARCHAR(35),
    courseEntryCriteriaQuery       VARCHAR(255),
    courseExitCriteriaQuery        VARCHAR(255),
    stageId                        BIGINT,
    whetherRepeatable              BIT              NOT NULL,
    whetherDeleted                 BIT               DEFAULT FALSE NOT NULL,
    categoryField1                 VARCHAR(15),
    categoryField2                 VARCHAR(15),
    categoryField3                 VARCHAR(15),
    categoryField4                 VARCHAR(15),
    categoryField5                 VARCHAR(15),
    createdOn                      TIMESTAMP,
    lastUpdatedBy                  BIGINT           NOT NULL,
    lastUpdate                     TIMESTAMP        NOT NULL,
    version                        BIGINT           NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: currency 
--

CREATE TABLE currency(
    id                BIGINT         AUTO_INCREMENT,
    currencyName      VARCHAR(50),
    currencyCode      VARCHAR(10)    NOT NULL,
    regionCode        VARCHAR(10)    NOT NULL,
    lastUpdate        TIMESTAMP      NOT NULL,
    version           BIGINT         NOT NULL,
    whetherDeleted    BIT            NOT NULL,
    lastUpdatedBy     BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: currency_exchange_rate 
--

CREATE TABLE currency_exchange_rate(
    id              BIGINT       AUTO_INCREMENT,
    currencyId      BIGINT       NOT NULL,
    exchangeRate    FLOAT        NOT NULL,
    validTill       TIMESTAMP,
    status          BIT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: currency_exchange_rate_history 
--

CREATE TABLE currency_exchange_rate_history(
    id              BIGINT       AUTO_INCREMENT,
    currencyId      BIGINT       NOT NULL,
    exchangeRate    FLOAT        NOT NULL,
    validTill       TIMESTAMP,
    currentDate     TIMESTAMP,
    status          BIT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: data_to_be_changed 
--

CREATE TABLE data_to_be_changed(
    id               BIGINT       NOT NULL,
    lastUpdatedBy    BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP,
    personId         BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: dataview_audit 
--

CREATE TABLE dataview_audit(
    id               BIGINT         AUTO_INCREMENT,
    userId           BIGINT,
    accessTime       DATETIME,
    entityName       VARCHAR(35),
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: debarment_reasons 
--

CREATE TABLE debarment_reasons(
    id               BIGINT          NOT NULL,
    itemCode         VARCHAR(100),
    itemValue        VARCHAR(255),
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: debarment_request_details 
--

CREATE TABLE debarment_request_details(
    detailId             BIGINT       NOT NULL,
    fromDate             TIMESTAMP,
    toDate               TIMESTAMP,
    courseId             BIGINT       NOT NULL,
    debarmentReasonId    BIGINT       NOT NULL,
    programId            BIGINT       NOT NULL,
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: default_search_criterias 
--

CREATE TABLE default_search_criterias(
    id                          BIGINT          AUTO_INCREMENT,
    CriteriaName                VARCHAR(250),
    searchConfigId              BIGINT          NOT NULL,
    searchConfigTableId         BIGINT          NOT NULL,
    searchTableColumnId         BIGINT          NOT NULL,
    searchCriteriaOperatorId    BIGINT          NOT NULL,
    operandValue                VARCHAR(200),
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: deficit_credit 
--

CREATE TABLE deficit_credit(
    id               BIGINT       AUTO_INCREMENT,
    courseId         BIGINT,
    gradeGroupId     BIGINT,
    gradeId          BIGINT,
    deficitPoints    INT,
    lastUpdatedBy    BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: deficit_credit_transaction 
--

CREATE TABLE deficit_credit_transaction(
    id                            BIGINT       AUTO_INCREMENT,
    admissionId                   BIGINT,
    programBatchPeriodConfigId    BIGINT,
    courseId                      BIGINT,
    sectionId                     BIGINT,
    courseComponentId             BIGINT,
    evalSequenceId                BIGINT,
    evalDetailSequenceId          BIGINT,
    deficitCredited               INT,
    lastUpdatedBy                 BIGINT       NOT NULL,
    lastUpdate                    TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: department 
--

CREATE TABLE department(
    id                    BIGINT          AUTO_INCREMENT,
    parentDepartmentId    BIGINT,
    shortCode             CHAR(10),
    deptName              VARCHAR(255),
    deptType              VARCHAR(15),
    status                INT,
    hasSubDepartment      INT,
    hodId                 BIGINT,
    hodStartDate          DATE,
    hodEndDate            DATE,
    serialId              VARCHAR(255),
    academyLocationId     BIGINT,
    lastUpdatedBy         BIGINT          NOT NULL,
    lastUpdate            TIMESTAMP       NOT NULL,
    version               BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: disciplinary_actions 
--

CREATE TABLE disciplinary_actions(
    id                BIGINT           AUTO_INCREMENT,
    personId          BIGINT           NOT NULL,
    incidentDate      DATE             NOT NULL,
    yearOfAction      DECIMAL(0, 0)    NOT NULL,
    whetherDeleted    BIT              NOT NULL,
    actionTaken       VARCHAR(255)     NOT NULL,
    details           VARCHAR(255)     NOT NULL,
    remarks           VARCHAR(255)      DEFAULT NULL,
    version           DECIMAL(0, 0)    NOT NULL,
    lastUpdate        TIMESTAMP        NOT NULL,
    lastUpdatedBy     BIGINT           NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: distribution_list 
--

CREATE TABLE distribution_list(
    id                      BIGINT          AUTO_INCREMENT,
    remarks                 VARCHAR(255),
    createdDate             DATE            NOT NULL,
    distributionListType    VARCHAR(45),
    listName                VARCHAR(255),
    whetherAutoApprove      BIT,
    lastUpdatedBy           BIGINT          NOT NULL,
    lastUpdate              DATETIME        NOT NULL,
    createdBy               BIGINT,
    distributionModeId      BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: distribution_mode 
--

CREATE TABLE distribution_mode(
    id               BIGINT         AUTO_INCREMENT,
    modeName         VARCHAR(30),
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: document_rules 
--

CREATE TABLE document_rules(
    id                         BIGINT          AUTO_INCREMENT,
    documentId                 BIGINT          NOT NULL,
    serviceRequestSettingId    BIGINT          NOT NULL,
    whetherDeleted             BIT,
    rule                       VARCHAR(255),
    ruleDescription            VARCHAR(255),
    lastUpdatedBy              BIGINT          NOT NULL,
    lastUpdate                 TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: documents 
--

CREATE TABLE documents(
    id               BIGINT         AUTO_INCREMENT,
    documentName     VARCHAR(10),
    documentType     VARCHAR(10),
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: draft_grade_distribution 
--

CREATE TABLE draft_grade_distribution(
    id                      BIGINT         AUTO_INCREMENT,
    programId               BIGINT,
    batchId                 BIGINT,
    courseId                BIGINT,
    courseVarientId         BIGINT,
    evalSequenceId          BIGINT,
    evalDetailSequenceId    BIGINT,
    enteredBy               BIGINT,
    entryDate               DATE,
    distributionStatus      VARCHAR(10),
    lastUpdatedBy           BIGINT         NOT NULL,
    lastUpdate              TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: drop_down 
--

CREATE TABLE drop_down(
    id               BIGINT         AUTO_INCREMENT,
    lastUpdate       VARCHAR(10)    NOT NULL,
    type             VARCHAR(45),
    name             VARCHAR(45),
    value            VARCHAR(10),
    lastUpdatedBy    BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: education_data_to_be_changed 
--

CREATE TABLE education_data_to_be_changed(
    dataToBeChangedId         BIGINT          NOT NULL,
    whetherExistingStudent    BIT,
    yearPassed                TIMESTAMP,
    examName                  VARCHAR(255),
    result                    VARCHAR(100),
    examConductedBy           VARCHAR(255),
    enrollmentNumber          VARCHAR(50),
    PRIMARY KEY (dataToBeChangedId)
)
;



-- 
-- TABLE: education_histories 
--

CREATE TABLE education_histories(
    id                        BIGINT           AUTO_INCREMENT,
    personId                  BIGINT           NOT NULL,
    enrollmentNumber          VARCHAR(100)      DEFAULT NULL,
    examName                  VARCHAR(255)     NOT NULL,
    examConductedBy           VARCHAR(255)     NOT NULL,
    whetherExistingStudent    BIT               DEFAULT FALSE NOT NULL,
    examResult                VARCHAR(100)     NOT NULL,
    yearPassed                VARCHAR(5)       NOT NULL,
    whetherDeleted            BIT               DEFAULT FALSE NOT NULL,
    version                   DECIMAL(0, 0)    NOT NULL,
    lastUpdate                TIMESTAMP        NOT NULL,
    lastUpdatedBy             BIGINT           NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: enq_address 
--

CREATE TABLE enq_address(
    id                 BIGINT         AUTO_INCREMENT,
    enquiryId          BIGINT,
    addressId          BIGINT,
    addressCategory    VARCHAR(20),
    lastUpdatedBy      BIGINT         NOT NULL,
    lastUpdate         TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: enq_closure_reason 
--

CREATE TABLE enq_closure_reason(
    id                       BIGINT          AUTO_INCREMENT,
    enquiryId                BIGINT,
    closureReasonId          BIGINT,
    enqStudentDetailsId      BIGINT,
    enqAdmissionDetailsId    BIGINT,
    closureDate              DATE            NOT NULL,
    reasonRemark             VARCHAR(255),
    whetherDeleted           BIT,
    lastUpdate               TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    lastUpdatedBy            BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: enq_exams_details 
--

CREATE TABLE enq_exams_details(
    id                     BIGINT          AUTO_INCREMENT,
    enquiryId              BIGINT,
    programExamType        VARCHAR(35),
    qualifyingProgramId    BIGINT          NOT NULL,
    programConductedBy     VARCHAR(100),
    programYear            INT,
    examResult             VARCHAR(10),
    examStatus             VARCHAR(5),
    whetherDeleted         BIT,
    lastUpdatedBy          BIGINT          NOT NULL,
    lastUpdate             TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: enq_followup 
--

CREATE TABLE enq_followup(
    id                    BIGINT          AUTO_INCREMENT,
    userId                BIGINT,
    enquiryId             BIGINT,
    assignTo              BIGINT,
    followUpNo            SMALLINT        NOT NULL,
    followUpDate          DATE,
    actualFollowUpDate    DATE,
    whetherDeleted        BIT,
    remark                VARCHAR(255),
    lastUpdatedBy         BIGINT          NOT NULL,
    lastUpdate            TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: enq_program_master 
--

CREATE TABLE enq_program_master(
    id               BIGINT         AUTO_INCREMENT,
    programName      VARCHAR(45)    NOT NULL,
    programCode      VARCHAR(45),
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: enq_reopen_reason 
--

CREATE TABLE enq_reopen_reason(
    id                       BIGINT          AUTO_INCREMENT,
    enquiryId                BIGINT,
    reopenReasonId           BIGINT,
    enqStudentDetailsId      BIGINT,
    enqAdmissionDetailsId    BIGINT,
    reopenDate               DATE            NOT NULL,
    reasonRemark             VARCHAR(255),
    whethetDeleted           BIT,
    lastUpdatedBy            BIGINT          NOT NULL,
    lastUpdate               TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: enq_student_details 
--

CREATE TABLE enq_student_details(
    id                        BIGINT         AUTO_INCREMENT,
    enquiryId                 BIGINT,
    studentFirstName          VARCHAR(50),
    studentMiddleName         VARCHAR(50),
    studentLastName           VARCHAR(50),
    studentDateOfBirth        DATE,
    gender                    CHAR(6),
    fatherFirstName           VARCHAR(35),
    fatherMiddleName          VARCHAR(35),
    fatherLastName            VARCHAR(35),
    motherFirstName           VARCHAR(35),
    motherMiddleName          VARCHAR(35),
    motherLastName            VARCHAR(35),
    fatherEmployed            BIT            NOT NULL,
    fatherEmployeeId          BIGINT,
    motherEmployed            BIT            NOT NULL,
    motherEmployeeId          BIGINT,
    reservationCategoryId     BIGINT,
    bloodGroup                CHAR(10),
    applnAcademicYearFor      VARCHAR(8),
    whetherSiblingStudying    BIT             DEFAULT FALSE NOT NULL,
    sibiling1AdmissionId      BIGINT,
    sibiling2AdmissionId      BIGINT,
    sibiling3AdmissionId      BIGINT,
    familyIncomeId            BIGINT,
    whetherDeleted            BIT,
    lastUpdatedBy             BIGINT,
    lastUpdate                TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: enquiry 
--

CREATE TABLE enquiry(
    id                        BIGINT          AUTO_INCREMENT,
    registeredBy              BIGINT,
    campaignId                BIGINT,
    enquiryTypeId             BIGINT,
    userId                    BIGINT,
    code                      VARCHAR(10),
    sourceCode                VARCHAR(15),
    registeredByType          VARCHAR(35),
    firstName                 VARCHAR(35)     NOT NULL,
    lastName                  VARCHAR(35)     NOT NULL,
    middleName                VARCHAR(35),
    enquiryDate               DATE,
    followUpDate              DATE,
    timeTakenForCompletion    INT,
    followUpUser              BIGINT,
    remark                    VARCHAR(255),
    status                    VARCHAR(1),
    notificationError         VARCHAR(1),
    whetherDeleted            BIT,
    categoryField1            VARCHAR(15),
    categoryField2            VARCHAR(15),
    categoryField3            VARCHAR(15),
    categoryField4            VARCHAR(15),
    categoryField5            VARCHAR(15),
    lastUpdatedBy             BIGINT          NOT NULL,
    lastUpdate                TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: enquiry_cf_data 
--

CREATE TABLE enquiry_cf_data(
    id                BIGINT         AUTO_INCREMENT,
    enquiryId         BIGINT,
    fieldId           BIGINT,
    strFieldValue     VARCHAR(20),
    dateFieldValue    VARCHAR(20),
    txtFieldValue     VARCHAR(20),
    lastUpdatedBy     BIGINT         NOT NULL,
    lastUpdate        TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: enquiry_student_address 
--

CREATE TABLE enquiry_student_address(
    id                     BIGINT       AUTO_INCREMENT,
    enqStudentDetailsId    BIGINT,
    addressId              BIGINT,
    lastUpdatedBy          BIGINT       NOT NULL,
    lastUpdate             TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: enquiry_type 
--

CREATE TABLE enquiry_type(
    id                 BIGINT          AUTO_INCREMENT,
    code               VARCHAR(255),
    enquiryTypeName    VARCHAR(255),
    lastUpdatedBy      BIGINT          NOT NULL,
    lastUpdate         TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: entity_field_meta_data 
--

CREATE TABLE entity_field_meta_data(
    id                  BIGINT         AUTO_INCREMENT,
    entityTypeId        BIGINT,
    dataType            VARCHAR(20),
    displayCode         VARCHAR(50),
    displayOrder        BIGINT         NOT NULL,
    whetherMandatory    BIT            NOT NULL,
    lastUpdatedBy       BIGINT         NOT NULL,
    lastUpdate          TIMESTAMP,
    version             BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: entity_setting 
--

CREATE TABLE entity_setting(
    id                   BIGINT         AUTO_INCREMENT,
    fieldDataTypeCode    VARCHAR(10)    NOT NULL,
    fieldLabel           VARCHAR(50)    NOT NULL,
    fieldCode            VARCHAR(50)    NOT NULL,
    mandatory            BIT            NOT NULL,
    displayOrder         INT            NOT NULL,
    typeCode             CHAR(3)        NOT NULL,
    defaultValue         VARCHAR(50),
    lastUpdate           TIMESTAMP      NOT NULL,
    lastUpdatedBy        BIGINT         NOT NULL,
    version              BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: entity_type 
--

CREATE TABLE entity_type(
    id                   BIGINT         AUTO_INCREMENT,
    entityName           VARCHAR(60)    NOT NULL,
    displayCode          VARCHAR(60),
    whetherConfigured    BIT            NOT NULL,
    entityCode           VARCHAR(50)    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: eval_group_center 
--

CREATE TABLE eval_group_center(
    id                      BIGINT       AUTO_INCREMENT,
    evaluationGroupId       BIGINT,
    centerId                BIGINT,
    evalSequenceDetailId    BIGINT,
    lastUpdatedBy           BIGINT       NOT NULL,
    lastUpdate              TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: eval_group_criteria 
--

CREATE TABLE eval_group_criteria(
    id                    BIGINT          AUTO_INCREMENT,
    evaluationGroupId     BIGINT,
    evalCriteria          VARCHAR(35),
    evalCriteriaQuery     VARCHAR(255),
    evalCriteriaStatus    BIT             NOT NULL,
    evalCriteriaWaived    BIT             NOT NULL,
    lastUpdatedBy         BIGINT          NOT NULL,
    lastUpdate            TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: eval_group_sch_date 
--

CREATE TABLE eval_group_sch_date(
    id                      BIGINT       AUTO_INCREMENT,
    evaluationGroupId       BIGINT,
    evalSequenceDetailId    BIGINT,
    scheduleDate            DATE,
    lastUpdatedBy           BIGINT       NOT NULL,
    lastUpdate              TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: eval_group_seat_type 
--

CREATE TABLE eval_group_seat_type(
    id                         BIGINT       AUTO_INCREMENT,
    evaluationGroupId          BIGINT,
    progBatchPeriodConfigId    BIGINT,
    seatType                   CHAR(2),
    lastUpdatedBy              BIGINT       NOT NULL,
    lastUpdate                 TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: eval_group_sequences 
--

CREATE TABLE eval_group_sequences(
    id                      BIGINT          AUTO_INCREMENT,
    evaluationGroupId       BIGINT,
    courseId                BIGINT,
    evaluationPlanId        BIGINT,
    evaluationSequenceId    BIGINT,
    centers                 VARCHAR(4),
    disableTimeSlot         VARCHAR(255),
    lastUpdate              TIMESTAMP       NOT NULL,
    lastUpdatedBy           BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: eval_seq_detail 
--

CREATE TABLE eval_seq_detail(
    id                                BIGINT         AUTO_INCREMENT,
    whetherPrimaryEvalDetails         BIT            NOT NULL,
    periodSequence                    INT,
    whetherCourseEvalTestWritten      BIT            NOT NULL,
    whetherAdministerSurprise         BIT            NOT NULL,
    evalSequenceId                    BIGINT,
    plannedDate                       DATETIME       NOT NULL,
    mandatoryForEvaluation            BIT            NOT NULL,
    mandatoryForAttendance            BIT            NOT NULL,
    administrationMode                CHAR(2),
    randomAdminSelectionApplicable    BIT,
    whetherBatches                    BIT            NOT NULL,
    whetherForLimitedSet              BIT,
    noOfSetsRequired                  INT,
    whetherDetailSeqEquivalent        BIT            NOT NULL,
    courseEvalDetailSeqEquivalent     INT            NOT NULL,
    whetherAnsAvailableForReview      BIT            NOT NULL,
    whetherEvalAnonymous              BIT            NOT NULL,
    whetherRevaluationPossible        BIT            NOT NULL,
    hasObjectTypeQuestions            BIT            NOT NULL,
    notificationTime                  VARCHAR(6)     NOT NULL,
    notificationMode                  VARCHAR(7)     NOT NULL,
    evalInMarksOrGrade                CHAR(1),
    maxMarksOrGrade                   VARCHAR(3),
    minMarksOrGrade                   VARCHAR(3),
    weightage                         VARCHAR(10),
    whetherResultApproved             BIT            NOT NULL,
    approverName                      VARCHAR(35),
    lastUpdatedBy                     BIGINT         NOT NULL,
    lastUpdate                        TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: eval_sequence_logistics 
--

CREATE TABLE eval_sequence_logistics(
    id                         BIGINT       AUTO_INCREMENT,
    evalSequenceId             BIGINT,
    staffLogisticRequired      BIT,
    questionaPaperRequired     BIT,
    centerLogisticsRequired    BIT,
    attendanceRelevant         BIT,
    lastUpdatedBy              BIGINT       NOT NULL,
    lastUpdate                 TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: eval_sequence_rules 
--

CREATE TABLE eval_sequence_rules(
    id                      BIGINT          AUTO_INCREMENT,
    courseEvalQuePaperId    BIGINT,
    ruleName                VARCHAR(100),
    ruleDescription         VARCHAR(255),
    lastUpdatedBy           BIGINT          NOT NULL,
    lastUpdate              TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: evaluation_group 
--

CREATE TABLE evaluation_group(
    id                               BIGINT         AUTO_INCREMENT,
    programId                        BIGINT,
    batchId                          BIGINT,
    evaluationGroupCode              VARCHAR(35),
    examdateFrom                     DATE           NOT NULL,
    examdateTill                     DATE           NOT NULL,
    hallTicketGenerationRequired     BIT            NOT NULL,
    hallTicketDistributionMode       CHAR(5)        NOT NULL,
    whetherMultipleBatches           BIT            NOT NULL,
    centerType                       CHAR(1),
    feePlanId                        BIGINT,
    applicationFormNeeded            BIT            NOT NULL,
    applicationStartDate             DATE,
    applicationTillDate              DATE,
    studentParticipationAutomatic    CHAR(1),
    centerSelectionAllowed           BIT            NOT NULL,
    reschedulePossible               BIT            NOT NULL,
    rescheduleTillDate               DATE,
    lastUpdatedBy                    BIGINT         NOT NULL,
    lastUpdate                       TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: evaluation_plan 
--

CREATE TABLE evaluation_plan(
    id                            BIGINT         AUTO_INCREMENT,
    evaluationType                CHAR(1)        NOT NULL,
    courseId                      BIGINT,
    sectionId                     BIGINT,
    tillDate                      DATE,
    courseEvalPlanType            CHAR(1)        NOT NULL,
    courseEvalWeightageTotal      CHAR(1)        NOT NULL,
    assignedTo                    BIGINT,
    externalOrganizationName      VARCHAR(50)    NOT NULL,
    courseEvaluationConsidered    CHAR(1),
    lastUpdatedBy                 BIGINT         NOT NULL,
    lastUpdate                    TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: evaluation_plan_batches 
--

CREATE TABLE evaluation_plan_batches(
    id                      BIGINT       AUTO_INCREMENT,
    evalSequenceDetailId    BIGINT,
    batchId                 BIGINT,
    lastUpdatedBy           BIGINT       NOT NULL,
    lastUpdate              TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: evaluation_plan_level_one 
--

CREATE TABLE evaluation_plan_level_one(
    id                  BIGINT         AUTO_INCREMENT,
    evaluationPlanId    BIGINT,
    levelName           VARCHAR(20),
    levelValue          VARCHAR(30),
    lastUpdatedBy       BIGINT         NOT NULL,
    lastUpdate          TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: evaluation_plan_level_two 
--

CREATE TABLE evaluation_plan_level_two(
    id                             BIGINT         AUTO_INCREMENT,
    evalPlanLevelOneId             BIGINT,
    levelName                      VARCHAR(20),
    levelValue                     VARCHAR(30),
    courseComponentId              BIGINT,
    courseEvalWeightageRelevant    VARCHAR(30),
    weightage                      VARCHAR(10),
    lastUpdatedBy                  BIGINT         NOT NULL,
    lastUpdate                     TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: evaluation_plan_students 
--

CREATE TABLE evaluation_plan_students(
    id                      BIGINT       AUTO_INCREMENT,
    evalSequenceDetailId    BIGINT,
    admissionId             BIGINT,
    lastUpdatedBy           BIGINT       NOT NULL,
    lastUpdate              TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: evaluation_plan_topic 
--

CREATE TABLE evaluation_plan_topic(
    id                      BIGINT       AUTO_INCREMENT,
    evalSequenceDetailId    BIGINT,
    courseTopicId           BIGINT,
    minMarks                INT,
    maxMarks                INT,
    lastUpdatedBy           BIGINT       NOT NULL,
    lastUpdate              TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: evaluation_sec_sequences 
--

CREATE TABLE evaluation_sec_sequences(
    id                      BIGINT         AUTO_INCREMENT,
    evalSequenceDetailId    BIGINT,
    sequenceName            VARCHAR(30),
    sequenceShortName       VARCHAR(6),
    lastUpdatedBy           BIGINT         NOT NULL,
    lastUpdate              TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: evaluation_sequence 
--

CREATE TABLE evaluation_sequence(
    id                              BIGINT          AUTO_INCREMENT,
    evalPlanLevelTwoId              BIGINT,
    evalSequenceNo                  INT             NOT NULL,
    ruleName                        VARCHAR(100)    NOT NULL,
    courseEvalSeqCriteriaRegular    VARCHAR(255)    NOT NULL,
    criteriaRuleName                VARCHAR(100)    NOT NULL,
    courseEvalSeqCriteriaRptn       VARCHAR(255)    NOT NULL,
    courseEvalWeightage             INT             NOT NULL,
    lastUpdatedBy                   BIGINT          NOT NULL,
    lastUpdate                      TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: evaluation_type_course 
--

CREATE TABLE evaluation_type_course(
    id                  BIGINT      AUTO_INCREMENT,
    evaluationPlanId    BIGINT,
    courseId            BIGINT,
    sectionId           BIGINT,
    lastUpdatedBy       BIGINT      NOT NULL,
    updateDate          DATETIME    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: evaluation_type_program 
--

CREATE TABLE evaluation_type_program(
    id                            BIGINT      AUTO_INCREMENT,
    evaluationPlanId              BIGINT,
    programBatchPeriodConfigId    BIGINT,
    sectionId                     BIGINT,
    lastUpdatedBy                 BIGINT      NOT NULL,
    lastUpdate                    DATETIME    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: exam_center 
--

CREATE TABLE exam_center(
    id                             BIGINT          AUTO_INCREMENT,
    centerType                     VARCHAR(10),
    centreCode                     VARCHAR(6)      NOT NULL,
    centerName                     VARCHAR(100),
    centerAddressId                BIGINT          NOT NULL,
    centerResponsibleId            BIGINT          NOT NULL,
    centerCapacity                 INT,
    allowAllocationBySupervisor    BIT             NOT NULL,
    noOfRooms                      INT,
    whetherRoomCapacitySame        BIT             NOT NULL,
    lastUpdatedBy                  BIGINT          NOT NULL,
    lastUpdate                     TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: exam_centre_change_req_types 
--

CREATE TABLE exam_centre_change_req_types(
    examRequestTypeDetailId    BIGINT    NOT NULL,
    currentExamBatchId         BIGINT    NOT NULL,
    expectedExamBatchId        BIGINT    NOT NULL,
    currentExamCentreId        BIGINT    NOT NULL,
    expectedExamCentreId       BIGINT    NOT NULL,
    PRIMARY KEY (examRequestTypeDetailId)
)
;



-- 
-- TABLE: exam_date_change_req_types 
--

CREATE TABLE exam_date_change_req_types(
    examRequestTypeDetailId    BIGINT       NOT NULL,
    currentExamDate            TIMESTAMP,
    expectedExamDate           TIMESTAMP,
    currentExamBatchId         BIGINT       NOT NULL,
    expectedExamBatchId        BIGINT       NOT NULL,
    PRIMARY KEY (examRequestTypeDetailId)
)
;



-- 
-- TABLE: exam_leave_req_types 
--

CREATE TABLE exam_leave_req_types(
    examRequestTypeDetailId    BIGINT       NOT NULL,
    currentExamDate            TIMESTAMP,
    currentExamCentreId        BIGINT       NOT NULL,
    PRIMARY KEY (examRequestTypeDetailId)
)
;



-- 
-- TABLE: exam_logistics 
--

CREATE TABLE exam_logistics(
    id                      BIGINT         AUTO_INCREMENT,
    evaluationPlanId        BIGINT,
    stageId                 BIGINT,
    programId               BIGINT,
    courseId                BIGINT,
    batchId                 BIGINT,
    evalSequenceId          BIGINT,
    centerType              VARCHAR(18),
    centerId                BIGINT,
    evalSequenceDetailId    BIGINT,
    logisticDate            DATE,
    timeSlot                VARCHAR(15),
    lastUpdatedBy           BIGINT         NOT NULL,
    lastUpdate              TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: exam_logistics_details 
--

CREATE TABLE exam_logistics_details(
    id                           BIGINT          AUTO_INCREMENT,
    logisticId                   BIGINT,
    evalQuestionPaper            VARCHAR(6)      NOT NULL,
    noOfQPapersIssued            INT             NOT NULL,
    noOfQuestionPaperReturned    INT,
    NoOfQuestionPapersUsed       INT,
    userId                       BIGINT,
    remark                       VARCHAR(255),
    lastUpdatedBy                BIGINT          NOT NULL,
    lastUpdate                   TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: exam_logistics_malpractice 
--

CREATE TABLE exam_logistics_malpractice(
    mgmtGroupTypeId        BIGINT          AUTO_INCREMENT,
    logisticId             BIGINT,
    admissionId            BIGINT,
    hallTicket             VARCHAR(15),
    whetherExamAttended    BIT             NOT NULL,
    questionPaperCode      VARCHAR(6),
    marpracticeReported    CHAR(1),
    malPracticeAction      VARCHAR(255),
    lastUpdatedBy          BIGINT          NOT NULL,
    lastUpdate             TIMESTAMP       NOT NULL,
    PRIMARY KEY (mgmtGroupTypeId)
)
;



-- 
-- TABLE: exam_malpractice_type 
--

CREATE TABLE exam_malpractice_type(
    mgmtGroupTypeId    BIGINT         AUTO_INCREMENT,
    malpracticeId      BIGINT,
    malPracticeType    VARCHAR(50),
    lastUpdatedBy      BIGINT         NOT NULL,
    lastUpdate         TIMESTAMP      NOT NULL,
    PRIMARY KEY (mgmtGroupTypeId)
)
;



-- 
-- TABLE: exam_paper_reval_req_types 
--

CREATE TABLE exam_paper_reval_req_types(
    examRequestTypeDetailId    BIGINT         NOT NULL,
    questionNo                 VARCHAR(20),
    questionNoPart             VARCHAR(20),
    questionNoPart1            VARCHAR(20),
    totalMarks                 INT,
    whetherCompletePaper       BIT,
    questionPaperId            BIGINT         NOT NULL,
    PRIMARY KEY (examRequestTypeDetailId)
)
;



-- 
-- TABLE: exam_related_request_details 
--

CREATE TABLE exam_related_request_details(
    detailId                   BIGINT         NOT NULL,
    examRequestStatus          VARCHAR(20),
    examRequestTypeDetailId    BIGINT         NOT NULL,
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: exam_request_type_details 
--

CREATE TABLE exam_request_type_details(
    id                 BIGINT          NOT NULL,
    whetherDeleted     BIT,
    examRequestType    VARCHAR(255),
    reason             VARCHAR(255),
    lastUpdatedBy      BIGINT          NOT NULL,
    lastUpdate         TIMESTAMP,
    courseId           BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: exam_staff_allocation 
--

CREATE TABLE exam_staff_allocation(
    id                       BIGINT         AUTO_INCREMENT,
    evaluationSeqDetailId    BIGINT,
    userId                   BIGINT,
    roleId                   BIGINT,
    centerType               VARCHAR(6),
    centerId                 BIGINT,
    allocationDate           DATE,
    timeSlots                VARCHAR(12),
    lastUpdatedBy            BIGINT         NOT NULL,
    lastUpdate               TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: exam_timeslot 
--

CREATE TABLE exam_timeslot(
    id                         BIGINT         AUTO_INCREMENT,
    stageId                    BIGINT,
    examApplicationNo          VARCHAR(10),
    groupDateBatchCenterId     BIGINT,
    evaluationPlanStudentId    BIGINT,
    applicationNo              INT,
    centerType                 VARCHAR(18),
    evaluationGroupId          BIGINT,
    centerId                   BIGINT,
    lastUpdatedBy              BIGINT         NOT NULL,
    lastUpdate                 TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: exam_timeslot_booking 
--

CREATE TABLE exam_timeslot_booking(
    id               BIGINT         AUTO_INCREMENT,
    timeSlotId       BIGINT,
    examDate         DATE,
    timeSlot         VARCHAR(15),
    courseId         BIGINT,
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: exam_withdrawal_req_types 
--

CREATE TABLE exam_withdrawal_req_types(
    examRequestTypeDetailId    BIGINT       NOT NULL,
    currentExamDate            TIMESTAMP,
    currentExamCentreId        BIGINT       NOT NULL,
    PRIMARY KEY (examRequestTypeDetailId)
)
;



-- 
-- TABLE: examination_request 
--

CREATE TABLE examination_request(
    id                    INT          NOT NULL,
    serviceRequestId      BIGINT,
    requestFollowUpId     BIGINT,
    examRequestType       INT,
    executionRequestId    BIGINT,
    lastUpdatedBy         BIGINT       NOT NULL,
    lastUpdate            TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: examination_result 
--

CREATE TABLE examination_result(
    id                            BIGINT          AUTO_INCREMENT,
    evalMode                      VARCHAR(10),
    admissionId                   BIGINT,
    courseId                      BIGINT,
    questionPaperId               BIGINT,
    examType                      VARCHAR(10),
    programBatchPeriodConfigId    BIGINT,
    evaluationStageId             BIGINT,
    evaluationDetailSequenceId    BIGINT,
    whetherRevaluation            BIT             NOT NULL,
    whetherMalpracticeReported    BIT,
    revalType                     VARCHAR(20),
    marksScored                   INT,
    gradePoints                   FLOAT,
    evaluationSeqId               BIGINT,
    grade                         VARCHAR(4),
    resultCategory                VARCHAR(10),
    programRank                   INT,
    courseRank                    INT,
    evalGroupRank                 INT,
    examinorRemark                VARCHAR(255),
    reviewerRemark                VARCHAR(255),
    lastUpdatedBy                 BIGINT          NOT NULL,
    lastUpdate                    TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: examiner_allocation 
--

CREATE TABLE examiner_allocation(
    id                     BIGINT       AUTO_INCREMENT,
    evalPlanDetailSeqId    BIGINT,
    userId                 BIGINT,
    lastUpdatedBy          BIGINT,
    lastUpdate             TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: examiner_feedback 
--

CREATE TABLE examiner_feedback(
    id                    BIGINT         AUTO_INCREMENT,
    evaluationPlanType    VARCHAR(10),
    evalTypeId            BIGINT,
    stageId               BIGINT,
    courseId              BIGINT,
    evaluationSeqId       BIGINT,
    questionPaperId       BIGINT,
    feedbackPattern       VARCHAR(15),
    userId                BIGINT,
    roleId                BIGINT,
    lastUpdatedBy         BIGINT         NOT NULL,
    lastUpdate            TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: execution_details 
--

CREATE TABLE execution_details(
    id                     BIGINT            AUTO_INCREMENT,
    whetherPartlyWaived    BIT,
    waiverAmount           DECIMAL(18, 2),
    waiverPercentage       DECIMAL(18, 2),
    whetherApproved        BIT,
    handoverModeId         BIGINT,
    executionDate          TIMESTAMP,
    whetherDeleted         BIT               NOT NULL,
    type                   VARCHAR(20)       NOT NULL,
    handoverDate           TIMESTAMP,
    lastUpdatedBy          BIGINT            NOT NULL,
    lastUpdate             TIMESTAMP         NOT NULL,
    remarks                VARCHAR(255),
    closureReason          VARCHAR(255),
    version                BIGINT            NOT NULL,
    serviceRequestId       BIGINT            NOT NULL,
    userId                 BIGINT            NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: execution_request 
--

CREATE TABLE execution_request(
    id                      BIGINT          AUTO_INCREMENT,
    userId                  BIGINT,
    requestExecutionOn      DATE,
    requestExecutionMode    INT,
    closureReason           INT,
    closureRemarks          VARCHAR(255),
    feePlanId               BIGINT,
    followupCommonId        INT,
    lastUpdatedBy           BIGINT          NOT NULL,
    lastUpdate              TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: external_resources 
--

CREATE TABLE external_resources(
    resourceId           BIGINT    NOT NULL,
    concernedPersonId    BIGINT,
    PRIMARY KEY (resourceId)
)
;



-- 
-- TABLE: extracurricular_activity 
--

CREATE TABLE extracurricular_activity(
    id                            BIGINT           AUTO_INCREMENT,
    personId                      BIGINT           NOT NULL,
    activityName                  VARCHAR(255)     NOT NULL,
    activityType                  VARCHAR(255)     NOT NULL,
    activityYear                  DECIMAL(0, 0)    NOT NULL,
    organization                  VARCHAR(255)     NOT NULL,
    performance                   VARCHAR(255)     NOT NULL,
    remarks                       VARCHAR(255)      DEFAULT NULL,
    version                       DECIMAL(0, 0)    NOT NULL,
    whetherCurrentOrganization    BIT               DEFAULT FALSE NOT NULL,
    whetherDeleted                BIT               DEFAULT FALSE NOT NULL,
    lastUpdate                    TIMESTAMP        NOT NULL,
    lastUpdatedBy                 BIGINT           NOT NULL,
    communityId                   BIGINT           NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: extracurricular_to_be_changed 
--

CREATE TABLE extracurricular_to_be_changed(
    dataToBeChangedId             BIGINT          NOT NULL,
    year                          INT,
    whetherCurrentOrganization    BIT,
    activityType                  VARCHAR(255),
    activityName                  VARCHAR(100),
    organization                  VARCHAR(255),
    performance                   VARCHAR(100),
    remarks                       VARCHAR(255),
    PRIMARY KEY (dataToBeChangedId)
)
;



-- 
-- TABLE: fac_course_account_detail 
--

CREATE TABLE fac_course_account_detail(
    id                        BIGINT         AUTO_INCREMENT,
    configControlAccountId    BIGINT,
    accountingConfigId        BIGINT,
    accountMappingBasic       VARCHAR(35),
    courseId                  BIGINT,
    controlAccount            INT,
    lastUpdatedBy             BIGINT,
    lastUpdate                TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fac_course_comp_acc_detail 
--

CREATE TABLE fac_course_comp_acc_detail(
    id                        BIGINT         AUTO_INCREMENT,
    configControlAccountId    BIGINT,
    accountingConfigId        BIGINT,
    courseComponentId         BIGINT,
    accountMappingBasic       VARCHAR(35),
    controlAccount            INT,
    lastUpdatedBy             BIGINT,
    lastUpdate                TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fac_data_change_request 
--

CREATE TABLE fac_data_change_request(
    id                           BIGINT          AUTO_INCREMENT,
    approvedBy                   BIGINT,
    facultyId                    BIGINT          NOT NULL,
    requestDate                  DATE,
    dataGrouptoChange            VARCHAR(2),
    remark                       VARCHAR(255),
    closedOn                     DATE,
    closureReason                VARCHAR(3),
    changeDays                   TINYINT,
    changeDescriptions           VARCHAR(255),
    changeStatusActive           BIT             NOT NULL,
    changeDocumentsProofReqd     BIT             NOT NULL,
    changeDocumentsProofGiven    BIT             NOT NULL,
    changeDocuments              VARCHAR(40),
    lastUpdatedBy                BIGINT          NOT NULL,
    lastUpdate                   TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    personId                     BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fac_default_control_account 
--

CREATE TABLE fac_default_control_account(
    id                     BIGINT         AUTO_INCREMENT,
    facultyAccountId       BIGINT,
    accountMappingBasic    VARCHAR(35),
    facultyType            VARCHAR(2),
    courseId               BIGINT,
    courseComponentId      BIGINT,
    controlAccount         INT,
    lastUpdatedBy          BIGINT         NOT NULL,
    lastUpdate             TIMESTAMP      NOT NULL,
    facultyId              BIGINT         NOT NULL,
    personId               BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fac_perform_param 
--

CREATE TABLE fac_perform_param(
    id                BIGINT          AUTO_INCREMENT,
    parameterName     VARCHAR(100),
    parameterValue    VARCHAR(30)     NOT NULL,
    lastUpdatedBy     BIGINT          NOT NULL,
    lastUpdate        TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fac_type_account_details 
--

CREATE TABLE fac_type_account_details(
    id                        BIGINT         AUTO_INCREMENT,
    configControlAccountId    BIGINT,
    accountingConfigId        BIGINT,
    facultyType               VARCHAR(10),
    lastUpdatedBy             BIGINT,
    lastUpdate                TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: faculties 
--

CREATE TABLE faculties(
    personId             BIGINT           NOT NULL,
    userId               BIGINT           NOT NULL,
    departmentId         BIGINT           NOT NULL,
    subDepartmentId      BIGINT           NOT NULL,
    facultyCode          VARCHAR(255)     NOT NULL,
    designation          VARCHAR(255)     NOT NULL,
    facultyType          VARCHAR(20)      NOT NULL,
    joiningDate          DATE             NOT NULL,
    exitDate             DATE              DEFAULT NULL,
    yearsOfExperience    DECIMAL(0, 0)    NOT NULL,
    PRIMARY KEY (personId)
)
;



-- 
-- TABLE: faculty_account 
--

CREATE TABLE faculty_account(
    id                              BIGINT       AUTO_INCREMENT,
    accountconfigId                 BIGINT,
    iauId                           BIGINT,
    individualControlAccountFlag    BIT          NOT NULL,
    lastUpdatedBy                   BIGINT       NOT NULL,
    lastUpdate                      TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: faculty_cheques 
--

CREATE TABLE faculty_cheques(
    id               BIGINT          AUTO_INCREMENT,
    checkDate        DATE,
    drawnOn          VARCHAR(100),
    installmentNo    INT,
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    facultyId        BIGINT,
    personId         BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: faculty_docs 
--

CREATE TABLE faculty_docs(
    id                           BIGINT         AUTO_INCREMENT,
    facultyId                    BIGINT         NOT NULL,
    inspectedBy                  BIGINT,
    docReturnedBy                BIGINT,
    docReturnedTo                BIGINT,
    documentName                 VARCHAR(6),
    documentSubmissionDate       DATE,
    imageFileLocation            VARCHAR(35)    NOT NULL,
    whetherElectronicDocument    BIT            NOT NULL,
    whetherInspectionRequired    BIT            NOT NULL,
    withEmployee                 VARCHAR(6),
    inspectionDate               DATE,
    whetherDocumentReturnable    BIT            NOT NULL,
    documentReturnedDate         DATE,
    lastUpdatedBy                BIGINT         NOT NULL,
    lastUpdate                   TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    personId                     BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: faculty_fee_plan 
--

CREATE TABLE faculty_fee_plan(
    id               BIGINT         AUTO_INCREMENT,
    planName         VARCHAR(50),
    lastUpdate       TIMESTAMP      NOT NULL,
    lastUpdatedBy    BIGINT         NOT NULL,
    version          BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: faculty_feedback 
--

CREATE TABLE faculty_feedback(
    id                 BIGINT         AUTO_INCREMENT,
    courseId           BIGINT,
    facultyId          BIGINT         NOT NULL,
    feedbackType       VARCHAR(10),
    feedbackGivenBy    VARCHAR(10),
    feedbackGivenTo    CHAR(10),
    feedbackStatus     BIT,
    completionDate     DATE           NOT NULL,
    lastUpdate         TIMESTAMP,
    lastUpdatedBy      BIGINT         NOT NULL,
    personId           BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: faculty_feedback_details 
--

CREATE TABLE faculty_feedback_details(
    id                 BIGINT       AUTO_INCREMENT,
    questionnaireId    BIGINT,
    feedbackId         BIGINT,
    lastUpdatedBy      BIGINT       NOT NULL,
    lastUpdate         TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: faculty_payment_settings 
--

CREATE TABLE faculty_payment_settings(
    id               BIGINT         AUTO_INCREMENT,
    facultyId        BIGINT         NOT NULL,
    courseId         BIGINT,
    academicYear     INT,
    paymentBasic     VARCHAR(15),
    rate             INT,
    billDate         DATE,
    dueDate          DATE,
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    personId         BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: faculty_performance 
--

CREATE TABLE faculty_performance(
    id                    BIGINT       AUTO_INCREMENT,
    performanceParamId    BIGINT,
    facultyId             BIGINT       NOT NULL,
    assessmentYear        CHAR(10),
    assessmentStatus      CHAR(10),
    lastUpdatedBy         BIGINT       NOT NULL,
    lastUpdate            TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    personId              BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: faculty_program 
--

CREATE TABLE faculty_program(
    id                            BIGINT       AUTO_INCREMENT,
    facultyId                     BIGINT,
    courseId                      BIGINT       NOT NULL,
    courseComponentId             BIGINT,
    sectionId                     BIGINT,
    courseTopicId                 BIGINT,
    programBatchPeriodConfigId    BIGINT,
    lastUpdatedBy                 BIGINT       NOT NULL,
    lastUpdate                    TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    alternateFacultyId            BIGINT,
    personId                      BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: faculty_topic_assignment 
--

CREATE TABLE faculty_topic_assignment(
    id                         BIGINT       AUTO_INCREMENT,
    sectionId                  BIGINT,
    topicId                    BIGINT,
    courseVariantId            BIGINT,
    alternateFacultyId         BIGINT       NOT NULL,
    whetherAlternateFaculty    BIT          NOT NULL,
    lastUpdatedBy              BIGINT       NOT NULL,
    lastUpdate                 TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    personId                   BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: faculty_topic_assignment_1 
--

CREATE TABLE faculty_topic_assignment_1(
    id                         BIGINT       AUTO_INCREMENT,
    sectionId                  BIGINT,
    topicId                    BIGINT,
    courseVariantId            BIGINT,
    alternateFacultyId         BIGINT       NOT NULL,
    whetherAlternateFaculty    BIT          NOT NULL,
    lastUpdatedBy              BIGINT       NOT NULL,
    lastUpdate                 TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    personId                   BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: feature 
--

CREATE TABLE feature(
    id                BIGINT          AUTO_INCREMENT,
    displayCode       VARCHAR(150)    NOT NULL,
    code              VARCHAR(100)    NOT NULL,
    featureName       VARCHAR(200)    NOT NULL,
    systemModuleId    BIGINT          NOT NULL,
    lastUpdatedBy     BIGINT          NOT NULL,
    lastUpdate        TIMESTAMP       NOT NULL,
    version           BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: feature_privilege 
--

CREATE TABLE feature_privilege(
    id               BIGINT       AUTO_INCREMENT,
    privilegeId      BIGINT       NOT NULL,
    featureId        BIGINT       NOT NULL,
    lastUpdatedBy    BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP    NOT NULL,
    version          BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_config_modes 
--

CREATE TABLE fee_config_modes(
    id                      BIGINT         AUTO_INCREMENT,
    feeStageHeadConfigId    BIGINT,
    paymentMode             VARCHAR(35),
    whetherRefundMode       BIT            NOT NULL,
    lastUpdatedBy           BIGINT         NOT NULL,
    lastUpdate              TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_details 
--

CREATE TABLE fee_details(
    id                  BIGINT       AUTO_INCREMENT,
    whetherDeleted      BIT          NOT NULL,
    lastUpdatedBy       BIGINT       NOT NULL,
    lastUpdate          TIMESTAMP    NOT NULL,
    version             BIGINT       NOT NULL,
    serviceRequestId    BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_discount 
--

CREATE TABLE fee_discount(
    id                            BIGINT          AUTO_INCREMENT,
    whetherDiscountAvailable      BIT             NOT NULL,
    feeStageHeadConfigId          BIGINT,
    whetherPercentageDiscount     BIT             NOT NULL,
    percentAmount                 VARCHAR(6),
    discountRule                  VARCHAR(50),
    rule                          VARCHAR(100),
    whetherFixedAmountDiscount    BIT             NOT NULL,
    fixedAmount                   INT,
    whetherAdhoc                  BIT             NOT NULL,
    lastUpdatedBy                 BIGINT          NOT NULL,
    lastUpdate                    TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_heads 
--

CREATE TABLE fee_heads(
    id               BIGINT         AUTO_INCREMENT,
    feeHeadName      VARCHAR(35),
    feeHeadStatus    BIT            NOT NULL,
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_notifications 
--

CREATE TABLE fee_notifications(
    id                  BIGINT        AUTO_INCREMENT,
    feePlanId           BIGINT,
    notificationType    VARCHAR(4),
    templateId          INT,
    lastUpdatedBy       BIGINT        NOT NULL,
    lastUpdate          TIMESTAMP     NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_plan 
--

CREATE TABLE fee_plan(
    id               BIGINT         AUTO_INCREMENT,
    feePlanName      VARCHAR(35),
    feePlanType      INT,
    currencyId       BIGINT,
    feePlanStatus    CHAR(1),
    validTill        DATE,
    approver         BIGINT,
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_plan_acad_locations 
--

CREATE TABLE fee_plan_acad_locations(
    id                       BIGINT       AUTO_INCREMENT,
    feePlanId                BIGINT,
    progBatchSeatConfigId    BIGINT,
    academyLocationId        BIGINT,
    lastUpdatedBy            BIGINT       NOT NULL,
    lastUpdate               TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_plan_rule_stage 
--

CREATE TABLE fee_plan_rule_stage(
    id                            BIGINT       AUTO_INCREMENT,
    stageId                       BIGINT,
    feePlanId                     BIGINT,
    feePlanRuleId                 BIGINT,
    status                        CHAR(1),
    whetherMultiPaymentAllowed    BIT          NOT NULL,
    lastUpdatedBy                 BIGINT       NOT NULL,
    lastUpdate                    TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_plan_rules 
--

CREATE TABLE fee_plan_rules(
    id               BIGINT          AUTO_INCREMENT,
    feePlanId        BIGINT,
    feeRuleName      VARCHAR(35),
    feeRuleDesc      VARCHAR(255),
    rule             VARCHAR(35),
    status           CHAR(1),
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       DATETIME        NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_plan_submission_sch 
--

CREATE TABLE fee_plan_submission_sch(
    id                      BIGINT         AUTO_INCREMENT,
    feeStageHeadConfigId    BIGINT,
    installmentType         VARCHAR(35),
    installmentName         VARCHAR(35),
    billDay                 INT,
    billMonth               VARCHAR(10),
    dueDay                  INT,
    dueMonth                VARCHAR(10),
    amount                  INT,
    lastUpdatedBy           BIGINT         NOT NULL,
    lastUpdate              TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_refund_modes 
--

CREATE TABLE fee_refund_modes(
    id                      BIGINT         AUTO_INCREMENT,
    feeStageHeadConfigId    BIGINT,
    modeName                VARCHAR(10),
    lastUpdatedBy           BIGINT         NOT NULL,
    lastUpdate              TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_refunds 
--

CREATE TABLE fee_refunds(
    id                 BIGINT          AUTO_INCREMENT,
    feeConfigId        BIGINT,
    feeRefundModeId    BIGINT,
    refund             VARCHAR(35),
    refundRules        VARCHAR(255),
    natureOfRefund     VARCHAR(35),
    lastUpdatedBy      BIGINT          NOT NULL,
    lastUpdate         TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_related_request_details 
--

CREATE TABLE fee_related_request_details(
    detailId    BIGINT          NOT NULL,
    dueDate     TIMESTAMP,
    remark      VARCHAR(255),
    category    VARCHAR(20),
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: fee_request 
--

CREATE TABLE fee_request(
    id               BIGINT           AUTO_INCREMENT,
    feePlanId        BIGINT,
    stageId          BIGINT,
    feeHeadId        BIGINT,
    personId         DECIMAL(0, 0)    NOT NULL,
    studentId        BIGINT           NOT NULL,
    feeAmount        INT,
    dueDate          DATE,
    requestType      VARCHAR(10),
    waiverAmount     INT,
    waiverPercent    VARCHAR(6),
    requestReason    VARCHAR(1000),
    lastUpdatedBy    BIGINT           NOT NULL,
    lastUpdate       TIMESTAMP         DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_rule_documents 
--

CREATE TABLE fee_rule_documents(
    id               BIGINT       AUTO_INCREMENT,
    feeRuleId        BIGINT,
    documentId       BIGINT,
    lastUpdatedBy    BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_sch_details 
--

CREATE TABLE fee_sch_details(
    id                      BIGINT         AUTO_INCREMENT,
    feeScheduleStudentId    BIGINT,
    installmentType         VARCHAR(35),
    installmentName         VARCHAR(35),
    billDay                 INT,
    dueDay                  INT,
    amount                  INT,
    lastUpdatedBy           BIGINT         NOT NULL,
    lastUpdate              TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_schedule_student 
--

CREATE TABLE fee_schedule_student(
    id                    BIGINT           AUTO_INCREMENT,
    feeSubmissionSchId    BIGINT,
    personId              DECIMAL(0, 0)    NOT NULL,
    studentId             BIGINT           NOT NULL,
    lastUpdatedBy         BIGINT,
    lastUpdate            TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fee_stage_head_config 
--

CREATE TABLE fee_stage_head_config(
    id                         BIGINT          AUTO_INCREMENT,
    feePlanRuleStageId         BIGINT,
    feeStageId                 BIGINT,
    feeHeadId                  BIGINT,
    iauId                      BIGINT,
    feeAmount                  INT,
    whetherSplitPayment        BIT             NOT NULL,
    paymentPeriod              VARCHAR(35),
    whetherInstallPostDated    BIT             NOT NULL,
    remark                     VARCHAR(255),
    feeManageId                BIGINT,
    lastUpdate                 TIMESTAMP       NOT NULL,
    lastUpdatedBy              BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: feedback_questions 
--

CREATE TABLE feedback_questions(
    id                BIGINT          AUTO_INCREMENT,
    feedBackId        BIGINT,
    questionId        BIGINT,
    feedback          VARCHAR(255),
    feedbackStatus    BIT,
    lastUpdatedBy     BIGINT          NOT NULL,
    lastUpdate        TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: fine_request_details 
--

CREATE TABLE fine_request_details(
    detailId           BIGINT            NOT NULL,
    recommendedFine    DECIMAL(18, 2),
    feeHeadId          BIGINT            NOT NULL,
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: followup_details 
--

CREATE TABLE followup_details(
    id                     BIGINT          AUTO_INCREMENT,
    plannedFollowupDate    TIMESTAMP,
    actualFollowupDate     TIMESTAMP,
    whetherDeleted         BIT             NOT NULL,
    lastUpdatedBy          BIGINT          NOT NULL,
    lastUpdate             TIMESTAMP       NOT NULL,
    remarks                VARCHAR(255),
    nextFollowupDate       TIMESTAMP,
    documentProofStatus    VARCHAR(20),
    version                BIGINT          NOT NULL,
    serviceRequestId       BIGINT          NOT NULL,
    userId                 BIGINT          NOT NULL,
    approverUserId         BIGINT,
    assigneeUserId         BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: free_form_request_categories 
--

CREATE TABLE free_form_request_categories(
    id               BIGINT          NOT NULL,
    itemCode         VARCHAR(255),
    itemValue        VARCHAR(255),
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: free_form_request_details 
--

CREATE TABLE free_form_request_details(
    detailId    BIGINT         NOT NULL,
    status      VARCHAR(20),
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: free_form_request_types 
--

CREATE TABLE free_form_request_types(
    requestTypeId    BIGINT    NOT NULL,
    categoryId       BIGINT    NOT NULL,
    PRIMARY KEY (requestTypeId)
)
;



-- 
-- TABLE: free_format_request 
--

CREATE TABLE free_format_request(
    id                    BIGINT         AUTO_INCREMENT,
    serviceRequestId      BIGINT,
    requestType           VARCHAR(12),
    requestFollowUpId     BIGINT,
    requestDetails        VARCHAR(35),
    executionRequestId    BIGINT,
    lastUpdatedBy         BIGINT         NOT NULL,
    lastUpdate            TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: grade 
--

CREATE TABLE grade(
    id                BIGINT        AUTO_INCREMENT,
    gradeType         VARCHAR(5),
    gradeName         VARCHAR(6),
    gradeRangeFrom    FLOAT,
    gradeRangeTo      FLOAT,
    hasGroup          BIT,
    maxPercent        INT,
    minPercent        INT,
    gradeStatus       VARCHAR(5),
    lastUpdatedBy     BIGINT        NOT NULL,
    lastUpdate        TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: grade_distribution_details 
--

CREATE TABLE grade_distribution_details(
    id                  BIGINT       AUTO_INCREMENT,
    distributionId      BIGINT,
    gradeId             BIGINT,
    percentFrom         INT,
    percentTo           INT,
    percentTotalFrom    INT,
    percentTotalTo      INT,
    entryDate           DATE,
    enteredBy           BIGINT,
    lastUpdatedBy       BIGINT       NOT NULL,
    lastUpdate          TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: grade_group 
--

CREATE TABLE grade_group(
    id               BIGINT         AUTO_INCREMENT,
    groupName        VARCHAR(10),
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: grades_group 
--

CREATE TABLE grades_group(
    id               BIGINT       AUTO_INCREMENT,
    gradeId          BIGINT,
    gradeGroupId     BIGINT,
    lastUpdatedBy    BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: group_batch_seat_type 
--

CREATE TABLE group_batch_seat_type(
    id                        BIGINT       AUTO_INCREMENT,
    groupDateBatchCenterId    BIGINT,
    progBatchSeatConfigId     BIGINT,
    lastUpdatedBy             BIGINT,
    lastUpdate                TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: group_date_batch_center 
--

CREATE TABLE group_date_batch_center(
    id                      BIGINT       AUTO_INCREMENT,
    evalGroupSchDateId      BIGINT,
    evalGroupSchBatchId     INT,
    evalGroupSchCenterId    BIGINT,
    lastUpdatedBy           BIGINT,
    lastUpdate              TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: group_hw_assignment 
--

CREATE TABLE group_hw_assignment(
    id                BIGINT           AUTO_INCREMENT,
    hwAssignmentId    BIGINT,
    personId          DECIMAL(0, 0)    NOT NULL,
    studentId         BIGINT           NOT NULL,
    readingName       VARCHAR(255),
    markesGrade       VARCHAR(3),
    lastUpdatedBy     BIGINT           NOT NULL,
    lastUpdate        TIMESTAMP        NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: group_schedule_batch 
--

CREATE TABLE group_schedule_batch(
    id                      INT            AUTO_INCREMENT,
    evaluationGroupId       BIGINT,
    evalSequenceDetailId    BIGINT,
    timeSlot                VARCHAR(18),
    lastUpdatedBy           BIGINT,
    lastUpdate              TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: guestfaculty_sessions 
--

CREATE TABLE guestfaculty_sessions(
    id                       INT            AUTO_INCREMENT,
    userId                   INT            NOT NULL,
    facultyId                BIGINT         NOT NULL,
    courseVarientId          BIGINT,
    feeType                  CHAR(1),
    sessionDate              DATE,
    sessionDateSlot          TINYINT,
    sessionAmount            INT,
    sessionAmountCurrency    VARCHAR(10),
    voucherRef               VARCHAR(10),
    payVoucherRef            VARCHAR(10),
    lastUpdatedBy            BIGINT,
    lastUpdate               TIMESTAMP      NOT NULL,
    personId                 BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: hod_history 
--

CREATE TABLE hod_history(
    id               BIGINT       AUTO_INCREMENT,
    departmentId     BIGINT,
    hod              BIGINT,
    fromDate         DATE,
    tillDate         DATE,
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: iau_accounting 
--

CREATE TABLE iau_accounting(
    id                 BIGINT         AUTO_INCREMENT,
    accountConfigId    BIGINT,
    iauId              BIGINT,
    startDate          DATE,
    tillDate           DATE,
    companyCode        VARCHAR(10),
    lastUpdatedBy      BIGINT         NOT NULL,
    lastUpdate         TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: id_definition 
--

CREATE TABLE id_definition(
    id                   BIGINT         AUTO_INCREMENT,
    idEntitySettingId    BIGINT,
    idFormatType         VARCHAR(20),
    whetherManualId      TINYINT,
    whetherDefaultID     TINYINT,
    lastUpdatedBy        BIGINT         NOT NULL,
    lastUpdate           TIME           NOT NULL,
    version              BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: id_entity_setting 
--

CREATE TABLE id_entity_setting(
    id                       BIGINT          AUTO_INCREMENT,
    searchTableId            BIGINT          NOT NULL,
    dynanicFieldAvailable    BIT              DEFAULT true NOT NULL,
    searchTableColumnId      BIGINT,
    searchConfigCode         VARCHAR(100),
    lastUpdatedBy            BIGINT          NOT NULL,
    lastUpdate               TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: id_format 
--

CREATE TABLE id_format(
    id                BIGINT    AUTO_INCREMENT,
    idDefinitionId    BIGINT    NOT NULL,
    seqNo             INT,
    lastUpdatedBy     BIGINT    NOT NULL,
    lastUpdate        TIME      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: id_format_alphanumeric 
--

CREATE TABLE id_format_alphanumeric(
    id           BIGINT         NOT NULL,
    prefix       VARCHAR(20),
    suffix       VARCHAR(20),
    startFrom    BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: id_format_counter_mapping 
--

CREATE TABLE id_format_counter_mapping(
    id                 BIGINT          AUTO_INCREMENT,
    idCounterPrefix    VARCHAR(255),
    currentCounter     BIGINT,
    idDefinition       BIGINT          NOT NULL,
    lastUpdatedBy      BIGINT          NOT NULL,
    lastUpdate         TIME            NOT NULL,
    version            BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: id_format_dynamic 
--

CREATE TABLE id_format_dynamic(
    id           BIGINT          NOT NULL,
    resultKey    VARCHAR(255),
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: id_format_running_no 
--

CREATE TABLE id_format_running_no(
    id           BIGINT    NOT NULL,
    startFrom    BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: incident_types 
--

CREATE TABLE incident_types(
    id               BIGINT          AUTO_INCREMENT,
    itemCode         VARCHAR(255)    NOT NULL,
    itemValue        VARCHAR(255)    NOT NULL,
    lastUpdate       TIMESTAMP       NOT NULL,
    lastUpdatedBy    BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: incidents 
--

CREATE TABLE incidents(
    id                BIGINT           AUTO_INCREMENT,
    personId          BIGINT           NOT NULL,
    incidentTypeId    BIGINT           NOT NULL,
    reportedBy        BIGINT           NOT NULL,
    category          VARCHAR(20)      NOT NULL,
    honourName        VARCHAR(255)     NOT NULL,
    incidentDate      DATE             NOT NULL,
    actionTaken       VARCHAR(255)     NOT NULL,
    remarks           VARCHAR(255)      DEFAULT NULL,
    whetherDeleted    BIT               DEFAULT FALSE NOT NULL,
    version           DECIMAL(0, 0)    NOT NULL,
    lastUpdate        TIMESTAMP        NOT NULL,
    lastUpdatedBy     BIGINT           NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: income_slabs 
--

CREATE TABLE income_slabs(
    id               BIGINT         AUTO_INCREMENT,
    incomeType       VARCHAR(10),
    incomeSlab       VARCHAR(10),
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: individual_hw_assignment 
--

CREATE TABLE individual_hw_assignment(
    id                BIGINT           AUTO_INCREMENT,
    hwAssignmentId    BIGINT,
    personId          DECIMAL(0, 0)    NOT NULL,
    studentId         BIGINT           NOT NULL,
    lastUpdatedBy     BIGINT           NOT NULL,
    lastUpdate        TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: individual_hw_download 
--

CREATE TABLE individual_hw_download(
    id                          BIGINT          AUTO_INCREMENT,
    individualHwAssignmentId    BIGINT,
    hwFile                      VARCHAR(100),
    lastUpdatedBy               BIGINT,
    lastUpdate                  TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: individual_hw_upload 
--

CREATE TABLE individual_hw_upload(
    id                          BIGINT          AUTO_INCREMENT,
    individualHwAssignmentId    BIGINT,
    hwFile                      VARCHAR(100),
    lastUpdatedBy               BIGINT,
    lastUpdate                  TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: installment_details 
--

CREATE TABLE installment_details(
    id                              BIGINT            AUTO_INCREMENT,
    lastUpdatedBy                   BIGINT            NOT NULL,
    whetherDeleted                  BIT,
    amount                          DECIMAL(18, 2),
    installmentDate                 TIMESTAMP,
    lastUpdate                      TIMESTAMP         NOT NULL,
    installmentExecutionDetailId    BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: internal_resources 
--

CREATE TABLE internal_resources(
    resourceId                   BIGINT    NOT NULL,
    resourceAcademyLocationId    BIGINT,
    calendarId                   BIGINT,
    childResourceId              BIGINT,
    parentResourceId             BIGINT,
    hasSharedAcadLoc             BIT       NOT NULL,
    whetherBookingAllowed        BIT        DEFAULT 1 NOT NULL,
    PRIMARY KEY (resourceId)
)
;



-- 
-- TABLE: kys_data 
--

CREATE TABLE kys_data(
    id                    BIGINT           NOT NULL,
    studentId             DECIMAL(0, 0)     DEFAULT NULL,
    daysOverdue           DECIMAL(0, 0)     DEFAULT NULL,
    submissionDate        DATETIME          DEFAULT NULL,
    lastSubmissionDate    DATETIME          DEFAULT NULL,
    status                VARCHAR(20)       DEFAULT NULL,
    whetherDeleted        BIT               DEFAULT FALSE NOT NULL,
    lastUpdate            TIMESTAMP        NOT NULL,
    lastUpdatedBy         BIGINT           NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: lack_of_attendance_req_types 
--

CREATE TABLE lack_of_attendance_req_types(
    examRequestTypeDetailId    BIGINT    NOT NULL,
    PRIMARY KEY (examRequestTypeDetailId)
)
;



-- 
-- TABLE: lack_of_other_crit_req_types 
--

CREATE TABLE lack_of_other_crit_req_types(
    examRequestTypeDetailId    BIGINT          NOT NULL,
    approvalSoughtFor          VARCHAR(255),
    PRIMARY KEY (examRequestTypeDetailId)
)
;



-- 
-- TABLE: late_fee 
--

CREATE TABLE late_fee(
    id                  BIGINT       AUTO_INCREMENT,
    feeStageConfigId    BIGINT,
    lateFeeAmount       INT,
    lateFeeDate         DATE,
    lastUpdatedBy       BIGINT       NOT NULL,
    lastUpdate          TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: leave_request 
--

CREATE TABLE leave_request(
    id                    BIGINT       AUTO_INCREMENT,
    requestId             BIGINT,
    requestFrom           DATE,
    requestFollowUpId     BIGINT,
    requestTo             DATE,
    executionRequestId    BIGINT,
    serviceRequestId      BIGINT,
    lastUpdatedBy         BIGINT       NOT NULL,
    lastUpdate            TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: leave_request_details 
--

CREATE TABLE leave_request_details(
    detailId    BIGINT          NOT NULL,
    fromDate    TIMESTAMP,
    toDate      TIMESTAMP,
    reason      VARCHAR(255),
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: leave_transaction 
--

CREATE TABLE leave_transaction(
    id               BIGINT         AUTO_INCREMENT,
    admissionId      BIGINT,
    programId        BIGINT,
    sectionId        BIGINT,
    leaveType        VARCHAR(10),
    noOfDays         INT,
    reason           VARCHAR(20),
    status           VARCHAR(10),
    approvalDate     TIMESTAMP,
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP,
    facultyId        BIGINT         NOT NULL,
    personId         BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: leave_transaction_details 
--

CREATE TABLE leave_transaction_details(
    id               BIGINT         AUTO_INCREMENT,
    transactionId    BIGINT,
    leaveDate        DATE,
    fromTime         VARCHAR(10),
    toTime           VARCHAR(10),
    status           VARCHAR(10),
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: location_addresses 
--

CREATE TABLE location_addresses(
    id               BIGINT       AUTO_INCREMENT,
    addressId        BIGINT,
    locationId       BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP    NOT NULL,
    lastUpdatedBy    BIGINT,
    version          BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: locations 
--

CREATE TABLE locations(
    id                BIGINT          AUTO_INCREMENT,
    organizationId    BIGINT          NOT NULL,
    shortCode         VARCHAR(10)     NOT NULL,
    locationName      VARCHAR(255)    NOT NULL,
    startDate         DATE            NOT NULL,
    tillDate          DATE,
    status            BIT             NOT NULL,
    lastUpdate        TIMESTAMP       NOT NULL,
    lastUpdatedBy     BIGINT,
    version           BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: media 
--

CREATE TABLE media(
    id               BIGINT         AUTO_INCREMENT,
    code             VARCHAR(3),
    mediaName        VARCHAR(35),
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: medical_data_to_be_changed 
--

CREATE TABLE medical_data_to_be_changed(
    dataToBeChangedId    BIGINT          NOT NULL,
    medicalCondition     VARCHAR(255),
    dateSince            TIMESTAMP,
    consultingDoctor     VARCHAR(255),
    remarks              VARCHAR(255),
    PRIMARY KEY (dataToBeChangedId)
)
;



-- 
-- TABLE: medical_history 
--

CREATE TABLE medical_history(
    id                  BIGINT           AUTO_INCREMENT,
    personId            BIGINT           NOT NULL,
    medicalCondition    VARCHAR(255)     NOT NULL,
    dateSince           DATE             NOT NULL,
    consultingDoctor    VARCHAR(255)     NOT NULL,
    remarks             VARCHAR(255)      DEFAULT NULL,
    whetherDeleted      BIT               DEFAULT FALSE NOT NULL,
    version             DECIMAL(0, 0)    NOT NULL,
    lastUpdate          TIMESTAMP        NOT NULL,
    lastUpdatedBy       BIGINT           NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: module_usage 
--

CREATE TABLE module_usage(
    id               BIGINT         AUTO_INCREMENT,
    userId           BIGINT         NOT NULL,
    moduleId         BIGINT,
    menuOption       VARCHAR(35),
    timeOfUsage      TIME,
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: nationalities 
--

CREATE TABLE nationalities(
    id               BIGINT          AUTO_INCREMENT,
    itemCode         VARCHAR(255)    NOT NULL,
    itemValue        VARCHAR(255)    NOT NULL,
    lastUpdate       TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    lastUpdatedBy    BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: occupation 
--

CREATE TABLE occupation(
    id                BIGINT         AUTO_INCREMENT,
    occupationName    VARCHAR(20),
    lastUpdatedBy     BIGINT,
    lastUpdate        TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: organization_addresses 
--

CREATE TABLE organization_addresses(
    id                BIGINT       AUTO_INCREMENT,
    version           BIGINT       NOT NULL,
    addressId         BIGINT,
    organizationId    BIGINT,
    lastUpdate        TIMESTAMP    NOT NULL,
    lastUpdatedBy     BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: organization_cf_data 
--

CREATE TABLE organization_cf_data(
    id                       BIGINT          AUTO_INCREMENT,
    organizationId           BIGINT          NOT NULL,
    entityFieldMetaDataId    BIGINT          NOT NULL,
    data                     VARCHAR(255)    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: organization_settings 
--

CREATE TABLE organization_settings(
    id                 BIGINT         AUTO_INCREMENT,
    organizationId     BIGINT,
    entitySettingId    BIGINT         NOT NULL,
    orgSettingvalue    VARCHAR(25)    NOT NULL,
    lastUpdate         TIMESTAMP      NOT NULL,
    lastUpdatedBy      BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: organization_supervisory_units 
--

CREATE TABLE organization_supervisory_units(
    id                        BIGINT          AUTO_INCREMENT,
    unitName                  VARCHAR(60),
    shortCode                 VARCHAR(15),
    status                    BIT             NOT NULL,
    organizationUnitTypeId    BIGINT,
    organizationId            BIGINT,
    note                      VARCHAR(255),
    structureTypeCode         VARCHAR(10)     NOT NULL,
    lastUpdate                TIMESTAMP       NOT NULL,
    lastUpdatedBy             BIGINT          NOT NULL,
    version                   BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: organization_unit_alps 
--

CREATE TABLE organization_unit_alps(
    id                           BIGINT       AUTO_INCREMENT,
    academyLocationPuirposeId    BIGINT       NOT NULL,
    organizationUnitId           BIGINT       NOT NULL,
    startDate                    DATE         NOT NULL,
    tillDate                     DATE,
    lastUpdate                   TIMESTAMP    NOT NULL,
    version                      BIGINT,
    lastUpdatedBy                BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: organization_unit_settings 
--

CREATE TABLE organization_unit_settings(
    id                    BIGINT         AUTO_INCREMENT,
    version               BIGINT         NOT NULL,
    entitySettingId       BIGINT         NOT NULL,
    organizationUnitId    BIGINT,
    unitSettingValue      VARCHAR(50)    NOT NULL,
    lastUpdate            TIMESTAMP      NOT NULL,
    lastUpdatedBy         BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: organization_unit_types 
--

CREATE TABLE organization_unit_types(
    id               BIGINT          AUTO_INCREMENT,
    version          BIGINT          NOT NULL,
    typeName         VARCHAR(255)    NOT NULL,
    description      VARCHAR(255)    NOT NULL,
    lastUpdate       TIMESTAMP       NOT NULL,
    lastUpdatedBy    BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: organization_units 
--

CREATE TABLE organization_units(
    id                               BIGINT          AUTO_INCREMENT,
    ownerId                          BIGINT          NOT NULL,
    lastUpdatedBy                    BIGINT,
    organizationSupervisoryUnitId    BIGINT,
    currencyId                       BIGINT,
    parentOrganizationUnitId         BIGINT,
    code                             VARCHAR(20)     NOT NULL,
    version                          BIGINT          NOT NULL,
    unitName                         VARCHAR(255)    NOT NULL,
    startDate                        DATE            NOT NULL,
    tillDate                         DATE,
    Status                           BIT             NOT NULL,
    lastUpdate                       TIMESTAMP       NOT NULL,
    addressTypeId                    BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: organizations 
--

CREATE TABLE organizations(
    id               BIGINT          AUTO_INCREMENT,
    currencyId       BIGINT,
    typeCode         VARCHAR(15)     NOT NULL,
    orgName          VARCHAR(255)    NOT NULL,
    archiveDBPath    VARCHAR(255)    NOT NULL,
    version          BIGINT,
    activeDBPath     VARCHAR(255)    NOT NULL,
    lastUpdate       TIMESTAMP       NOT NULL,
    lastUpdatedBy    BIGINT,
    calendarId       BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: password_policy_notifiy 
--

CREATE TABLE password_policy_notifiy(
    id                      BIGINT       AUTO_INCREMENT,
    modeId                  INT,
    passwordPolicyId        BIGINT,
    sendNotificationDays    INT,
    lastUpdatedBy           BIGINT,
    lastUpdate              TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: pay_bill_fee_plan_stg 
--

CREATE TABLE pay_bill_fee_plan_stg(
    id                      BIGINT         AUTO_INCREMENT,
    billId                  BIGINT,
    instrumentNo            VARCHAR(20),
    feeStageHeadConfigId    BIGINT,
    lastUpdatedBy           BIGINT,
    lastUpdate              TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: payment_adjust_refund 
--

CREATE TABLE payment_adjust_refund(
    id                         BIGINT       AUTO_INCREMENT,
    paymentModeInstrumentId    BIGINT,
    payBillFeePlanStgId        BIGINT,
    billFacultyPaymentId       BIGINT,
    adjustmentAmount           FLOAT,
    adjustmentDate             DATE,
    lastUpdatedBy              BIGINT,
    lastUpdate                 TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: payment_header 
--

CREATE TABLE payment_header(
    id                     BIGINT         AUTO_INCREMENT,
    billId                 BIGINT,
    voucherType            VARCHAR(12),
    transactionDate        DATE,
    tallyVoucherId         INT            NOT NULL,
    integratedWithTally    BIT            NOT NULL,
    toBeDeleted            BIT            NOT NULL,
    lastUpdatedBy          BIGINT,
    lastUpdate             TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: payment_mode_instrument 
--

CREATE TABLE payment_mode_instrument(
    id                 BIGINT         AUTO_INCREMENT,
    paymentHeaderId    BIGINT,
    paymentMode        VARCHAR(18),
    instrumentNo       VARCHAR(15),
    instrumentType     VARCHAR(10),
    lastUpdatedBy      BIGINT,
    lastUpdate         TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: pdc_adjustment 
--

CREATE TABLE pdc_adjustment(
    id                BIGINT       AUTO_INCREMENT,
    pdcId             BIGINT,
    installmentNo     INT,
    adjustmentDate    DATE,
    lastUpdatedBy     BIGINT,
    lastUpdate        TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: pers_data_request_documents 
--

CREATE TABLE pers_data_request_documents(
    PersonalDataRequestDetailId    BIGINT    NOT NULL,
    documentId                     BIGINT    NOT NULL,
    PRIMARY KEY (PersonalDataRequestDetailId, documentId)
)
;



-- 
-- TABLE: person_addresses 
--

CREATE TABLE person_addresses(
    id                BIGINT           AUTO_INCREMENT,
    personId          DECIMAL(0, 0)    NOT NULL,
    addressTypeId     BIGINT           NOT NULL,
    addressId         BIGINT           NOT NULL,
    whetherDeleted    BIT               DEFAULT FALSE NOT NULL,
    whetherPrimary    BIT               DEFAULT FALSE NOT NULL,
    version           DECIMAL(0, 0)    NOT NULL,
    lastUpdate        TIMESTAMP        NOT NULL,
    lastUpdatedBy     BIGINT           NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: person_communities 
--

CREATE TABLE person_communities(
    id                BIGINT           AUTO_INCREMENT,
    personId          BIGINT           NOT NULL,
    communityId       BIGINT           NOT NULL,
    joiningDate       DATE             NOT NULL,
    exitDate          DATE,
    remark            VARCHAR(255)      DEFAULT NULL,
    whetherDeleted    BIT               DEFAULT FALSE NOT NULL,
    whetherOpted      BIT              NOT NULL,
    status            VARCHAR(10),
    version           DECIMAL(0, 0)    NOT NULL,
    lastUpdate        TIMESTAMP        NOT NULL,
    lastUpdatedBy     BIGINT           NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: person_relationships 
--

CREATE TABLE person_relationships(
    id                 BIGINT           AUTO_INCREMENT,
    personId           BIGINT           NOT NULL,
    relatedPersonId    DECIMAL(0, 0)    NOT NULL,
    relationship       VARCHAR(20)      NOT NULL,
    whetherDeleted     BIT               DEFAULT FALSE NOT NULL,
    version            DECIMAL(0, 0)    NOT NULL,
    lastUpdate         TIMESTAMP        NOT NULL,
    lastUpdatedBy      BIGINT           NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: person_services 
--

CREATE TABLE person_services(
    id                   BIGINT           AUTO_INCREMENT,
    serviceIdentifier    VARCHAR(50)      NOT NULL,
    personId             DECIMAL(0, 0)    NOT NULL,
    serviceId            BIGINT           NOT NULL,
    feePlanId            BIGINT           NOT NULL,
    fromDate             DATE             NOT NULL,
    tillDate             DATE             NOT NULL,
    amountToBePaid       DECIMAL(0, 0)    NOT NULL,
    whetherOpted         BIT              NOT NULL,
    whetherMandatory     BIT               DEFAULT FALSE NOT NULL,
    whetherDeleted       BIT               DEFAULT FALSE NOT NULL,
    status               VARCHAR(10),
    remarks              VARCHAR(255)     NOT NULL,
    version              DECIMAL(0, 0)    NOT NULL,
    lastUpdate           TIMESTAMP        NOT NULL,
    lastUpdatedBy        BIGINT           NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: person_training 
--

CREATE TABLE person_training(
    id                    BIGINT          AUTO_INCREMENT,
    personId              BIGINT          NOT NULL,
    trainingCategoryId    BIGINT          NOT NULL,
    trainingName          VARCHAR(100)    NOT NULL,
    fromDate              TIMESTAMP       NOT NULL,
    toDate                TIMESTAMP       NOT NULL,
    organization          VARCHAR(100)    NOT NULL,
    whetherDeleted        BIT             NOT NULL,
    remarks               VARCHAR(255),
    version               BIGINT          NOT NULL,
    lastUpdate            TIMESTAMP       NOT NULL,
    lastUpdatedBy         BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: personal_data_request_details 
--

CREATE TABLE personal_data_request_details(
    detailId             BIGINT    NOT NULL,
    dataToBeChangedId    BIGINT    NOT NULL,
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: personal_data_to_be_changed 
--

CREATE TABLE personal_data_to_be_changed(
    dataToBeChangedId    BIGINT            NOT NULL,
    personalIncome       DECIMAL(18, 2),
    familyIncome         DECIMAL(18, 2),
    maritalStatus        VARCHAR(20),
    photoUrl             VARCHAR(255),
    firstName            VARCHAR(255),
    middleName           VARCHAR(255),
    lastName             VARCHAR(255),
    shortName            VARCHAR(100),
    gender               VARCHAR(10),
    birthDate            TIMESTAMP,
    category             VARCHAR(100),
    salutationId         BIGINT            NOT NULL,
    castCategoryId       BIGINT            NOT NULL,
    bloodGroup           VARCHAR(20),
    countryId            BIGINT            NOT NULL,
    religionId           BIGINT            NOT NULL,
    nationalityId        BIGINT            NOT NULL,
    PRIMARY KEY (dataToBeChangedId)
)
;



-- 
-- TABLE: persons 
--

CREATE TABLE persons(
    id                               BIGINT            AUTO_INCREMENT,
    mobileNumber                     VARCHAR(15),
    employeeId                       VARCHAR(255)       DEFAULT NULL,
    firstName                        VARCHAR(255)      NOT NULL,
    middleName                       VARCHAR(255),
    emailId                          VARCHAR(100),
    lastName                         VARCHAR(255)      NOT NULL,
    shortName                        VARCHAR(255)      NOT NULL,
    birthDate                        DATE              NOT NULL,
    bloodGroup                       VARCHAR(20)        DEFAULT NULL,
    gender                           VARCHAR(20)       NOT NULL,
    maritalStatus                    VARCHAR(20),
    category                         VARCHAR(255)       DEFAULT NULL,
    occupation                       BIGINT,
    personalIncome                   DECIMAL(18, 2),
    photoUrl                         VARCHAR(255),
    salutationId                     BIGINT            NOT NULL,
    castCategoryId                   BIGINT,
    nationalityId                    BIGINT,
    status                           VARCHAR(20)       NOT NULL,
    whetherEmployeeOfOrganization    BIT               NOT NULL,
    whetherDeleted                   BIT               NOT NULL,
    lastUpdatedBy                    BIGINT            NOT NULL,
    lastUpdate                       TIMESTAMP         NOT NULL,
    version                          BIGINT            NOT NULL,
    countryId                        BIGINT,
    printName                        VARCHAR(255),
    religionId                       BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: picklist_enum 
--

CREATE TABLE picklist_enum(
    id           BIGINT          AUTO_INCREMENT,
    enumType     VARCHAR(200)    NOT NULL,
    code         VARCHAR(200)    NOT NULL,
    enumValue    VARCHAR(200)    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: placement_request_details 
--

CREATE TABLE placement_request_details(
    detailId                      BIGINT    NOT NULL,
    whetherWillingForPlacement    BIT,
    placementPeriod               INT,
    programId                     BIGINT    NOT NULL,
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: portals 
--

CREATE TABLE portals(
    id               BIGINT         AUTO_INCREMENT,
    portalName       VARCHAR(35)    NOT NULL,
    portalDesc       VARCHAR(20),
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    version          BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: privilege 
--

CREATE TABLE privilege(
    id               BIGINT         AUTO_INCREMENT,
    version          BIGINT         NOT NULL,
    description      VARCHAR(20),
    displayCode      VARCHAR(20),
    code             VARCHAR(20)    NOT NULL,
    privilegeName    CHAR(10),
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: prog_batch_course_details 
--

CREATE TABLE prog_batch_course_details(
    id                            BIGINT          AUTO_INCREMENT,
    programBatchPeriodConfigId    BIGINT,
    courseVarientId               BIGINT,
    admissionId                   BIGINT,
    enrollmentRequirement         VARCHAR(10),
    whetherRequirementReceived    BIT              DEFAULT 0,
    whetherRejected               BIT              DEFAULT 0,
    whetherEnrolled               BIT              DEFAULT 0,
    whetherDeEnrolled             BIT              DEFAULT 0,
    whetherCompleted              BIT              DEFAULT 0,
    rejectionReason               VARCHAR(255),
    deEnrollReason                VARCHAR(255),
    lastUpdatedBy                 BIGINT,
    lastUpdate                    TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: prog_batch_course_faculty 
--

CREATE TABLE prog_batch_course_faculty(
    id                            BIGINT         AUTO_INCREMENT,
    alternateFacultyAssignment    VARCHAR(45),
    lastUpdate                    TIMESTAMP      NOT NULL,
    progBatchCourseParamId        BIGINT,
    facultyId                     BIGINT,
    lastUpdatedBy                 BIGINT,
    alternateFacultyId            BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: prog_batch_course_special 
--

CREATE TABLE prog_batch_course_special(
    id                  BIGINT       AUTO_INCREMENT,
    programBatchId      BIGINT,
    specializationId    BIGINT,
    lastUpdatedBy       BIGINT       NOT NULL,
    lastUpdate          TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: prog_batch_period_config 
--

CREATE TABLE prog_batch_period_config(
    id                                BIGINT          AUTO_INCREMENT,
    programBatchId                    BIGINT          NOT NULL,
    programPeriodSeq                  INT,
    programPeriodName                 VARCHAR(20),
    programPeriodStart                DATE,
    programPeriodEnd                  DATE,
    programPeriodAutoPromotion        CHAR(1),
    programPeriodExternalPromotion    CHAR(1),
    programPeriodStartNotify          CHAR(1),
    programPeriodStartMessageType     VARCHAR(4),
    programPeriodResponsible          BIGINT,
    programPeriodEndNotify            CHAR(1),
    programPeriodEndMessageType       VARCHAR(4),
    programPeriodRankBasis            VARCHAR(20),
    minCourses                        INT,
    maxCourses                        INT,
    minCredits                        INT,
    maxCredit                         INT,
    entryCriteriaQuery                VARCHAR(255),
    exitCriteriaQuery                 VARCHAR(255),
    whetherPlacementPeriod            BIT             NOT NULL,
    lastUpdatedBy                     BIGINT          NOT NULL,
    lastUpdate                        TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: prog_batch_seat_config 
--

CREATE TABLE prog_batch_seat_config(
    id                                 BIGINT          AUTO_INCREMENT,
    enrollmentLastDate                 DATE,
    studentCourseSelectionStartDate    DATE,
    programBatchId                     BIGINT,
    selectionProcessStageId            BIGINT,
    enqSeatType                        CHAR(1),
    studentCourseSelectionEndDate      DATE,
    seatTypeId                         BIGINT,
    seatCapacity                       INT             NOT NULL,
    seatsFilled                        INT             NOT NULL,
    selProcessNote                     VARCHAR(255),
    selProcessStartDate                DATETIME,
    selProcessEndDate                  DATETIME,
    lastUpdatedBy                      BIGINT          NOT NULL,
    lastUpdate                         TIMESTAMP       NOT NULL,
    version                            BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: prog_period_break_config 
--

CREATE TABLE prog_period_break_config(
    id                       BIGINT         AUTO_INCREMENT,
    programBatchId           BIGINT,
    programPeriodSeqId       BIGINT,
    programPeriodBreakSeq    INT,
    breakName                VARCHAR(20),
    breakStart               DATE,
    breakEnd                 DATE,
    breakType                VARCHAR(10),
    breakStatus              BIT,
    lastUpdatedBy            BIGINT         NOT NULL,
    lastUpdate               TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: prog_slctn_process_admisn_conf 
--

CREATE TABLE prog_slctn_process_admisn_conf(
    id                              BIGINT          AUTO_INCREMENT,
    programSelectionProcessId       BIGINT          NOT NULL,
    offerLetterAcceptDaysLimit      INT,
    maxDaysToHoldOfferLetter        INT,
    lastDateForAdmission            DATE,
    disallowAdmission               INT             NOT NULL,
    whetherTrialAdmissionAllowed    BIT             NOT NULL,
    trialAdmissionEndDate           DATE            NOT NULL,
    allowProvisionalAdmission       BIT             NOT NULL,
    lastDateForConfirmation         DATE,
    documentsAccompanied            BIT             NOT NULL,
    offerLetterTemplate             VARCHAR(255),
    serviceEnrollmentMandatory      BIT             NOT NULL,
    remark                          VARCHAR(255),
    approverAuthority               VARCHAR(60),
    appProcessDocLink               VARCHAR(255),
    lastUpdatedBy                   BIGINT          NOT NULL,
    lastUpdate                      TIMESTAMP       NOT NULL,
    version                         BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: prog_slctn_process_checklist 
--

CREATE TABLE prog_slctn_process_checklist(
    id                           BIGINT          AUTO_INCREMENT,
    programSelectionProcessId    BIGINT          NOT NULL,
    checklistItemId              BIGINT,
    applicableAt                 VARCHAR(100),
    lastUpdatedBy                BIGINT          NOT NULL,
    lastUpdate                   TIMESTAMP       NOT NULL,
    version                      BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: prog_slctn_process_document 
--

CREATE TABLE prog_slctn_process_document(
    id                           BIGINT          AUTO_INCREMENT,
    programSelectionProcessId    BIGINT          NOT NULL,
    documentId                   BIGINT,
    applicability                VARCHAR(20)     NOT NULL,
    applicabilityRule            VARCHAR(100),
    appProcessDocLink            VARCHAR(255),
    remark                       VARCHAR(255),
    applicableAt                 VARCHAR(100),
    lastUpdatedBy                BIGINT          NOT NULL,
    lastUpdate                   TIMESTAMP       NOT NULL,
    version                      BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: prog_slctn_process_quota_type 
--

CREATE TABLE prog_slctn_process_quota_type(
    id                           BIGINT         AUTO_INCREMENT,
    programSelectionProcessId    BIGINT         NOT NULL,
    quotaTypeId                  BIGINT         NOT NULL,
    priority                     INT            NOT NULL,
    distributionBasis            VARCHAR(50),
    minSeat                      INT,
    maxSeat                      INT,
    lastUpdatedBy                BIGINT         NOT NULL,
    lastUpdate                   TIMESTAMP      NOT NULL,
    version                      BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: prog_slctn_process_stage_quota 
--

CREATE TABLE prog_slctn_process_stage_quota(
    id                                BIGINT       AUTO_INCREMENT,
    programSelProcessQuotaTypeId      BIGINT       NOT NULL,
    programSelectionProcessStageId    BIGINT       NOT NULL,
    quotaId                           BIGINT,
    minSeat                           INT,
    maxSeat                           INT,
    lastUpdatedBy                     BIGINT       NOT NULL,
    lastUpdate                        TIMESTAMP    NOT NULL,
    version                           BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: prog_slctn_stage_quota_overide 
--

CREATE TABLE prog_slctn_stage_quota_overide(
    id                              BIGINT          AUTO_INCREMENT,
    programSelectionStageQuotaId    BIGINT          NOT NULL,
    overriddenMinSeat               INT,
    overriddenMaxSeat               INT,
    overrideReason                  VARCHAR(255),
    approvedDate                    DATE,
    approvedBy                      BIGINT          NOT NULL,
    lastUpdatedBy                   BIGINT          NOT NULL,
    lastUpdated                     TIMESTAMP       NOT NULL,
    version                         BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: prog_slctn_stage_trnsfr_seat 
--

CREATE TABLE prog_slctn_stage_trnsfr_seat(
    id                         BIGINT       AUTO_INCREMENT,
    programSelectionStageId    BIGINT       NOT NULL,
    fromQuotaId                BIGINT       NOT NULL,
    toQuotaId                  BIGINT       NOT NULL,
    nmbrOfSeat                 INT,
    lastUpdatedBy              BIGINT       NOT NULL,
    lastUpdated                TIMESTAMP    NOT NULL,
    version                    BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: prog_wd_req_detail_programs 
--

CREATE TABLE prog_wd_req_detail_programs(
    programWithdrawReqDetailId    BIGINT    NOT NULL,
    programId                     BIGINT    NOT NULL,
    PRIMARY KEY (programWithdrawReqDetailId, programId)
)
;



-- 
-- TABLE: program_batch_course_param 
--

CREATE TABLE program_batch_course_param(
    id                               BIGINT         AUTO_INCREMENT,
    programBatchId                   BIGINT,
    courseId                         BIGINT,
    courseVarientId                  BIGINT,
    sectionId                        BIGINT,
    progBatchPeriodConfigId          BIGINT,
    periods                          CHAR(10),
    whetherCourseRepeatable          BIT,
    courseEvaluationTotal            INT,
    whetherPrimary                   BIT,
    minSectionEnrollment             INT,
    maxSectionEnrollment             INT,
    whetherStudentSelectionOption    BIT,
    enrollmentCriteria               VARCHAR(10),
    ceasingLastDate                  DATE,
    canStudentWithdraw               BIT,
    approverId                       BIGINT,
    lastUpdatedBy                    BIGINT         NOT NULL,
    lastUpdate                       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_batch_exam 
--

CREATE TABLE program_batch_exam(
    id                            BIGINT         AUTO_INCREMENT,
    admissionId                   BIGINT,
    centerType                    VARCHAR(18),
    centerId                      BIGINT,
    programBatchPeriodConfigId    BIGINT,
    sectionId                     BIGINT,
    courseId                      BIGINT,
    examDate                      DATE,
    examCode                      CHAR(10),
    studentAttended               INT,
    resourceId                    BIGINT,
    lastUpdatedBy                 BIGINT         NOT NULL,
    lastUpdate                    TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_batch_exam_center 
--

CREATE TABLE program_batch_exam_center(
    id                BIGINT         AUTO_INCREMENT,
    programBatchId    BIGINT,
    examCenterId      BIGINT,
    selectionStage    VARCHAR(35),
    centerType        VARCHAR(18),
    lastUpdatedBy     BIGINT         NOT NULL,
    lastUpdate        TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_batch_students 
--

CREATE TABLE program_batch_students(
    id                         BIGINT       AUTO_INCREMENT,
    programBatchId             BIGINT,
    progBatchSeatConfigId      BIGINT,
    progBatchPeriodConfigId    BIGINT,
    admissionId                BIGINT,
    sectionId                  BIGINT,
    lastUpdatedBy              BIGINT       NOT NULL,
    lastUpdate                 TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_cf_data 
--

CREATE TABLE program_cf_data(
    id                BIGINT         AUTO_INCREMENT,
    programId         BIGINT,
    fieldId           BIGINT,
    strFieldValue     VARCHAR(20),
    dateFieldValue    VARCHAR(20),
    txtFieldValue     VARCHAR(20),
    lastUpdatedBy     BIGINT,
    lastUpdate        TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_classification 
--

CREATE TABLE program_classification(
    id                          BIGINT         AUTO_INCREMENT,
    programId                   BIGINT,
    classificationFieldName     VARCHAR(10),
    classificationFieldValue    VARCHAR(15),
    lastUpdatedBy               BIGINT         NOT NULL,
    lastUpdate                  TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_course_faculty_fee 
--

CREATE TABLE program_course_faculty_fee(
    id                   BIGINT       AUTO_INCREMENT,
    courseId             BIGINT,
    programId            BIGINT,
    batchId              BIGINT,
    userId               BIGINT       NOT NULL,
    feeType              CHAR(1),
    feeAmount            INT,
    feeAmountCurrency    INT,
    feeEffectiveFrom     DATETIME,
    lastUpdatedBy        BIGINT       NOT NULL,
    lastUpdate           TIMESTAMP    NOT NULL,
    personId             BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_course_group 
--

CREATE TABLE program_course_group(
    id                 BIGINT       AUTO_INCREMENT,
    coursesGroupsId    BIGINT,
    programBatchId     BIGINT,
    lastUpdatedBy      BIGINT       NOT NULL,
    lastUpdate         TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_course_section_req 
--

CREATE TABLE program_course_section_req(
    id                    BIGINT       AUTO_INCREMENT,
    serviceRequestId      BIGINT,
    fromProgramId         BIGINT,
    toProgramId           BIGINT,
    fromCourseId          BIGINT,
    toCourseId            BIGINT,
    fromSectionId         BIGINT,
    toSectionId           BIGINT,
    executionRequestId    BIGINT,
    lastUpdatedBy         BIGINT       NOT NULL,
    lastUpdate            TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    requestFollowUpId     BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_courses 
--

CREATE TABLE program_courses(
    id                 BIGINT       AUTO_INCREMENT,
    courseId           BIGINT,
    programBatchId     BIGINT,
    whetherOptional    BIT,
    lastUpdatedBy      BIGINT       NOT NULL,
    lastUpdate         TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_group 
--

CREATE TABLE program_group(
    id               BIGINT         AUTO_INCREMENT,
    groupName        VARCHAR(20),
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_history 
--

CREATE TABLE program_history(
    id                           BIGINT       AUTO_INCREMENT,
    progBatchSeatConfigId        BIGINT,
    quotaTypeId                  BIGINT,
    quotaCodeId                  BIGINT,
    stageId                      BIGINT,
    noOfApplications             INT,
    noOfWithdrawls               INT,
    noOfRejected                 INT,
    noOfReplacements             INT,
    noOfAdmissions               INT,
    noOfTrialAdmissions          INT,
    noOfProvisionalAdmissions    INT,
    noOfOfferedAdmissions        INT,
    noOfRejectedAdmissions       INT,
    noOfQuotaViolations          INT,
    noOfSeatsShortForQuota       INT,
    lastUpdatedBy                BIGINT,
    lastUpdate                   TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_period_seq 
--

CREATE TABLE program_period_seq(
    id                 BIGINT         AUTO_INCREMENT,
    programPeriodId    BIGINT,
    sequenceName       VARCHAR(10),
    lastUpdatedBy      BIGINT         NOT NULL,
    lastUpdate         TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_period_type 
--

CREATE TABLE program_period_type(
    id               BIGINT         AUTO_INCREMENT,
    typeName         VARCHAR(60),
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_related_course 
--

CREATE TABLE program_related_course(
    id                   BIGINT          AUTO_INCREMENT,
    programBatchId       BIGINT,
    primaryCourseId      BIGINT,
    secCourseId          BIGINT,
    setRelation          INT,
    relationType         VARCHAR(255),
    courseDescription    VARCHAR(255),
    lastUpdatedBy        BIGINT          NOT NULL,
    lastUpdate           TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_selection_process 
--

CREATE TABLE program_selection_process(
    id                           BIGINT       AUTO_INCREMENT,
    programBatchSeatConfigId     BIGINT       NOT NULL,
    selectionProcessId           BIGINT       NOT NULL,
    whetherSelectionInBatches    BIT           DEFAULT false NOT NULL,
    mandatoryQuotaTypeId         BIGINT,
    lastUpdatedBy                BIGINT       NOT NULL,
    lastUpdate                   TIMESTAMP    NOT NULL,
    version                      BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_set_deadlines 
--

CREATE TABLE program_set_deadlines(
    id                      BIGINT       AUTO_INCREMENT,
    programBatchPeriodId    BIGINT,
    programId               BIGINT,
    courseStartDate         DATE,
    courseEndDate           DATE,
    enrollmentLastDate      DATE,
    requestStartDate        DATE,
    requestEndDate          DATE,
    lastUpdatedBy           BIGINT       NOT NULL,
    lastUpdate              TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_slctn_process_stages 
--

CREATE TABLE program_slctn_process_stages(
    id                           BIGINT          AUTO_INCREMENT,
    programSelectionProcessId    BIGINT          NOT NULL,
    stageId                      BIGINT,
    startDate                    DATE,
    endDate                      DATE,
    minSeat                      INT,
    maxSeat                      INT,
    entryRule                    VARCHAR(50),
    entryRuleDescription         VARCHAR(255),
    exitRule                     VARCHAR(50),
    exitRuleDescription          VARCHAR(255),
    lastUpdatedBy                BIGINT          NOT NULL,
    lastUpdate                   TIMESTAMP       NOT NULL,
    version                      BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_slctn_process_status 
--

CREATE TABLE program_slctn_process_status(
    id                           BIGINT          AUTO_INCREMENT,
    programSelectionProcessId    BIGINT          NOT NULL,
    status                       VARCHAR(100)    NOT NULL,
    remark                       VARCHAR(255),
    lastUpdatedBy                BIGINT          NOT NULL,
    lastUpdated                  TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_slctn_stage_statistics 
--

CREATE TABLE program_slctn_stage_statistics(
    id                                BIGINT       AUTO_INCREMENT,
    programSelectionProcStageQuota    BIGINT       NOT NULL,
    programSelectionProcessStageId    BIGINT       NOT NULL,
    numberOfApplication               INT,
    numberOfSelectedStudents          INT,
    numberOfStudentsInWaitList        INT,
    numberOfStudentsRejected          INT,
    numberOfStudentsWithdrawn         INT,
    numberOfStudentsReplaced          INT,
    lastUpdatedBy                     BIGINT       NOT NULL,
    lastUpdated                       TIMESTAMP    NOT NULL,
    version                           BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: program_withdraw_req_details 
--

CREATE TABLE program_withdraw_req_details(
    detailId    BIGINT    NOT NULL,
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: program_xfer_request_details 
--

CREATE TABLE program_xfer_request_details(
    detailId         BIGINT    NOT NULL,
    fromProgramId    BIGINT    NOT NULL,
    toProgramId      BIGINT    NOT NULL,
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: programs 
--

CREATE TABLE programs(
    id                           BIGINT          AUTO_INCREMENT,
    academyLocationId            BIGINT,
    programGroupId               BIGINT          NOT NULL,
    succeedingProgramId          BIGINT,
    approver                     BIGINT          NOT NULL,
    programCode                  VARCHAR(10)     NOT NULL,
    programName                  VARCHAR(35)     NOT NULL,
    programShortName             VARCHAR(35),
    programNameToBePrint         VARCHAR(35)     NOT NULL,
    status                       CHAR(1)         NOT NULL,
    programDepartmentId          BIGINT          NOT NULL,
    subDepartmentId              BIGINT,
    programMarkGrade             VARCHAR(1)      NOT NULL,
    whetherSucceedingProgram     BIT             NOT NULL,
    whetherCreateNewAdmission    BIT,
    remark                       VARCHAR(255),
    programClosureReason         VARCHAR(100),
    programClosureDate           DATE,
    isSingleCourseProgram        BIT             NOT NULL,
    categoryField1               VARCHAR(15),
    categoryField2               VARCHAR(15),
    categoryField3               VARCHAR(15),
    categoryField4               VARCHAR(15),
    categoryField5               VARCHAR(15),
    lastUpdatedBy                BIGINT          NOT NULL,
    lastUpdate                   TIMESTAMP       NOT NULL,
    version                      BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: que_paper_details_break 
--

CREATE TABLE que_paper_details_break(
    id                              BIGINT          AUTO_INCREMENT,
    questionPaperDetailId           BIGINT,
    questionText                    VARCHAR(50),
    questionAltSeq                  INT,
    courseQuestionAltSeq            INT,
    courseQuestionAltSeqImage       VARCHAR(100),
    courseQuestionAltSeqText1       CHAR(10),
    courseQuestionAltImage1         VARCHAR(100),
    courseAnswer                    VARCHAR(50),
    courseMatchAnswer               VARCHAR(50),
    courseQuestionObjSeq            INT,
    courseQuestionObjDescription    VARCHAR(100),
    lastUpdatedBy                   BIGINT          NOT NULL,
    lastUpdate                      TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: que_paper_topic_coverage 
--

CREATE TABLE que_paper_topic_coverage(
    id                      BIGINT         AUTO_INCREMENT,
    evalSequenceId          BIGINT,
    evalSequenceDetailId    BIGINT,
    courseQuestionTopic     VARCHAR(35),
    minMarks                INT,
    maxMarks                INT,
    lastUpdatedBy           BIGINT         NOT NULL,
    lastUpdate              TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: que_resp_result_details 
--

CREATE TABLE que_resp_result_details(
    id                         BIGINT         AUTO_INCREMENT,
    questionResponseId         BIGINT,
    questionPaperQuestionId    BIGINT,
    response                   VARCHAR(40),
    result                     VARCHAR(15),
    lastUpdatedBy              BIGINT         NOT NULL,
    lastUpdate                 TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: question_bank_break_up 
--

CREATE TABLE question_bank_break_up(
    id                            BIGINT          AUTO_INCREMENT,
    questionBankId                BIGINT,
    questionText                  VARCHAR(255),
    questionAltSeq                VARCHAR(100),
    courseQuestionAltSeqText      VARCHAR(255)    NOT NULL,
    courseQuestionAltSeqImage     VARCHAR(100),
    courseQuestionAltSeqText1     VARCHAR(255)    NOT NULL,
    courseQuestionAltSeqImage1    VARCHAR(100),
    courseAnswer                  CHAR(1),
    courseMatchAnswer             TINYINT         NOT NULL,
    courseQuestionObjSeq          VARCHAR(6),
    courseQuestionObjDesc         VARCHAR(255),
    approverId                    BIGINT,
    remark                        VARCHAR(255),
    lastUpdatedBy                 BIGINT          NOT NULL,
    lastUpdate                    TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: question_bank_questions 
--

CREATE TABLE question_bank_questions(
    id                            BIGINT          AUTO_INCREMENT,
    questionNo                    INT,
    questionType                  VARCHAR(10),
    questionCourseTopicId         BIGINT,
    questionText                  VARCHAR(255),
    questionAltSeq                VARCHAR(100),
    courseQuestionAltSeqText      VARCHAR(255)    NOT NULL,
    courseQuestionAltSeqImage     VARCHAR(100),
    courseQuestionAltSeqText1     VARCHAR(255)    NOT NULL,
    courseQuestionAltSeqImage1    VARCHAR(100),
    courseAnswer                  CHAR(1),
    courseMatchAnswer             TINYINT         NOT NULL,
    courseQuestionObjSeq          VARCHAR(6),
    courseQuestionObjDesc         VARCHAR(255),
    approverId                    BIGINT,
    remark                        VARCHAR(255),
    lastUpdatedBy                 BIGINT          NOT NULL,
    lastUpdate                    TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: question_paper 
--

CREATE TABLE question_paper(
    id                       BIGINT          AUTO_INCREMENT,
    programBatchId           BIGINT,
    courseComponentId        BIGINT,
    questionId               BIGINT,
    questionPaperStructId    BIGINT,
    approverId               BIGINT,
    remark                   VARCHAR(255),
    lastUpdatedBy            BIGINT          NOT NULL,
    lastUpdate               TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: question_paper_details 
--

CREATE TABLE question_paper_details(
    id                           BIGINT          AUTO_INCREMENT,
    questionPaperId              BIGINT,
    questionNo                   INT,
    questionTopicId              BIGINT,
    questionText                 VARCHAR(255),
    structureLevelTwoId          BIGINT,
    structureLevelThreeId        BIGINT,
    structureLeafNodeId          BIGINT,
    questionAltSeq               INT,
    courseQuestionAltSeq         INT,
    courseQuestionAltSeqImage    VARCHAR(100),
    courseQuestionAltSeqText1    CHAR(10),
    courseQuestionAltImage1      VARCHAR(100),
    courseAnswer                 VARCHAR(50),
    courseMatchAnswer            VARCHAR(50),
    courseQuestionObjSeq         INT,
    courseQuestionObjDesc        VARCHAR(100),
    lastUpdatedBy                BIGINT          NOT NULL,
    lastUpdate                   TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: question_paper_structure 
--

CREATE TABLE question_paper_structure(
    id                            BIGINT        AUTO_INCREMENT,
    courseComponentId             BIGINT,
    programBatchPeriodConfigId    BIGINT,
    questionsToBeAnswered         INT,
    maxMarks                      INT,
    maxTime                       VARCHAR(8),
    lastUpdatedBy                 BIGINT        NOT NULL,
    lastUpdate                    TIMESTAMP     NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: question_program_batch 
--

CREATE TABLE question_program_batch(
    id                      BIGINT       AUTO_INCREMENT,
    programId               BIGINT,
    courseId                BIGINT,
    evalSequenceId          BIGINT,
    batchId                 BIGINT,
    sectionId               BIGINT,
    evalDetailSequenceId    BIGINT,
    lastUpdatedBy           BIGINT       NOT NULL,
    lastUpdate              TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: question_response_result 
--

CREATE TABLE question_response_result(
    id                   BIGINT       AUTO_INCREMENT,
    evalPlanStudentId    BIGINT,
    questionPaperId      BIGINT,
    lastUpatedBy         BIGINT       NOT NULL,
    lastUpdate           TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: questionnaire 
--

CREATE TABLE questionnaire(
    id                   BIGINT         AUTO_INCREMENT,
    questionnaireName    VARCHAR(50),
    lastUpdatedBy        BIGINT,
    lastUpdate           TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: quota 
--

CREATE TABLE quota(
    id                   BIGINT          AUTO_INCREMENT,
    quotaTypeId          BIGINT,
    code                 VARCHAR(100),
    description          VARCHAR(255),
    displayOrder         BIGINT,
    applicabilityRule    VARCHAR(100),
    ruleDescription      VARCHAR(255),
    lastUpdatedBy        BIGINT          NOT NULL,
    lastUpdate           TIMESTAMP,
    version              BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: quota_type 
--

CREATE TABLE quota_type(
    id               BIGINT          AUTO_INCREMENT,
    code             VARCHAR(100),
    description      VARCHAR(255),
    displayOrder     BIGINT,
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       TIMESTAMP,
    version          BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: quota_validity 
--

CREATE TABLE quota_validity(
    id               BIGINT       AUTO_INCREMENT,
    quotaId          BIGINT       NOT NULL,
    validFrom        TIMESTAMP    NOT NULL,
    validTill        TIMESTAMP,
    status           BIT          NOT NULL,
    lastUpdatedBy    BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP,
    version          BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: reasons 
--

CREATE TABLE reasons(
    id               BIGINT          AUTO_INCREMENT,
    code             VARCHAR(50)     NOT NULL,
    value            VARCHAR(150)    NOT NULL,
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: rec_bill_fee_plan_stg 
--

CREATE TABLE rec_bill_fee_plan_stg(
    id                      BIGINT         AUTO_INCREMENT,
    billId                  BIGINT,
    instrumentNo            VARCHAR(20),
    feeStageHeadConfigId    BIGINT,
    lastUpdatedBy           BIGINT,
    lastUpdate              TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: receipt_adjustment 
--

CREATE TABLE receipt_adjustment(
    id                        BIGINT       AUTO_INCREMENT,
    receiptPayInstrumentId    BIGINT,
    recBillFeePlanStgId       BIGINT,
    adjustmentDate            DATE,
    lastUpdatedBy             BIGINT,
    lastUpdate                TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: receipt_header 
--

CREATE TABLE receipt_header(
    id                     BIGINT         AUTO_INCREMENT,
    billId                 BIGINT,
    voucherType            VARCHAR(12),
    transactionDate        DATE,
    tallyVoucherId         INT            NOT NULL,
    integratedWithTally    BIT            NOT NULL,
    transactionType        VARCHAR(10),
    toBeDeleted            BIT            NOT NULL,
    lastUpdatedBy          BIGINT         NOT NULL,
    lastUpdate             TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: receipt_payment_instrument 
--

CREATE TABLE receipt_payment_instrument(
    id                  BIGINT         NOT NULL,
    receiptHeaderId     BIGINT,
    paymentMode         VARCHAR(2),
    instrumentAmount    INT            NOT NULL,
    instrumentNo        INT            NOT NULL,
    instrumentDate      DATE           NOT NULL,
    drawnOn             DATE,
    depositedIn         VARCHAR(10),
    amountPaid          FLOAT,
    lastUpdatedBy       BIGINT         NOT NULL,
    lastUpdate          TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: reexamination_req_types 
--

CREATE TABLE reexamination_req_types(
    examRequestTypeDetailId    BIGINT       NOT NULL,
    currentExamDate            TIMESTAMP,
    currentExamBatchId         BIGINT       NOT NULL,
    PRIMARY KEY (examRequestTypeDetailId)
)
;



-- 
-- TABLE: refund_details 
--

CREATE TABLE refund_details(
    id                    BIGINT         NOT NULL,
    whetherDeleted        BIT,
    version               BIGINT         NOT NULL,
    paymentMode           VARCHAR(2),
    instrumentAmount      INT            NOT NULL,
    billRefundHeaderId    BIGINT,
    instrumentNo          INT            NOT NULL,
    instrumentDate        DATE           NOT NULL,
    drawnOn               DATE,
    depositedIn           VARCHAR(10),
    amountPaid            FLOAT,
    lastUpdatedBy         BIGINT         NOT NULL,
    lastUpdate            TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    serviceRequestId      BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: refund_reasons 
--

CREATE TABLE refund_reasons(
    id                 BIGINT          AUTO_INCREMENT,
    reasonType         VARCHAR(10),
    reasonCode         VARCHAR(10),
    reasonTitle        VARCHAR(20),
    reasonStatus       VARCHAR(6),
    ruleAgenda         VARCHAR(50),
    ruleDescription    VARCHAR(255),
    lastUpdatedBy      BIGINT          NOT NULL,
    lastUpdate         TIMESTAMP,
    version            BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: relations_data_to_be_changed 
--

CREATE TABLE relations_data_to_be_changed(
    dataToBeChangedId                BIGINT            NOT NULL,
    whetherEmployeeOfOrganization    BIT,
    employeeId                       VARCHAR(50),
    personalIncome                   DECIMAL(18, 2),
    maritalStatus                    VARCHAR(20),
    firstName                        VARCHAR(255),
    middleName                       VARCHAR(255),
    lastName                         VARCHAR(255),
    relationship                     VARCHAR(100),
    gender                           VARCHAR(10),
    birthDate                        TIMESTAMP,
    bloodGroup                       VARCHAR(20),
    salutationId                     BIGINT            NOT NULL,
    PRIMARY KEY (dataToBeChangedId)
)
;



-- 
-- TABLE: religions 
--

CREATE TABLE religions(
    id               BIGINT          AUTO_INCREMENT,
    itemCode         VARCHAR(255)    NOT NULL,
    itemValue        VARCHAR(255)    NOT NULL,
    lastUpdate       TIMESTAMP       NOT NULL,
    lastUpdatedBy    BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: reopen_reason 
--

CREATE TABLE reopen_reason(
    id               BIGINT          AUTO_INCREMENT,
    reasonCode       VARCHAR(255),
    status           VARCHAR(255),
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: repeat_stu_detail_seq 
--

CREATE TABLE repeat_stu_detail_seq(
    mgmtGroupTypeId     BIGINT         AUTO_INCREMENT,
    repeatationId       BIGINT,
    evalDetailSeqId     BIGINT,
    evaluationPlanNo    VARCHAR(15),
    feePlanId           BIGINT,
    evaluationType      VARCHAR(18),
    status              CHAR(1),
    feeAmount           INT,
    lastUpdatedBy       BIGINT         NOT NULL,
    lastUpdate          TIMESTAMP      NOT NULL,
    PRIMARY KEY (mgmtGroupTypeId)
)
;



-- 
-- TABLE: repeating_course_comp 
--

CREATE TABLE repeating_course_comp(
    id                   BIGINT       AUTO_INCREMENT,
    courseComponentId    BIGINT,
    repeatationId        BIGINT,
    lastUpdatedBy        BIGINT       NOT NULL,
    lastUpdate           TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: repeating_student 
--

CREATE TABLE repeating_student(
    mgmtGroupTypeId               BIGINT         AUTO_INCREMENT,
    admissionId                   BIGINT,
    courseId                      BIGINT,
    sectionId                     BIGINT,
    evalSequenceId                BIGINT,
    evalDetailSeqId               BIGINT,
    programBatchPeriodConfigId    BIGINT,
    feePlanId                     BIGINT,
    repetitionType                VARCHAR(15),
    repeatationType               VARCHAR(10),
    evaluationPlanNo              VARCHAR(15),
    evaluationType                VARCHAR(18),
    status                        CHAR(1),
    feeAmount                     INT,
    lastUpdatedBy                 BIGINT         NOT NULL,
    lastUpdate                    TIMESTAMP      NOT NULL,
    PRIMARY KEY (mgmtGroupTypeId)
)
;



-- 
-- TABLE: report_audit 
--

CREATE TABLE report_audit(
    id                  BIGINT         AUTO_INCREMENT,
    userId              BIGINT,
    systemReportId      BIGINT,
    reportAccessTime    DATETIME,
    reportOutputType    VARCHAR(35),
    lastUpdatedBy       BIGINT         NOT NULL,
    updatedDate         TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: req_against_bill_details 
--

CREATE TABLE req_against_bill_details(
    feeRelatedRequestDetailId    BIGINT    NOT NULL,
    billHeaderId                 BIGINT    NOT NULL,
    PRIMARY KEY (feeRelatedRequestDetailId)
)
;



-- 
-- TABLE: req_against_feehead_details 
--

CREATE TABLE req_against_feehead_details(
    feeRelatedRequestDetailId    BIGINT    NOT NULL,
    feeHeadId                    BIGINT    NOT NULL,
    PRIMARY KEY (feeRelatedRequestDetailId)
)
;



-- 
-- TABLE: req_documents_submitted 
--

CREATE TABLE req_documents_submitted(
    id                     BIGINT         AUTO_INCREMENT,
    serviceRequestId       BIGINT,
    changeDocumentsName    VARCHAR(40),
    lastUpdatedBy          BIGINT         NOT NULL,
    lastUpdate             TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: request_followup 
--

CREATE TABLE request_followup(
    id                     BIGINT          AUTO_INCREMENT,
    serviceRequestId       BIGINT,
    plannedFollowupDate    DATE,
    actualFlwDate          DATE,
    followUpRemarks        VARCHAR(255),
    nextFollowUpDate       DATE,
    approverId             BIGINT,
    approverRemarks        VARCHAR(255),
    lastUpdatedBy          BIGINT          NOT NULL,
    lastUpdate             TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: request_for_installment 
--

CREATE TABLE request_for_installment(
    id                   BIGINT       NOT NULL,
    feeRequestId         BIGINT,
    installmentDate      DATE,
    installmentAmount    INT,
    lastUpdatedBy        BIGINT       NOT NULL,
    lastUpdate           TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: request_handover_modes 
--

CREATE TABLE request_handover_modes(
    id               BIGINT          NOT NULL,
    itemCode         VARCHAR(100),
    itemValue        VARCHAR(255),
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: request_type_categories 
--

CREATE TABLE request_type_categories(
    id                        BIGINT         AUTO_INCREMENT,
    serviceRequestCategory    VARCHAR(50),
    whetherDeleted            BIT,
    lastUpdatedBy             BIGINT         NOT NULL,
    lastUpdate                TIMESTAMP,
    requestTypeId             BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: request_types 
--

CREATE TABLE request_types(
    id                     BIGINT          NOT NULL,
    serviceRequestGroup    VARCHAR(50),
    whetherDeleted         BIT,
    itemCode               VARCHAR(255),
    itemValue              VARCHAR(255),
    lastUpdatedBy          BIGINT          NOT NULL,
    lastUpdate             TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: res_acad_loc_prog_batches 
--

CREATE TABLE res_acad_loc_prog_batches(
    id                          BIGINT       NOT NULL,
    version                     INT          NOT NULL,
    batchId                     BIGINT,
    resAcadLocationProgramId    INT,
    lastUpdatedBy               BIGINT,
    lastUpdate                  TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: res_acad_location_programs 
--

CREATE TABLE res_acad_location_programs(
    id                           INT          AUTO_INCREMENT,
    version                      INT          NOT NULL,
    programId                    BIGINT,
    lastUpdatedBy                BIGINT,
    lastUpdate                   TIMESTAMP,
    resourceAcademyLocationId    BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: res_temp_unavail_infos 
--

CREATE TABLE res_temp_unavail_infos(
    resUnavailInfoId    BIGINT         NOT NULL,
    toDate              DATE,
    type                VARCHAR(20),
    PRIMARY KEY (resUnavailInfoId)
)
;



-- 
-- TABLE: res_temp_unavail_slots 
--

CREATE TABLE res_temp_unavail_slots(
    id                      BIGINT      AUTO_INCREMENT,
    resTempUnavailInfoId    BIGINT,
    fromTime                DATETIME,
    toTime                  DATETIME,
    lastUpdatedBy           BIGINT      NOT NULL,
    lastUpdate              DATE        NOT NULL,
    version                 BIGINT      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: res_unavail_infos 
--

CREATE TABLE res_unavail_infos(
    id               BIGINT       AUTO_INCREMENT,
    lastUpdate       DATE         NOT NULL,
    version          INT          NOT NULL,
    fromDate         DATE,
    reason           CHAR(100),
    lastUpdatedBy    BIGINT,
    resourceId       BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: reservation_category 
--

CREATE TABLE reservation_category(
    id                     BIGINT          AUTO_INCREMENT,
    categoryCode           VARCHAR(10),
    categoryDescription    VARCHAR(255),
    lastUpdatedBy          BIGINT,
    lastUpdate             TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_academy_locations 
--

CREATE TABLE resource_academy_locations(
    id                   BIGINT       AUTO_INCREMENT,
    resourceId           BIGINT,
    academyLocationId    BIGINT,
    whetherPrimary       BIT,
    whetherDeleted       BIT          NOT NULL,
    lastUpdatedBy        BIGINT,
    lastUpdate           TIMESTAMP,
    version              INT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_booking_adhocs 
--

CREATE TABLE resource_booking_adhocs(
    id                   BIGINT          AUTO_INCREMENT,
    remark               VARCHAR(255),
    version              INT             NOT NULL,
    resourceBookingId    BIGINT,
    internalUser         BIGINT,
    resourceTypeId       BIGINT,
    resourceName         VARCHAR(10),
    quantity             INT,
    description          VARCHAR(255),
    whetherConfirmed     BIT,
    lastUpdatedBy        BIGINT,
    lastUpdate           TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_booking_courses 
--

CREATE TABLE resource_booking_courses(
    id                   BIGINT       AUTO_INCREMENT,
    version              INT          NOT NULL,
    resourceBookingId    BIGINT,
    courseId             BIGINT,
    lastUpdatedBy        BIGINT,
    lastUpdate           TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_booking_faculties 
--

CREATE TABLE resource_booking_faculties(
    id                   BIGINT       AUTO_INCREMENT,
    resourceBookingId    BIGINT,
    lastUpdatedBy        BIGINT,
    facultyId            BIGINT       NOT NULL,
    version              CHAR(10)     NOT NULL,
    lastUpdate           TIMESTAMP    NOT NULL,
    personId             BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_booking_programs 
--

CREATE TABLE resource_booking_programs(
    id                   BIGINT       AUTO_INCREMENT,
    resourceBookingId    BIGINT,
    programId            BIGINT,
    batchId              BIGINT,
    sectionId            BIGINT,
    courseTopicId        BIGINT,
    version              INT          NOT NULL,
    lastUpdatedBy        BIGINT,
    lastUpdate           TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_booking_purposes 
--

CREATE TABLE resource_booking_purposes(
    id                  BIGINT    AUTO_INCREMENT,
    lastUpdate          DATE      NOT NULL,
    version             INT       NOT NULL,
    capacity            INT,
    resourceId          BIGINT,
    bookingPurposeId    BIGINT,
    lastUpdatedBy       BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_booking_resources 
--

CREATE TABLE resource_booking_resources(
    id                   BIGINT          AUTO_INCREMENT,
    feedback             VARCHAR(255),
    version              INT             NOT NULL,
    lastUpdatedBy        BIGINT,
    lastUpdate           TIMESTAMP,
    resourceBookingId    BIGINT,
    resourceId           BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_booking_users 
--

CREATE TABLE resource_booking_users(
    id                   BIGINT       AUTO_INCREMENT,
    version              BIGINT       NOT NULL,
    resourceBookingId    BIGINT,
    userId               BIGINT,
    lastUpdatedBy        BIGINT,
    lastUpdate           TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_bookings 
--

CREATE TABLE resource_bookings(
    id                      BIGINT          AUTO_INCREMENT,
    bookingPurposeId        BIGINT,
    locationId              BIGINT,
    eventDate               DATE,
    eventDesc               VARCHAR(255),
    whetherCompleteDay      BIT             NOT NULL,
    whetherMandatory        BIT,
    sessionDateSlot         TINYINT,
    whetherRecurring        BIT             NOT NULL,
    tillDate                DATE,
    timeFrom                DATETIME,
    timeTo                  DATETIME,
    status                  CHAR(10),
    eventName               VARCHAR(15),
    resourceCategoryCode    CHAR(10),
    purpose                 VARCHAR(30),
    purposeDescription      VARCHAR(255),
    noOfParticipants        INT,
    bookingRemark           VARCHAR(255),
    approverRemark          VARCHAR(255),
    bookedBy                BIGINT,
    approvedBy              BIGINT,
    whetherDeleted          BIT             NOT NULL,
    lastUpdatedBy           BIGINT,
    lastUpdate              TIMESTAMP       NOT NULL,
    version                 INT             NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_cf_data 
--

CREATE TABLE resource_cf_data(
    id                BIGINT         AUTO_INCREMENT,
    resourceId        BIGINT,
    fieldId           BIGINT,
    strFieldValue     VARCHAR(20),
    dateFieldValue    VARCHAR(20),
    txtFieldValue     VARCHAR(20),
    lastUpdatedBy     BIGINT,
    lastUpdate        TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_classifications 
--

CREATE TABLE resource_classifications(
    id                  BIGINT       AUTO_INCREMENT,
    version             INT          NOT NULL,
    resourceId          BIGINT,
    lastUpdatedBy       BIGINT,
    lastUpdate          TIMESTAMP,
    classificationId    BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: resource_types 
--

CREATE TABLE resource_types(
    id               BIGINT         AUTO_INCREMENT,
    version          BIGINT         NOT NULL,
    resourceGroup    CHAR(10),
    code             CHAR(10),
    typeName         VARCHAR(20),
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: resources 
--

CREATE TABLE resources(
    id                           BIGINT          AUTO_INCREMENT,
    resourceTypeId               BIGINT,
    code                         VARCHAR(50),
    resourceName                 VARCHAR(100),
    shortName                    VARCHAR(50),
    whetherDependent             BIT,
    resourceDescription          VARCHAR(255),
    capacity                     INT,
    resourceGroup                VARCHAR(10),
    categoryCode                 CHAR(10),
    landMark                     VARCHAR(20),
    whetherConflictAcceptable    BIT,
    whetherSharingAllowed        BIT,
    availabilityStatus           VARCHAR(18),
    status                       VARCHAR(20),
    whetherDeleted               BIT             NOT NULL,
    nameToBePrinted              VARCHAR(100),
    categoryField1               VARCHAR(15),
    categoryField2               VARCHAR(15),
    categoryField3               VARCHAR(15),
    categoryField4               VARCHAR(15),
    categoryField5               VARCHAR(15),
    lastUpdatedBy                BIGINT,
    lastUpdate                   TIMESTAMP,
    version                      BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: resrc_acad_location_courses 
--

CREATE TABLE resrc_acad_location_courses(
    id                        BIGINT       AUTO_INCREMENT,
    version                   BIGINT       NOT NULL,
    resourceAcadLocationId    BIGINT,
    courseId                  BIGINT,
    lastUpdatedBy             BIGINT,
    lastUpdate                TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: resrc_booking_acad_locations 
--

CREATE TABLE resrc_booking_acad_locations(
    id                   BIGINT       AUTO_INCREMENT,
    lastUpdatedBy        BIGINT,
    lastUpdate           TIMESTAMP    NOT NULL,
    version              BIGINT       NOT NULL,
    academyLocationId    BIGINT,
    resourceBookingId    BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: result_columns_translations 
--

CREATE TABLE result_columns_translations(
    id             BIGINT          AUTO_INCREMENT,
    resultKey      VARCHAR(200)    NOT NULL,
    displayCode    VARCHAR(200)    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: result_details 
--

CREATE TABLE result_details(
    mgmtGroupTypeId        BIGINT         AUTO_INCREMENT,
    examinationResultId    BIGINT,
    questionId             BIGINT,
    questionPart           VARCHAR(6),
    questionPart1          VARCHAR(6),
    marksGiven             FLOAT,
    negativeMarksGiven     FLOAT,
    graceMarksGiven        FLOAT,
    penultyMarksGiven      INT,
    wrongMarksGiven        INT,
    errorCode              VARCHAR(10),
    lastUpdatedBy          BIGINT         NOT NULL,
    lastUpdate             TIMESTAMP      NOT NULL,
    PRIMARY KEY (mgmtGroupTypeId)
)
;



-- 
-- TABLE: role_portals 
--

CREATE TABLE role_portals(
    id               BIGINT       AUTO_INCREMENT,
    roleId           BIGINT,
    portalId         BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    lastUpdatedBy    BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: role_privileges 
--

CREATE TABLE role_privileges(
    id                        BIGINT       AUTO_INCREMENT,
    whetherOverrideAllowed    BIT          NOT NULL,
    granted                   BIT          NOT NULL,
    featurePrivilegeId        BIGINT       NOT NULL,
    roleId                    BIGINT       NOT NULL,
    lastUpdatedBy             BIGINT       NOT NULL,
    lastUpdate                TIMESTAMP    NOT NULL,
    version                   BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: roles 
--

CREATE TABLE roles(
    id                  BIGINT          AUTO_INCREMENT,
    roleName            VARCHAR(35)     NOT NULL,
    roleDesc            VARCHAR(255),
    whetherDeletable    BIT             NOT NULL,
    createdOn           DATE,
    whetherEditable     BIT             NOT NULL,
    whetherDeleted      BIT             NOT NULL,
    serialNumber        VARCHAR(10)     NOT NULL,
    lastUpdatedBy       BIGINT,
    lastUpdate          TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    version             BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: salutations 
--

CREATE TABLE salutations(
    id                BIGINT         AUTO_INCREMENT,
    salutationName    VARCHAR(50)    NOT NULL,
    lastUpdate        TIMESTAMP       DEFAULT CURRENT_TIMESTAMP,
    lastUpdatedBy     BIGINT,
    version           BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: saved_search 
--

CREATE TABLE saved_search(
    id                BIGINT         AUTO_INCREMENT,
    searchViewId      BIGINT         NOT NULL,
    searchConfigId    BIGINT         NOT NULL,
    searchName        VARCHAR(50)    NOT NULL,
    userId            BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: saved_search_criteria 
--

CREATE TABLE saved_search_criteria(
    id                          BIGINT          AUTO_INCREMENT,
    savedSearchId               BIGINT,
    searchConfigTableId         BIGINT,
    searchCriteriaOperatorId    BIGINT,
    searchTableColumnId         BIGINT,
    parentId                    BIGINT,
    criteriaType                VARCHAR(50)     NOT NULL,
    logicalOperator             VARCHAR(20),
    operandValue                VARCHAR(200),
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: saved_search_sort_criteria 
--

CREATE TABLE saved_search_sort_criteria(
    id                          BIGINT         AUTO_INCREMENT,
    savedSearchId               BIGINT         NOT NULL,
    searchResultViewColumnId    BIGINT         NOT NULL,
    sortOrder                   VARCHAR(20),
    sortSequence                INT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: scholarship 
--

CREATE TABLE scholarship(
    id                           BIGINT            AUTO_INCREMENT,
    currencyId                   BIGINT            NOT NULL,
    scholarshipOrganizationId    BIGINT            NOT NULL,
    scholarshipCode              VARCHAR(150)      NOT NULL,
    scholarshipName              VARCHAR(150)      NOT NULL,
    scholarshipType              CHAR(3)           NOT NULL,
    scholarshipAmountType        CHAR(3)           NOT NULL,
    disbursementMode             CHAR(3)           NOT NULL,
    selectionType                CHAR(3)           NOT NULL,
    paymentType                  CHAR(3)           NOT NULL,
    applicationMode              CHAR(3)           NOT NULL,
    amount                       DECIMAL(18, 2),
    validityInMonth              BIGINT,
    maxNoAwardees                INT,
    scholarshipStatus            BIT               NOT NULL,
    adjustmentAllowed            BIT,
    allowConcessionCandidate     BIT               NOT NULL,
    droolAgenda                  VARCHAR(150)      NOT NULL,
    droolAgendaDescription       VARCHAR(255),
    lastUpdatedBy                BIGINT            NOT NULL,
    lastUpdate                   TIMESTAMP          DEFAULT CURRENT_TIMESTAMP NOT NULL,
    version                      BIGINT            NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: scholarship_academy_locations 
--

CREATE TABLE scholarship_academy_locations(
    id                   BIGINT    AUTO_INCREMENT,
    scholarshipId        BIGINT    NOT NULL,
    academyLocationId    BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: scholarship_account_details 
--

CREATE TABLE scholarship_account_details(
    id                        BIGINT         AUTO_INCREMENT,
    configControlAccountId    BIGINT,
    accountingConfigId        BIGINT,
    scholarshipId             BIGINT         NOT NULL,
    controlAccount            VARCHAR(10),
    lastUpdatedBy             BIGINT         NOT NULL,
    lastUpdate                TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: scholarship_awardees 
--

CREATE TABLE scholarship_awardees(
    id                   BIGINT            AUTO_INCREMENT,
    scholarshipId        BIGINT            NOT NULL,
    admissionId          BIGINT            NOT NULL,
    programId            BIGINT            NOT NULL,
    courseVariantId      BIGINT,
    personId             DECIMAL(0, 0)     NOT NULL,
    studentId            BIGINT            NOT NULL,
    scholarshipAmount    DECIMAL(18, 2)    NOT NULL,
    appliedOn            DATE              NOT NULL,
    awardedOn            DATE              NOT NULL,
    validFrom            DATE              NOT NULL,
    validUpto            DATE              NOT NULL,
    lastUpdate           TIMESTAMP         NOT NULL,
    lastUpdatedBy        BIGINT            NOT NULL,
    version              BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: scholarship_batches 
--

CREATE TABLE scholarship_batches(
    id               BIGINT       AUTO_INCREMENT,
    scholarshipId    BIGINT       NOT NULL,
    batchId          BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP    NOT NULL,
    lastUpdatedBy    BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: scholarship_courses 
--

CREATE TABLE scholarship_courses(
    id               BIGINT    NOT NULL,
    courseId         BIGINT    NOT NULL,
    scholarshipId    BIGINT    NOT NULL,
    lastUpdate       BIGINT    NOT NULL,
    lastUpdatedBy    BIGINT    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: scholarship_installments 
--

CREATE TABLE scholarship_installments(
    id                 BIGINT          AUTO_INCREMENT,
    scholarshipId      BIGINT          NOT NULL,
    periodName         VARCHAR(150)    NOT NULL,
    periodSequence     INT             NOT NULL,
    durationInMonth    INT             NOT NULL,
    amount             FLOAT           NOT NULL,
    lastUpdatedBy      BIGINT          NOT NULL,
    lastUpdate         TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: scholarship_organizations 
--

CREATE TABLE scholarship_organizations(
    id                  BIGINT          AUTO_INCREMENT,
    organizationName    VARCHAR(150)    NOT NULL,
    lastUpdatedBy       BIGINT          NOT NULL,
    lastUpdate          TIMESTAMP       NOT NULL,
    version             BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: scholarship_programs 
--

CREATE TABLE scholarship_programs(
    id               BIGINT       AUTO_INCREMENT,
    scholarshipId    BIGINT       NOT NULL,
    programId        BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP    NOT NULL,
    lastUpdatedBy    BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: scholarship_request_details 
--

CREATE TABLE scholarship_request_details(
    detailId             BIGINT          NOT NULL,
    scholarshipId        VARCHAR(100),
    scholarshipStatus    VARCHAR(20),
    awardDate            TIMESTAMP,
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: scholarship_transactions 
--

CREATE TABLE scholarship_transactions(
    id                      BIGINT          AUTO_INCREMENT,
    scholarshipAwardeeId    BIGINT          NOT NULL,
    transactionType         CHAR(3)         NOT NULL,
    transactionDate         DATETIME        NOT NULL,
    transactionAmount       FLOAT           NOT NULL,
    transactionNote         VARCHAR(255),
    instrumentNo            VARCHAR(50)     NOT NULL,
    instrumentDrawnOn       VARCHAR(150)    NOT NULL,
    instrumentDate          DATE            NOT NULL,
    voucherReference        VARCHAR(20),
    lastUpdate              TIMESTAMP,
    lastUpdatedBy           BIGINT          NOT NULL,
    version                 BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: search_aggregation_column 
--

CREATE TABLE search_aggregation_column(
    id                     BIGINT         AUTO_INCREMENT,
    searchTableId          BIGINT         NOT NULL,
    searchTableColumnId    BIGINT         NOT NULL,
    aliasName              VARCHAR(50)    NOT NULL,
    aggregateFunction      VARCHAR(20)    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: search_config 
--

CREATE TABLE search_config(
    id                           BIGINT          AUTO_INCREMENT,
    rootSearchConfigTableId      BIGINT,
    defaultSearchResultViewId    BIGINT,
    configCode                   VARCHAR(100)    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: search_config_table 
--

CREATE TABLE search_config_table(
    id                            BIGINT         AUTO_INCREMENT,
    searchTableId                 BIGINT         NOT NULL,
    relationLinkId                BIGINT,
    searchConfigId                BIGINT         NOT NULL,
    joinClause                    BIGINT,
    displayOrder                  BIGINT,
    alias                         VARCHAR(20),
    displayCode                   VARCHAR(50),
    whetherSubQuery               BIT,
    joinType                      VARCHAR(20),
    availableForCriteriaSearch    BIT             DEFAULT b'0' NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: search_criteria_operator 
--

CREATE TABLE search_criteria_operator(
    id                BIGINT         AUTO_INCREMENT,
    dataType          VARCHAR(20)    NOT NULL,
    operatorName      VARCHAR(50)    NOT NULL,
    displayCode       VARCHAR(50)    NOT NULL,
    operatorClause    VARCHAR(20),
    prefix            VARCHAR(20),
    postfix           VARCHAR(20),
    noOfOperands      INT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: search_implicit_criteria 
--

CREATE TABLE search_implicit_criteria(
    id                     BIGINT          AUTO_INCREMENT,
    searchConfigId         BIGINT          NOT NULL,
    searchConfigTableId    BIGINT          NOT NULL,
    searchTableColumnId    BIGINT,
    securityCode           VARCHAR(100),
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: search_result_enhancer 
--

CREATE TABLE search_result_enhancer(
    id                    BIGINT          AUTO_INCREMENT,
    searchConfigId        BIGINT,
    mergeKey              VARCHAR(100),
    resultColumnsAlias    VARCHAR(255),
    sqlQuery              TEXT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: search_result_formatter_params 
--

CREATE TABLE search_result_formatter_params(
    id                     BIGINT          AUTO_INCREMENT,
    formatParamKey         VARCHAR(200),
    whetherResultColumn    BIT,
    param                  VARCHAR(200),
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: search_result_view 
--

CREATE TABLE search_result_view(
    id                BIGINT          AUTO_INCREMENT,
    searchConfigId    BIGINT          NOT NULL,
    viewCode          VARCHAR(200),
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: search_result_view_column 
--

CREATE TABLE search_result_view_column(
    id                         BIGINT          AUTO_INCREMENT,
    searchConfigTableId        BIGINT          NOT NULL,
    searchTableColumnId        BIGINT          NOT NULL,
    searchAggregateColumnId    BIGINT,
    searchSQLGroupId           BIGINT,
    searchResultViewId         BIGINT          NOT NULL,
    resultKey                  VARCHAR(50),
    displayCode                VARCHAR(50),
    formatter                  VARCHAR(200),
    formatParams               BIGINT,
    sqlFunction                VARCHAR(50),
    visibility                 BIT              DEFAULT b'0' NOT NULL,
    displayOrder               INT             NOT NULL,
    whetherHyperlink           BIT              DEFAULT FALSE NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: search_result_view_sort 
--

CREATE TABLE search_result_view_sort(
    id                          BIGINT         AUTO_INCREMENT,
    searchResultViewId          BIGINT         NOT NULL,
    searchResultViewColumnId    BIGINT         NOT NULL,
    sortOrder                   VARCHAR(20),
    sortSequence                INT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: search_sql_group 
--

CREATE TABLE search_sql_group(
    id                    BIGINT         AUTO_INCREMENT,
    searchResultViewId    BIGINT         NOT NULL,
    groupName             VARCHAR(50)    NOT NULL,
    groupOrder            INT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: search_sql_groupby 
--

CREATE TABLE search_sql_groupby(
    id                          BIGINT    AUTO_INCREMENT,
    searchSQLGroupId            BIGINT    NOT NULL,
    searchResultViewColumnId    BIGINT    NOT NULL,
    groupByOrder                INT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: search_table 
--

CREATE TABLE search_table(
    id                 BIGINT          AUTO_INCREMENT,
    dbTableName        VARCHAR(50),
    i18nDisplayCode    VARCHAR(200),
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: search_table_column 
--

CREATE TABLE search_table_column(
    id                        BIGINT          AUTO_INCREMENT,
    searchTableId             BIGINT          NOT NULL,
    columnName                VARCHAR(50),
    displayCode               VARCHAR(200),
    virtualField              VARCHAR(20),
    dataType                  VARCHAR(20),
    criteriaPrivilegeLevel    VARCHAR(20),
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: search_table_relation 
--

CREATE TABLE search_table_relation(
    id             BIGINT          AUTO_INCREMENT,
    fromTableId    BIGINT          NOT NULL,
    toTableId      BIGINT          NOT NULL,
    joinClause     VARCHAR(200)    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: seat_types 
--

CREATE TABLE seat_types(
    id                 BIGINT         AUTO_INCREMENT,
    seatCode           VARCHAR(10),
    seatName           VARCHAR(10),
    seatDescription    VARCHAR(30),
    lastUpdatedBy      BIGINT         NOT NULL,
    lastUpdate         TIMESTAMP      NOT NULL,
    version            BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: section_xfer_request_details 
--

CREATE TABLE section_xfer_request_details(
    detailId         BIGINT    NOT NULL,
    fromSectionId    BIGINT    NOT NULL,
    toSectionId      BIGINT    NOT NULL,
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: sections 
--

CREATE TABLE sections(
    id                 BIGINT         AUTO_INCREMENT,
    sectionCode        VARCHAR(25),
    sectionRule        VARCHAR(25),
    alternateName      VARCHAR(25),
    periodId           BIGINT,
    courseVariantId    BIGINT,
    roomId             BIGINT,
    minCapacity        INT,
    maxCapacity        INT,
    lastUpdatedBy      BIGINT         NOT NULL,
    lastUpdate         TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: selection_override 
--

CREATE TABLE selection_override(
    id                      BIGINT          AUTO_INCREMENT,
    selectStageId           BIGINT,
    whetherOverrideQuota    BIT             NOT NULL,
    whetherTransSeatType    BIT             NOT NULL,
    seatTypeId              BIGINT          NOT NULL,
    reasonForOverride       VARCHAR(255),
    overrideDate            DATE,
    approvedBy              BIGINT          NOT NULL,
    lastUpdatedBy           BIGINT          NOT NULL,
    lastUpdate              TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: selection_stage 
--

CREATE TABLE selection_stage(
    id                    BIGINT          AUTO_INCREMENT,
    stageName             VARCHAR(35),
    remark                VARCHAR(255),
    validTill             DATE,
    stageStatus           INT,
    whetherUserDefined    BIT             NOT NULL,
    lastUpdatedBy         BIGINT          NOT NULL,
    lastUpdate            TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: seq_academy_location 
--

CREATE TABLE seq_academy_location(
    id                   BIGINT       AUTO_INCREMENT,
    academyLocationId    BIGINT,
    evaluationPlanId     BIGINT,
    programBatchId       BIGINT,
    sequenceId           BIGINT,
    lastUpdatedBy        BIGINT       NOT NULL,
    lastUpdate           TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: sequence_header 
--

CREATE TABLE sequence_header(
    id               BIGINT         AUTO_INCREMENT,
    sequenceName     VARCHAR(10),
    sequenceCode     VARCHAR(10),
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: service 
--

CREATE TABLE service(
    id                    BIGINT         AUTO_INCREMENT,
    serviceName           VARCHAR(10),
    serviceDescription    VARCHAR(18),
    lastUpdatedBy         BIGINT,
    lastUpdate            TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: service_request 
--

CREATE TABLE service_request(
    id                    BIGINT           AUTO_INCREMENT,
    userId                BIGINT,
    facultyId             BIGINT,
    requestBy             BIGINT,
    requestDate           DATE,
    requestStatus         BIT              NOT NULL,
    remark                VARCHAR(255),
    requestFollowUpId     BIGINT,
    requestReason         VARCHAR(255),
    executionRequestId    BIGINT,
    personId              DECIMAL(0, 0)    NOT NULL,
    studentId             BIGINT           NOT NULL,
    lastUpdatedBy         BIGINT           NOT NULL,
    lastUpdate            TIMESTAMP         DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: service_request_details 
--

CREATE TABLE service_request_details(
    id                  BIGINT          AUTO_INCREMENT,
    whetherDeleted      BIT             NOT NULL,
    lastUpdatedBy       BIGINT          NOT NULL,
    lastUpdate          TIMESTAMP       NOT NULL,
    version             BIGINT          NOT NULL,
    serviceRequestId    BIGINT          NOT NULL,
    remarks             VARCHAR(255),
    requestDate         TIMESTAMP,
    requesterType       VARCHAR(20),
    enteredByUserId     BIGINT          NOT NULL,
    requesterUserId     BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: service_request_documents 
--

CREATE TABLE service_request_documents(
    id                  BIGINT          AUTO_INCREMENT,
    whetherDeleted      BIT             NOT NULL,
    lastUpdatedBy       BIGINT          NOT NULL,
    lastUpdate          TIMESTAMP       NOT NULL,
    documentUrl         VARCHAR(255),
    serviceRequestId    BIGINT          NOT NULL,
    documentId          BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: service_request_settings 
--

CREATE TABLE service_request_settings(
    id                        BIGINT          AUTO_INCREMENT,
    sla                       INT,
    serviceRequestType        VARCHAR(100)     DEFAULT NULL,
    serviceRequestCategory    VARCHAR(100),
    billingPreference         VARCHAR(50),
    whetherAutoApprove        BIT,
    whetherFeeApplicable      BIT,
    whetherDeleted            BIT             NOT NULL,
    lastUpdatedBy             BIGINT          NOT NULL,
    lastUpdate                TIMESTAMP       NOT NULL,
    version                   BIGINT          NOT NULL,
    feeHeadId                 BIGINT,
    requestTypeId             BIGINT          NOT NULL,
    academyLocationId         BIGINT          NOT NULL,
    defaultAssigneeUserId     BIGINT,
    defaultApproverUserId     BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: service_requests 
--

CREATE TABLE service_requests(
    id                         BIGINT          AUTO_INCREMENT,
    type                       VARCHAR(20),
    dueDate                    TIMESTAMP,
    whetherWithdrawn           BIT,
    whetherDeleted             BIT             NOT NULL,
    lastUpdatedBy              BIGINT          NOT NULL,
    lastUpdate                 TIMESTAMP       NOT NULL,
    name                       VARCHAR(100),
    requestId                  VARCHAR(100),
    version                    BIGINT          NOT NULL,
    status                     VARCHAR(20),
    serviceRequestSettingId    BIGINT          NOT NULL,
    detailId                   BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: service_sw_request_details 
--

CREATE TABLE service_sw_request_details(
    detailId         BIGINT       NOT NULL,
    validFromDate    TIMESTAMP,
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: session_attedance 
--

CREATE TABLE session_attedance(
    id                      BIGINT       AUTO_INCREMENT,
    courseTopicSessionId    BIGINT,
    dateOfAttendance        DATE,
    whetherCompleteDay      BIT,
    lastUpdatedBy           BIGINT       NOT NULL,
    lastUpdate              TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: slctn_process 
--

CREATE TABLE slctn_process(
    id                 BIGINT          AUTO_INCREMENT,
    name               VARCHAR(100),
    remark             VARCHAR(255),
    quotaTypeRemark    VARCHAR(255),
    lastUpdatedBy      BIGINT          NOT NULL,
    lastUpdate         TIMESTAMP,
    version            BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: slctn_process_quota_type 
--

CREATE TABLE slctn_process_quota_type(
    id                    BIGINT       AUTO_INCREMENT,
    selectionProcessId    BIGINT       NOT NULL,
    quotaTypeId           BIGINT,
    lastUpdatedBy         BIGINT       NOT NULL,
    lastUpdate            TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: slctn_process_stage 
--

CREATE TABLE slctn_process_stage(
    id                           BIGINT          AUTO_INCREMENT,
    stageOrder                   BIGINT,
    stageId                      BIGINT,
    selectionProcessId           BIGINT          NOT NULL,
    validTill                    DATETIME,
    status                       BIT             NOT NULL,
    committeeApprovalRequired    BIT             NOT NULL,
    expNumberOfDays              INT,
    remark                       VARCHAR(255),
    lastUpdatedBy                BIGINT          NOT NULL,
    lastUpdate                   TIMESTAMP       NOT NULL,
    version                      BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: slctn_process_stage_eval_param 
--

CREATE TABLE slctn_process_stage_eval_param(
    id                              BIGINT          AUTO_INCREMENT,
    selectionProcessStageId         BIGINT,
    evaluationType                  VARCHAR(20),
    whetherAutomatic                BIT             NOT NULL,
    includePrevsStagePerformance    BIT             NOT NULL,
    ruleForGradeTomark              VARCHAR(100),
    remark                          VARCHAR(255),
    lastUpdatedBy                   BIGINT          NOT NULL,
    lastUpdate                      TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    version                         BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: slctn_stage_cndtnl_marks 
--

CREATE TABLE slctn_stage_cndtnl_marks(
    id                  BIGINT          AUTO_INCREMENT,
    stageEvalParamId    BIGINT          NOT NULL,
    marks               INT,
    rule                VARCHAR(100)    NOT NULL,
    ruleDescription     VARCHAR(255),
    lastUpdatedBy       BIGINT          NOT NULL,
    lastUpdate          TIMESTAMP       NOT NULL,
    version             BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: slctn_stage_documents 
--

CREATE TABLE slctn_stage_documents(
    id                         BIGINT          AUTO_INCREMENT,
    selectionProcessStageId    BIGINT,
    documentId                 BIGINT,
    documentFor                VARCHAR(100),
    rule                       VARCHAR(100),
    remark                     VARCHAR(255),
    lastUpdatedBy              BIGINT          NOT NULL,
    lastUpdate                 TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    version                    BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: slctn_stage_eval_prm_weightage 
--

CREATE TABLE slctn_stage_eval_prm_weightage(
    id                     BIGINT            AUTO_INCREMENT,
    stageEvalParamId       BIGINT,
    evaluationParameter    VARCHAR(100)      NOT NULL,
    weightage              DECIMAL(18, 5),
    lastUpdatedBy          BIGINT            NOT NULL,
    lastUpdate             TIMESTAMP         NOT NULL,
    version                BIGINT            NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: slctn_stage_prvs_weightage 
--

CREATE TABLE slctn_stage_prvs_weightage(
    id                  BIGINT            AUTO_INCREMENT,
    stageEvalParamId    BIGINT            NOT NULL,
    previousStageId     BIGINT            NOT NULL,
    weightage           DECIMAL(18, 5),
    lastUpdatedBy       BIGINT            NOT NULL,
    lastUpdate          TIMESTAMP         NOT NULL,
    version             BIGINT            NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: slctn_stage_resource_plan 
--

CREATE TABLE slctn_stage_resource_plan(
    id                         BIGINT          AUTO_INCREMENT,
    selectionProcessStageId    BIGINT          NOT NULL,
    resourceTypeId             BIGINT,
    resourceGroup              VARCHAR(50),
    resourceQuantity           INT             NOT NULL,
    resourseCategory           VARCHAR(35),
    remark                     VARCHAR(255),
    lastUpdatedBy              BIGINT          NOT NULL,
    lastUpdate                 TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: specialization 
--

CREATE TABLE specialization(
    id                           BIGINT          AUTO_INCREMENT,
    specializationCode           VARCHAR(10),
    specializationName           VARCHAR(100),
    specializationDescription    VARCHAR(255),
    lastUpdatedBy                BIGINT          NOT NULL,
    lastUpdate                   TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: specialization_group 
--

CREATE TABLE specialization_group(
    id                  BIGINT       AUTO_INCREMENT,
    specializationId    BIGINT,
    courseGroupId       BIGINT,
    lastUpdatedBy       BIGINT       NOT NULL,
    lastUpdate          TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: sponsor_account_details 
--

CREATE TABLE sponsor_account_details(
    id                        BIGINT         AUTO_INCREMENT,
    configControlAccountId    BIGINT,
    accountingConfigId        BIGINT,
    controlAccount            VARCHAR(10),
    lastUpdatedBy             BIGINT         NOT NULL,
    lastUpdate                TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: sponsor_contacts 
--

CREATE TABLE sponsor_contacts(
    id               BIGINT          AUTO_INCREMENT,
    addressId        BIGINT          NOT NULL,
    sponsorId        BIGINT,
    contactName      VARCHAR(100)    NOT NULL,
    designation      VARCHAR(25)     NOT NULL,
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: sponsor_receipt_disbursments 
--

CREATE TABLE sponsor_receipt_disbursments(
    id                   BIGINT          AUTO_INCREMENT,
    transactionType      CHAR(1),
    transactionDate      DATE,
    voucherReference     VARCHAR(10),
    transactionAmount    FLOAT,
    transactionNote      VARCHAR(255),
    instrumentNo         VARCHAR(10),
    instrumentDate       DATE,
    instrumentDrawnOn    VARCHAR(18),
    lastUpdatedBy        BIGINT          NOT NULL,
    lastUpdate           TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: sponsors 
--

CREATE TABLE sponsors(
    id                      BIGINT          AUTO_INCREMENT,
    sponsorName             VARCHAR(150)    NOT NULL,
    sponsorshipCode         VARCHAR(15),
    sponsotStatus           BIT             NOT NULL,
    consolidationAllowed    BIT,
    sponsorType             CHAR(3),
    lastUpdatedBy           BIGINT          NOT NULL,
    lastUpdate              TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    version                 BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: sponsorship_awarded_items 
--

CREATE TABLE sponsorship_awarded_items(
    id                       BIGINT       NOT NULL,
    sponsorshipAwardeeId     CHAR(10)     NOT NULL,
    feePlanId                BIGINT       NOT NULL,
    feeStageHeadConfigId     BIGINT       NOT NULL,
    feeHeadId                BIGINT       NOT NULL,
    amountType               CHAR(1),
    amount                   FLOAT,
    sponsorshipPercentage    FLOAT,
    lastUpdatedBy            BIGINT       NOT NULL,
    lastUpdate               TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: sponsorship_awardees 
--

CREATE TABLE sponsorship_awardees(
    id               CHAR(10)         NOT NULL,
    sponsorId        BIGINT           NOT NULL,
    admissionId      BIGINT           NOT NULL,
    personId         DECIMAL(0, 0)    NOT NULL,
    studentId        BIGINT           NOT NULL,
    awardedDate      DATE             NOT NULL,
    version          BIGINT           NOT NULL,
    lastUpdate       TIMESTAMP        NOT NULL,
    lastUpdatedBy    BIGINT           NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: srvc_sw_req_detail_s_services 
--

CREATE TABLE srvc_sw_req_detail_s_services(
    serviceSWRequestDetailId    BIGINT    NOT NULL,
    subscribedServiceId         BIGINT    NOT NULL,
    PRIMARY KEY (serviceSWRequestDetailId, subscribedServiceId)
)
;



-- 
-- TABLE: srvc_sw_req_detail_w_services 
--

CREATE TABLE srvc_sw_req_detail_w_services(
    serviceSWRequestDetailId    BIGINT    NOT NULL,
    withdrawnServiceId          BIGINT    NOT NULL,
    PRIMARY KEY (serviceSWRequestDetailId, withdrawnServiceId)
)
;



-- 
-- TABLE: stage_resource_plan 
--

CREATE TABLE stage_resource_plan(
    id                      BIGINT          AUTO_INCREMENT,
    processStageId          BIGINT,
    resourceCategoryType    VARCHAR(10),
    resourceTypeId          BIGINT,
    employeeId              BIGINT,
    responsibility          VARCHAR(15),
    fromDate                DATE,
    tillDate                DATE,
    timeFrom                CHAR(10),
    timeTo                  CHAR(10),
    remark                  VARCHAR(255),
    lastUpdatedBy           BIGINT          NOT NULL,
    lastUpdate              TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: standard_master 
--

CREATE TABLE standard_master(
    id               BIGINT          AUTO_INCREMENT,
    childMaster      BIGINT,
    tableName        VARCHAR(255)    NOT NULL,
    masterName       VARCHAR(255)    NOT NULL,
    whetherChild     BIT,
    whetherParent    BIT,
    droolsAgenda     VARCHAR(255),
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: standard_master_items 
--

CREATE TABLE standard_master_items(
    id                   BIGINT          AUTO_INCREMENT,
    dbFieldName          VARCHAR(255)    NOT NULL,
    fieldLabel           VARCHAR(255)    NOT NULL,
    standardMasterId     BIGINT          NOT NULL,
    fieldType            VARCHAR(50)     NOT NULL,
    diaplayOrder         INT,
    whetherForeignKey    BIT,
    fkTable              VARCHAR(255),
    fkFieldName          VARCHAR(255),
    fkDisplayField       VARCHAR(255),
    whetherShortCode     BIT,
    whetherReadOnly      BIT,
    wheherNullable       BIT             NOT NULL,
    lastUpdatedBy        BIGINT          NOT NULL,
    lastUpdate           TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: structure_leaf_node 
--

CREATE TABLE structure_leaf_node(
    id                       BIGINT          AUTO_INCREMENT,
    structureLevelThreeId    BIGINT,
    questionNumberSubPart    VARCHAR(4),
    instructionText          VARCHAR(255),
    whetherCompulsory        BIT,
    status                   BIT             NOT NULL,
    marks                    INT,
    complexity               CHAR(1),
    negativeMarks            VARCHAR(3),
    lastUpdatedBy            BIGINT          NOT NULL,
    lastUpdate               TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: structure_level_one 
--

CREATE TABLE structure_level_one(
    id                        BIGINT          AUTO_INCREMENT,
    questionPaperStructId     BIGINT,
    instructionText           VARCHAR(255),
    instructionDisplayText    VARCHAR(100),
    optionGroupMarks          INT,
    questionNo                INT,
    lastUpdatedBy             BIGINT          NOT NULL,
    lastUpdate                TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: structure_level_three 
--

CREATE TABLE structure_level_three(
    id                     BIGINT          AUTO_INCREMENT,
    structureLevelTwoId    BIGINT,
    qNumberPart            VARCHAR(4),
    instructionText        VARCHAR(255),
    whetherCompulsory      CHAR(1),
    status                 BIT             NOT NULL,
    marks                  INT,
    complexity             CHAR(1),
    negativeMarks          VARCHAR(3),
    lastUpdatedBy          BIGINT          NOT NULL,
    lastUpdate             TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: structure_level_two 
--

CREATE TABLE structure_level_two(
    id                     BIGINT          AUTO_INCREMENT,
    structureLevelOneId    BIGINT,
    questionNumber         VARCHAR(5),
    instructionText        VARCHAR(255),
    whetherCompulsory      BIT,
    status                 BIT             NOT NULL,
    marks                  INT,
    complexity             CHAR(1),
    negativeMarks          VARCHAR(3),
    lastUpdatedBy          BIGINT          NOT NULL,
    lastUpdate             TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: stu_account_receipts 
--

CREATE TABLE stu_account_receipts(
    id                    BIGINT            AUTO_INCREMENT,
    debitCredit           CHAR(1),
    documentNo            INT,
    documentDate          DATE,
    payMode               CHAR(1),
    instrumentNo          VARCHAR(18),
    instrumentDate        DATE,
    instrumentAmt         DECIMAL(18, 2),
    instrumentDrawnOn     VARCHAR(18),
    ourBankAccount        VARCHAR(20),
    personId              DECIMAL(0, 0)     NOT NULL,
    studentId             BIGINT            NOT NULL,
    narration             VARCHAR(255),
    currencyId            BIGINT,
    currencyBaseId        BIGINT,
    currencyBaseAmount    DECIMAL(18, 2),
    accountDescription    VARCHAR(255),
    lastUpdatedBy         BIGINT            NOT NULL,
    lastUpdate            TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_account 
--

CREATE TABLE student_account(
    id                              BIGINT         AUTO_INCREMENT,
    accountConfigId                 BIGINT,
    studentControlAccountPerm       VARCHAR(10),
    studentControlAccountTemp       VARCHAR(10),
    individualControlAccountFlag    BIT,
    lastUpdatedBy                   BIGINT         NOT NULL,
    lastUpdate                      TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_attendance 
--

CREATE TABLE student_attendance(
    id                      BIGINT         AUTO_INCREMENT,
    batchId                 BIGINT,
    whetherCourseSection    BIT            NOT NULL,
    admissionId             BIGINT,
    programId               BIGINT,
    courseId                BIGINT,
    sectionId               BIGINT,
    courseVariantId         BIGINT,
    dateOfAttendance        DATE,
    whetherCompleteDay      BIT,
    attendanceType          VARCHAR(35),
    lastUpdatedBy           BIGINT         NOT NULL,
    lastUpdate              TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_attendance_details 
--

CREATE TABLE student_attendance_details(
    id                BIGINT         AUTO_INCREMENT,
    attendanceId      BIGINT,
    whetherPresent    CHAR(3),
    timeFrom          VARCHAR(10),
    timeTo            VARCHAR(10),
    lastUpdatedBy     BIGINT         NOT NULL,
    lastUpdate        TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_cert_request 
--

CREATE TABLE student_cert_request(
    id                    BIGINT       AUTO_INCREMENT,
    serviceRequestId      BIGINT,
    certificateId         BIGINT,
    requestFollowUpId     BIGINT,
    requestIsOrginal      BIT          NOT NULL,
    executionRequestId    BIGINT,
    feePlanId             BIGINT,
    lastUpdatedBy         BIGINT,
    lastUpdate            TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_course_enrollment 
--

CREATE TABLE student_course_enrollment(
    id                            BIGINT         AUTO_INCREMENT,
    whetherCourseExempted         BIT             DEFAULT 0,
    whetherFailed                 BIT             DEFAULT 0,
    marksObtained                 INT             DEFAULT 0,
    whetherPassed                 BIT             DEFAULT 0,
    admissionId                   BIGINT,
    courseVarientId               BIGINT,
    sectionId                     BIGINT,
    programBatchPeriodConfigId    BIGINT,
    sectionType                   VARCHAR(15),
    whetherOptional               BIT            NOT NULL,
    whetherAudit                  BIT            NOT NULL,
    whetherSpecialized            BIT            NOT NULL,
    enrollmentDate                TIMESTAMP,
    lastUpdatedBy                 BIGINT         NOT NULL,
    lastUpdate                    TIMESTAMP      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_distribution_list 
--

CREATE TABLE student_distribution_list(
    id                    BIGINT           AUTO_INCREMENT,
    approveReason         VARCHAR(255),
    approveDate           DATE,
    approveFlag           BIT,
    distributionListId    BIGINT,
    personId              DECIMAL(0, 0)    NOT NULL,
    studentId             BIGINT           NOT NULL,
    lastUpdatedBy         BIGINT,
    lastUpdate            DATETIME         NOT NULL,
    approvedBy            BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_exam 
--

CREATE TABLE student_exam(
    id               BIGINT         AUTO_INCREMENT,
    admissionId      BIGINT,
    applicationId    BIGINT,
    examPassed       VARCHAR(35),
    examResult       VARCHAR(8)     NOT NULL,
    conductedBy      BIGINT,
    passingYear      DATE,
    studentType      VARCHAR(35),
    enrollmentNo     VARCHAR(10),
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_exam_subject 
--

CREATE TABLE student_exam_subject(
    id               BIGINT           AUTO_INCREMENT,
    studentExamId    BIGINT,
    personId         DECIMAL(0, 0)    NOT NULL,
    studentId        BIGINT           NOT NULL,
    subjectsName     VARCHAR(30),
    marksGrades      VARCHAR(10),
    lastUpdatedBy    BIGINT           NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_faculty_attendance 
--

CREATE TABLE student_faculty_attendance(
    id               BIGINT       AUTO_INCREMENT,
    facultyId        BIGINT       NOT NULL,
    lastUpdatedBy    BIGINT       NOT NULL,
    lastUpdate       TIMESTAMP    NOT NULL,
    personId         BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_feedback 
--

CREATE TABLE student_feedback(
    id                 BIGINT           AUTO_INCREMENT,
    feedbackType       VARCHAR(10),
    courseId           BIGINT,
    personId           DECIMAL(0, 0)    NOT NULL,
    feedbackGivenBy    BIGINT           NOT NULL,
    studentId          BIGINT           NOT NULL,
    feedbackGivenTo    BIGINT,
    status             INT,
    completionDate     DATE,
    lastUpdatedBy      BIGINT           NOT NULL,
    lastUpdate         TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_feedback_details 
--

CREATE TABLE student_feedback_details(
    id                   BIGINT       AUTO_INCREMENT,
    questionnaireId      BIGINT,
    studentFeedbackId    BIGINT,
    lastUpdatedBy        BIGINT       NOT NULL,
    lastUpdate           TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_hw_file_download 
--

CREATE TABLE student_hw_file_download(
    id                  BIGINT          AUTO_INCREMENT,
    studentHwGroupId    BIGINT,
    hWFile              VARCHAR(100),
    lastUpdatedBy       BIGINT          NOT NULL,
    lastUpdate          TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_hw_file_upload 
--

CREATE TABLE student_hw_file_upload(
    id                  BIGINT          AUTO_INCREMENT,
    studentHwGroupId    BIGINT,
    hWFile              VARCHAR(100),
    lastUpdatedBy       BIGINT          NOT NULL,
    lastUpdate          TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_pdc 
--

CREATE TABLE student_pdc(
    id               BIGINT          AUTO_INCREMENT,
    admissionId      BIGINT,
    feePlanId        BIGINT,
    pdcDate          DATE,
    drawnOn          VARCHAR(100),
    installmentNo    INT,
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_promotions 
--

CREATE TABLE student_promotions(
    id                   BIGINT          AUTO_INCREMENT,
    admissionId          BIGINT,
    reasonForPromoton    VARCHAR(255),
    remark               VARCHAR(255),
    status               CHAR(1),
    lastUpdatedBy        BIGINT          NOT NULL,
    lastUpdate           TIMESTAMP       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_revaluation 
--

CREATE TABLE student_revaluation(
    mgmtGroupTypeId    BIGINT       AUTO_INCREMENT,
    employeeId         BIGINT,
    revaluationDate    DATE,
    lastUpdatedBy      BIGINT       NOT NULL,
    lastUpdate         TIMESTAMP    NOT NULL,
    requestId          BIGINT,
    PRIMARY KEY (mgmtGroupTypeId)
)
;



-- 
-- TABLE: student_stakeholders 
--

CREATE TABLE student_stakeholders(
    id               BIGINT           AUTO_INCREMENT,
    applicationId    BIGINT,
    parentType       CHAR(1)          NOT NULL,
    firstName        VARCHAR(25),
    lastName         VARCHAR(25),
    middleName       VARCHAR(25),
    status           CHAR(1),
    occupation       VARCHAR(18),
    relationship     VARCHAR(18),
    incomeId         BIGINT,
    employeeId       BIGINT,
    maritalStatus    CHAR(1),
    salutationId     BIGINT,
    gender           CHAR(8),
    bloodGroup       VARCHAR(8),
    lastUpdatedBy    BIGINT           NOT NULL,
    lastUpdate       TIMESTAMP,
    studentId        BIGINT           NOT NULL,
    personId         DECIMAL(0, 0)    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_stakeholders_adress 
--

CREATE TABLE student_stakeholders_adress(
    id                      BIGINT       AUTO_INCREMENT,
    studentStakeholderId    BIGINT,
    addressId               BIGINT,
    lastUpdatedBy           BIGINT       NOT NULL,
    lastUpdate              TIMESTAMP    NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: student_trans_terminate 
--

CREATE TABLE student_trans_terminate(
    id                    BIGINT           AUTO_INCREMENT,
    whetherTermination    BIT              NOT NULL,
    whetherTransfer       BIT              NOT NULL,
    whetherDebarment      BIT              NOT NULL,
    reason                VARCHAR(255),
    remark                VARCHAR(255),
    studentRemark         VARCHAR(255),
    initiatedBy           BIGINT,
    requestFollowUpId     BIGINT,
    executionRequestId    BIGINT,
    programId             BIGINT,
    courseId              BIGINT,
    personId              DECIMAL(0, 0)    NOT NULL,
    studentId             BIGINT           NOT NULL,
    debarmentFrom         DATE,
    debarmentTo           DATE,
    lastUpdatedBy         BIGINT           NOT NULL,
    lastUpdate            TIMESTAMP         DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: students 
--

CREATE TABLE students(
    personId                      BIGINT          NOT NULL,
    userId                        BIGINT          NOT NULL,
    studentCode                   VARCHAR(255)    NOT NULL,
    whetherAppliedForPlacement    BIT              DEFAULT FALSE NOT NULL,
    whetherMidtermJoinee          BIT              DEFAULT FALSE NOT NULL,
    PRIMARY KEY (personId)
)
;



-- 
-- TABLE: subject_mark_info 
--

CREATE TABLE subject_mark_info(
    id                    BIGINT           AUTO_INCREMENT,
    educationHistoryId    BIGINT           NOT NULL,
    marks                 DECIMAL(0, 0)    NOT NULL,
    subject               VARCHAR(255)     NOT NULL,
    whetherDeleted        BIT               DEFAULT FALSE NOT NULL,
    version               DECIMAL(0, 0)    NOT NULL,
    lastUpdate            TIMESTAMP        NOT NULL,
    lastUpdatedBy         BIGINT           NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: subject_mark_to_be_changed 
--

CREATE TABLE subject_mark_to_be_changed(
    id                   BIGINT         AUTO_INCREMENT,
    subject              VARCHAR(20),
    marks                INT,
    lastUpdatedBy        BIGINT         NOT NULL,
    lastUpdate           TIMESTAMP,
    dataToBeChangedId    BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: supervisor_allocation 
--

CREATE TABLE supervisor_allocation(
    id                        BIGINT       AUTO_INCREMENT,
    userId                    BIGINT,
    groupDateBatchCenterId    BIGINT,
    lastUpdatedBy             BIGINT,
    lastUpdate                TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: survey 
--

CREATE TABLE survey(
    id                    BIGINT          AUTO_INCREMENT,
    surveyCode            VARCHAR(10),
    surveyName            VARCHAR(100),
    surveyDescription     VARCHAR(255),
    surveyCreatedBy       BIGINT,
    whetherAnonymous      BIT             NOT NULL,
    purpose               VARCHAR(100),
    relatedTo             VARCHAR(35),
    programId             BIGINT,
    surveyStartDate       DATE,
    surveyEndDate         DATE,
    surveyStatus          BIT             NOT NULL,
    specificEmail         VARCHAR(100),
    specificCellNumber    VARCHAR(15),
    remark                VARCHAR(255),
    status                VARCHAR(10),
    lastUpdatedBy         BIGINT          NOT NULL,
    lastUpdate            TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: survey_distribution_list 
--

CREATE TABLE survey_distribution_list(
    id                 BIGINT         AUTO_INCREMENT,
    surveyId           BIGINT,
    userId             BIGINT,
    personId           BIGINT         NOT NULL,
    facultyId          BIGINT         NOT NULL,
    userType           VARCHAR(10),
    specificEmailId    VARCHAR(30),
    specificCellNo     VARCHAR(50),
    lastUpdatedBy      BIGINT         NOT NULL,
    lastUpdate         TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: survey_question_options 
--

CREATE TABLE survey_question_options(
    id                 BIGINT          AUTO_INCREMENT,
    questionId         INT,
    questionOptions    VARCHAR(100),
    lastUpdatedBy      BIGINT          NOT NULL,
    lastUpdate         TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: survey_questions 
--

CREATE TABLE survey_questions(
    id                         INT             AUTO_INCREMENT,
    surveySectionQuestionId    BIGINT,
    questionCode               VARCHAR(6),
    question                   VARCHAR(255),
    lastUpdatedBy              BIGINT          NOT NULL,
    lastUpdate                 TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: survey_section 
--

CREATE TABLE survey_section(
    id               BIGINT          AUTO_INCREMENT,
    sectionTitle     VARCHAR(100),
    surveyId         BIGINT,
    instruction      VARCHAR(255),
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: survey_section_question 
--

CREATE TABLE survey_section_question(
    id                 BIGINT       AUTO_INCREMENT,
    surveyId           BIGINT,
    surveySectionId    BIGINT,
    questionType       CHAR(1),
    lastUpdatedBy      BIGINT       NOT NULL,
    lastUpdate         TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: system_menu 
--

CREATE TABLE system_menu(
    id                    BIGINT          AUTO_INCREMENT,
    featurePrivilegeId    BIGINT,
    portalId              BIGINT,
    parentMenuId          BIGINT,
    displayCode           VARCHAR(200)    NOT NULL,
    displayOrder          INT,
    iconCls               VARCHAR(50),
    lastUpdate            TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    lastUpdatedBy         BIGINT          NOT NULL,
    launchView            VARCHAR(50),
    menuColorCls          VARCHAR(50),
    version               BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: system_modules 
--

CREATE TABLE system_modules(
    id               BIGINT          AUTO_INCREMENT,
    displayCode      VARCHAR(150)    NOT NULL,
    moduleName       VARCHAR(50)     NOT NULL,
    portalId         BIGINT          NOT NULL,
    parentId         BIGINT,
    moduleDesc       VARCHAR(35),
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP        DEFAULT CURRENT_TIMESTAMP NOT NULL,
    version          BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: system_reports 
--

CREATE TABLE system_reports(
    id               BIGINT         AUTO_INCREMENT,
    reportName       VARCHAR(35),
    moduleName       VARCHAR(35),
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    version          BIGINT         NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: termination_reasons 
--

CREATE TABLE termination_reasons(
    id               BIGINT          NOT NULL,
    itemCode         VARCHAR(100),
    itemValue        VARCHAR(255),
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: termination_request_details 
--

CREATE TABLE termination_request_details(
    detailId               BIGINT          NOT NULL,
    studentRemark          VARCHAR(255),
    programId              BIGINT          NOT NULL,
    terminationReasonId    BIGINT          NOT NULL,
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: topic_depth 
--

CREATE TABLE topic_depth(
    id               BIGINT          AUTO_INCREMENT,
    depthType        VARCHAR(100),
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       DATETIME        NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: training_category 
--

CREATE TABLE training_category(
    id               BIGINT          AUTO_INCREMENT,
    itemCode         VARCHAR(255)    NOT NULL,
    itemValue        VARCHAR(255)    NOT NULL,
    lastUpdate       TIMESTAMP       NOT NULL,
    lastUpdatedBy    BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: transfer_reasons 
--

CREATE TABLE transfer_reasons(
    id               BIGINT          NOT NULL,
    itemCode         VARCHAR(255),
    itemValue        VARCHAR(255),
    lastUpdatedBy    BIGINT          NOT NULL,
    lastUpdate       TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: transfer_request_details 
--

CREATE TABLE transfer_request_details(
    detailId            BIGINT    NOT NULL,
    programId           BIGINT    NOT NULL,
    transferReasonId    BIGINT    NOT NULL,
    PRIMARY KEY (detailId)
)
;



-- 
-- TABLE: user_acad_loc_role_privileges 
--

CREATE TABLE user_acad_loc_role_privileges(
    id                    BIGINT       AUTO_INCREMENT,
    userAcadLocationId    BIGINT       NOT NULL,
    rolePrivilegeId       BIGINT       NOT NULL,
    lastUpdatedBy         BIGINT       NOT NULL,
    lastUpdate            TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    version               BIGINT       NOT NULL,
    lastUpadtedBy         BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: user_acad_loc_roles 
--

CREATE TABLE user_acad_loc_roles(
    id                    BIGINT       AUTO_INCREMENT,
    userAcadLocationId    BIGINT,
    roleId                BIGINT,
    fromDate              DATE,
    tillDate              DATE,
    lastUpdatedBy         BIGINT       NOT NULL,
    lastUpdate            TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    version               BIGINT       NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: user_academy_locations 
--

CREATE TABLE user_academy_locations(
    id                   BIGINT       AUTO_INCREMENT,
    version              INT,
    userId               BIGINT,
    academyLocationId    BIGINT,
    whetherPrimary       BIT          NOT NULL,
    fromDate             DATE,
    tillDate             DATE,
    lastUpdatedBy        BIGINT,
    lastUpdate           TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: user_account_locked 
--

CREATE TABLE user_account_locked(
    id              BIGINT          AUTO_INCREMENT,
    userId          BIGINT          NOT NULL,
    lockedDate      TIMESTAMP       NOT NULL,
    releaseDate     TIMESTAMP,
    lockedReason    VARCHAR(250),
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: user_cf_data 
--

CREATE TABLE user_cf_data(
    id                       BIGINT          AUTO_INCREMENT,
    userId                   BIGINT,
    entityFieldMetaDataId    BIGINT,
    data                     VARCHAR(255),
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: user_courses 
--

CREATE TABLE user_courses(
    id               BIGINT       AUTO_INCREMENT,
    userProgramId    BIGINT,
    courseGroupId    BIGINT,
    courseId         BIGINT,
    lastUpdatedBy    BIGINT,
    lastUpdate       TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: user_groups 
--

CREATE TABLE user_groups(
    id               BIGINT         AUTO_INCREMENT,
    userGroupName    VARCHAR(50)    NOT NULL,
    lastUpdate       TIMESTAMP       DEFAULT CURRENT_TIMESTAMP,
    lastUpdatedBy    BIGINT,
    version          BIGINT,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: user_login 
--

CREATE TABLE user_login(
    id               BIGINT         AUTO_INCREMENT,
    userId           BIGINT,
    userName         VARCHAR(35),
    ipAddress        VARCHAR(15)    NOT NULL,
    loginTime        DATETIME       NOT NULL,
    logoutTime       DATETIME       NOT NULL,
    loginStatus      CHAR(1),
    noOfTries        INT,
    logoutStatus     CHAR(1),
    lastUpdatedBy    BIGINT         NOT NULL,
    lastUpdate       TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: user_login_history 
--

CREATE TABLE user_login_history(
    id                BIGINT          AUTO_INCREMENT,
    userId            BIGINT          NOT NULL,
    accessToken       VARCHAR(255),
    ipAddress         VARCHAR(50),
    loginTime         TIMESTAMP,
    logoutTime        TIMESTAMP,
    whetherTimeout    BIT             NOT NULL,
    timeSpent         DOUBLE,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: user_password_policy 
--

CREATE TABLE user_password_policy(
    id                              BIGINT       AUTO_INCREMENT,
    passwordMinLength               INT,
    passwordMaxLength               INT,
    minSpecialChars                 INT,
    minDigits                       INT          NOT NULL,
    alphabetsRequired               BIT          NOT NULL,
    upperCaseRequired               BIT          NOT NULL,
    minUpperCaseCount               DATETIME,
    lowerCaseRequired               BIT          NOT NULL,
    minLowerCaseCount               INT,
    preventPasswordReuse            BIT          NOT NULL,
    preventUsernamePart             BIT          NOT NULL,
    preventFirstCharAsDigit         BIT          NOT NULL,
    preventFirstCharAsSpecSymbol    BIT          NOT NULL,
    passwordNeverExpires            BIT          NOT NULL,
    maxPasswordAge                  INT,
    lockUotUser                     BIT          NOT NULL,
    lockedAttempts                  INT,
    automaticUnlockPassword         BIT          NOT NULL,
    lastUpdatedBy                   BIGINT,
    lastUpdate                      TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: user_privilege_overrides 
--

CREATE TABLE user_privilege_overrides(
    id                           BIGINT    AUTO_INCREMENT,
    userAcademyLocationRoleId    BIGINT    NOT NULL,
    featurePrivilegeId           BIGINT    NOT NULL,
    granted                      BIT       NOT NULL,
    version                      BIGINT    NOT NULL,
    lastUpdatedBy                BIGINT    NOT NULL,
    lastUpdate                   TIME      NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: user_programs 
--

CREATE TABLE user_programs(
    id                   BIGINT       AUTO_INCREMENT,
    academyLocationId    BIGINT,
    programId            BIGINT,
    allPrograms          INT,
    allCourses           INT,
    lastUpdatedBy        BIGINT,
    lastUpdate           TIMESTAMP     DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: users 
--

CREATE TABLE users(
    id                     BIGINT          AUTO_INCREMENT,
    userGroupId            BIGINT          NOT NULL,
    code                   CHAR(10),
    salutationId           BIGINT,
    firstName              VARCHAR(20),
    middleName             VARCHAR(20),
    lastName               VARCHAR(20),
    shortName              VARCHAR(20),
    nameToBePrinted        VARCHAR(60),
    emailId                VARCHAR(50),
    status                 BIT,
    whetherInternal        BIT             NOT NULL,
    whetherSystemUser      BIT             NOT NULL,
    password               VARCHAR(100),
    salt                   VARCHAR(100),
    ipAddress              VARCHAR(30),
    lockedOn               TIMESTAMP,
    lockedStatus           BIT             NOT NULL,
    lockedReason           VARCHAR(100),
    noOfTimesLocked        INT             NOT NULL,
    noOfLoginFailed        INT              DEFAULT 0 NOT NULL,
    lastLockReleaseDate    TIMESTAMP,
    calendarId             BIGINT,
    departmentId           BIGINT,
    subDepartmentId        BIGINT,
    totalAutoLogout        BIGINT,
    whetherDeleted         BIT              DEFAULT 0 NOT NULL,
    totalLoginFailed       BIGINT,
    categoryField1         VARCHAR(15),
    categoryField2         VARCHAR(15),
    categoryField3         VARCHAR(15),
    categoryField4         VARCHAR(15),
    categoryField5         VARCHAR(15),
    lastUpdatedBy          BIGINT          NOT NULL,
    lastUpdate             TIMESTAMP,
    version                BIGINT          NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: users_system_usage_log 
--

CREATE TABLE users_system_usage_log(
    id              BIGINT       AUTO_INCREMENT,
    userId          BIGINT       NOT NULL,
    systemMenuId    BIGINT       NOT NULL,
    accessTime      TIMESTAMP,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: usertries 
--

CREATE TABLE usertries(
    id              BIGINT         AUTO_INCREMENT,
    userId          BIGINT,
    userName        VARCHAR(35),
    errorMessage    VARCHAR(35),
    lastUpdate      TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: vaccin_data_to_be_changed 
--

CREATE TABLE vaccin_data_to_be_changed(
    dataToBeChangedId    BIGINT          NOT NULL,
    name                 VARCHAR(255),
    purpose              VARCHAR(255),
    remarks              VARCHAR(255),
    date                 TIMESTAMP,
    PRIMARY KEY (dataToBeChangedId)
)
;



-- 
-- TABLE: vaccination_info 
--

CREATE TABLE vaccination_info(
    id                 BIGINT           AUTO_INCREMENT,
    personId           BIGINT           NOT NULL,
    name               VARCHAR(255)     NOT NULL,
    purpose            VARCHAR(255)     NOT NULL,
    vaccinationDate    DATE             NOT NULL,
    whetherDeleted     BIT               DEFAULT FALSE NOT NULL,
    remarks            VARCHAR(255)      DEFAULT NULL,
    version            DECIMAL(0, 0)    NOT NULL,
    lastUpdate         TIMESTAMP        NOT NULL,
    lastUpdatedBy      BIGINT           NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: work_data_to_be_changed 
--

CREATE TABLE work_data_to_be_changed(
    dataToBeChangedId    BIGINT          NOT NULL,
    duration             INT,
    whetherFullTime      BIT,
    employer             VARCHAR(255),
    designation          VARCHAR(100),
    department           VARCHAR(255),
    joiningDate          TIMESTAMP,
    workType             VARCHAR(20),
    experienceType       VARCHAR(100),
    remarks              VARCHAR(255),
    PRIMARY KEY (dataToBeChangedId)
)
;



-- 
-- TABLE: work_experience 
--

CREATE TABLE work_experience(
    id                 BIGINT           AUTO_INCREMENT,
    personId           BIGINT           NOT NULL,
    workType           VARCHAR(20)       DEFAULT NULL,
    experienceType     VARCHAR(20)      NOT NULL,
    department         VARCHAR(255)      DEFAULT NULL,
    designation        VARCHAR(255)     NOT NULL,
    employer           VARCHAR(255)     NOT NULL,
    duration           DECIMAL(0, 0)    NOT NULL,
    joiningDate        DATE             NOT NULL,
    remarks            VARCHAR(255)      DEFAULT NULL,
    whetherFullTime    BIT              NOT NULL,
    whetherDeleted     BIT               DEFAULT FALSE NOT NULL,
    version            DECIMAL(0, 0)    NOT NULL,
    lastUpdate         TIMESTAMP        NOT NULL,
    lastUpdatedBy      BIGINT           NOT NULL,
    PRIMARY KEY (id)
)
;



-- 
-- TABLE: acad_loc_purpose_setting 
--

ALTER TABLE acad_loc_purpose_setting ADD CONSTRAINT Refentity_setting98 
    FOREIGN KEY (entitySettingId)
    REFERENCES entity_setting(id)
;

ALTER TABLE acad_loc_purpose_setting ADD CONSTRAINT Refacademy_location_purpose130 
    FOREIGN KEY (academyLocationPurposeId)
    REFERENCES academy_location_purpose(id)
;

ALTER TABLE acad_loc_purpose_setting ADD CONSTRAINT Refusers309 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: academies 
--

ALTER TABLE academies ADD CONSTRAINT Reforganizations132 
    FOREIGN KEY (organizationId)
    REFERENCES organizations(id)
;

ALTER TABLE academies ADD CONSTRAINT Refusers314 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: academy_cf_data 
--

ALTER TABLE academy_cf_data ADD CONSTRAINT Refacademies2176 
    FOREIGN KEY (academyId)
    REFERENCES academies(id)
;

ALTER TABLE academy_cf_data ADD CONSTRAINT Refentity_field_meta_data2177 
    FOREIGN KEY (entityFieldMetaDataId)
    REFERENCES entity_field_meta_data(id)
;


-- 
-- TABLE: academy_location 
--

ALTER TABLE academy_location ADD CONSTRAINT Reflocations125 
    FOREIGN KEY (locationId)
    REFERENCES locations(id)
;

ALTER TABLE academy_location ADD CONSTRAINT Refacademies133 
    FOREIGN KEY (academyId)
    REFERENCES academies(id)
;

ALTER TABLE academy_location ADD CONSTRAINT Refusers313 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: academy_location_purpose 
--

ALTER TABLE academy_location_purpose ADD CONSTRAINT Refacademy_location126 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;

ALTER TABLE academy_location_purpose ADD CONSTRAINT Refcalendars139 
    FOREIGN KEY (calendarId)
    REFERENCES calendars(id)
;

ALTER TABLE academy_location_purpose ADD CONSTRAINT Refusers311 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE academy_location_purpose ADD CONSTRAINT Refacademy_year458 
    FOREIGN KEY (academicYearId)
    REFERENCES academy_year(id)
;

ALTER TABLE academy_location_purpose ADD CONSTRAINT Refacademy_year_tenure459 
    FOREIGN KEY (academicYearTenureId)
    REFERENCES academy_year_tenure(id)
;

ALTER TABLE academy_location_purpose ADD CONSTRAINT Refusers1060 
    FOREIGN KEY (ownerId)
    REFERENCES users(id)
;

ALTER TABLE academy_location_purpose ADD CONSTRAINT Reffaculty_fee_plan1585 
    FOREIGN KEY (facultyFeePlanId)
    REFERENCES faculty_fee_plan(id)
;


-- 
-- TABLE: academy_location_setting 
--

ALTER TABLE academy_location_setting ADD CONSTRAINT Refentity_setting101 
    FOREIGN KEY (entitySettingId)
    REFERENCES entity_setting(id)
;

ALTER TABLE academy_location_setting ADD CONSTRAINT Refacademy_location128 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;

ALTER TABLE academy_location_setting ADD CONSTRAINT Refusers319 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: academy_year 
--

ALTER TABLE academy_year ADD CONSTRAINT Refusers317 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: academy_year_tenure 
--

ALTER TABLE academy_year_tenure ADD CONSTRAINT Refacademy_year105 
    FOREIGN KEY (academyYearId)
    REFERENCES academy_year(id)
;

ALTER TABLE academy_year_tenure ADD CONSTRAINT Refusers316 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: account_config 
--

ALTER TABLE account_config ADD CONSTRAINT Refusers1186 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE account_config ADD CONSTRAINT Refusers1762 
    FOREIGN KEY (createdBy)
    REFERENCES users(id)
;

ALTER TABLE account_config ADD CONSTRAINT Refcurrency1763 
    FOREIGN KEY (currencyId)
    REFERENCES currency(id)
;


-- 
-- TABLE: account_config_batch_sch 
--

ALTER TABLE account_config_batch_sch ADD CONSTRAINT Refaccount_config365 
    FOREIGN KEY (accountConfigId)
    REFERENCES account_config(id)
;

ALTER TABLE account_config_batch_sch ADD CONSTRAINT Refusers1187 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: account_config_import_sch 
--

ALTER TABLE account_config_import_sch ADD CONSTRAINT Refaccount_config597 
    FOREIGN KEY (accountConfigId)
    REFERENCES account_config(id)
;

ALTER TABLE account_config_import_sch ADD CONSTRAINT Refusers1188 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: activity 
--

ALTER TABLE activity ADD CONSTRAINT Refusers1189 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: address 
--

ALTER TABLE address ADD CONSTRAINT Refcountry_region32 
    FOREIGN KEY (countryRegionId)
    REFERENCES country_region(id)
;

ALTER TABLE address ADD CONSTRAINT Refaddress_type33 
    FOREIGN KEY (addressTypeId)
    REFERENCES address_type(id)
;

ALTER TABLE address ADD CONSTRAINT Refcountry_region38 
    FOREIGN KEY (parentRegionId)
    REFERENCES country_region(id)
;

ALTER TABLE address ADD CONSTRAINT Refusers1061 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE address ADD CONSTRAINT Refcity1479 
    FOREIGN KEY (cityId)
    REFERENCES city(id)
;


-- 
-- TABLE: address_to_be_changed 
--

ALTER TABLE address_to_be_changed ADD CONSTRAINT Refusers2184 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE address_to_be_changed ADD CONSTRAINT Refaddress2190 
    FOREIGN KEY (addressId)
    REFERENCES address(id)
;

ALTER TABLE address_to_be_changed ADD CONSTRAINT Refaddress_type2201 
    FOREIGN KEY (addressTypeId)
    REFERENCES address_type(id)
;

ALTER TABLE address_to_be_changed ADD CONSTRAINT Refdata_to_be_changed2202 
    FOREIGN KEY (dataToBeChangedId)
    REFERENCES data_to_be_changed(id)
;


-- 
-- TABLE: address_type 
--

ALTER TABLE address_type ADD CONSTRAINT Refusers1062 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: admission 
--

ALTER TABLE admission ADD CONSTRAINT Refapplication_form434 
    FOREIGN KEY (applicationId)
    REFERENCES application_form(id)
;

ALTER TABLE admission ADD CONSTRAINT Refprog_batch_period_config899 
    FOREIGN KEY (programBatchPeriodConfigId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE admission ADD CONSTRAINT Refprog_batch_seat_config900 
    FOREIGN KEY (programBatchSeatConfigId)
    REFERENCES prog_batch_seat_config(id)
;

ALTER TABLE admission ADD CONSTRAINT Refacademy_location901 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;

ALTER TABLE admission ADD CONSTRAINT Refusers1190 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE admission ADD CONSTRAINT Refusers1715 
    FOREIGN KEY (approverId)
    REFERENCES users(id)
;

ALTER TABLE admission ADD CONSTRAINT Refreceipt_header1716 
    FOREIGN KEY (lastReceiptId)
    REFERENCES receipt_header(id)
;

ALTER TABLE admission ADD CONSTRAINT Refstudents2129 
    FOREIGN KEY (studentId)
    REFERENCES students(personId)
;


-- 
-- TABLE: admission_enq_details 
--

ALTER TABLE admission_enq_details ADD CONSTRAINT Refenq_student_details24 
    FOREIGN KEY (enqStudentDetailsId)
    REFERENCES enq_student_details(id)
;

ALTER TABLE admission_enq_details ADD CONSTRAINT Refenq_closure_reason55 
    FOREIGN KEY (enquiryClosureReasonId)
    REFERENCES enq_closure_reason(id)
;

ALTER TABLE admission_enq_details ADD CONSTRAINT Refenq_reopen_reason56 
    FOREIGN KEY (enquiryReopenReasonId)
    REFERENCES enq_reopen_reason(id)
;

ALTER TABLE admission_enq_details ADD CONSTRAINT Refusers329 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE admission_enq_details ADD CONSTRAINT Refacademies1624 
    FOREIGN KEY (academyId)
    REFERENCES academies(id)
;

ALTER TABLE admission_enq_details ADD CONSTRAINT Reflocations1625 
    FOREIGN KEY (locationId)
    REFERENCES locations(id)
;

ALTER TABLE admission_enq_details ADD CONSTRAINT Refprograms1626 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE admission_enq_details ADD CONSTRAINT Refbatches1627 
    FOREIGN KEY (batchId)
    REFERENCES batches(id)
;

ALTER TABLE admission_enq_details ADD CONSTRAINT Refprog_batch_seat_config1641 
    FOREIGN KEY (progBatchSeatConfigId)
    REFERENCES prog_batch_seat_config(id)
;


-- 
-- TABLE: admission_program_course 
--

ALTER TABLE admission_program_course ADD CONSTRAINT Refadmission2023 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE admission_program_course ADD CONSTRAINT Refcourses2024 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE admission_program_course ADD CONSTRAINT Refusers2025 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: admission_status 
--

ALTER TABLE admission_status ADD CONSTRAINT Refadmission2021 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE admission_status ADD CONSTRAINT Refusers2022 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: against_bill_request_types 
--

ALTER TABLE against_bill_request_types ADD CONSTRAINT Refrequest_types2336 
    FOREIGN KEY (requestTypeId)
    REFERENCES request_types(id)
;


-- 
-- TABLE: against_feehead_request_types 
--

ALTER TABLE against_feehead_request_types ADD CONSTRAINT Refrequest_types2337 
    FOREIGN KEY (requestTypeId)
    REFERENCES request_types(id)
;


-- 
-- TABLE: app_extra_curricular 
--

ALTER TABLE app_extra_curricular ADD CONSTRAINT Refusers1193 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE app_extra_curricular ADD CONSTRAINT Refusers1764 
    FOREIGN KEY (conductedBy)
    REFERENCES users(id)
;

ALTER TABLE app_extra_curricular ADD CONSTRAINT Refapplicant2012 
    FOREIGN KEY (applicantId)
    REFERENCES applicant(id)
;


-- 
-- TABLE: app_selection_replacement 
--

ALTER TABLE app_selection_replacement ADD CONSTRAINT Refslctn_process_stage888 
    FOREIGN KEY (processStageId)
    REFERENCES slctn_process_stage(id)
;

ALTER TABLE app_selection_replacement ADD CONSTRAINT Refapplication889 
    FOREIGN KEY (applicantId)
    REFERENCES application(id)
;

ALTER TABLE app_selection_replacement ADD CONSTRAINT Refapplication_form890 
    FOREIGN KEY (applicationId)
    REFERENCES application_form(id)
;

ALTER TABLE app_selection_replacement ADD CONSTRAINT Refacademy_location891 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;

ALTER TABLE app_selection_replacement ADD CONSTRAINT Refprog_batch_period_config892 
    FOREIGN KEY (programBatchPeriodConfigId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE app_selection_replacement ADD CONSTRAINT Refprog_batch_seat_config893 
    FOREIGN KEY (programBatchSeatConfigId)
    REFERENCES prog_batch_seat_config(id)
;

ALTER TABLE app_selection_replacement ADD CONSTRAINT Refquota894 
    FOREIGN KEY (quotaId)
    REFERENCES quota(id)
;

ALTER TABLE app_selection_replacement ADD CONSTRAINT Refusers1199 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE app_selection_replacement ADD CONSTRAINT Refapplication_form1765 
    FOREIGN KEY (toBeReplacedAppId)
    REFERENCES application_form(id)
;

ALTER TABLE app_selection_replacement ADD CONSTRAINT Refapplication_form1766 
    FOREIGN KEY (replacedAppId)
    REFERENCES application_form(id)
;


-- 
-- TABLE: applicant 
--

ALTER TABLE applicant ADD CONSTRAINT Refpersons2009 
    FOREIGN KEY (personId)
    REFERENCES persons(id)
;

ALTER TABLE applicant ADD CONSTRAINT Refapplication_form2010 
    FOREIGN KEY (applicationFormId)
    REFERENCES application_form(id)
;

ALTER TABLE applicant ADD CONSTRAINT Refusers2011 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: applicant_cf_data 
--

ALTER TABLE applicant_cf_data ADD CONSTRAINT Refapplication1589 
    FOREIGN KEY (applicantId)
    REFERENCES application(id)
;

ALTER TABLE applicant_cf_data ADD CONSTRAINT Refusers1591 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: applicant_classification 
--

ALTER TABLE applicant_classification ADD CONSTRAINT Refapplication533 
    FOREIGN KEY (applicantId)
    REFERENCES application(id)
;

ALTER TABLE applicant_classification ADD CONSTRAINT Refusers1204 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: applicant_doc_link 
--

ALTER TABLE applicant_doc_link ADD CONSTRAINT Refapplicant_documents541 
    FOREIGN KEY (applicationDocumentId)
    REFERENCES applicant_documents(id)
;

ALTER TABLE applicant_doc_link ADD CONSTRAINT Refusers1205 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: applicant_documents 
--

ALTER TABLE applicant_documents ADD CONSTRAINT Refapplication_form419 
    FOREIGN KEY (applicationId)
    REFERENCES application_form(id)
;

ALTER TABLE applicant_documents ADD CONSTRAINT Refacademy_location542 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;

ALTER TABLE applicant_documents ADD CONSTRAINT Refprog_batch_period_config543 
    FOREIGN KEY (programBatchPeriodId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE applicant_documents ADD CONSTRAINT Refprog_batch_seat_config544 
    FOREIGN KEY (programBatchSeatId)
    REFERENCES prog_batch_seat_config(id)
;

ALTER TABLE applicant_documents ADD CONSTRAINT Refselection_stage545 
    FOREIGN KEY (stageId)
    REFERENCES selection_stage(id)
;

ALTER TABLE applicant_documents ADD CONSTRAINT Refusers1206 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE applicant_documents ADD CONSTRAINT Refusers1770 
    FOREIGN KEY (employeeId)
    REFERENCES users(id)
;

ALTER TABLE applicant_documents ADD CONSTRAINT Refusers1771 
    FOREIGN KEY (inspectionDoneBy)
    REFERENCES users(id)
;

ALTER TABLE applicant_documents ADD CONSTRAINT Refusers1772 
    FOREIGN KEY (returnedTo)
    REFERENCES users(id)
;


-- 
-- TABLE: applicant_prev_exam 
--

ALTER TABLE applicant_prev_exam ADD CONSTRAINT Refusers1209 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE applicant_prev_exam ADD CONSTRAINT Refapplicant2017 
    FOREIGN KEY (applicantId)
    REFERENCES applicant(id)
;


-- 
-- TABLE: application 
--

ALTER TABLE application ADD CONSTRAINT Refapplication_form535 
    FOREIGN KEY (applicationFormId)
    REFERENCES application_form(id)
;

ALTER TABLE application ADD CONSTRAINT Refusers1201 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE application ADD CONSTRAINT Refstudents2389 
    FOREIGN KEY (existingStudentId)
    REFERENCES students(personId)
;

ALTER TABLE application ADD CONSTRAINT Refpersons2390 
    FOREIGN KEY (personId)
    REFERENCES persons(id)
;

ALTER TABLE application ADD CONSTRAINT Refenq_student_details2391 
    FOREIGN KEY (enquiryStudentDetailId)
    REFERENCES enq_student_details(id)
;


-- 
-- TABLE: application_fee_payment 
--

ALTER TABLE application_fee_payment ADD CONSTRAINT Refapplication_form221 
    FOREIGN KEY (applicationId)
    REFERENCES application_form(id)
;

ALTER TABLE application_fee_payment ADD CONSTRAINT Refacademy_location529 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;

ALTER TABLE application_fee_payment ADD CONSTRAINT Refprograms530 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE application_fee_payment ADD CONSTRAINT Refusers1217 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE application_fee_payment ADD CONSTRAINT Refreceipt_header1653 
    FOREIGN KEY (receiptId)
    REFERENCES receipt_header(id)
;

ALTER TABLE application_fee_payment ADD CONSTRAINT Reffee_plan1654 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;

ALTER TABLE application_fee_payment ADD CONSTRAINT Refusers1655 
    FOREIGN KEY (collectedBy)
    REFERENCES users(id)
;

ALTER TABLE application_fee_payment ADD CONSTRAINT Refprog_batch_seat_config1656 
    FOREIGN KEY (progBatchSeatConfigId)
    REFERENCES prog_batch_seat_config(id)
;


-- 
-- TABLE: application_form 
--

ALTER TABLE application_form ADD CONSTRAINT Refusers1216 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: application_prog_stage 
--

ALTER TABLE application_prog_stage ADD CONSTRAINT Refusers1212 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE application_prog_stage ADD CONSTRAINT Refapplication_program1989 
    FOREIGN KEY (applicationProgramId)
    REFERENCES application_program(id)
;

ALTER TABLE application_prog_stage ADD CONSTRAINT Refprogram_slctn_process_stages1990 
    FOREIGN KEY (programSelectionProcessStageId)
    REFERENCES program_slctn_process_stages(id)
;


-- 
-- TABLE: application_prog_stage_marks 
--

ALTER TABLE application_prog_stage_marks ADD CONSTRAINT Refapplication_prog_stage548 
    FOREIGN KEY (applicationProgramStageId)
    REFERENCES application_prog_stage(id)
;

ALTER TABLE application_prog_stage_marks ADD CONSTRAINT Refusers1207 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE application_prog_stage_marks ADD CONSTRAINT Refslctn_stage_eval_prm_weightage1984 
    FOREIGN KEY (evaluationParameterWeightageId)
    REFERENCES slctn_stage_eval_prm_weightage(id)
;


-- 
-- TABLE: application_prog_stage_status 
--

ALTER TABLE application_prog_stage_status ADD CONSTRAINT Refapplication_prog_stage1991 
    FOREIGN KEY (applicationProgramStageId)
    REFERENCES application_prog_stage(id)
;

ALTER TABLE application_prog_stage_status ADD CONSTRAINT Refusers2001 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: application_program 
--

ALTER TABLE application_program ADD CONSTRAINT Refacademy_location527 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;

ALTER TABLE application_program ADD CONSTRAINT Refprograms528 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE application_program ADD CONSTRAINT Refusers1218 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE application_program ADD CONSTRAINT Refprog_batch_seat_config1780 
    FOREIGN KEY (progBatchSeatConfigId)
    REFERENCES prog_batch_seat_config(id)
;

ALTER TABLE application_program ADD CONSTRAINT Refapplication1973 
    FOREIGN KEY (applicationId)
    REFERENCES application(id)
;

ALTER TABLE application_program ADD CONSTRAINT Refprogram_slctn_process_stages2020 
    FOREIGN KEY (currentStageId)
    REFERENCES program_slctn_process_stages(id)
;


-- 
-- TABLE: application_program_group_conf 
--

ALTER TABLE application_program_group_conf ADD CONSTRAINT Refusers1219 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE application_program_group_conf ADD CONSTRAINT Refprogram_group2393 
    FOREIGN KEY (programGroupId)
    REFERENCES program_group(id)
;


-- 
-- TABLE: application_program_services 
--

ALTER TABLE application_program_services ADD CONSTRAINT Refusers1194 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE application_program_services ADD CONSTRAINT Refservice1688 
    FOREIGN KEY (serviceId)
    REFERENCES service(id)
;

ALTER TABLE application_program_services ADD CONSTRAINT Refapplication_program2013 
    FOREIGN KEY (applicationProcessId)
    REFERENCES application_program(id)
;


-- 
-- TABLE: application_program_status 
--

ALTER TABLE application_program_status ADD CONSTRAINT Refapplication_program1974 
    FOREIGN KEY (applicationProgramId)
    REFERENCES application_program(id)
;

ALTER TABLE application_program_status ADD CONSTRAINT Refusers2002 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: application_references 
--

ALTER TABLE application_references ADD CONSTRAINT Refapplication1976 
    FOREIGN KEY (applicationId)
    REFERENCES application(id)
;


-- 
-- TABLE: application_status 
--

ALTER TABLE application_status ADD CONSTRAINT Refapplication1982 
    FOREIGN KEY (applicationId)
    REFERENCES application(id)
;

ALTER TABLE application_status ADD CONSTRAINT Refusers2003 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: approval_details 
--

ALTER TABLE approval_details ADD CONSTRAINT Refusers2232 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE approval_details ADD CONSTRAINT Refusers2233 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE approval_details ADD CONSTRAINT Refservice_requests2234 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_requests(id)
;

ALTER TABLE approval_details ADD CONSTRAINT Refusers2332 
    FOREIGN KEY (escalatedApproverUserId)
    REFERENCES users(id)
;


-- 
-- TABLE: assignment 
--

ALTER TABLE assignment ADD CONSTRAINT Refusers1220 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: assignment_topics 
--

ALTER TABLE assignment_topics ADD CONSTRAINT Refassignment1055 
    FOREIGN KEY (assignmentId)
    REFERENCES assignment(id)
;

ALTER TABLE assignment_topics ADD CONSTRAINT Refusers1221 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE assignment_topics ADD CONSTRAINT Refcourse_topics2027 
    FOREIGN KEY (courseTopicId)
    REFERENCES course_topics(id)
;


-- 
-- TABLE: bank 
--

ALTER TABLE bank ADD CONSTRAINT Refacademies825 
    FOREIGN KEY (academyId)
    REFERENCES academies(id)
;

ALTER TABLE bank ADD CONSTRAINT Reflocations826 
    FOREIGN KEY (locationId)
    REFERENCES locations(id)
;

ALTER TABLE bank ADD CONSTRAINT Refusers1123 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: bank_account_detail 
--

ALTER TABLE bank_account_detail ADD CONSTRAINT Refusers1223 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE bank_account_detail ADD CONSTRAINT Refconfig_control_account1508 
    FOREIGN KEY (configControlAccountId)
    REFERENCES config_control_account(id)
;

ALTER TABLE bank_account_detail ADD CONSTRAINT Refaccount_config1509 
    FOREIGN KEY (accountingConfigId)
    REFERENCES account_config(id)
;


-- 
-- TABLE: bank_contact_person 
--

ALTER TABLE bank_contact_person ADD CONSTRAINT Refbank822 
    FOREIGN KEY (bankId)
    REFERENCES bank(id)
;

ALTER TABLE bank_contact_person ADD CONSTRAINT Refusers1224 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: bank_details 
--

ALTER TABLE bank_details ADD CONSTRAINT Refpersons2154 
    FOREIGN KEY (personId)
    REFERENCES persons(id)
;

ALTER TABLE bank_details ADD CONSTRAINT Refusers2155 
    FOREIGN KEY (lastUpdatedby)
    REFERENCES users(id)
;


-- 
-- TABLE: bank_person_address 
--

ALTER TABLE bank_person_address ADD CONSTRAINT Refbank_contact_person823 
    FOREIGN KEY (bankPersonId)
    REFERENCES bank_contact_person(id)
;

ALTER TABLE bank_person_address ADD CONSTRAINT Refaddress824 
    FOREIGN KEY (addressId)
    REFERENCES address(id)
;

ALTER TABLE bank_person_address ADD CONSTRAINT Refusers1225 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: basic_search_config 
--

ALTER TABLE basic_search_config ADD CONSTRAINT Refsearch_config1734 
    FOREIGN KEY (searchConfigId)
    REFERENCES search_config(id)
;


-- 
-- TABLE: basic_search_config_param 
--

ALTER TABLE basic_search_config_param ADD CONSTRAINT Refbasic_search_config1726 
    FOREIGN KEY (basicSearchConfigId)
    REFERENCES basic_search_config(id)
;

ALTER TABLE basic_search_config_param ADD CONSTRAINT Refsearch_table_column1727 
    FOREIGN KEY (searchTableColumnId)
    REFERENCES search_table_column(id)
;

ALTER TABLE basic_search_config_param ADD CONSTRAINT Refsearch_criteria_operator1728 
    FOREIGN KEY (searchCriteriaOperatorId)
    REFERENCES search_criteria_operator(id)
;

ALTER TABLE basic_search_config_param ADD CONSTRAINT Refsearch_config_table1729 
    FOREIGN KEY (searchConfigTableId)
    REFERENCES search_config_table(id)
;


-- 
-- TABLE: batches 
--

ALTER TABLE batches ADD CONSTRAINT Refcalendars470 
    FOREIGN KEY (calendarId)
    REFERENCES calendars(id)
;

ALTER TABLE batches ADD CONSTRAINT Refusers471 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE batches ADD CONSTRAINT Refprogram_period_type487 
    FOREIGN KEY (programPeriodTypeId)
    REFERENCES program_period_type(id)
;

ALTER TABLE batches ADD CONSTRAINT Refprograms1631 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE batches ADD CONSTRAINT Refprograms1781 
    FOREIGN KEY (inheritProgramId)
    REFERENCES programs(id)
;

ALTER TABLE batches ADD CONSTRAINT Refbatches1782 
    FOREIGN KEY (inheritFromBatch)
    REFERENCES batches(id)
;


-- 
-- TABLE: bill_faculty_covered 
--

ALTER TABLE bill_faculty_covered ADD CONSTRAINT Refbill_header1525 
    FOREIGN KEY (billId)
    REFERENCES bill_header(id)
;

ALTER TABLE bill_faculty_covered ADD CONSTRAINT Refusers1527 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE bill_faculty_covered ADD CONSTRAINT Reffaculties2111 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;


-- 
-- TABLE: bill_faculty_payment 
--

ALTER TABLE bill_faculty_payment ADD CONSTRAINT Refbill_header610 
    FOREIGN KEY (billId)
    REFERENCES bill_header(id)
;

ALTER TABLE bill_faculty_payment ADD CONSTRAINT Refusers1228 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE bill_faculty_payment ADD CONSTRAINT Reffaculties2112 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;


-- 
-- TABLE: bill_faculty_sessions 
--

ALTER TABLE bill_faculty_sessions ADD CONSTRAINT Refbill_faculty_covered1528 
    FOREIGN KEY (billFacultyId)
    REFERENCES bill_faculty_covered(id)
;

ALTER TABLE bill_faculty_sessions ADD CONSTRAINT Refusers1529 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE bill_faculty_sessions ADD CONSTRAINT Refcourses1530 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;


-- 
-- TABLE: bill_fee_concessions 
--

ALTER TABLE bill_fee_concessions ADD CONSTRAINT Reffee_stage_head_config1531 
    FOREIGN KEY (feeStageHeadConfigId)
    REFERENCES fee_stage_head_config(id)
;

ALTER TABLE bill_fee_concessions ADD CONSTRAINT Refusers1532 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE bill_fee_concessions ADD CONSTRAINT Refbill_header1533 
    FOREIGN KEY (billId)
    REFERENCES bill_header(id)
;


-- 
-- TABLE: bill_fee_installments 
--

ALTER TABLE bill_fee_installments ADD CONSTRAINT Refbill_header1534 
    FOREIGN KEY (billId)
    REFERENCES bill_header(id)
;

ALTER TABLE bill_fee_installments ADD CONSTRAINT Reffee_stage_head_config1535 
    FOREIGN KEY (feeStageHeadConfigId)
    REFERENCES fee_stage_head_config(id)
;

ALTER TABLE bill_fee_installments ADD CONSTRAINT Refusers1536 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: bill_fee_plan_rule_stage 
--

ALTER TABLE bill_fee_plan_rule_stage ADD CONSTRAINT Refbill_header619 
    FOREIGN KEY (billId)
    REFERENCES bill_header(id)
;

ALTER TABLE bill_fee_plan_rule_stage ADD CONSTRAINT Refusers1226 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE bill_fee_plan_rule_stage ADD CONSTRAINT Reffee_stage_head_config1521 
    FOREIGN KEY (feeStageHeadConfigId)
    REFERENCES fee_stage_head_config(id)
;

ALTER TABLE bill_fee_plan_rule_stage ADD CONSTRAINT Refsequence_header1784 
    FOREIGN KEY (feeSequenceId)
    REFERENCES sequence_header(id)
;


-- 
-- TABLE: bill_header 
--

ALTER TABLE bill_header ADD CONSTRAINT Refselection_stage632 
    FOREIGN KEY (stageId)
    REFERENCES selection_stage(id)
;

ALTER TABLE bill_header ADD CONSTRAINT Refusers1229 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE bill_header ADD CONSTRAINT Refsequence_header1783 
    FOREIGN KEY (sequenceId)
    REFERENCES sequence_header(id)
;

ALTER TABLE bill_header ADD CONSTRAINT Refusers1785 
    FOREIGN KEY (sponsorId)
    REFERENCES users(id)
;


-- 
-- TABLE: bill_refund_fee_plan 
--

ALTER TABLE bill_refund_fee_plan ADD CONSTRAINT Refbill_refund_header612 
    FOREIGN KEY (billRefundId)
    REFERENCES bill_refund_header(id)
;

ALTER TABLE bill_refund_fee_plan ADD CONSTRAINT Reffee_heads624 
    FOREIGN KEY (feeHeadId)
    REFERENCES fee_heads(id)
;

ALTER TABLE bill_refund_fee_plan ADD CONSTRAINT Refusers1230 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: bill_refund_header 
--

ALTER TABLE bill_refund_header ADD CONSTRAINT Refbill_header620 
    FOREIGN KEY (billId)
    REFERENCES bill_header(id)
;

ALTER TABLE bill_refund_header ADD CONSTRAINT Refusers1231 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE bill_refund_header ADD CONSTRAINT Refpayment_header1553 
    FOREIGN KEY (paymentHeaderId)
    REFERENCES payment_header(id)
;


-- 
-- TABLE: bill_student_sessions 
--

ALTER TABLE bill_student_sessions ADD CONSTRAINT Refbill_students_covered1537 
    FOREIGN KEY (billStudentId)
    REFERENCES bill_students_covered(id)
;

ALTER TABLE bill_student_sessions ADD CONSTRAINT Refcourses1538 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE bill_student_sessions ADD CONSTRAINT Refusers1539 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: bill_students_covered 
--

ALTER TABLE bill_students_covered ADD CONSTRAINT Refbill_header1522 
    FOREIGN KEY (billId)
    REFERENCES bill_header(id)
;

ALTER TABLE bill_students_covered ADD CONSTRAINT Refusers1524 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE bill_students_covered ADD CONSTRAINT Refstudents2130 
    FOREIGN KEY (studentId)
    REFERENCES students(personId)
;


-- 
-- TABLE: booking_purposes 
--

ALTER TABLE booking_purposes ADD CONSTRAINT Refusers984 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: calendar_academy_locations 
--

ALTER TABLE calendar_academy_locations ADD CONSTRAINT Refcalendars70 
    FOREIGN KEY (calendarId)
    REFERENCES calendars(id)
;

ALTER TABLE calendar_academy_locations ADD CONSTRAINT Refusers301 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE calendar_academy_locations ADD CONSTRAINT Refacademy_location775 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;


-- 
-- TABLE: calendar_breaks 
--

ALTER TABLE calendar_breaks ADD CONSTRAINT Refcalendar_weekdays967 
    FOREIGN KEY (calendarWeekdayId)
    REFERENCES calendar_weekdays(id)
;

ALTER TABLE calendar_breaks ADD CONSTRAINT Refusers968 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: calendar_holidays 
--

ALTER TABLE calendar_holidays ADD CONSTRAINT Refcalendars66 
    FOREIGN KEY (calendarId)
    REFERENCES calendars(id)
;

ALTER TABLE calendar_holidays ADD CONSTRAINT Refusers299 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE calendar_holidays ADD CONSTRAINT Refusers956 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: calendar_special_days 
--

ALTER TABLE calendar_special_days ADD CONSTRAINT Refcalendars961 
    FOREIGN KEY (calendarId)
    REFERENCES calendars(id)
;

ALTER TABLE calendar_special_days ADD CONSTRAINT Refcalendar_weekdays962 
    FOREIGN KEY (calendarWeekdayId)
    REFERENCES calendar_weekdays(id)
;


-- 
-- TABLE: calendar_weekdays 
--

ALTER TABLE calendar_weekdays ADD CONSTRAINT Refusers957 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: calendar_weeklyoffs 
--

ALTER TABLE calendar_weeklyoffs ADD CONSTRAINT Refusers969 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE calendar_weeklyoffs ADD CONSTRAINT Refcalendars970 
    FOREIGN KEY (calendarId)
    REFERENCES calendars(id)
;


-- 
-- TABLE: calendar_working_weekdays 
--

ALTER TABLE calendar_working_weekdays ADD CONSTRAINT Refcalendar_weekdays963 
    FOREIGN KEY (calendarWeekdayId)
    REFERENCES calendar_weekdays(id)
;

ALTER TABLE calendar_working_weekdays ADD CONSTRAINT Refcalendars965 
    FOREIGN KEY (calendarId)
    REFERENCES calendars(id)
;


-- 
-- TABLE: calendars 
--

ALTER TABLE calendars ADD CONSTRAINT Refusers298 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: campaign 
--

ALTER TABLE campaign ADD CONSTRAINT Refusers23 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE campaign ADD CONSTRAINT Refusers321 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: campaign_coverage 
--

ALTER TABLE campaign_coverage ADD CONSTRAINT Refcampaign3 
    FOREIGN KEY (campaignId)
    REFERENCES campaign(id)
;

ALTER TABLE campaign_coverage ADD CONSTRAINT Refusers21 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE campaign_coverage ADD CONSTRAINT Refusers322 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE campaign_coverage ADD CONSTRAINT Reflocations918 
    FOREIGN KEY (locationId)
    REFERENCES locations(id)
;

ALTER TABLE campaign_coverage ADD CONSTRAINT Refacademies919 
    FOREIGN KEY (academyId)
    REFERENCES academies(id)
;

ALTER TABLE campaign_coverage ADD CONSTRAINT Refprograms920 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;


-- 
-- TABLE: campaign_media 
--

ALTER TABLE campaign_media ADD CONSTRAINT Refmedia1 
    FOREIGN KEY (mediaId)
    REFERENCES media(id)
;

ALTER TABLE campaign_media ADD CONSTRAINT Refcampaign2 
    FOREIGN KEY (campaignId)
    REFERENCES campaign(id)
;

ALTER TABLE campaign_media ADD CONSTRAINT Refusers325 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: caste_categories 
--

ALTER TABLE caste_categories ADD CONSTRAINT Refusers2055 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: category_field_items 
--

ALTER TABLE category_field_items ADD CONSTRAINT Refcategory_field_meta_data1598 
    FOREIGN KEY (categoryMetaDataId)
    REFERENCES category_field_meta_data(id)
;

ALTER TABLE category_field_items ADD CONSTRAINT Refusers1599 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: category_field_meta_data 
--

ALTER TABLE category_field_meta_data ADD CONSTRAINT Refentity_type1596 
    FOREIGN KEY (entityTypeId)
    REFERENCES entity_type(id)
;

ALTER TABLE category_field_meta_data ADD CONSTRAINT Refusers1597 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: center_allocation 
--

ALTER TABLE center_allocation ADD CONSTRAINT Refexam_center638 
    FOREIGN KEY (examCenterId)
    REFERENCES exam_center(id)
;

ALTER TABLE center_allocation ADD CONSTRAINT Refusers1232 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: center_room_details 
--

ALTER TABLE center_room_details ADD CONSTRAINT Refcenter_allocation639 
    FOREIGN KEY (allocatedCenterId)
    REFERENCES center_allocation(id)
;

ALTER TABLE center_room_details ADD CONSTRAINT Refusers1233 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: centre_unavailability_date 
--

ALTER TABLE centre_unavailability_date ADD CONSTRAINT Refexam_center686 
    FOREIGN KEY (centerId)
    REFERENCES exam_center(id)
;

ALTER TABLE centre_unavailability_date ADD CONSTRAINT Refusers1234 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: centre_unavailability_time 
--

ALTER TABLE centre_unavailability_time ADD CONSTRAINT Refcentre_unavailability_date1180 
    FOREIGN KEY (unavailabilityDateId)
    REFERENCES centre_unavailability_date(id)
;

ALTER TABLE centre_unavailability_time ADD CONSTRAINT Refusers1235 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: certificate 
--

ALTER TABLE certificate ADD CONSTRAINT Refusers1063 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE certificate ADD CONSTRAINT Refcertificate_category1720 
    FOREIGN KEY (certificateCategoryId)
    REFERENCES certificate_category(id)
;


-- 
-- TABLE: certificate_category 
--

ALTER TABLE certificate_category ADD CONSTRAINT Refusers1721 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: certificate_request_details 
--

ALTER TABLE certificate_request_details ADD CONSTRAINT Refservice_request_details2247 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;


-- 
-- TABLE: certificates 
--

ALTER TABLE certificates ADD CONSTRAINT Refrequest_types2209 
    FOREIGN KEY (requestTypeId)
    REFERENCES request_types(id)
;


-- 
-- TABLE: city 
--

ALTER TABLE city ADD CONSTRAINT Refusers291 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE city ADD CONSTRAINT Refcountry406 
    FOREIGN KEY (countryId)
    REFERENCES country(id)
;


-- 
-- TABLE: classifications 
--

ALTER TABLE classifications ADD CONSTRAINT Refusers975 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: closure_reason 
--

ALTER TABLE closure_reason ADD CONSTRAINT Refusers332 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: community 
--

ALTER TABLE community ADD CONSTRAINT Refusers1066 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: community_locations 
--

ALTER TABLE community_locations ADD CONSTRAINT Refcommunity820 
    FOREIGN KEY (communityId)
    REFERENCES community(id)
;

ALTER TABLE community_locations ADD CONSTRAINT Refprog_batch_seat_config910 
    FOREIGN KEY (programBatchSeatConfigId)
    REFERENCES prog_batch_seat_config(id)
;

ALTER TABLE community_locations ADD CONSTRAINT Refusers1067 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: complaint_details 
--

ALTER TABLE complaint_details ADD CONSTRAINT Refservice_request_details2248 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;

ALTER TABLE complaint_details ADD CONSTRAINT Refpersons2249 
    FOREIGN KEY (complaintAgainstPersonId)
    REFERENCES persons(id)
;

ALTER TABLE complaint_details ADD CONSTRAINT Refcomplaint_type_settings2250 
    FOREIGN KEY (complaintTypeSettingId)
    REFERENCES complaint_type_settings(id)
;


-- 
-- TABLE: complaint_type_settings 
--

ALTER TABLE complaint_type_settings ADD CONSTRAINT Refcomplaint_types2219 
    FOREIGN KEY (complaintTypeId)
    REFERENCES complaint_types(id)
;

ALTER TABLE complaint_type_settings ADD CONSTRAINT Refacademy_location2220 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;

ALTER TABLE complaint_type_settings ADD CONSTRAINT Refusers2221 
    FOREIGN KEY (defaultAssigneeUserId)
    REFERENCES users(id)
;

ALTER TABLE complaint_type_settings ADD CONSTRAINT Refusers2222 
    FOREIGN KEY (defaultApproverUserId)
    REFERENCES users(id)
;

ALTER TABLE complaint_type_settings ADD CONSTRAINT Refusers2224 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: complaint_types 
--

ALTER TABLE complaint_types ADD CONSTRAINT Refusers2223 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: completion_certificates 
--

ALTER TABLE completion_certificates ADD CONSTRAINT Refprograms757 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE completion_certificates ADD CONSTRAINT Refbatches758 
    FOREIGN KEY (batchId)
    REFERENCES batches(id)
;

ALTER TABLE completion_certificates ADD CONSTRAINT Refusers1068 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE completion_certificates ADD CONSTRAINT Refcertificate1719 
    FOREIGN KEY (certificateId)
    REFERENCES certificate(id)
;


-- 
-- TABLE: completion_check_list 
--

ALTER TABLE completion_check_list ADD CONSTRAINT Refprograms759 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE completion_check_list ADD CONSTRAINT Refbatches760 
    FOREIGN KEY (batchId)
    REFERENCES batches(id)
;

ALTER TABLE completion_check_list ADD CONSTRAINT Refusers1069 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: completion_docs 
--

ALTER TABLE completion_docs ADD CONSTRAINT Refcompletion_transaction_details667 
    FOREIGN KEY (transactionId)
    REFERENCES completion_transaction_details(id)
;

ALTER TABLE completion_docs ADD CONSTRAINT Refcompletion_check_list668 
    FOREIGN KEY (checkListId)
    REFERENCES completion_check_list(id)
;

ALTER TABLE completion_docs ADD CONSTRAINT Refusers1236 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE completion_docs ADD CONSTRAINT Refdocuments1786 
    FOREIGN KEY (documentId)
    REFERENCES documents(id)
;


-- 
-- TABLE: completion_termination 
--

ALTER TABLE completion_termination ADD CONSTRAINT Refcompletion_transactions665 
    FOREIGN KEY (transactionId)
    REFERENCES completion_transactions(id)
;

ALTER TABLE completion_termination ADD CONSTRAINT Refcompletion_check_list666 
    FOREIGN KEY (checkListId)
    REFERENCES completion_check_list(id)
;

ALTER TABLE completion_termination ADD CONSTRAINT Refusers1237 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE completion_termination ADD CONSTRAINT Refusers1787 
    FOREIGN KEY (approvedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: completion_transaction_details 
--

ALTER TABLE completion_transaction_details ADD CONSTRAINT Refcompletion_transactions663 
    FOREIGN KEY (transactionId)
    REFERENCES completion_transactions(id)
;

ALTER TABLE completion_transaction_details ADD CONSTRAINT Refcompletion_transactions664 
    FOREIGN KEY (checkListId)
    REFERENCES completion_transactions(id)
;

ALTER TABLE completion_transaction_details ADD CONSTRAINT Refusers1238 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE completion_transaction_details ADD CONSTRAINT Refusers1788 
    FOREIGN KEY (inspectionDoneBy)
    REFERENCES users(id)
;


-- 
-- TABLE: completion_transactions 
--

ALTER TABLE completion_transactions ADD CONSTRAINT Refprograms761 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE completion_transactions ADD CONSTRAINT Refbatches762 
    FOREIGN KEY (batchId)
    REFERENCES batches(id)
;

ALTER TABLE completion_transactions ADD CONSTRAINT Refadmission763 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE completion_transactions ADD CONSTRAINT Refusers1070 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: component_type 
--

ALTER TABLE component_type ADD CONSTRAINT Refusers2385 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: config_control_account 
--

ALTER TABLE config_control_account ADD CONSTRAINT Refiau_accounting1491 
    FOREIGN KEY (iauAccountingId)
    REFERENCES iau_accounting(id)
;

ALTER TABLE config_control_account ADD CONSTRAINT Refusers1492 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: config_control_head_detail 
--

ALTER TABLE config_control_head_detail ADD CONSTRAINT Refconfig_control_account1493 
    FOREIGN KEY (configControlAccountId)
    REFERENCES config_control_account(id)
;

ALTER TABLE config_control_head_detail ADD CONSTRAINT Reffee_heads1494 
    FOREIGN KEY (feeHeadId)
    REFERENCES fee_heads(id)
;

ALTER TABLE config_control_head_detail ADD CONSTRAINT Refaccount_config1497 
    FOREIGN KEY (accountingConfigId)
    REFERENCES account_config(id)
;

ALTER TABLE config_control_head_detail ADD CONSTRAINT Refusers1499 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: config_control_head_plan 
--

ALTER TABLE config_control_head_plan ADD CONSTRAINT Refaccount_config600 
    FOREIGN KEY (accountConfigId)
    REFERENCES account_config(id)
;

ALTER TABLE config_control_head_plan ADD CONSTRAINT Reffee_heads602 
    FOREIGN KEY (feeHeadId)
    REFERENCES fee_heads(id)
;

ALTER TABLE config_control_head_plan ADD CONSTRAINT Reffee_plan604 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;

ALTER TABLE config_control_head_plan ADD CONSTRAINT Refusers1340 
    FOREIGN KEY (lastUpdateBy)
    REFERENCES users(id)
;

ALTER TABLE config_control_head_plan ADD CONSTRAINT Refconfig_control_account1503 
    FOREIGN KEY (configControlAccountId)
    REFERENCES config_control_account(id)
;


-- 
-- TABLE: config_control_plan_detail 
--

ALTER TABLE config_control_plan_detail ADD CONSTRAINT Refconfig_control_account1495 
    FOREIGN KEY (configControlAccountId)
    REFERENCES config_control_account(id)
;

ALTER TABLE config_control_plan_detail ADD CONSTRAINT Refaccount_config1498 
    FOREIGN KEY (accountingConfigId)
    REFERENCES account_config(id)
;

ALTER TABLE config_control_plan_detail ADD CONSTRAINT Refusers1500 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE config_control_plan_detail ADD CONSTRAINT Reffee_plan1501 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;

ALTER TABLE config_control_plan_detail ADD CONSTRAINT Reffee_plan_rule_stage1502 
    FOREIGN KEY (feePlanRuleStageId)
    REFERENCES fee_plan_rule_stage(id)
;


-- 
-- TABLE: country 
--

ALTER TABLE country ADD CONSTRAINT Refusers1064 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: country_region 
--

ALTER TABLE country_region ADD CONSTRAINT Refcountry31 
    FOREIGN KEY (countryId)
    REFERENCES country(id)
;

ALTER TABLE country_region ADD CONSTRAINT Refcountry_region1072 
    FOREIGN KEY (parentRegionId)
    REFERENCES country_region(id)
;

ALTER TABLE country_region ADD CONSTRAINT Refusers1074 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: course_academy_location 
--

ALTER TABLE course_academy_location ADD CONSTRAINT Refcourses827 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE course_academy_location ADD CONSTRAINT Refacademy_location828 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;

ALTER TABLE course_academy_location ADD CONSTRAINT Refusers1239 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: course_cf_data 
--

ALTER TABLE course_cf_data ADD CONSTRAINT Refcourses1583 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE course_cf_data ADD CONSTRAINT Refusers1584 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: course_components 
--

ALTER TABLE course_components ADD CONSTRAINT Refcourses164 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE course_components ADD CONSTRAINT Refusers1241 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE course_components ADD CONSTRAINT Refcomponent_type2386 
    FOREIGN KEY (componentTypeId)
    REFERENCES component_type(id)
;


-- 
-- TABLE: course_coverage_plan 
--

ALTER TABLE course_coverage_plan ADD CONSTRAINT Refcourses179 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE course_coverage_plan ADD CONSTRAINT Refsections829 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;

ALTER TABLE course_coverage_plan ADD CONSTRAINT Refusers1242 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE course_coverage_plan ADD CONSTRAINT Refusers1243 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE course_coverage_plan ADD CONSTRAINT Refbatches1902 
    FOREIGN KEY (programBatchId)
    REFERENCES batches(id)
;


-- 
-- TABLE: course_coverage_plan_details 
--

ALTER TABLE course_coverage_plan_details ADD CONSTRAINT Refcourse_coverage_plan178 
    FOREIGN KEY (courseCoveragePlanId)
    REFERENCES course_coverage_plan(id)
;

ALTER TABLE course_coverage_plan_details ADD CONSTRAINT Refusers1244 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE course_coverage_plan_details ADD CONSTRAINT Refcourse_topics2028 
    FOREIGN KEY (courseTopicId)
    REFERENCES course_topics(id)
;

ALTER TABLE course_coverage_plan_details ADD CONSTRAINT Reffaculties2113 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;

ALTER TABLE course_coverage_plan_details ADD CONSTRAINT Reffaculties2114 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;

ALTER TABLE course_coverage_plan_details ADD CONSTRAINT Reffaculties2115 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;

ALTER TABLE course_coverage_plan_details ADD CONSTRAINT Reffaculties2116 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;


-- 
-- TABLE: course_distribution_list 
--

ALTER TABLE course_distribution_list ADD CONSTRAINT Refdistribution_list1038 
    FOREIGN KEY (distributionListId)
    REFERENCES distribution_list(id)
;

ALTER TABLE course_distribution_list ADD CONSTRAINT Refusers1045 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE course_distribution_list ADD CONSTRAINT Refcourse_variants1144 
    FOREIGN KEY (courseVariantId)
    REFERENCES course_variants(id)
;


-- 
-- TABLE: course_equivalence 
--

ALTER TABLE course_equivalence ADD CONSTRAINT Refcourse_components161 
    FOREIGN KEY (courseComponentId)
    REFERENCES course_components(id)
;

ALTER TABLE course_equivalence ADD CONSTRAINT Refusers1245 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE course_equivalence ADD CONSTRAINT Refcourse_components1855 
    FOREIGN KEY (equivalentComponent)
    REFERENCES course_components(id)
;


-- 
-- TABLE: course_evaluation_que_paper 
--

ALTER TABLE course_evaluation_que_paper ADD CONSTRAINT Refeval_seq_detail1157 
    FOREIGN KEY (evalSequenceDetailId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE course_evaluation_que_paper ADD CONSTRAINT Refquestion_paper1159 
    FOREIGN KEY (questionPaperId)
    REFERENCES question_paper(id)
;

ALTER TABLE course_evaluation_que_paper ADD CONSTRAINT Refusers1246 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: course_group 
--

ALTER TABLE course_group ADD CONSTRAINT Refusers1247 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: course_groups_course 
--

ALTER TABLE course_groups_course ADD CONSTRAINT Refcourse_group162 
    FOREIGN KEY (courseGroupId)
    REFERENCES course_group(id)
;

ALTER TABLE course_groups_course ADD CONSTRAINT Refcourses166 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE course_groups_course ADD CONSTRAINT Refusers1075 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: course_history_one 
--

ALTER TABLE course_history_one ADD CONSTRAINT Refprog_batch_period_config1605 
    FOREIGN KEY (progBatchPeriodConfigId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE course_history_one ADD CONSTRAINT Refcourses1606 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE course_history_one ADD CONSTRAINT Refcourse_group1607 
    FOREIGN KEY (courseGroupId)
    REFERENCES course_group(id)
;

ALTER TABLE course_history_one ADD CONSTRAINT Refusers1608 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: course_history_two 
--

ALTER TABLE course_history_two ADD CONSTRAINT Refcourse_history_one1604 
    FOREIGN KEY (courseHistoryOneId)
    REFERENCES course_history_one(id)
;

ALTER TABLE course_history_two ADD CONSTRAINT Refcourse_variants1609 
    FOREIGN KEY (courseVariantId)
    REFERENCES course_variants(id)
;

ALTER TABLE course_history_two ADD CONSTRAINT Refusers1610 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: course_hw_asignment 
--

ALTER TABLE course_hw_asignment ADD CONSTRAINT Refprog_batch_period_config200 
    FOREIGN KEY (programBatchPeriodConfigId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE course_hw_asignment ADD CONSTRAINT Refassignment800 
    FOREIGN KEY (assignmentId)
    REFERENCES assignment(id)
;

ALTER TABLE course_hw_asignment ADD CONSTRAINT Refevaluation_plan847 
    FOREIGN KEY (evaluationPlanId)
    REFERENCES evaluation_plan(id)
;

ALTER TABLE course_hw_asignment ADD CONSTRAINT Refevaluation_group848 
    FOREIGN KEY (evaluationGroupId)
    REFERENCES evaluation_group(id)
;

ALTER TABLE course_hw_asignment ADD CONSTRAINT Refevaluation_sequence849 
    FOREIGN KEY (evaluationSequenceId)
    REFERENCES evaluation_sequence(id)
;

ALTER TABLE course_hw_asignment ADD CONSTRAINT Refeval_seq_detail850 
    FOREIGN KEY (evaluationDetailSequenceId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE course_hw_asignment ADD CONSTRAINT Refsections851 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;

ALTER TABLE course_hw_asignment ADD CONSTRAINT Refusers1248 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE course_hw_asignment ADD CONSTRAINT Refbatches1862 
    FOREIGN KEY (batchId)
    REFERENCES batches(id)
;


-- 
-- TABLE: course_read_distribution 
--

ALTER TABLE course_read_distribution ADD CONSTRAINT Refdistribution_list1039 
    FOREIGN KEY (distributionListId)
    REFERENCES distribution_list(id)
;

ALTER TABLE course_read_distribution ADD CONSTRAINT Refcourse_reading1042 
    FOREIGN KEY (courseReadingId)
    REFERENCES course_reading(id)
;

ALTER TABLE course_read_distribution ADD CONSTRAINT Refusers1046 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: course_read_type 
--

ALTER TABLE course_read_type ADD CONSTRAINT Refusers1249 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: course_reading 
--

ALTER TABLE course_reading ADD CONSTRAINT Refcourses159 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE course_reading ADD CONSTRAINT Refcourse_read_type803 
    FOREIGN KEY (courseReadTypeId)
    REFERENCES course_read_type(id)
;

ALTER TABLE course_reading ADD CONSTRAINT Refusers1251 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE course_reading ADD CONSTRAINT Refdistribution_mode1864 
    FOREIGN KEY (distributionModeId)
    REFERENCES distribution_mode(id)
;


-- 
-- TABLE: course_reading_links 
--

ALTER TABLE course_reading_links ADD CONSTRAINT Refcourse_reading1151 
    FOREIGN KEY (courseReadingId)
    REFERENCES course_reading(id)
;

ALTER TABLE course_reading_links ADD CONSTRAINT Refusers1253 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: course_reading_period_details 
--

ALTER TABLE course_reading_period_details ADD CONSTRAINT Refcourse_reading2341 
    FOREIGN KEY (courseReadingId)
    REFERENCES course_reading(id)
;

ALTER TABLE course_reading_period_details ADD CONSTRAINT Refprograms2346 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE course_reading_period_details ADD CONSTRAINT Refbatches2347 
    FOREIGN KEY (batchId)
    REFERENCES batches(id)
;

ALTER TABLE course_reading_period_details ADD CONSTRAINT Refprog_batch_period_config2348 
    FOREIGN KEY (periodId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE course_reading_period_details ADD CONSTRAINT Refusers2349 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: course_reading_topics 
--

ALTER TABLE course_reading_topics ADD CONSTRAINT Refcourse_reading1148 
    FOREIGN KEY (courseReadingId)
    REFERENCES course_reading(id)
;

ALTER TABLE course_reading_topics ADD CONSTRAINT Refusers1254 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE course_reading_topics ADD CONSTRAINT Refcourse_topics2030 
    FOREIGN KEY (courseTopicId)
    REFERENCES course_topics(id)
;


-- 
-- TABLE: course_reading_variant 
--

ALTER TABLE course_reading_variant ADD CONSTRAINT Refcourse_reading1146 
    FOREIGN KEY (courseReadingId)
    REFERENCES course_reading(id)
;

ALTER TABLE course_reading_variant ADD CONSTRAINT Refcourse_variants1147 
    FOREIGN KEY (courseVariantId)
    REFERENCES course_variants(id)
;

ALTER TABLE course_reading_variant ADD CONSTRAINT Refusers1255 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: course_relation_history 
--

ALTER TABLE course_relation_history ADD CONSTRAINT Refcourses1613 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE course_relation_history ADD CONSTRAINT Refcourses1614 
    FOREIGN KEY (relatedCourseId)
    REFERENCES courses(id)
;

ALTER TABLE course_relation_history ADD CONSTRAINT Refusers1615 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE course_relation_history ADD CONSTRAINT Refbatches1905 
    FOREIGN KEY (programBatchId)
    REFERENCES batches(id)
;


-- 
-- TABLE: course_req_detail_courses 
--

ALTER TABLE course_req_detail_courses ADD CONSTRAINT Refcourse_withdraw_req_details2317 
    FOREIGN KEY (courseWithdrawReqDetailId)
    REFERENCES course_withdraw_req_details(detailId)
;

ALTER TABLE course_req_detail_courses ADD CONSTRAINT Refcourses2318 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;


-- 
-- TABLE: course_topic_session 
--

ALTER TABLE course_topic_session ADD CONSTRAINT Refcourse_topics1600 
    FOREIGN KEY (courseTopicId)
    REFERENCES course_topics(id)
;

ALTER TABLE course_topic_session ADD CONSTRAINT Refcourse_variants1602 
    FOREIGN KEY (courseVariantId)
    REFERENCES course_variants(id)
;

ALTER TABLE course_topic_session ADD CONSTRAINT Refusers1603 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: course_topics 
--

ALTER TABLE course_topics ADD CONSTRAINT Refcourse_components160 
    FOREIGN KEY (courseComponentId)
    REFERENCES course_components(id)
;

ALTER TABLE course_topics ADD CONSTRAINT Refusers1256 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE course_topics ADD CONSTRAINT Reftopic_depth1966 
    FOREIGN KEY (topicDepth)
    REFERENCES topic_depth(id)
;


-- 
-- TABLE: course_variants 
--

ALTER TABLE course_variants ADD CONSTRAINT Refcourses163 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE course_variants ADD CONSTRAINT Refcalendars841 
    FOREIGN KEY (calendarId)
    REFERENCES calendars(id)
;

ALTER TABLE course_variants ADD CONSTRAINT Refusers1096 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: course_withdraw_req_details 
--

ALTER TABLE course_withdraw_req_details ADD CONSTRAINT Refservice_request_details2254 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;

ALTER TABLE course_withdraw_req_details ADD CONSTRAINT Refprograms2256 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;


-- 
-- TABLE: course_xfer_request_details 
--

ALTER TABLE course_xfer_request_details ADD CONSTRAINT Refservice_request_details2251 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;

ALTER TABLE course_xfer_request_details ADD CONSTRAINT Refcourses2252 
    FOREIGN KEY (toCourseId)
    REFERENCES courses(id)
;

ALTER TABLE course_xfer_request_details ADD CONSTRAINT Refcourses2253 
    FOREIGN KEY (fromCourseId)
    REFERENCES courses(id)
;


-- 
-- TABLE: courses 
--

ALTER TABLE courses ADD CONSTRAINT Refusers1097 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE courses ADD CONSTRAINT Refdepartment1098 
    FOREIGN KEY (departmentId)
    REFERENCES department(id)
;

ALTER TABLE courses ADD CONSTRAINT Refdepartment1099 
    FOREIGN KEY (subDepartmentId)
    REFERENCES department(id)
;

ALTER TABLE courses ADD CONSTRAINT Refselection_stage1850 
    FOREIGN KEY (stageId)
    REFERENCES selection_stage(id)
;

ALTER TABLE courses ADD CONSTRAINT Refusers1851 
    FOREIGN KEY (courseCoordinator)
    REFERENCES users(id)
;


-- 
-- TABLE: currency 
--

ALTER TABLE currency ADD CONSTRAINT Refusers1076 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: currency_exchange_rate 
--

ALTER TABLE currency_exchange_rate ADD CONSTRAINT Refcurrency2182 
    FOREIGN KEY (currencyId)
    REFERENCES currency(id)
;


-- 
-- TABLE: currency_exchange_rate_history 
--

ALTER TABLE currency_exchange_rate_history ADD CONSTRAINT Refcurrency2183 
    FOREIGN KEY (currencyId)
    REFERENCES currency(id)
;


-- 
-- TABLE: data_to_be_changed 
--

ALTER TABLE data_to_be_changed ADD CONSTRAINT Refpersons2189 
    FOREIGN KEY (personId)
    REFERENCES persons(id)
;


-- 
-- TABLE: dataview_audit 
--

ALTER TABLE dataview_audit ADD CONSTRAINT Refusers400 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE dataview_audit ADD CONSTRAINT Refusers1257 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: debarment_reasons 
--

ALTER TABLE debarment_reasons ADD CONSTRAINT Refusers2261 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: debarment_request_details 
--

ALTER TABLE debarment_request_details ADD CONSTRAINT Refservice_request_details2257 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;

ALTER TABLE debarment_request_details ADD CONSTRAINT Refcourses2258 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE debarment_request_details ADD CONSTRAINT Refdebarment_reasons2259 
    FOREIGN KEY (debarmentReasonId)
    REFERENCES debarment_reasons(id)
;

ALTER TABLE debarment_request_details ADD CONSTRAINT Refprograms2260 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;


-- 
-- TABLE: default_search_criterias 
--

ALTER TABLE default_search_criterias ADD CONSTRAINT Refsearch_config1894 
    FOREIGN KEY (searchConfigId)
    REFERENCES search_config(id)
;

ALTER TABLE default_search_criterias ADD CONSTRAINT Refsearch_config_table1895 
    FOREIGN KEY (searchConfigTableId)
    REFERENCES search_config_table(id)
;

ALTER TABLE default_search_criterias ADD CONSTRAINT Refsearch_table_column1896 
    FOREIGN KEY (searchTableColumnId)
    REFERENCES search_table_column(id)
;

ALTER TABLE default_search_criterias ADD CONSTRAINT Refsearch_criteria_operator1897 
    FOREIGN KEY (searchCriteriaOperatorId)
    REFERENCES search_criteria_operator(id)
;


-- 
-- TABLE: deficit_credit 
--

ALTER TABLE deficit_credit ADD CONSTRAINT Refgrade814 
    FOREIGN KEY (gradeId)
    REFERENCES grade(id)
;

ALTER TABLE deficit_credit ADD CONSTRAINT Refgrades_group815 
    FOREIGN KEY (gradeGroupId)
    REFERENCES grades_group(id)
;

ALTER TABLE deficit_credit ADD CONSTRAINT Refusers1258 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE deficit_credit ADD CONSTRAINT Refcourses1865 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;


-- 
-- TABLE: deficit_credit_transaction 
--

ALTER TABLE deficit_credit_transaction ADD CONSTRAINT Refusers1259 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE deficit_credit_transaction ADD CONSTRAINT Refadmission1691 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE deficit_credit_transaction ADD CONSTRAINT Refprog_batch_period_config1692 
    FOREIGN KEY (programBatchPeriodConfigId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE deficit_credit_transaction ADD CONSTRAINT Refcourses1693 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE deficit_credit_transaction ADD CONSTRAINT Refsections1694 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;

ALTER TABLE deficit_credit_transaction ADD CONSTRAINT Refcourse_components1695 
    FOREIGN KEY (courseComponentId)
    REFERENCES course_components(id)
;

ALTER TABLE deficit_credit_transaction ADD CONSTRAINT Refevaluation_sequence1696 
    FOREIGN KEY (evalSequenceId)
    REFERENCES evaluation_sequence(id)
;

ALTER TABLE deficit_credit_transaction ADD CONSTRAINT Refeval_seq_detail1697 
    FOREIGN KEY (evalDetailSequenceId)
    REFERENCES eval_seq_detail(id)
;


-- 
-- TABLE: department 
--

ALTER TABLE department ADD CONSTRAINT Refacademy_location519 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;

ALTER TABLE department ADD CONSTRAINT Refusers817 
    FOREIGN KEY (hodId)
    REFERENCES users(id)
;

ALTER TABLE department ADD CONSTRAINT Refusers818 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE department ADD CONSTRAINT Refdepartment1077 
    FOREIGN KEY (parentDepartmentId)
    REFERENCES department(id)
;


-- 
-- TABLE: disciplinary_actions 
--

ALTER TABLE disciplinary_actions ADD CONSTRAINT Refusers2054 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE disciplinary_actions ADD CONSTRAINT Refpersons2056 
    FOREIGN KEY (personId)
    REFERENCES persons(id)
;


-- 
-- TABLE: distribution_list 
--

ALTER TABLE distribution_list ADD CONSTRAINT Refusers1263 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE distribution_list ADD CONSTRAINT Refusers2394 
    FOREIGN KEY (createdBy)
    REFERENCES users(id)
;

ALTER TABLE distribution_list ADD CONSTRAINT Refdistribution_mode2395 
    FOREIGN KEY (distributionModeId)
    REFERENCES distribution_mode(id)
;


-- 
-- TABLE: distribution_mode 
--

ALTER TABLE distribution_mode ADD CONSTRAINT Refusers1863 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: document_rules 
--

ALTER TABLE document_rules ADD CONSTRAINT Refdocuments2212 
    FOREIGN KEY (documentId)
    REFERENCES documents(id)
;

ALTER TABLE document_rules ADD CONSTRAINT Refservice_request_settings2218 
    FOREIGN KEY (serviceRequestSettingId)
    REFERENCES service_request_settings(id)
;


-- 
-- TABLE: documents 
--

ALTER TABLE documents ADD CONSTRAINT Refusers1685 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: draft_grade_distribution 
--

ALTER TABLE draft_grade_distribution ADD CONSTRAINT Refusers1264 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE draft_grade_distribution ADD CONSTRAINT Refprograms1642 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE draft_grade_distribution ADD CONSTRAINT Refbatches1643 
    FOREIGN KEY (batchId)
    REFERENCES batches(id)
;

ALTER TABLE draft_grade_distribution ADD CONSTRAINT Refcourses1644 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE draft_grade_distribution ADD CONSTRAINT Refcourse_variants1645 
    FOREIGN KEY (courseVarientId)
    REFERENCES course_variants(id)
;

ALTER TABLE draft_grade_distribution ADD CONSTRAINT Refevaluation_sequence1646 
    FOREIGN KEY (evalSequenceId)
    REFERENCES evaluation_sequence(id)
;

ALTER TABLE draft_grade_distribution ADD CONSTRAINT Refeval_seq_detail1647 
    FOREIGN KEY (evalDetailSequenceId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE draft_grade_distribution ADD CONSTRAINT Refusers1648 
    FOREIGN KEY (enteredBy)
    REFERENCES users(id)
;


-- 
-- TABLE: drop_down 
--

ALTER TABLE drop_down ADD CONSTRAINT Refusers2351 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: education_data_to_be_changed 
--

ALTER TABLE education_data_to_be_changed ADD CONSTRAINT Refdata_to_be_changed2191 
    FOREIGN KEY (dataToBeChangedId)
    REFERENCES data_to_be_changed(id)
;


-- 
-- TABLE: education_histories 
--

ALTER TABLE education_histories ADD CONSTRAINT Refusers2053 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE education_histories ADD CONSTRAINT Refpersons2057 
    FOREIGN KEY (personId)
    REFERENCES persons(id)
;


-- 
-- TABLE: enq_address 
--

ALTER TABLE enq_address ADD CONSTRAINT Refenquiry13 
    FOREIGN KEY (enquiryId)
    REFERENCES enquiry(id)
;

ALTER TABLE enq_address ADD CONSTRAINT Refaddress34 
    FOREIGN KEY (addressId)
    REFERENCES address(id)
;

ALTER TABLE enq_address ADD CONSTRAINT Refusers328 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: enq_closure_reason 
--

ALTER TABLE enq_closure_reason ADD CONSTRAINT Refenquiry50 
    FOREIGN KEY (enquiryId)
    REFERENCES enquiry(id)
;

ALTER TABLE enq_closure_reason ADD CONSTRAINT Refclosure_reason51 
    FOREIGN KEY (closureReasonId)
    REFERENCES closure_reason(id)
;

ALTER TABLE enq_closure_reason ADD CONSTRAINT Refenq_student_details149 
    FOREIGN KEY (enqStudentDetailsId)
    REFERENCES enq_student_details(id)
;

ALTER TABLE enq_closure_reason ADD CONSTRAINT Refadmission_enq_details150 
    FOREIGN KEY (enqAdmissionDetailsId)
    REFERENCES admission_enq_details(id)
;

ALTER TABLE enq_closure_reason ADD CONSTRAINT Refusers1265 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: enq_exams_details 
--

ALTER TABLE enq_exams_details ADD CONSTRAINT Refenquiry14 
    FOREIGN KEY (enquiryId)
    REFERENCES enquiry(id)
;

ALTER TABLE enq_exams_details ADD CONSTRAINT Refusers331 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE enq_exams_details ADD CONSTRAINT Refenq_program_master1963 
    FOREIGN KEY (qualifyingProgramId)
    REFERENCES enq_program_master(id)
;


-- 
-- TABLE: enq_followup 
--

ALTER TABLE enq_followup ADD CONSTRAINT Refenquiry5 
    FOREIGN KEY (enquiryId)
    REFERENCES enquiry(id)
;

ALTER TABLE enq_followup ADD CONSTRAINT Refusers35 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE enq_followup ADD CONSTRAINT Refusers335 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE enq_followup ADD CONSTRAINT Refusers1867 
    FOREIGN KEY (assignTo)
    REFERENCES users(id)
;


-- 
-- TABLE: enq_program_master 
--

ALTER TABLE enq_program_master ADD CONSTRAINT Refusers1962 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: enq_reopen_reason 
--

ALTER TABLE enq_reopen_reason ADD CONSTRAINT Refenquiry52 
    FOREIGN KEY (enquiryId)
    REFERENCES enquiry(id)
;

ALTER TABLE enq_reopen_reason ADD CONSTRAINT Refreopen_reason53 
    FOREIGN KEY (reopenReasonId)
    REFERENCES reopen_reason(id)
;

ALTER TABLE enq_reopen_reason ADD CONSTRAINT Refenq_student_details151 
    FOREIGN KEY (enqStudentDetailsId)
    REFERENCES enq_student_details(id)
;

ALTER TABLE enq_reopen_reason ADD CONSTRAINT Refadmission_enq_details152 
    FOREIGN KEY (enqAdmissionDetailsId)
    REFERENCES admission_enq_details(id)
;

ALTER TABLE enq_reopen_reason ADD CONSTRAINT Refusers327 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: enq_student_details 
--

ALTER TABLE enq_student_details ADD CONSTRAINT Refenquiry17 
    FOREIGN KEY (enquiryId)
    REFERENCES enquiry(id)
;

ALTER TABLE enq_student_details ADD CONSTRAINT Refreservation_category48 
    FOREIGN KEY (reservationCategoryId)
    REFERENCES reservation_category(id)
;

ALTER TABLE enq_student_details ADD CONSTRAINT Refusers330 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE enq_student_details ADD CONSTRAINT Refadmission1621 
    FOREIGN KEY (sibiling1AdmissionId)
    REFERENCES admission(id)
;

ALTER TABLE enq_student_details ADD CONSTRAINT Refadmission1622 
    FOREIGN KEY (sibiling2AdmissionId)
    REFERENCES admission(id)
;

ALTER TABLE enq_student_details ADD CONSTRAINT Refadmission1623 
    FOREIGN KEY (sibiling3AdmissionId)
    REFERENCES admission(id)
;

ALTER TABLE enq_student_details ADD CONSTRAINT Refusers1639 
    FOREIGN KEY (fatherEmployeeId)
    REFERENCES users(id)
;

ALTER TABLE enq_student_details ADD CONSTRAINT Refusers1640 
    FOREIGN KEY (motherEmployeeId)
    REFERENCES users(id)
;

ALTER TABLE enq_student_details ADD CONSTRAINT Refincome_slabs1881 
    FOREIGN KEY (familyIncomeId)
    REFERENCES income_slabs(id)
;


-- 
-- TABLE: enquiry 
--

ALTER TABLE enquiry ADD CONSTRAINT Refcampaign10 
    FOREIGN KEY (campaignId)
    REFERENCES campaign(id)
;

ALTER TABLE enquiry ADD CONSTRAINT Refenquiry_type15 
    FOREIGN KEY (enquiryTypeId)
    REFERENCES enquiry_type(id)
;

ALTER TABLE enquiry ADD CONSTRAINT Refusers47 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE enquiry ADD CONSTRAINT Refusers326 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE enquiry ADD CONSTRAINT Refusers1868 
    FOREIGN KEY (registeredBy)
    REFERENCES users(id)
;

ALTER TABLE enquiry ADD CONSTRAINT Refusers1961 
    FOREIGN KEY (followUpUser)
    REFERENCES users(id)
;


-- 
-- TABLE: enquiry_cf_data 
--

ALTER TABLE enquiry_cf_data ADD CONSTRAINT Refenquiry1592 
    FOREIGN KEY (enquiryId)
    REFERENCES enquiry(id)
;

ALTER TABLE enquiry_cf_data ADD CONSTRAINT Refusers1594 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: enquiry_student_address 
--

ALTER TABLE enquiry_student_address ADD CONSTRAINT Refenq_student_details916 
    FOREIGN KEY (enqStudentDetailsId)
    REFERENCES enq_student_details(id)
;

ALTER TABLE enquiry_student_address ADD CONSTRAINT Refaddress917 
    FOREIGN KEY (addressId)
    REFERENCES address(id)
;

ALTER TABLE enquiry_student_address ADD CONSTRAINT Refusers1266 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: enquiry_type 
--

ALTER TABLE enquiry_type ADD CONSTRAINT Refusers336 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: entity_field_meta_data 
--

ALTER TABLE entity_field_meta_data ADD CONSTRAINT Refentity_type1577 
    FOREIGN KEY (entityTypeId)
    REFERENCES entity_type(id)
;

ALTER TABLE entity_field_meta_data ADD CONSTRAINT Refusers1578 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: entity_setting 
--

ALTER TABLE entity_setting ADD CONSTRAINT Refusers304 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: eval_group_center 
--

ALTER TABLE eval_group_center ADD CONSTRAINT Refevaluation_group635 
    FOREIGN KEY (evaluationGroupId)
    REFERENCES evaluation_group(id)
;

ALTER TABLE eval_group_center ADD CONSTRAINT Refexam_center636 
    FOREIGN KEY (centerId)
    REFERENCES exam_center(id)
;

ALTER TABLE eval_group_center ADD CONSTRAINT Refeval_seq_detail1173 
    FOREIGN KEY (evalSequenceDetailId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE eval_group_center ADD CONSTRAINT Refusers1268 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: eval_group_criteria 
--

ALTER TABLE eval_group_criteria ADD CONSTRAINT Refevaluation_group385 
    FOREIGN KEY (evaluationGroupId)
    REFERENCES evaluation_group(id)
;

ALTER TABLE eval_group_criteria ADD CONSTRAINT Refusers1269 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: eval_group_sch_date 
--

ALTER TABLE eval_group_sch_date ADD CONSTRAINT Refevaluation_group387 
    FOREIGN KEY (evaluationGroupId)
    REFERENCES evaluation_group(id)
;

ALTER TABLE eval_group_sch_date ADD CONSTRAINT Refeval_seq_detail1171 
    FOREIGN KEY (evalSequenceDetailId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE eval_group_sch_date ADD CONSTRAINT Refusers1270 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: eval_group_seat_type 
--

ALTER TABLE eval_group_seat_type ADD CONSTRAINT Refevaluation_group388 
    FOREIGN KEY (evaluationGroupId)
    REFERENCES evaluation_group(id)
;

ALTER TABLE eval_group_seat_type ADD CONSTRAINT Refprog_batch_period_config1170 
    FOREIGN KEY (progBatchPeriodConfigId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE eval_group_seat_type ADD CONSTRAINT Refusers1271 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: eval_group_sequences 
--

ALTER TABLE eval_group_sequences ADD CONSTRAINT Refevaluation_group386 
    FOREIGN KEY (evaluationGroupId)
    REFERENCES evaluation_group(id)
;

ALTER TABLE eval_group_sequences ADD CONSTRAINT Refcourses702 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE eval_group_sequences ADD CONSTRAINT Refevaluation_plan703 
    FOREIGN KEY (evaluationPlanId)
    REFERENCES evaluation_plan(id)
;

ALTER TABLE eval_group_sequences ADD CONSTRAINT Refevaluation_sequence704 
    FOREIGN KEY (evaluationSequenceId)
    REFERENCES evaluation_sequence(id)
;

ALTER TABLE eval_group_sequences ADD CONSTRAINT Refusers1272 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: eval_seq_detail 
--

ALTER TABLE eval_seq_detail ADD CONSTRAINT Refevaluation_sequence463 
    FOREIGN KEY (evalSequenceId)
    REFERENCES evaluation_sequence(id)
;

ALTER TABLE eval_seq_detail ADD CONSTRAINT Refusers1274 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: eval_sequence_logistics 
--

ALTER TABLE eval_sequence_logistics ADD CONSTRAINT Refevaluation_sequence382 
    FOREIGN KEY (evalSequenceId)
    REFERENCES evaluation_sequence(id)
;

ALTER TABLE eval_sequence_logistics ADD CONSTRAINT Refusers1273 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: eval_sequence_rules 
--

ALTER TABLE eval_sequence_rules ADD CONSTRAINT Refcourse_evaluation_que_paper1158 
    FOREIGN KEY (courseEvalQuePaperId)
    REFERENCES course_evaluation_que_paper(id)
;

ALTER TABLE eval_sequence_rules ADD CONSTRAINT Refusers1275 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: evaluation_group 
--

ALTER TABLE evaluation_group ADD CONSTRAINT Refprograms683 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE evaluation_group ADD CONSTRAINT Refbatches684 
    FOREIGN KEY (batchId)
    REFERENCES batches(id)
;

ALTER TABLE evaluation_group ADD CONSTRAINT Reffee_plan685 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;

ALTER TABLE evaluation_group ADD CONSTRAINT Refusers1276 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: evaluation_plan 
--

ALTER TABLE evaluation_plan ADD CONSTRAINT Refcourses678 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE evaluation_plan ADD CONSTRAINT Refsections679 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;

ALTER TABLE evaluation_plan ADD CONSTRAINT Refusers1277 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE evaluation_plan ADD CONSTRAINT Refusers1870 
    FOREIGN KEY (assignedTo)
    REFERENCES users(id)
;


-- 
-- TABLE: evaluation_plan_batches 
--

ALTER TABLE evaluation_plan_batches ADD CONSTRAINT Refeval_seq_detail1165 
    FOREIGN KEY (evalSequenceDetailId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE evaluation_plan_batches ADD CONSTRAINT Refbatches1166 
    FOREIGN KEY (batchId)
    REFERENCES batches(id)
;

ALTER TABLE evaluation_plan_batches ADD CONSTRAINT Refusers1278 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: evaluation_plan_level_one 
--

ALTER TABLE evaluation_plan_level_one ADD CONSTRAINT Refevaluation_plan1152 
    FOREIGN KEY (evaluationPlanId)
    REFERENCES evaluation_plan(id)
;

ALTER TABLE evaluation_plan_level_one ADD CONSTRAINT Refusers1279 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: evaluation_plan_level_two 
--

ALTER TABLE evaluation_plan_level_two ADD CONSTRAINT Refevaluation_plan_level_one1153 
    FOREIGN KEY (evalPlanLevelOneId)
    REFERENCES evaluation_plan_level_one(id)
;

ALTER TABLE evaluation_plan_level_two ADD CONSTRAINT Refcourse_components1154 
    FOREIGN KEY (courseComponentId)
    REFERENCES course_components(id)
;

ALTER TABLE evaluation_plan_level_two ADD CONSTRAINT Refusers1280 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: evaluation_plan_students 
--

ALTER TABLE evaluation_plan_students ADD CONSTRAINT Refeval_seq_detail1162 
    FOREIGN KEY (evalSequenceDetailId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE evaluation_plan_students ADD CONSTRAINT Refadmission1163 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE evaluation_plan_students ADD CONSTRAINT Refusers1281 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: evaluation_plan_topic 
--

ALTER TABLE evaluation_plan_topic ADD CONSTRAINT Refeval_seq_detail1160 
    FOREIGN KEY (evalSequenceDetailId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE evaluation_plan_topic ADD CONSTRAINT Refcourse_topics1161 
    FOREIGN KEY (courseTopicId)
    REFERENCES course_topics(id)
;

ALTER TABLE evaluation_plan_topic ADD CONSTRAINT Refusers1282 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: evaluation_sec_sequences 
--

ALTER TABLE evaluation_sec_sequences ADD CONSTRAINT Refeval_seq_detail1164 
    FOREIGN KEY (evalSequenceDetailId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE evaluation_sec_sequences ADD CONSTRAINT Refusers1284 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: evaluation_sequence 
--

ALTER TABLE evaluation_sequence ADD CONSTRAINT Refevaluation_plan_level_two1155 
    FOREIGN KEY (evalPlanLevelTwoId)
    REFERENCES evaluation_plan_level_two(id)
;

ALTER TABLE evaluation_sequence ADD CONSTRAINT Refusers1285 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: evaluation_type_course 
--

ALTER TABLE evaluation_type_course ADD CONSTRAINT Refevaluation_plan786 
    FOREIGN KEY (evaluationPlanId)
    REFERENCES evaluation_plan(id)
;

ALTER TABLE evaluation_type_course ADD CONSTRAINT Refcourses791 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE evaluation_type_course ADD CONSTRAINT Refsections792 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;

ALTER TABLE evaluation_type_course ADD CONSTRAINT Refusers1467 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: evaluation_type_program 
--

ALTER TABLE evaluation_type_program ADD CONSTRAINT Refevaluation_plan648 
    FOREIGN KEY (evaluationPlanId)
    REFERENCES evaluation_plan(id)
;

ALTER TABLE evaluation_type_program ADD CONSTRAINT Refprog_batch_period_config790 
    FOREIGN KEY (programBatchPeriodConfigId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE evaluation_type_program ADD CONSTRAINT Refsections1156 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;

ALTER TABLE evaluation_type_program ADD CONSTRAINT Refusers1468 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: exam_center 
--

ALTER TABLE exam_center ADD CONSTRAINT Refusers1286 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE exam_center ADD CONSTRAINT Refusers1883 
    FOREIGN KEY (centerResponsibleId)
    REFERENCES users(id)
;

ALTER TABLE exam_center ADD CONSTRAINT Refaddress1884 
    FOREIGN KEY (centerAddressId)
    REFERENCES address(id)
;


-- 
-- TABLE: exam_centre_change_req_types 
--

ALTER TABLE exam_centre_change_req_types ADD CONSTRAINT Refexam_request_type_details2264 
    FOREIGN KEY (examRequestTypeDetailId)
    REFERENCES exam_request_type_details(id)
;

ALTER TABLE exam_centre_change_req_types ADD CONSTRAINT Refbatches2265 
    FOREIGN KEY (currentExamBatchId)
    REFERENCES batches(id)
;

ALTER TABLE exam_centre_change_req_types ADD CONSTRAINT Refbatches2266 
    FOREIGN KEY (expectedExamBatchId)
    REFERENCES batches(id)
;

ALTER TABLE exam_centre_change_req_types ADD CONSTRAINT Refexam_center2267 
    FOREIGN KEY (currentExamCentreId)
    REFERENCES exam_center(id)
;

ALTER TABLE exam_centre_change_req_types ADD CONSTRAINT Refexam_center2268 
    FOREIGN KEY (expectedExamCentreId)
    REFERENCES exam_center(id)
;


-- 
-- TABLE: exam_date_change_req_types 
--

ALTER TABLE exam_date_change_req_types ADD CONSTRAINT Refexam_request_type_details2269 
    FOREIGN KEY (examRequestTypeDetailId)
    REFERENCES exam_request_type_details(id)
;

ALTER TABLE exam_date_change_req_types ADD CONSTRAINT Refbatches2270 
    FOREIGN KEY (expectedExamBatchId)
    REFERENCES batches(id)
;

ALTER TABLE exam_date_change_req_types ADD CONSTRAINT Refbatches2271 
    FOREIGN KEY (currentExamBatchId)
    REFERENCES batches(id)
;


-- 
-- TABLE: exam_leave_req_types 
--

ALTER TABLE exam_leave_req_types ADD CONSTRAINT Refexam_request_type_details2272 
    FOREIGN KEY (examRequestTypeDetailId)
    REFERENCES exam_request_type_details(id)
;

ALTER TABLE exam_leave_req_types ADD CONSTRAINT Refexam_center2273 
    FOREIGN KEY (currentExamCentreId)
    REFERENCES exam_center(id)
;


-- 
-- TABLE: exam_logistics 
--

ALTER TABLE exam_logistics ADD CONSTRAINT Refprograms726 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE exam_logistics ADD CONSTRAINT Refcourses727 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE exam_logistics ADD CONSTRAINT Refeval_seq_detail730 
    FOREIGN KEY (evalSequenceDetailId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE exam_logistics ADD CONSTRAINT Refevaluation_plan731 
    FOREIGN KEY (evaluationPlanId)
    REFERENCES evaluation_plan(id)
;

ALTER TABLE exam_logistics ADD CONSTRAINT Refevaluation_sequence732 
    FOREIGN KEY (evalSequenceId)
    REFERENCES evaluation_sequence(id)
;

ALTER TABLE exam_logistics ADD CONSTRAINT Refexam_center733 
    FOREIGN KEY (centerId)
    REFERENCES exam_center(id)
;

ALTER TABLE exam_logistics ADD CONSTRAINT Refbatches734 
    FOREIGN KEY (batchId)
    REFERENCES batches(id)
;

ALTER TABLE exam_logistics ADD CONSTRAINT Refselection_stage735 
    FOREIGN KEY (stageId)
    REFERENCES selection_stage(id)
;

ALTER TABLE exam_logistics ADD CONSTRAINT Refusers1287 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: exam_logistics_details 
--

ALTER TABLE exam_logistics_details ADD CONSTRAINT Refexam_logistics736 
    FOREIGN KEY (logisticId)
    REFERENCES exam_logistics(id)
;

ALTER TABLE exam_logistics_details ADD CONSTRAINT Refusers1288 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE exam_logistics_details ADD CONSTRAINT Refusers1709 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;


-- 
-- TABLE: exam_logistics_malpractice 
--

ALTER TABLE exam_logistics_malpractice ADD CONSTRAINT Refexam_logistics396 
    FOREIGN KEY (logisticId)
    REFERENCES exam_logistics(id)
;

ALTER TABLE exam_logistics_malpractice ADD CONSTRAINT Refadmission737 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE exam_logistics_malpractice ADD CONSTRAINT Refusers1289 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: exam_malpractice_type 
--

ALTER TABLE exam_malpractice_type ADD CONSTRAINT Refexam_logistics_malpractice397 
    FOREIGN KEY (malpracticeId)
    REFERENCES exam_logistics_malpractice(mgmtGroupTypeId)
;

ALTER TABLE exam_malpractice_type ADD CONSTRAINT Refusers1290 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: exam_paper_reval_req_types 
--

ALTER TABLE exam_paper_reval_req_types ADD CONSTRAINT Refexam_request_type_details2274 
    FOREIGN KEY (examRequestTypeDetailId)
    REFERENCES exam_request_type_details(id)
;

ALTER TABLE exam_paper_reval_req_types ADD CONSTRAINT Refquestion_paper2275 
    FOREIGN KEY (questionPaperId)
    REFERENCES question_paper(id)
;


-- 
-- TABLE: exam_related_request_details 
--

ALTER TABLE exam_related_request_details ADD CONSTRAINT Refservice_request_details2282 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;

ALTER TABLE exam_related_request_details ADD CONSTRAINT Refexam_request_type_details2283 
    FOREIGN KEY (examRequestTypeDetailId)
    REFERENCES exam_request_type_details(id)
;


-- 
-- TABLE: exam_request_type_details 
--

ALTER TABLE exam_request_type_details ADD CONSTRAINT Refusers2262 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE exam_request_type_details ADD CONSTRAINT Refcourses2263 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;


-- 
-- TABLE: exam_staff_allocation 
--

ALTER TABLE exam_staff_allocation ADD CONSTRAINT Refeval_seq_detail392 
    FOREIGN KEY (evaluationSeqDetailId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE exam_staff_allocation ADD CONSTRAINT Refusers693 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE exam_staff_allocation ADD CONSTRAINT Refroles694 
    FOREIGN KEY (roleId)
    REFERENCES roles(id)
;

ALTER TABLE exam_staff_allocation ADD CONSTRAINT Refexam_center695 
    FOREIGN KEY (centerId)
    REFERENCES exam_center(id)
;

ALTER TABLE exam_staff_allocation ADD CONSTRAINT Refusers1292 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: exam_timeslot 
--

ALTER TABLE exam_timeslot ADD CONSTRAINT Refselection_stage689 
    FOREIGN KEY (stageId)
    REFERENCES selection_stage(id)
;

ALTER TABLE exam_timeslot ADD CONSTRAINT Refexam_center691 
    FOREIGN KEY (centerId)
    REFERENCES exam_center(id)
;

ALTER TABLE exam_timeslot ADD CONSTRAINT Refevaluation_group692 
    FOREIGN KEY (evaluationGroupId)
    REFERENCES evaluation_group(id)
;

ALTER TABLE exam_timeslot ADD CONSTRAINT Refevaluation_plan_students1181 
    FOREIGN KEY (evaluationPlanStudentId)
    REFERENCES evaluation_plan_students(id)
;

ALTER TABLE exam_timeslot ADD CONSTRAINT Refusers1293 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE exam_timeslot ADD CONSTRAINT Refgroup_date_batch_center1569 
    FOREIGN KEY (groupDateBatchCenterId)
    REFERENCES group_date_batch_center(id)
;


-- 
-- TABLE: exam_timeslot_booking 
--

ALTER TABLE exam_timeslot_booking ADD CONSTRAINT Refexam_timeslot391 
    FOREIGN KEY (timeSlotId)
    REFERENCES exam_timeslot(id)
;

ALTER TABLE exam_timeslot_booking ADD CONSTRAINT Refcourses688 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE exam_timeslot_booking ADD CONSTRAINT Refusers1294 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: exam_withdrawal_req_types 
--

ALTER TABLE exam_withdrawal_req_types ADD CONSTRAINT Refexam_request_type_details2276 
    FOREIGN KEY (examRequestTypeDetailId)
    REFERENCES exam_request_type_details(id)
;

ALTER TABLE exam_withdrawal_req_types ADD CONSTRAINT Refexam_center2277 
    FOREIGN KEY (currentExamCentreId)
    REFERENCES exam_center(id)
;


-- 
-- TABLE: examination_request 
--

ALTER TABLE examination_request ADD CONSTRAINT Refservice_request229 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_request(id)
;

ALTER TABLE examination_request ADD CONSTRAINT Refexecution_request863 
    FOREIGN KEY (executionRequestId)
    REFERENCES execution_request(id)
;

ALTER TABLE examination_request ADD CONSTRAINT Refrequest_followup864 
    FOREIGN KEY (requestFollowUpId)
    REFERENCES request_followup(id)
;

ALTER TABLE examination_request ADD CONSTRAINT Refusers1295 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: examination_result 
--

ALTER TABLE examination_result ADD CONSTRAINT Refadmission738 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE examination_result ADD CONSTRAINT Refcourses739 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE examination_result ADD CONSTRAINT Refquestion_paper740 
    FOREIGN KEY (questionPaperId)
    REFERENCES question_paper(id)
;

ALTER TABLE examination_result ADD CONSTRAINT Refprog_batch_period_config741 
    FOREIGN KEY (programBatchPeriodConfigId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE examination_result ADD CONSTRAINT Refusers1296 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE examination_result ADD CONSTRAINT Refslctn_process_stage1698 
    FOREIGN KEY (evaluationStageId)
    REFERENCES slctn_process_stage(id)
;

ALTER TABLE examination_result ADD CONSTRAINT Refevaluation_sequence1699 
    FOREIGN KEY (evaluationSeqId)
    REFERENCES evaluation_sequence(id)
;

ALTER TABLE examination_result ADD CONSTRAINT Refeval_seq_detail1700 
    FOREIGN KEY (evaluationDetailSequenceId)
    REFERENCES eval_seq_detail(id)
;


-- 
-- TABLE: examiner_allocation 
--

ALTER TABLE examiner_allocation ADD CONSTRAINT Refeval_seq_detail1570 
    FOREIGN KEY (evalPlanDetailSeqId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE examiner_allocation ADD CONSTRAINT Refusers1571 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE examiner_allocation ADD CONSTRAINT Refusers1572 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: examiner_feedback 
--

ALTER TABLE examiner_feedback ADD CONSTRAINT Refevaluation_type_program705 
    FOREIGN KEY (evalTypeId)
    REFERENCES evaluation_type_program(id)
;

ALTER TABLE examiner_feedback ADD CONSTRAINT Refcourses706 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE examiner_feedback ADD CONSTRAINT Refselection_stage707 
    FOREIGN KEY (stageId)
    REFERENCES selection_stage(id)
;

ALTER TABLE examiner_feedback ADD CONSTRAINT Refevaluation_sequence708 
    FOREIGN KEY (evaluationSeqId)
    REFERENCES evaluation_sequence(id)
;

ALTER TABLE examiner_feedback ADD CONSTRAINT Refquestion_paper709 
    FOREIGN KEY (questionPaperId)
    REFERENCES question_paper(id)
;

ALTER TABLE examiner_feedback ADD CONSTRAINT Refusers710 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE examiner_feedback ADD CONSTRAINT Refroles711 
    FOREIGN KEY (roleId)
    REFERENCES roles(id)
;

ALTER TABLE examiner_feedback ADD CONSTRAINT Refusers1297 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: execution_details 
--

ALTER TABLE execution_details ADD CONSTRAINT Refservice_requests2235 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_requests(id)
;

ALTER TABLE execution_details ADD CONSTRAINT Refusers2236 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE execution_details ADD CONSTRAINT Refusers2237 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE execution_details ADD CONSTRAINT Refrequest_handover_modes2241 
    FOREIGN KEY (handoverModeId)
    REFERENCES request_handover_modes(id)
;


-- 
-- TABLE: execution_request 
--

ALTER TABLE execution_request ADD CONSTRAINT Refusers861 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE execution_request ADD CONSTRAINT Reffee_plan862 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;

ALTER TABLE execution_request ADD CONSTRAINT Refusers1298 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: external_resources 
--

ALTER TABLE external_resources ADD CONSTRAINT Refusers983 
    FOREIGN KEY (concernedPersonId)
    REFERENCES users(id)
;

ALTER TABLE external_resources ADD CONSTRAINT Refresources1027 
    FOREIGN KEY (resourceId)
    REFERENCES resources(id)
;


-- 
-- TABLE: extracurricular_activity 
--

ALTER TABLE extracurricular_activity ADD CONSTRAINT Refusers2052 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE extracurricular_activity ADD CONSTRAINT Refpersons2058 
    FOREIGN KEY (personId)
    REFERENCES persons(id)
;

ALTER TABLE extracurricular_activity ADD CONSTRAINT Refcommunity2153 
    FOREIGN KEY (communityId)
    REFERENCES community(id)
;


-- 
-- TABLE: extracurricular_to_be_changed 
--

ALTER TABLE extracurricular_to_be_changed ADD CONSTRAINT Refdata_to_be_changed2192 
    FOREIGN KEY (dataToBeChangedId)
    REFERENCES data_to_be_changed(id)
;


-- 
-- TABLE: fac_course_account_detail 
--

ALTER TABLE fac_course_account_detail ADD CONSTRAINT Refconfig_control_account1510 
    FOREIGN KEY (configControlAccountId)
    REFERENCES config_control_account(id)
;

ALTER TABLE fac_course_account_detail ADD CONSTRAINT Refiau_accounting1511 
    FOREIGN KEY (accountingConfigId)
    REFERENCES iau_accounting(id)
;

ALTER TABLE fac_course_account_detail ADD CONSTRAINT Refcourses1514 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE fac_course_account_detail ADD CONSTRAINT Refusers1515 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: fac_course_comp_acc_detail 
--

ALTER TABLE fac_course_comp_acc_detail ADD CONSTRAINT Refconfig_control_account1512 
    FOREIGN KEY (configControlAccountId)
    REFERENCES config_control_account(id)
;

ALTER TABLE fac_course_comp_acc_detail ADD CONSTRAINT Refaccount_config1513 
    FOREIGN KEY (accountingConfigId)
    REFERENCES account_config(id)
;

ALTER TABLE fac_course_comp_acc_detail ADD CONSTRAINT Refcourse_components1516 
    FOREIGN KEY (courseComponentId)
    REFERENCES course_components(id)
;

ALTER TABLE fac_course_comp_acc_detail ADD CONSTRAINT Refusers1517 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: fac_data_change_request 
--

ALTER TABLE fac_data_change_request ADD CONSTRAINT Refusers1299 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE fac_data_change_request ADD CONSTRAINT Refusers1872 
    FOREIGN KEY (approvedBy)
    REFERENCES users(id)
;

ALTER TABLE fac_data_change_request ADD CONSTRAINT Reffaculties2117 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;


-- 
-- TABLE: fac_default_control_account 
--

ALTER TABLE fac_default_control_account ADD CONSTRAINT Reffaculty_account357 
    FOREIGN KEY (facultyAccountId)
    REFERENCES faculty_account(id)
;

ALTER TABLE fac_default_control_account ADD CONSTRAINT Refusers1300 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE fac_default_control_account ADD CONSTRAINT Refcourses1874 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE fac_default_control_account ADD CONSTRAINT Refcourse_components1875 
    FOREIGN KEY (courseComponentId)
    REFERENCES course_components(id)
;

ALTER TABLE fac_default_control_account ADD CONSTRAINT Reffaculties2108 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;


-- 
-- TABLE: fac_perform_param 
--

ALTER TABLE fac_perform_param ADD CONSTRAINT Refusers1301 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: fac_type_account_details 
--

ALTER TABLE fac_type_account_details ADD CONSTRAINT Refconfig_control_account1518 
    FOREIGN KEY (configControlAccountId)
    REFERENCES config_control_account(id)
;

ALTER TABLE fac_type_account_details ADD CONSTRAINT Refaccount_config1519 
    FOREIGN KEY (accountingConfigId)
    REFERENCES account_config(id)
;

ALTER TABLE fac_type_account_details ADD CONSTRAINT Refusers1520 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: faculties 
--

ALTER TABLE faculties ADD CONSTRAINT Refusers2070 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE faculties ADD CONSTRAINT Refdepartment2071 
    FOREIGN KEY (departmentId)
    REFERENCES department(id)
;

ALTER TABLE faculties ADD CONSTRAINT Refdepartment2072 
    FOREIGN KEY (subDepartmentId)
    REFERENCES department(id)
;

ALTER TABLE faculties ADD CONSTRAINT Refpersons2128 
    FOREIGN KEY (personId)
    REFERENCES persons(id)
;


-- 
-- TABLE: faculty_account 
--

ALTER TABLE faculty_account ADD CONSTRAINT Refaccount_config353 
    FOREIGN KEY (accountconfigId)
    REFERENCES account_config(id)
;

ALTER TABLE faculty_account ADD CONSTRAINT Refusers1302 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE faculty_account ADD CONSTRAINT Reforganization_units1876 
    FOREIGN KEY (iauId)
    REFERENCES organization_units(id)
;


-- 
-- TABLE: faculty_cheques 
--

ALTER TABLE faculty_cheques ADD CONSTRAINT Refusers1305 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE faculty_cheques ADD CONSTRAINT Reffaculties2088 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;


-- 
-- TABLE: faculty_docs 
--

ALTER TABLE faculty_docs ADD CONSTRAINT Refusers1307 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE faculty_docs ADD CONSTRAINT Refusers1877 
    FOREIGN KEY (inspectedBy)
    REFERENCES users(id)
;

ALTER TABLE faculty_docs ADD CONSTRAINT Refusers1878 
    FOREIGN KEY (docReturnedBy)
    REFERENCES users(id)
;

ALTER TABLE faculty_docs ADD CONSTRAINT Refusers1879 
    FOREIGN KEY (docReturnedTo)
    REFERENCES users(id)
;

ALTER TABLE faculty_docs ADD CONSTRAINT Reffaculties2096 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;


-- 
-- TABLE: faculty_fee_plan 
--

ALTER TABLE faculty_fee_plan ADD CONSTRAINT Refusers1082 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: faculty_feedback 
--

ALTER TABLE faculty_feedback ADD CONSTRAINT Refcourses873 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE faculty_feedback ADD CONSTRAINT Refusers1310 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE faculty_feedback ADD CONSTRAINT Reffaculties2095 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;


-- 
-- TABLE: faculty_feedback_details 
--

ALTER TABLE faculty_feedback_details ADD CONSTRAINT Reffaculty_feedback569 
    FOREIGN KEY (feedbackId)
    REFERENCES faculty_feedback(id)
;

ALTER TABLE faculty_feedback_details ADD CONSTRAINT Refusers1311 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE faculty_feedback_details ADD CONSTRAINT Refquestionnaire1680 
    FOREIGN KEY (questionnaireId)
    REFERENCES questionnaire(id)
;


-- 
-- TABLE: faculty_payment_settings 
--

ALTER TABLE faculty_payment_settings ADD CONSTRAINT Refcourses874 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE faculty_payment_settings ADD CONSTRAINT Refusers1313 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE faculty_payment_settings ADD CONSTRAINT Reffaculties2098 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;


-- 
-- TABLE: faculty_performance 
--

ALTER TABLE faculty_performance ADD CONSTRAINT Reffac_perform_param247 
    FOREIGN KEY (performanceParamId)
    REFERENCES fac_perform_param(id)
;

ALTER TABLE faculty_performance ADD CONSTRAINT Refusers1314 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE faculty_performance ADD CONSTRAINT Reffaculties2097 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;


-- 
-- TABLE: faculty_program 
--

ALTER TABLE faculty_program ADD CONSTRAINT Refprog_batch_period_config876 
    FOREIGN KEY (programBatchPeriodConfigId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE faculty_program ADD CONSTRAINT Refcourse_components878 
    FOREIGN KEY (courseComponentId)
    REFERENCES course_components(id)
;

ALTER TABLE faculty_program ADD CONSTRAINT Refsections879 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;

ALTER TABLE faculty_program ADD CONSTRAINT Refusers1316 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE faculty_program ADD CONSTRAINT Reffaculties2091 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;

ALTER TABLE faculty_program ADD CONSTRAINT Reffaculties2092 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;

ALTER TABLE faculty_program ADD CONSTRAINT Refcourses2093 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE faculty_program ADD CONSTRAINT Refcourse_topics2172 
    FOREIGN KEY (courseTopicId)
    REFERENCES course_topics(id)
;


-- 
-- TABLE: faculty_topic_assignment 
--

ALTER TABLE faculty_topic_assignment ADD CONSTRAINT Refsections507 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;

ALTER TABLE faculty_topic_assignment ADD CONSTRAINT Refusers1318 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE faculty_topic_assignment ADD CONSTRAINT Reffaculties2099 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;

ALTER TABLE faculty_topic_assignment ADD CONSTRAINT Refcourse_topics2180 
    FOREIGN KEY (topicId)
    REFERENCES course_topics(id)
;

ALTER TABLE faculty_topic_assignment ADD CONSTRAINT Refcourse_variants2181 
    FOREIGN KEY (courseVariantId)
    REFERENCES course_variants(id)
;


-- 
-- TABLE: feature 
--

ALTER TABLE feature ADD CONSTRAINT Refsystem_modules946 
    FOREIGN KEY (systemModuleId)
    REFERENCES system_modules(id)
;

ALTER TABLE feature ADD CONSTRAINT Refusers948 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: feature_privilege 
--

ALTER TABLE feature_privilege ADD CONSTRAINT Refprivilege949 
    FOREIGN KEY (privilegeId)
    REFERENCES privilege(id)
;

ALTER TABLE feature_privilege ADD CONSTRAINT Reffeature950 
    FOREIGN KEY (featureId)
    REFERENCES feature(id)
;

ALTER TABLE feature_privilege ADD CONSTRAINT Refusers951 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: fee_config_modes 
--

ALTER TABLE fee_config_modes ADD CONSTRAINT Reffee_stage_head_config904 
    FOREIGN KEY (feeStageHeadConfigId)
    REFERENCES fee_stage_head_config(id)
;

ALTER TABLE fee_config_modes ADD CONSTRAINT Refusers1321 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: fee_details 
--

ALTER TABLE fee_details ADD CONSTRAINT Refservice_requests2238 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_requests(id)
;

ALTER TABLE fee_details ADD CONSTRAINT Refusers2239 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: fee_discount 
--

ALTER TABLE fee_discount ADD CONSTRAINT Reffee_stage_head_config797 
    FOREIGN KEY (feeStageHeadConfigId)
    REFERENCES fee_stage_head_config(id)
;

ALTER TABLE fee_discount ADD CONSTRAINT Refusers1322 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: fee_heads 
--

ALTER TABLE fee_heads ADD CONSTRAINT Refusers1323 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: fee_notifications 
--

ALTER TABLE fee_notifications ADD CONSTRAINT Reffee_plan258 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;

ALTER TABLE fee_notifications ADD CONSTRAINT Refusers1326 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: fee_plan 
--

ALTER TABLE fee_plan ADD CONSTRAINT Refcurrency1483 
    FOREIGN KEY (currencyId)
    REFERENCES currency(id)
;

ALTER TABLE fee_plan ADD CONSTRAINT Refusers1484 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE fee_plan ADD CONSTRAINT Refusers1792 
    FOREIGN KEY (approver)
    REFERENCES users(id)
;


-- 
-- TABLE: fee_plan_acad_locations 
--

ALTER TABLE fee_plan_acad_locations ADD CONSTRAINT Reffee_plan794 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;

ALTER TABLE fee_plan_acad_locations ADD CONSTRAINT Refprog_batch_seat_config795 
    FOREIGN KEY (progBatchSeatConfigId)
    REFERENCES prog_batch_seat_config(id)
;

ALTER TABLE fee_plan_acad_locations ADD CONSTRAINT Refacademy_location796 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;

ALTER TABLE fee_plan_acad_locations ADD CONSTRAINT Refusers1328 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: fee_plan_rule_stage 
--

ALTER TABLE fee_plan_rule_stage ADD CONSTRAINT Reffee_plan259 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;

ALTER TABLE fee_plan_rule_stage ADD CONSTRAINT Refselection_stage774 
    FOREIGN KEY (stageId)
    REFERENCES selection_stage(id)
;

ALTER TABLE fee_plan_rule_stage ADD CONSTRAINT Refusers1330 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE fee_plan_rule_stage ADD CONSTRAINT Reffee_plan_rules1485 
    FOREIGN KEY (feePlanRuleId)
    REFERENCES fee_plan_rules(id)
;


-- 
-- TABLE: fee_plan_rules 
--

ALTER TABLE fee_plan_rules ADD CONSTRAINT Reffee_plan250 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;

ALTER TABLE fee_plan_rules ADD CONSTRAINT Refusers1329 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: fee_plan_submission_sch 
--

ALTER TABLE fee_plan_submission_sch ADD CONSTRAINT Reffee_stage_head_config256 
    FOREIGN KEY (feeStageHeadConfigId)
    REFERENCES fee_stage_head_config(id)
;

ALTER TABLE fee_plan_submission_sch ADD CONSTRAINT Refusers1324 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: fee_refund_modes 
--

ALTER TABLE fee_refund_modes ADD CONSTRAINT Refusers1331 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE fee_refund_modes ADD CONSTRAINT Reffee_stage_head_config1486 
    FOREIGN KEY (feeStageHeadConfigId)
    REFERENCES fee_stage_head_config(id)
;


-- 
-- TABLE: fee_refunds 
--

ALTER TABLE fee_refunds ADD CONSTRAINT Reffee_refund_modes253 
    FOREIGN KEY (feeRefundModeId)
    REFERENCES fee_refund_modes(id)
;

ALTER TABLE fee_refunds ADD CONSTRAINT Reffee_stage_head_config257 
    FOREIGN KEY (feeConfigId)
    REFERENCES fee_stage_head_config(id)
;

ALTER TABLE fee_refunds ADD CONSTRAINT Refusers1332 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: fee_related_request_details 
--

ALTER TABLE fee_related_request_details ADD CONSTRAINT Refservice_request_details2284 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;


-- 
-- TABLE: fee_request 
--

ALTER TABLE fee_request ADD CONSTRAINT Reffee_plan770 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;

ALTER TABLE fee_request ADD CONSTRAINT Refselection_stage771 
    FOREIGN KEY (stageId)
    REFERENCES selection_stage(id)
;

ALTER TABLE fee_request ADD CONSTRAINT Reffee_heads772 
    FOREIGN KEY (feeHeadId)
    REFERENCES fee_heads(id)
;

ALTER TABLE fee_request ADD CONSTRAINT Refusers1333 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE fee_request ADD CONSTRAINT Refstudents2131 
    FOREIGN KEY (studentId)
    REFERENCES students(personId)
;


-- 
-- TABLE: fee_rule_documents 
--

ALTER TABLE fee_rule_documents ADD CONSTRAINT Reffee_plan_rules249 
    FOREIGN KEY (feeRuleId)
    REFERENCES fee_plan_rules(id)
;

ALTER TABLE fee_rule_documents ADD CONSTRAINT Refusers1334 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE fee_rule_documents ADD CONSTRAINT Refdocuments1793 
    FOREIGN KEY (documentId)
    REFERENCES documents(id)
;


-- 
-- TABLE: fee_sch_details 
--

ALTER TABLE fee_sch_details ADD CONSTRAINT Refusers1325 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE fee_sch_details ADD CONSTRAINT Reffee_schedule_student1490 
    FOREIGN KEY (feeScheduleStudentId)
    REFERENCES fee_schedule_student(id)
;


-- 
-- TABLE: fee_schedule_student 
--

ALTER TABLE fee_schedule_student ADD CONSTRAINT Reffee_plan_submission_sch1488 
    FOREIGN KEY (feeSubmissionSchId)
    REFERENCES fee_plan_submission_sch(id)
;

ALTER TABLE fee_schedule_student ADD CONSTRAINT Refusers1489 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE fee_schedule_student ADD CONSTRAINT Refstudents2132 
    FOREIGN KEY (studentId)
    REFERENCES students(personId)
;


-- 
-- TABLE: fee_stage_head_config 
--

ALTER TABLE fee_stage_head_config ADD CONSTRAINT Reffee_refund_modes252 
    FOREIGN KEY (feeManageId)
    REFERENCES fee_refund_modes(id)
;

ALTER TABLE fee_stage_head_config ADD CONSTRAINT Reffee_plan_rule_stage255 
    FOREIGN KEY (feePlanRuleStageId)
    REFERENCES fee_plan_rule_stage(id)
;

ALTER TABLE fee_stage_head_config ADD CONSTRAINT Reffee_heads260 
    FOREIGN KEY (feeHeadId)
    REFERENCES fee_heads(id)
;

ALTER TABLE fee_stage_head_config ADD CONSTRAINT Reffee_plan_rule_stage773 
    FOREIGN KEY (feeStageId)
    REFERENCES fee_plan_rule_stage(id)
;

ALTER TABLE fee_stage_head_config ADD CONSTRAINT Refusers1335 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE fee_stage_head_config ADD CONSTRAINT Reforganization_units1794 
    FOREIGN KEY (iauId)
    REFERENCES organization_units(id)
;


-- 
-- TABLE: feedback_questions 
--

ALTER TABLE feedback_questions ADD CONSTRAINT Refexaminer_feedback646 
    FOREIGN KEY (feedBackId)
    REFERENCES examiner_feedback(id)
;

ALTER TABLE feedback_questions ADD CONSTRAINT Refquestion_bank_questions712 
    FOREIGN KEY (questionId)
    REFERENCES question_bank_questions(id)
;

ALTER TABLE feedback_questions ADD CONSTRAINT Refusers1336 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: fine_request_details 
--

ALTER TABLE fine_request_details ADD CONSTRAINT Reffee_heads2289 
    FOREIGN KEY (feeHeadId)
    REFERENCES fee_heads(id)
;

ALTER TABLE fine_request_details ADD CONSTRAINT Refservice_request_details2290 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;


-- 
-- TABLE: followup_details 
--

ALTER TABLE followup_details ADD CONSTRAINT Refservice_requests2229 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_requests(id)
;

ALTER TABLE followup_details ADD CONSTRAINT Refusers2230 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE followup_details ADD CONSTRAINT Refusers2231 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE followup_details ADD CONSTRAINT Refusers2330 
    FOREIGN KEY (approverUserId)
    REFERENCES users(id)
;

ALTER TABLE followup_details ADD CONSTRAINT Refusers2331 
    FOREIGN KEY (assigneeUserId)
    REFERENCES users(id)
;


-- 
-- TABLE: free_form_request_categories 
--

ALTER TABLE free_form_request_categories ADD CONSTRAINT Refusers2207 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: free_form_request_details 
--

ALTER TABLE free_form_request_details ADD CONSTRAINT Refservice_request_details2291 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;


-- 
-- TABLE: free_form_request_types 
--

ALTER TABLE free_form_request_types ADD CONSTRAINT Reffree_form_request_categories2210 
    FOREIGN KEY (categoryId)
    REFERENCES free_form_request_categories(id)
;

ALTER TABLE free_form_request_types ADD CONSTRAINT Refrequest_types2211 
    FOREIGN KEY (requestTypeId)
    REFERENCES request_types(id)
;


-- 
-- TABLE: free_format_request 
--

ALTER TABLE free_format_request ADD CONSTRAINT Refservice_request231 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_request(id)
;

ALTER TABLE free_format_request ADD CONSTRAINT Refusers1337 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE free_format_request ADD CONSTRAINT Refexecution_request1795 
    FOREIGN KEY (executionRequestId)
    REFERENCES execution_request(id)
;

ALTER TABLE free_format_request ADD CONSTRAINT Refrequest_followup1796 
    FOREIGN KEY (requestFollowUpId)
    REFERENCES request_followup(id)
;


-- 
-- TABLE: grade 
--

ALTER TABLE grade ADD CONSTRAINT Refusers1341 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: grade_distribution_details 
--

ALTER TABLE grade_distribution_details ADD CONSTRAINT Refdraft_grade_distribution819 
    FOREIGN KEY (distributionId)
    REFERENCES draft_grade_distribution(id)
;

ALTER TABLE grade_distribution_details ADD CONSTRAINT Refusers1342 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE grade_distribution_details ADD CONSTRAINT Refgrade1704 
    FOREIGN KEY (gradeId)
    REFERENCES grade(id)
;

ALTER TABLE grade_distribution_details ADD CONSTRAINT Refusers1705 
    FOREIGN KEY (enteredBy)
    REFERENCES users(id)
;


-- 
-- TABLE: grade_group 
--

ALTER TABLE grade_group ADD CONSTRAINT Refusers1343 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: grades_group 
--

ALTER TABLE grades_group ADD CONSTRAINT Refgrade812 
    FOREIGN KEY (gradeId)
    REFERENCES grade(id)
;

ALTER TABLE grades_group ADD CONSTRAINT Refgrade_group813 
    FOREIGN KEY (gradeGroupId)
    REFERENCES grade_group(id)
;

ALTER TABLE grades_group ADD CONSTRAINT Refusers1344 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: group_batch_seat_type 
--

ALTER TABLE group_batch_seat_type ADD CONSTRAINT Refgroup_date_batch_center1565 
    FOREIGN KEY (groupDateBatchCenterId)
    REFERENCES group_date_batch_center(id)
;

ALTER TABLE group_batch_seat_type ADD CONSTRAINT Refprog_batch_seat_config1566 
    FOREIGN KEY (progBatchSeatConfigId)
    REFERENCES prog_batch_seat_config(id)
;

ALTER TABLE group_batch_seat_type ADD CONSTRAINT Refusers1567 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: group_date_batch_center 
--

ALTER TABLE group_date_batch_center ADD CONSTRAINT Refeval_group_sch_date1562 
    FOREIGN KEY (evalGroupSchDateId)
    REFERENCES eval_group_sch_date(id)
;

ALTER TABLE group_date_batch_center ADD CONSTRAINT Refgroup_schedule_batch1563 
    FOREIGN KEY (evalGroupSchBatchId)
    REFERENCES group_schedule_batch(id)
;

ALTER TABLE group_date_batch_center ADD CONSTRAINT Refeval_group_center1564 
    FOREIGN KEY (evalGroupSchCenterId)
    REFERENCES eval_group_center(id)
;

ALTER TABLE group_date_batch_center ADD CONSTRAINT Refusers1568 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: group_hw_assignment 
--

ALTER TABLE group_hw_assignment ADD CONSTRAINT Refusers1345 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE group_hw_assignment ADD CONSTRAINT Refcourse_hw_asignment1861 
    FOREIGN KEY (hwAssignmentId)
    REFERENCES course_hw_asignment(id)
;

ALTER TABLE group_hw_assignment ADD CONSTRAINT Refstudents2133 
    FOREIGN KEY (studentId)
    REFERENCES students(personId)
;


-- 
-- TABLE: group_schedule_batch 
--

ALTER TABLE group_schedule_batch ADD CONSTRAINT Refevaluation_group389 
    FOREIGN KEY (evaluationGroupId)
    REFERENCES evaluation_group(id)
;

ALTER TABLE group_schedule_batch ADD CONSTRAINT Refeval_seq_detail1172 
    FOREIGN KEY (evalSequenceDetailId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE group_schedule_batch ADD CONSTRAINT Refusers1802 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: guestfaculty_sessions 
--

ALTER TABLE guestfaculty_sessions ADD CONSTRAINT Refcourse_variants1803 
    FOREIGN KEY (courseVarientId)
    REFERENCES course_variants(id)
;

ALTER TABLE guestfaculty_sessions ADD CONSTRAINT Refusers1804 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE guestfaculty_sessions ADD CONSTRAINT Reffaculties2119 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;


-- 
-- TABLE: hod_history 
--

ALTER TABLE hod_history ADD CONSTRAINT Refdepartment475 
    FOREIGN KEY (departmentId)
    REFERENCES department(id)
;

ALTER TABLE hod_history ADD CONSTRAINT Refusers478 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE hod_history ADD CONSTRAINT Refusers1806 
    FOREIGN KEY (hod)
    REFERENCES users(id)
;


-- 
-- TABLE: iau_accounting 
--

ALTER TABLE iau_accounting ADD CONSTRAINT Refaccount_config363 
    FOREIGN KEY (accountConfigId)
    REFERENCES account_config(id)
;

ALTER TABLE iau_accounting ADD CONSTRAINT Refusers1346 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE iau_accounting ADD CONSTRAINT Reforganization_units1805 
    FOREIGN KEY (iauId)
    REFERENCES organization_units(id)
;


-- 
-- TABLE: id_definition 
--

ALTER TABLE id_definition ADD CONSTRAINT Refusers1114 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE id_definition ADD CONSTRAINT Refid_entity_setting1899 
    FOREIGN KEY (idEntitySettingId)
    REFERENCES id_entity_setting(id)
;


-- 
-- TABLE: id_entity_setting 
--

ALTER TABLE id_entity_setting ADD CONSTRAINT Refusers1116 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE id_entity_setting ADD CONSTRAINT Refsearch_table_column1809 
    FOREIGN KEY (searchTableColumnId)
    REFERENCES search_table_column(id)
;

ALTER TABLE id_entity_setting ADD CONSTRAINT Refsearch_table1900 
    FOREIGN KEY (searchTableId)
    REFERENCES search_table(id)
;


-- 
-- TABLE: id_format 
--

ALTER TABLE id_format ADD CONSTRAINT Refid_definition1108 
    FOREIGN KEY (idDefinitionId)
    REFERENCES id_definition(id)
;

ALTER TABLE id_format ADD CONSTRAINT Refusers1113 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: id_format_alphanumeric 
--

ALTER TABLE id_format_alphanumeric ADD CONSTRAINT Refid_format1109 
    FOREIGN KEY (id)
    REFERENCES id_format(id)
;


-- 
-- TABLE: id_format_counter_mapping 
--

ALTER TABLE id_format_counter_mapping ADD CONSTRAINT Refid_definition1112 
    FOREIGN KEY (idDefinition)
    REFERENCES id_definition(id)
;

ALTER TABLE id_format_counter_mapping ADD CONSTRAINT Refusers1115 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: id_format_dynamic 
--

ALTER TABLE id_format_dynamic ADD CONSTRAINT Refid_format1111 
    FOREIGN KEY (id)
    REFERENCES id_format(id)
;


-- 
-- TABLE: id_format_running_no 
--

ALTER TABLE id_format_running_no ADD CONSTRAINT Refid_format1110 
    FOREIGN KEY (id)
    REFERENCES id_format(id)
;


-- 
-- TABLE: incident_types 
--

ALTER TABLE incident_types ADD CONSTRAINT Refusers2041 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: incidents 
--

ALTER TABLE incidents ADD CONSTRAINT Refusers2049 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE incidents ADD CONSTRAINT Refpersons2061 
    FOREIGN KEY (personId)
    REFERENCES persons(id)
;

ALTER TABLE incidents ADD CONSTRAINT Refincident_types2073 
    FOREIGN KEY (incidentTypeId)
    REFERENCES incident_types(id)
;

ALTER TABLE incidents ADD CONSTRAINT Refusers2074 
    FOREIGN KEY (reportedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: income_slabs 
--

ALTER TABLE income_slabs ADD CONSTRAINT Refusers1832 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: individual_hw_assignment 
--

ALTER TABLE individual_hw_assignment ADD CONSTRAINT Refcourse_hw_asignment801 
    FOREIGN KEY (hwAssignmentId)
    REFERENCES course_hw_asignment(id)
;

ALTER TABLE individual_hw_assignment ADD CONSTRAINT Refusers1347 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE individual_hw_assignment ADD CONSTRAINT Refstudents2134 
    FOREIGN KEY (studentId)
    REFERENCES students(personId)
;


-- 
-- TABLE: individual_hw_download 
--

ALTER TABLE individual_hw_download ADD CONSTRAINT Refindividual_hw_assignment1143 
    FOREIGN KEY (individualHwAssignmentId)
    REFERENCES individual_hw_assignment(id)
;

ALTER TABLE individual_hw_download ADD CONSTRAINT Refusers1815 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: individual_hw_upload 
--

ALTER TABLE individual_hw_upload ADD CONSTRAINT Refindividual_hw_assignment1142 
    FOREIGN KEY (individualHwAssignmentId)
    REFERENCES individual_hw_assignment(id)
;

ALTER TABLE individual_hw_upload ADD CONSTRAINT Refusers1816 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: installment_details 
--

ALTER TABLE installment_details ADD CONSTRAINT Refusers2333 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE installment_details ADD CONSTRAINT Refexecution_details2334 
    FOREIGN KEY (installmentExecutionDetailId)
    REFERENCES execution_details(id)
;


-- 
-- TABLE: internal_resources 
--

ALTER TABLE internal_resources ADD CONSTRAINT Refresources973 
    FOREIGN KEY (resourceId)
    REFERENCES resources(id)
;

ALTER TABLE internal_resources ADD CONSTRAINT Refinternal_resources980 
    FOREIGN KEY (parentResourceId)
    REFERENCES internal_resources(resourceId)
;

ALTER TABLE internal_resources ADD CONSTRAINT Refinternal_resources981 
    FOREIGN KEY (childResourceId)
    REFERENCES internal_resources(resourceId)
;

ALTER TABLE internal_resources ADD CONSTRAINT Refcalendars982 
    FOREIGN KEY (calendarId)
    REFERENCES calendars(id)
;

ALTER TABLE internal_resources ADD CONSTRAINT Refresource_academy_locations991 
    FOREIGN KEY (resourceAcademyLocationId)
    REFERENCES resource_academy_locations(id)
;


-- 
-- TABLE: kys_data 
--

ALTER TABLE kys_data ADD CONSTRAINT Refusers2046 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: lack_of_attendance_req_types 
--

ALTER TABLE lack_of_attendance_req_types ADD CONSTRAINT Refexam_request_type_details2278 
    FOREIGN KEY (examRequestTypeDetailId)
    REFERENCES exam_request_type_details(id)
;


-- 
-- TABLE: lack_of_other_crit_req_types 
--

ALTER TABLE lack_of_other_crit_req_types ADD CONSTRAINT Refexam_request_type_details2279 
    FOREIGN KEY (examRequestTypeDetailId)
    REFERENCES exam_request_type_details(id)
;


-- 
-- TABLE: late_fee 
--

ALTER TABLE late_fee ADD CONSTRAINT Reffee_stage_head_config793 
    FOREIGN KEY (feeStageConfigId)
    REFERENCES fee_stage_head_config(id)
;

ALTER TABLE late_fee ADD CONSTRAINT Refusers1348 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: leave_request 
--

ALTER TABLE leave_request ADD CONSTRAINT Refservice_request556 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_request(id)
;

ALTER TABLE leave_request ADD CONSTRAINT Refservice_request859 
    FOREIGN KEY (requestId)
    REFERENCES service_request(id)
;

ALTER TABLE leave_request ADD CONSTRAINT Refusers1349 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE leave_request ADD CONSTRAINT Refexecution_request1797 
    FOREIGN KEY (executionRequestId)
    REFERENCES execution_request(id)
;

ALTER TABLE leave_request ADD CONSTRAINT Refrequest_followup1798 
    FOREIGN KEY (requestFollowUpId)
    REFERENCES request_followup(id)
;


-- 
-- TABLE: leave_request_details 
--

ALTER TABLE leave_request_details ADD CONSTRAINT Refservice_request_details2292 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;


-- 
-- TABLE: leave_transaction 
--

ALTER TABLE leave_transaction ADD CONSTRAINT Refusers1032 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE leave_transaction ADD CONSTRAINT Refprograms1036 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE leave_transaction ADD CONSTRAINT Refsections1037 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;

ALTER TABLE leave_transaction ADD CONSTRAINT Refadmission1145 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE leave_transaction ADD CONSTRAINT Reffaculties2120 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;


-- 
-- TABLE: leave_transaction_details 
--

ALTER TABLE leave_transaction_details ADD CONSTRAINT Refleave_transaction1031 
    FOREIGN KEY (transactionId)
    REFERENCES leave_transaction(id)
;

ALTER TABLE leave_transaction_details ADD CONSTRAINT Refusers1033 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: location_addresses 
--

ALTER TABLE location_addresses ADD CONSTRAINT Reflocations123 
    FOREIGN KEY (locationId)
    REFERENCES locations(id)
;

ALTER TABLE location_addresses ADD CONSTRAINT Refaddress138 
    FOREIGN KEY (addressId)
    REFERENCES address(id)
;

ALTER TABLE location_addresses ADD CONSTRAINT Refusers318 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: locations 
--

ALTER TABLE locations ADD CONSTRAINT Reforganizations135 
    FOREIGN KEY (organizationId)
    REFERENCES organizations(id)
;

ALTER TABLE locations ADD CONSTRAINT Refusers315 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: media 
--

ALTER TABLE media ADD CONSTRAINT Refusers324 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: medical_data_to_be_changed 
--

ALTER TABLE medical_data_to_be_changed ADD CONSTRAINT Refdata_to_be_changed2193 
    FOREIGN KEY (dataToBeChangedId)
    REFERENCES data_to_be_changed(id)
;


-- 
-- TABLE: medical_history 
--

ALTER TABLE medical_history ADD CONSTRAINT Refusers2043 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE medical_history ADD CONSTRAINT Refpersons2064 
    FOREIGN KEY (personId)
    REFERENCES persons(id)
;


-- 
-- TABLE: module_usage 
--

ALTER TABLE module_usage ADD CONSTRAINT Refusers401 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE module_usage ADD CONSTRAINT Refusers1350 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE module_usage ADD CONSTRAINT Refsystem_modules1817 
    FOREIGN KEY (moduleId)
    REFERENCES system_modules(id)
;


-- 
-- TABLE: nationalities 
--

ALTER TABLE nationalities ADD CONSTRAINT Refusers2048 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: occupation 
--

ALTER TABLE occupation ADD CONSTRAINT Refusers1777 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: organization_addresses 
--

ALTER TABLE organization_addresses ADD CONSTRAINT Reforganizations457 
    FOREIGN KEY (organizationId)
    REFERENCES organizations(id)
;

ALTER TABLE organization_addresses ADD CONSTRAINT Refaddress911 
    FOREIGN KEY (addressId)
    REFERENCES address(id)
;

ALTER TABLE organization_addresses ADD CONSTRAINT Refusers1351 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: organization_cf_data 
--

ALTER TABLE organization_cf_data ADD CONSTRAINT Reforganizations2161 
    FOREIGN KEY (organizationId)
    REFERENCES organizations(id)
;

ALTER TABLE organization_cf_data ADD CONSTRAINT Refentity_field_meta_data2162 
    FOREIGN KEY (entityFieldMetaDataId)
    REFERENCES entity_field_meta_data(id)
;


-- 
-- TABLE: organization_settings 
--

ALTER TABLE organization_settings ADD CONSTRAINT Refentity_setting99 
    FOREIGN KEY (entitySettingId)
    REFERENCES entity_setting(id)
;

ALTER TABLE organization_settings ADD CONSTRAINT Reforganizations121 
    FOREIGN KEY (organizationId)
    REFERENCES organizations(id)
;

ALTER TABLE organization_settings ADD CONSTRAINT Refusers308 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: organization_supervisory_units 
--

ALTER TABLE organization_supervisory_units ADD CONSTRAINT Reforganization_unit_types263 
    FOREIGN KEY (organizationUnitTypeId)
    REFERENCES organization_unit_types(id)
;

ALTER TABLE organization_supervisory_units ADD CONSTRAINT Reforganizations265 
    FOREIGN KEY (organizationId)
    REFERENCES organizations(id)
;

ALTER TABLE organization_supervisory_units ADD CONSTRAINT Refusers307 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: organization_unit_alps 
--

ALTER TABLE organization_unit_alps ADD CONSTRAINT Refacademy_location_purpose94 
    FOREIGN KEY (academyLocationPuirposeId)
    REFERENCES academy_location_purpose(id)
;

ALTER TABLE organization_unit_alps ADD CONSTRAINT Reforganization_units97 
    FOREIGN KEY (organizationUnitId)
    REFERENCES organization_units(id)
;

ALTER TABLE organization_unit_alps ADD CONSTRAINT Refusers312 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: organization_unit_settings 
--

ALTER TABLE organization_unit_settings ADD CONSTRAINT Refentity_setting103 
    FOREIGN KEY (entitySettingId)
    REFERENCES entity_setting(id)
;

ALTER TABLE organization_unit_settings ADD CONSTRAINT Refusers310 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE organization_unit_settings ADD CONSTRAINT Reforganization_units456 
    FOREIGN KEY (organizationUnitId)
    REFERENCES organization_units(id)
;


-- 
-- TABLE: organization_unit_types 
--

ALTER TABLE organization_unit_types ADD CONSTRAINT Refusers306 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: organization_units 
--

ALTER TABLE organization_units ADD CONSTRAINT Reforganization_units96 
    FOREIGN KEY (parentOrganizationUnitId)
    REFERENCES organization_units(id)
;

ALTER TABLE organization_units ADD CONSTRAINT Refcurrency141 
    FOREIGN KEY (currencyId)
    REFERENCES currency(id)
;

ALTER TABLE organization_units ADD CONSTRAINT Reforganization_supervisory_units264 
    FOREIGN KEY (organizationSupervisoryUnitId)
    REFERENCES organization_supervisory_units(id)
;

ALTER TABLE organization_units ADD CONSTRAINT Refusers305 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE organization_units ADD CONSTRAINT Refusers1084 
    FOREIGN KEY (ownerId)
    REFERENCES users(id)
;


-- 
-- TABLE: organizations 
--

ALTER TABLE organizations ADD CONSTRAINT Refcalendars140 
    FOREIGN KEY (calendarId)
    REFERENCES calendars(id)
;

ALTER TABLE organizations ADD CONSTRAINT Refcurrency142 
    FOREIGN KEY (currencyId)
    REFERENCES currency(id)
;

ALTER TABLE organizations ADD CONSTRAINT Refusers303 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: password_policy_notifiy 
--

ALTER TABLE password_policy_notifiy ADD CONSTRAINT Refuser_password_policy215 
    FOREIGN KEY (passwordPolicyId)
    REFERENCES user_password_policy(id)
;

ALTER TABLE password_policy_notifiy ADD CONSTRAINT Refusers320 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: pay_bill_fee_plan_stg 
--

ALTER TABLE pay_bill_fee_plan_stg ADD CONSTRAINT Refbill_header1547 
    FOREIGN KEY (billId)
    REFERENCES bill_header(id)
;

ALTER TABLE pay_bill_fee_plan_stg ADD CONSTRAINT Reffee_stage_head_config1548 
    FOREIGN KEY (feeStageHeadConfigId)
    REFERENCES fee_stage_head_config(id)
;

ALTER TABLE pay_bill_fee_plan_stg ADD CONSTRAINT Refusers1549 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: payment_adjust_refund 
--

ALTER TABLE payment_adjust_refund ADD CONSTRAINT Refpayment_mode_instrument1555 
    FOREIGN KEY (paymentModeInstrumentId)
    REFERENCES payment_mode_instrument(id)
;

ALTER TABLE payment_adjust_refund ADD CONSTRAINT Refpay_bill_fee_plan_stg1557 
    FOREIGN KEY (payBillFeePlanStgId)
    REFERENCES pay_bill_fee_plan_stg(id)
;

ALTER TABLE payment_adjust_refund ADD CONSTRAINT Refbill_faculty_payment1558 
    FOREIGN KEY (billFacultyPaymentId)
    REFERENCES bill_faculty_payment(id)
;

ALTER TABLE payment_adjust_refund ADD CONSTRAINT Refusers1561 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: payment_header 
--

ALTER TABLE payment_header ADD CONSTRAINT Refbill_header1545 
    FOREIGN KEY (billId)
    REFERENCES bill_header(id)
;

ALTER TABLE payment_header ADD CONSTRAINT Refusers1546 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: payment_mode_instrument 
--

ALTER TABLE payment_mode_instrument ADD CONSTRAINT Refpayment_header1551 
    FOREIGN KEY (paymentHeaderId)
    REFERENCES payment_header(id)
;

ALTER TABLE payment_mode_instrument ADD CONSTRAINT Refusers1552 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: pdc_adjustment 
--

ALTER TABLE pdc_adjustment ADD CONSTRAINT Refstudent_pdc1559 
    FOREIGN KEY (pdcId)
    REFERENCES student_pdc(id)
;

ALTER TABLE pdc_adjustment ADD CONSTRAINT Refusers1560 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: pers_data_request_documents 
--

ALTER TABLE pers_data_request_documents ADD CONSTRAINT Refpersonal_data_request_details2321 
    FOREIGN KEY (PersonalDataRequestDetailId)
    REFERENCES personal_data_request_details(detailId)
;

ALTER TABLE pers_data_request_documents ADD CONSTRAINT Refdocuments2322 
    FOREIGN KEY (documentId)
    REFERENCES documents(id)
;


-- 
-- TABLE: person_addresses 
--

ALTER TABLE person_addresses ADD CONSTRAINT Refusers2037 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE person_addresses ADD CONSTRAINT Refaddress2075 
    FOREIGN KEY (addressId)
    REFERENCES address(id)
;

ALTER TABLE person_addresses ADD CONSTRAINT Refaddress_type2076 
    FOREIGN KEY (addressTypeId)
    REFERENCES address_type(id)
;


-- 
-- TABLE: person_communities 
--

ALTER TABLE person_communities ADD CONSTRAINT Refusers2050 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE person_communities ADD CONSTRAINT Refpersons2060 
    FOREIGN KEY (personId)
    REFERENCES persons(id)
;

ALTER TABLE person_communities ADD CONSTRAINT Refcommunity2077 
    FOREIGN KEY (communityId)
    REFERENCES community(id)
;


-- 
-- TABLE: person_relationships 
--

ALTER TABLE person_relationships ADD CONSTRAINT Refusers2044 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE person_relationships ADD CONSTRAINT Refpersons2063 
    FOREIGN KEY (personId)
    REFERENCES persons(id)
;


-- 
-- TABLE: person_services 
--

ALTER TABLE person_services ADD CONSTRAINT Refusers2042 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE person_services ADD CONSTRAINT Refservice2079 
    FOREIGN KEY (serviceId)
    REFERENCES service(id)
;

ALTER TABLE person_services ADD CONSTRAINT Reffee_plan2080 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;


-- 
-- TABLE: person_training 
--

ALTER TABLE person_training ADD CONSTRAINT Refpersons2157 
    FOREIGN KEY (personId)
    REFERENCES persons(id)
;

ALTER TABLE person_training ADD CONSTRAINT Refusers2158 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: personal_data_request_details 
--

ALTER TABLE personal_data_request_details ADD CONSTRAINT Refservice_request_details2293 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;

ALTER TABLE personal_data_request_details ADD CONSTRAINT Refdata_to_be_changed2294 
    FOREIGN KEY (dataToBeChangedId)
    REFERENCES data_to_be_changed(id)
;


-- 
-- TABLE: personal_data_to_be_changed 
--

ALTER TABLE personal_data_to_be_changed ADD CONSTRAINT Refdata_to_be_changed2194 
    FOREIGN KEY (dataToBeChangedId)
    REFERENCES data_to_be_changed(id)
;

ALTER TABLE personal_data_to_be_changed ADD CONSTRAINT Refsalutations2195 
    FOREIGN KEY (salutationId)
    REFERENCES salutations(id)
;

ALTER TABLE personal_data_to_be_changed ADD CONSTRAINT Refcaste_categories2196 
    FOREIGN KEY (castCategoryId)
    REFERENCES caste_categories(id)
;

ALTER TABLE personal_data_to_be_changed ADD CONSTRAINT Refcountry2197 
    FOREIGN KEY (countryId)
    REFERENCES country(id)
;

ALTER TABLE personal_data_to_be_changed ADD CONSTRAINT Refreligions2198 
    FOREIGN KEY (religionId)
    REFERENCES religions(id)
;

ALTER TABLE personal_data_to_be_changed ADD CONSTRAINT Refnationalities2199 
    FOREIGN KEY (nationalityId)
    REFERENCES nationalities(id)
;


-- 
-- TABLE: persons 
--

ALTER TABLE persons ADD CONSTRAINT Refusers2004 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE persons ADD CONSTRAINT Refsalutations2151 
    FOREIGN KEY (salutationId)
    REFERENCES salutations(id)
;

ALTER TABLE persons ADD CONSTRAINT Refcountry2382 
    FOREIGN KEY (countryId)
    REFERENCES country(id)
;

ALTER TABLE persons ADD CONSTRAINT Refreligions2383 
    FOREIGN KEY (religionId)
    REFERENCES religions(id)
;

ALTER TABLE persons ADD CONSTRAINT Refnationalities2384 
    FOREIGN KEY (nationalityId)
    REFERENCES nationalities(id)
;


-- 
-- TABLE: placement_request_details 
--

ALTER TABLE placement_request_details ADD CONSTRAINT Refservice_request_details2295 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;

ALTER TABLE placement_request_details ADD CONSTRAINT Refprograms2296 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;


-- 
-- TABLE: portals 
--

ALTER TABLE portals ADD CONSTRAINT Refusers274 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: privilege 
--

ALTER TABLE privilege ADD CONSTRAINT Refusers281 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: prog_batch_course_details 
--

ALTER TABLE prog_batch_course_details ADD CONSTRAINT Refprog_batch_period_config1051 
    FOREIGN KEY (programBatchPeriodConfigId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE prog_batch_course_details ADD CONSTRAINT Refcourse_variants1052 
    FOREIGN KEY (courseVarientId)
    REFERENCES course_variants(id)
;

ALTER TABLE prog_batch_course_details ADD CONSTRAINT Refusers1053 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE prog_batch_course_details ADD CONSTRAINT Refadmission2170 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;


-- 
-- TABLE: prog_batch_course_faculty 
--

ALTER TABLE prog_batch_course_faculty ADD CONSTRAINT Refprogram_batch_course_param2352 
    FOREIGN KEY (progBatchCourseParamId)
    REFERENCES program_batch_course_param(id)
;

ALTER TABLE prog_batch_course_faculty ADD CONSTRAINT Reffaculties2378 
    FOREIGN KEY (facultyId)
    REFERENCES faculties(personId)
;

ALTER TABLE prog_batch_course_faculty ADD CONSTRAINT Refusers2379 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE prog_batch_course_faculty ADD CONSTRAINT Reffaculties2381 
    FOREIGN KEY (alternateFacultyId)
    REFERENCES faculties(personId)
;


-- 
-- TABLE: prog_batch_course_special 
--

ALTER TABLE prog_batch_course_special ADD CONSTRAINT Refspecialization1048 
    FOREIGN KEY (specializationId)
    REFERENCES specialization(id)
;

ALTER TABLE prog_batch_course_special ADD CONSTRAINT Refusers1359 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE prog_batch_course_special ADD CONSTRAINT Refbatches1909 
    FOREIGN KEY (programBatchId)
    REFERENCES batches(id)
;


-- 
-- TABLE: prog_batch_period_config 
--

ALTER TABLE prog_batch_period_config ADD CONSTRAINT Refusers1360 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE prog_batch_period_config ADD CONSTRAINT Refbatches1906 
    FOREIGN KEY (programBatchId)
    REFERENCES batches(id)
;

ALTER TABLE prog_batch_period_config ADD CONSTRAINT Refusers1967 
    FOREIGN KEY (programPeriodResponsible)
    REFERENCES users(id)
;


-- 
-- TABLE: prog_batch_seat_config 
--

ALTER TABLE prog_batch_seat_config ADD CONSTRAINT Refslctn_process_stage413 
    FOREIGN KEY (selectionProcessStageId)
    REFERENCES slctn_process_stage(id)
;

ALTER TABLE prog_batch_seat_config ADD CONSTRAINT Refseat_types923 
    FOREIGN KEY (seatTypeId)
    REFERENCES seat_types(id)
;

ALTER TABLE prog_batch_seat_config ADD CONSTRAINT Refusers1105 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE prog_batch_seat_config ADD CONSTRAINT Refbatches1911 
    FOREIGN KEY (programBatchId)
    REFERENCES batches(id)
;


-- 
-- TABLE: prog_period_break_config 
--

ALTER TABLE prog_period_break_config ADD CONSTRAINT Refprogram_period_seq485 
    FOREIGN KEY (programPeriodSeqId)
    REFERENCES program_period_seq(id)
;

ALTER TABLE prog_period_break_config ADD CONSTRAINT Refusers1361 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE prog_period_break_config ADD CONSTRAINT Refbatches1912 
    FOREIGN KEY (programBatchId)
    REFERENCES batches(id)
;


-- 
-- TABLE: prog_slctn_process_admisn_conf 
--

ALTER TABLE prog_slctn_process_admisn_conf ADD CONSTRAINT Refusers1196 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE prog_slctn_process_admisn_conf ADD CONSTRAINT Refprogram_selection_process2016 
    FOREIGN KEY (programSelectionProcessId)
    REFERENCES program_selection_process(id)
;


-- 
-- TABLE: prog_slctn_process_checklist 
--

ALTER TABLE prog_slctn_process_checklist ADD CONSTRAINT Refprogram_selection_process2014 
    FOREIGN KEY (programSelectionProcessId)
    REFERENCES program_selection_process(id)
;

ALTER TABLE prog_slctn_process_checklist ADD CONSTRAINT Refusers2015 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: prog_slctn_process_document 
--

ALTER TABLE prog_slctn_process_document ADD CONSTRAINT Refusers1197 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE prog_slctn_process_document ADD CONSTRAINT Refdocuments1686 
    FOREIGN KEY (documentId)
    REFERENCES documents(id)
;

ALTER TABLE prog_slctn_process_document ADD CONSTRAINT Refprogram_selection_process2019 
    FOREIGN KEY (programSelectionProcessId)
    REFERENCES program_selection_process(id)
;


-- 
-- TABLE: prog_slctn_process_quota_type 
--

ALTER TABLE prog_slctn_process_quota_type ADD CONSTRAINT Refprogram_selection_process1985 
    FOREIGN KEY (programSelectionProcessId)
    REFERENCES program_selection_process(id)
;

ALTER TABLE prog_slctn_process_quota_type ADD CONSTRAINT Refquota_type1986 
    FOREIGN KEY (quotaTypeId)
    REFERENCES quota_type(id)
;

ALTER TABLE prog_slctn_process_quota_type ADD CONSTRAINT Refusers2005 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: prog_slctn_process_stage_quota 
--

ALTER TABLE prog_slctn_process_stage_quota ADD CONSTRAINT Refquota882 
    FOREIGN KEY (quotaId)
    REFERENCES quota(id)
;

ALTER TABLE prog_slctn_process_stage_quota ADD CONSTRAINT Refusers1195 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE prog_slctn_process_stage_quota ADD CONSTRAINT Refprog_slctn_process_quota_type1987 
    FOREIGN KEY (programSelProcessQuotaTypeId)
    REFERENCES prog_slctn_process_quota_type(id)
;

ALTER TABLE prog_slctn_process_stage_quota ADD CONSTRAINT Refprogram_slctn_process_stages1988 
    FOREIGN KEY (programSelectionProcessStageId)
    REFERENCES program_slctn_process_stages(id)
;


-- 
-- TABLE: prog_slctn_stage_quota_overide 
--

ALTER TABLE prog_slctn_stage_quota_overide ADD CONSTRAINT Refprog_slctn_process_stage_quota1994 
    FOREIGN KEY (programSelectionStageQuotaId)
    REFERENCES prog_slctn_process_stage_quota(id)
;

ALTER TABLE prog_slctn_stage_quota_overide ADD CONSTRAINT Refusers1999 
    FOREIGN KEY (approvedBy)
    REFERENCES users(id)
;

ALTER TABLE prog_slctn_stage_quota_overide ADD CONSTRAINT Refusers2000 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: prog_slctn_stage_trnsfr_seat 
--

ALTER TABLE prog_slctn_stage_trnsfr_seat ADD CONSTRAINT Refprogram_slctn_process_stages1995 
    FOREIGN KEY (programSelectionStageId)
    REFERENCES program_slctn_process_stages(id)
;

ALTER TABLE prog_slctn_stage_trnsfr_seat ADD CONSTRAINT Refquota1996 
    FOREIGN KEY (fromQuotaId)
    REFERENCES quota(id)
;

ALTER TABLE prog_slctn_stage_trnsfr_seat ADD CONSTRAINT Refquota1998 
    FOREIGN KEY (toQuotaId)
    REFERENCES quota(id)
;

ALTER TABLE prog_slctn_stage_trnsfr_seat ADD CONSTRAINT Refusers2006 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: prog_wd_req_detail_programs 
--

ALTER TABLE prog_wd_req_detail_programs ADD CONSTRAINT Refprogram_withdraw_req_details2323 
    FOREIGN KEY (programWithdrawReqDetailId)
    REFERENCES program_withdraw_req_details(detailId)
;

ALTER TABLE prog_wd_req_detail_programs ADD CONSTRAINT Refprograms2324 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;


-- 
-- TABLE: program_batch_course_param 
--

ALTER TABLE program_batch_course_param ADD CONSTRAINT Refcourses516 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE program_batch_course_param ADD CONSTRAINT Refcourse_variants517 
    FOREIGN KEY (courseVarientId)
    REFERENCES course_variants(id)
;

ALTER TABLE program_batch_course_param ADD CONSTRAINT Refsections518 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;

ALTER TABLE program_batch_course_param ADD CONSTRAINT Refprog_batch_period_config1050 
    FOREIGN KEY (progBatchPeriodConfigId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE program_batch_course_param ADD CONSTRAINT Refusers1362 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE program_batch_course_param ADD CONSTRAINT Refusers1818 
    FOREIGN KEY (approverId)
    REFERENCES users(id)
;

ALTER TABLE program_batch_course_param ADD CONSTRAINT Refbatches1904 
    FOREIGN KEY (programBatchId)
    REFERENCES batches(id)
;


-- 
-- TABLE: program_batch_exam 
--

ALTER TABLE program_batch_exam ADD CONSTRAINT Refadmission713 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE program_batch_exam ADD CONSTRAINT Refexam_center714 
    FOREIGN KEY (centerId)
    REFERENCES exam_center(id)
;

ALTER TABLE program_batch_exam ADD CONSTRAINT Refsections715 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;

ALTER TABLE program_batch_exam ADD CONSTRAINT Refcourses716 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE program_batch_exam ADD CONSTRAINT Refprog_batch_period_config717 
    FOREIGN KEY (programBatchPeriodConfigId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE program_batch_exam ADD CONSTRAINT Refresources718 
    FOREIGN KEY (resourceId)
    REFERENCES resources(id)
;

ALTER TABLE program_batch_exam ADD CONSTRAINT Refusers1363 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: program_batch_exam_center 
--

ALTER TABLE program_batch_exam_center ADD CONSTRAINT Refexam_center838 
    FOREIGN KEY (examCenterId)
    REFERENCES exam_center(id)
;

ALTER TABLE program_batch_exam_center ADD CONSTRAINT Refusers1364 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE program_batch_exam_center ADD CONSTRAINT Refbatches1914 
    FOREIGN KEY (programBatchId)
    REFERENCES batches(id)
;


-- 
-- TABLE: program_batch_students 
--

ALTER TABLE program_batch_students ADD CONSTRAINT Refprog_batch_period_config483 
    FOREIGN KEY (progBatchPeriodConfigId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE program_batch_students ADD CONSTRAINT Refprog_batch_seat_config839 
    FOREIGN KEY (progBatchSeatConfigId)
    REFERENCES prog_batch_seat_config(id)
;

ALTER TABLE program_batch_students ADD CONSTRAINT Refusers1365 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE program_batch_students ADD CONSTRAINT Refadmission1611 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE program_batch_students ADD CONSTRAINT Refbatches1910 
    FOREIGN KEY (programBatchId)
    REFERENCES batches(id)
;

ALTER TABLE program_batch_students ADD CONSTRAINT Refsections2164 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;


-- 
-- TABLE: program_cf_data 
--

ALTER TABLE program_cf_data ADD CONSTRAINT Refprograms1581 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE program_cf_data ADD CONSTRAINT Refusers1582 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: program_classification 
--

ALTER TABLE program_classification ADD CONSTRAINT Refprograms469 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE program_classification ADD CONSTRAINT Refusers1366 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: program_course_faculty_fee 
--

ALTER TABLE program_course_faculty_fee ADD CONSTRAINT Refcourses869 
    FOREIGN KEY (programId)
    REFERENCES courses(id)
;

ALTER TABLE program_course_faculty_fee ADD CONSTRAINT Refcourses870 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE program_course_faculty_fee ADD CONSTRAINT Refbatches871 
    FOREIGN KEY (batchId)
    REFERENCES batches(id)
;

ALTER TABLE program_course_faculty_fee ADD CONSTRAINT Refusers1367 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE program_course_faculty_fee ADD CONSTRAINT Reffaculties2123 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;


-- 
-- TABLE: program_course_group 
--

ALTER TABLE program_course_group ADD CONSTRAINT Refusers1368 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE program_course_group ADD CONSTRAINT Refbatches1903 
    FOREIGN KEY (programBatchId)
    REFERENCES batches(id)
;

ALTER TABLE program_course_group ADD CONSTRAINT Refcourse_group1969 
    FOREIGN KEY (coursesGroupsId)
    REFERENCES course_group(id)
;


-- 
-- TABLE: program_course_section_req 
--

ALTER TABLE program_course_section_req ADD CONSTRAINT Refservice_request230 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_request(id)
;

ALTER TABLE program_course_section_req ADD CONSTRAINT Refusers1369 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE program_course_section_req ADD CONSTRAINT Refprograms1672 
    FOREIGN KEY (fromProgramId)
    REFERENCES programs(id)
;

ALTER TABLE program_course_section_req ADD CONSTRAINT Refprograms1673 
    FOREIGN KEY (toProgramId)
    REFERENCES programs(id)
;

ALTER TABLE program_course_section_req ADD CONSTRAINT Refcourses1674 
    FOREIGN KEY (fromCourseId)
    REFERENCES courses(id)
;

ALTER TABLE program_course_section_req ADD CONSTRAINT Refcourses1675 
    FOREIGN KEY (toCourseId)
    REFERENCES courses(id)
;

ALTER TABLE program_course_section_req ADD CONSTRAINT Refsections1676 
    FOREIGN KEY (fromSectionId)
    REFERENCES sections(id)
;

ALTER TABLE program_course_section_req ADD CONSTRAINT Refsections1677 
    FOREIGN KEY (toSectionId)
    REFERENCES sections(id)
;

ALTER TABLE program_course_section_req ADD CONSTRAINT Refexecution_request1678 
    FOREIGN KEY (executionRequestId)
    REFERENCES execution_request(id)
;

ALTER TABLE program_course_section_req ADD CONSTRAINT Refrequest_followup1679 
    FOREIGN KEY (requestFollowUpId)
    REFERENCES request_followup(id)
;


-- 
-- TABLE: program_courses 
--

ALTER TABLE program_courses ADD CONSTRAINT Refcourses186 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE program_courses ADD CONSTRAINT Refusers1370 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE program_courses ADD CONSTRAINT Refbatches1908 
    FOREIGN KEY (programBatchId)
    REFERENCES batches(id)
;


-- 
-- TABLE: program_group 
--

ALTER TABLE program_group ADD CONSTRAINT Refusers1371 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: program_history 
--

ALTER TABLE program_history ADD CONSTRAINT Refprog_batch_seat_config1616 
    FOREIGN KEY (progBatchSeatConfigId)
    REFERENCES prog_batch_seat_config(id)
;

ALTER TABLE program_history ADD CONSTRAINT Refquota1617 
    FOREIGN KEY (quotaCodeId)
    REFERENCES quota(id)
;

ALTER TABLE program_history ADD CONSTRAINT Refquota_type1618 
    FOREIGN KEY (quotaTypeId)
    REFERENCES quota_type(id)
;

ALTER TABLE program_history ADD CONSTRAINT Refselection_stage1619 
    FOREIGN KEY (stageId)
    REFERENCES selection_stage(id)
;

ALTER TABLE program_history ADD CONSTRAINT Refusers1620 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: program_period_seq 
--

ALTER TABLE program_period_seq ADD CONSTRAINT Refusers1372 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE program_period_seq ADD CONSTRAINT Refprog_batch_period_config1968 
    FOREIGN KEY (programPeriodId)
    REFERENCES prog_batch_period_config(id)
;


-- 
-- TABLE: program_period_type 
--

ALTER TABLE program_period_type ADD CONSTRAINT Refusers1373 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: program_related_course 
--

ALTER TABLE program_related_course ADD CONSTRAINT Refcourses835 
    FOREIGN KEY (primaryCourseId)
    REFERENCES courses(id)
;

ALTER TABLE program_related_course ADD CONSTRAINT Refcourses837 
    FOREIGN KEY (secCourseId)
    REFERENCES courses(id)
;

ALTER TABLE program_related_course ADD CONSTRAINT Refusers1374 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE program_related_course ADD CONSTRAINT Refbatches1913 
    FOREIGN KEY (programBatchId)
    REFERENCES batches(id)
;


-- 
-- TABLE: program_selection_process 
--

ALTER TABLE program_selection_process ADD CONSTRAINT Refusers1977 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE program_selection_process ADD CONSTRAINT Refprog_batch_seat_config1978 
    FOREIGN KEY (programBatchSeatConfigId)
    REFERENCES prog_batch_seat_config(id)
;

ALTER TABLE program_selection_process ADD CONSTRAINT Refslctn_process1979 
    FOREIGN KEY (selectionProcessId)
    REFERENCES slctn_process(id)
;


-- 
-- TABLE: program_set_deadlines 
--

ALTER TABLE program_set_deadlines ADD CONSTRAINT Refprog_batch_period_config193 
    FOREIGN KEY (programBatchPeriodId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE program_set_deadlines ADD CONSTRAINT Refprograms194 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE program_set_deadlines ADD CONSTRAINT Refusers1375 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: program_slctn_process_stages 
--

ALTER TABLE program_slctn_process_stages ADD CONSTRAINT Refselection_stage338 
    FOREIGN KEY (stageId)
    REFERENCES selection_stage(id)
;

ALTER TABLE program_slctn_process_stages ADD CONSTRAINT Refusers1198 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE program_slctn_process_stages ADD CONSTRAINT Refprogram_selection_process1980 
    FOREIGN KEY (programSelectionProcessId)
    REFERENCES program_selection_process(id)
;


-- 
-- TABLE: program_slctn_process_status 
--

ALTER TABLE program_slctn_process_status ADD CONSTRAINT Refprogram_selection_process1983 
    FOREIGN KEY (programSelectionProcessId)
    REFERENCES program_selection_process(id)
;

ALTER TABLE program_slctn_process_status ADD CONSTRAINT Refusers2007 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: program_slctn_stage_statistics 
--

ALTER TABLE program_slctn_stage_statistics ADD CONSTRAINT Refprogram_slctn_process_stages1992 
    FOREIGN KEY (programSelectionProcessStageId)
    REFERENCES program_slctn_process_stages(id)
;

ALTER TABLE program_slctn_stage_statistics ADD CONSTRAINT Refprog_slctn_process_stage_quota1993 
    FOREIGN KEY (programSelectionProcStageQuota)
    REFERENCES prog_slctn_process_stage_quota(id)
;

ALTER TABLE program_slctn_stage_statistics ADD CONSTRAINT Refusers2008 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: program_withdraw_req_details 
--

ALTER TABLE program_withdraw_req_details ADD CONSTRAINT Refservice_request_details2300 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;


-- 
-- TABLE: program_xfer_request_details 
--

ALTER TABLE program_xfer_request_details ADD CONSTRAINT Refservice_request_details2297 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;

ALTER TABLE program_xfer_request_details ADD CONSTRAINT Refprograms2298 
    FOREIGN KEY (fromProgramId)
    REFERENCES programs(id)
;

ALTER TABLE program_xfer_request_details ADD CONSTRAINT Refprograms2299 
    FOREIGN KEY (toProgramId)
    REFERENCES programs(id)
;


-- 
-- TABLE: programs 
--

ALTER TABLE programs ADD CONSTRAINT Refdepartment1101 
    FOREIGN KEY (programDepartmentId)
    REFERENCES department(id)
;

ALTER TABLE programs ADD CONSTRAINT Refdepartment1102 
    FOREIGN KEY (subDepartmentId)
    REFERENCES department(id)
;

ALTER TABLE programs ADD CONSTRAINT Refusers1103 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE programs ADD CONSTRAINT Refusers1819 
    FOREIGN KEY (approver)
    REFERENCES users(id)
;

ALTER TABLE programs ADD CONSTRAINT Refprograms1820 
    FOREIGN KEY (succeedingProgramId)
    REFERENCES programs(id)
;

ALTER TABLE programs ADD CONSTRAINT Refprogram_group1901 
    FOREIGN KEY (programGroupId)
    REFERENCES program_group(id)
;

ALTER TABLE programs ADD CONSTRAINT Refacademy_location2387 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;


-- 
-- TABLE: que_paper_details_break 
--

ALTER TABLE que_paper_details_break ADD CONSTRAINT Refquestion_paper_details1179 
    FOREIGN KEY (questionPaperDetailId)
    REFERENCES question_paper_details(id)
;

ALTER TABLE que_paper_details_break ADD CONSTRAINT Refusers1376 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: que_paper_topic_coverage 
--

ALTER TABLE que_paper_topic_coverage ADD CONSTRAINT Refevaluation_sequence764 
    FOREIGN KEY (evalSequenceId)
    REFERENCES evaluation_sequence(id)
;

ALTER TABLE que_paper_topic_coverage ADD CONSTRAINT Refeval_seq_detail765 
    FOREIGN KEY (evalSequenceDetailId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE que_paper_topic_coverage ADD CONSTRAINT Refusers1377 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: que_resp_result_details 
--

ALTER TABLE que_resp_result_details ADD CONSTRAINT Refquestion_response_result1168 
    FOREIGN KEY (questionResponseId)
    REFERENCES question_response_result(id)
;

ALTER TABLE que_resp_result_details ADD CONSTRAINT Refusers1378 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE que_resp_result_details ADD CONSTRAINT Refquestion_paper1821 
    FOREIGN KEY (questionPaperQuestionId)
    REFERENCES question_paper(id)
;

ALTER TABLE que_resp_result_details ADD CONSTRAINT Refusers1822 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: question_bank_break_up 
--

ALTER TABLE question_bank_break_up ADD CONSTRAINT Refquestion_bank_questions1175 
    FOREIGN KEY (questionBankId)
    REFERENCES question_bank_questions(id)
;

ALTER TABLE question_bank_break_up ADD CONSTRAINT Refusers1379 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE question_bank_break_up ADD CONSTRAINT Refusers1703 
    FOREIGN KEY (approverId)
    REFERENCES users(id)
;


-- 
-- TABLE: question_bank_questions 
--

ALTER TABLE question_bank_questions ADD CONSTRAINT Refusers1380 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE question_bank_questions ADD CONSTRAINT Refusers1702 
    FOREIGN KEY (approverId)
    REFERENCES users(id)
;

ALTER TABLE question_bank_questions ADD CONSTRAINT Refcourse_topics2032 
    FOREIGN KEY (questionCourseTopicId)
    REFERENCES course_topics(id)
;


-- 
-- TABLE: question_paper 
--

ALTER TABLE question_paper ADD CONSTRAINT Refquestion_program_batch395 
    FOREIGN KEY (programBatchId)
    REFERENCES question_program_batch(id)
;

ALTER TABLE question_paper ADD CONSTRAINT Refquestion_bank_questions655 
    FOREIGN KEY (questionId)
    REFERENCES question_bank_questions(id)
;

ALTER TABLE question_paper ADD CONSTRAINT Refcourse_components719 
    FOREIGN KEY (courseComponentId)
    REFERENCES course_components(id)
;

ALTER TABLE question_paper ADD CONSTRAINT Refquestion_paper_structure783 
    FOREIGN KEY (questionPaperStructId)
    REFERENCES question_paper_structure(id)
;

ALTER TABLE question_paper ADD CONSTRAINT Refusers1381 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE question_paper ADD CONSTRAINT Refusers1823 
    FOREIGN KEY (approverId)
    REFERENCES users(id)
;


-- 
-- TABLE: question_paper_details 
--

ALTER TABLE question_paper_details ADD CONSTRAINT Refquestion_paper785 
    FOREIGN KEY (questionPaperId)
    REFERENCES question_paper(id)
;

ALTER TABLE question_paper_details ADD CONSTRAINT Refstructure_level_two1176 
    FOREIGN KEY (structureLevelTwoId)
    REFERENCES structure_level_two(id)
;

ALTER TABLE question_paper_details ADD CONSTRAINT Refstructure_level_three1177 
    FOREIGN KEY (structureLevelThreeId)
    REFERENCES structure_level_three(id)
;

ALTER TABLE question_paper_details ADD CONSTRAINT Refstructure_leaf_node1178 
    FOREIGN KEY (structureLeafNodeId)
    REFERENCES structure_leaf_node(id)
;

ALTER TABLE question_paper_details ADD CONSTRAINT Refusers1382 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: question_paper_structure 
--

ALTER TABLE question_paper_structure ADD CONSTRAINT Refcourse_components725 
    FOREIGN KEY (courseComponentId)
    REFERENCES course_components(id)
;

ALTER TABLE question_paper_structure ADD CONSTRAINT Refusers1383 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE question_paper_structure ADD CONSTRAINT Refprog_batch_period_config1824 
    FOREIGN KEY (programBatchPeriodConfigId)
    REFERENCES prog_batch_period_config(id)
;


-- 
-- TABLE: question_program_batch 
--

ALTER TABLE question_program_batch ADD CONSTRAINT Refprograms696 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE question_program_batch ADD CONSTRAINT Refcourses697 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE question_program_batch ADD CONSTRAINT Refbatches698 
    FOREIGN KEY (batchId)
    REFERENCES batches(id)
;

ALTER TABLE question_program_batch ADD CONSTRAINT Refsections699 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;

ALTER TABLE question_program_batch ADD CONSTRAINT Refeval_seq_detail700 
    FOREIGN KEY (evalDetailSequenceId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE question_program_batch ADD CONSTRAINT Refevaluation_sequence701 
    FOREIGN KEY (evalSequenceId)
    REFERENCES evaluation_sequence(id)
;

ALTER TABLE question_program_batch ADD CONSTRAINT Refusers1384 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: question_response_result 
--

ALTER TABLE question_response_result ADD CONSTRAINT Refevaluation_plan_students1167 
    FOREIGN KEY (evalPlanStudentId)
    REFERENCES evaluation_plan_students(id)
;

ALTER TABLE question_response_result ADD CONSTRAINT Refquestion_paper1169 
    FOREIGN KEY (questionPaperId)
    REFERENCES question_paper(id)
;

ALTER TABLE question_response_result ADD CONSTRAINT Refusers1385 
    FOREIGN KEY (lastUpatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: questionnaire 
--

ALTER TABLE questionnaire ADD CONSTRAINT Refusers1825 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: quota 
--

ALTER TABLE quota ADD CONSTRAINT Refquota_type780 
    FOREIGN KEY (quotaTypeId)
    REFERENCES quota_type(id)
;

ALTER TABLE quota ADD CONSTRAINT Refusers1386 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: quota_type 
--

ALTER TABLE quota_type ADD CONSTRAINT Refusers1387 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: quota_validity 
--

ALTER TABLE quota_validity ADD CONSTRAINT Refquota1957 
    FOREIGN KEY (quotaId)
    REFERENCES quota(id)
;

ALTER TABLE quota_validity ADD CONSTRAINT Refusers1958 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: reasons 
--

ALTER TABLE reasons ADD CONSTRAINT Refusers1898 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: rec_bill_fee_plan_stg 
--

ALTER TABLE rec_bill_fee_plan_stg ADD CONSTRAINT Refbill_header1541 
    FOREIGN KEY (billId)
    REFERENCES bill_header(id)
;

ALTER TABLE rec_bill_fee_plan_stg ADD CONSTRAINT Reffee_stage_head_config1542 
    FOREIGN KEY (feeStageHeadConfigId)
    REFERENCES fee_stage_head_config(id)
;

ALTER TABLE rec_bill_fee_plan_stg ADD CONSTRAINT Refusers1543 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: receipt_adjustment 
--

ALTER TABLE receipt_adjustment ADD CONSTRAINT Refreceipt_payment_instrument1540 
    FOREIGN KEY (receiptPayInstrumentId)
    REFERENCES receipt_payment_instrument(id)
;

ALTER TABLE receipt_adjustment ADD CONSTRAINT Refrec_bill_fee_plan_stg1544 
    FOREIGN KEY (recBillFeePlanStgId)
    REFERENCES rec_bill_fee_plan_stg(id)
;

ALTER TABLE receipt_adjustment ADD CONSTRAINT Refusers1550 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: receipt_header 
--

ALTER TABLE receipt_header ADD CONSTRAINT Refbill_header613 
    FOREIGN KEY (billId)
    REFERENCES bill_header(id)
;

ALTER TABLE receipt_header ADD CONSTRAINT Refusers1389 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: receipt_payment_instrument 
--

ALTER TABLE receipt_payment_instrument ADD CONSTRAINT Refreceipt_header618 
    FOREIGN KEY (receiptHeaderId)
    REFERENCES receipt_header(id)
;

ALTER TABLE receipt_payment_instrument ADD CONSTRAINT Refusers1388 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: reexamination_req_types 
--

ALTER TABLE reexamination_req_types ADD CONSTRAINT Refexam_request_type_details2280 
    FOREIGN KEY (examRequestTypeDetailId)
    REFERENCES exam_request_type_details(id)
;

ALTER TABLE reexamination_req_types ADD CONSTRAINT Refbatches2281 
    FOREIGN KEY (currentExamBatchId)
    REFERENCES batches(id)
;


-- 
-- TABLE: refund_details 
--

ALTER TABLE refund_details ADD CONSTRAINT Refbill_refund_header799 
    FOREIGN KEY (billRefundHeaderId)
    REFERENCES bill_refund_header(id)
;

ALTER TABLE refund_details ADD CONSTRAINT Refusers1390 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE refund_details ADD CONSTRAINT Refservice_requests2240 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_requests(id)
;


-- 
-- TABLE: refund_reasons 
--

ALTER TABLE refund_reasons ADD CONSTRAINT Refusers1085 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: relations_data_to_be_changed 
--

ALTER TABLE relations_data_to_be_changed ADD CONSTRAINT Refdata_to_be_changed2203 
    FOREIGN KEY (dataToBeChangedId)
    REFERENCES data_to_be_changed(id)
;

ALTER TABLE relations_data_to_be_changed ADD CONSTRAINT Refsalutations2204 
    FOREIGN KEY (salutationId)
    REFERENCES salutations(id)
;


-- 
-- TABLE: religions 
--

ALTER TABLE religions ADD CONSTRAINT Refusers2040 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: reopen_reason 
--

ALTER TABLE reopen_reason ADD CONSTRAINT Refusers334 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: repeat_stu_detail_seq 
--

ALTER TABLE repeat_stu_detail_seq ADD CONSTRAINT Refrepeating_student1182 
    FOREIGN KEY (repeatationId)
    REFERENCES repeating_student(mgmtGroupTypeId)
;

ALTER TABLE repeat_stu_detail_seq ADD CONSTRAINT Refusers1391 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE repeat_stu_detail_seq ADD CONSTRAINT Refeval_seq_detail1707 
    FOREIGN KEY (evalDetailSeqId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE repeat_stu_detail_seq ADD CONSTRAINT Reffee_plan1708 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;


-- 
-- TABLE: repeating_course_comp 
--

ALTER TABLE repeating_course_comp ADD CONSTRAINT Refrepeating_student1183 
    FOREIGN KEY (repeatationId)
    REFERENCES repeating_student(mgmtGroupTypeId)
;

ALTER TABLE repeating_course_comp ADD CONSTRAINT Refcourse_components1184 
    FOREIGN KEY (courseComponentId)
    REFERENCES course_components(id)
;

ALTER TABLE repeating_course_comp ADD CONSTRAINT Refusers1392 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: repeating_student 
--

ALTER TABLE repeating_student ADD CONSTRAINT Refadmission804 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE repeating_student ADD CONSTRAINT Refcourses805 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE repeating_student ADD CONSTRAINT Refsections806 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;

ALTER TABLE repeating_student ADD CONSTRAINT Refevaluation_sequence808 
    FOREIGN KEY (evalSequenceId)
    REFERENCES evaluation_sequence(id)
;

ALTER TABLE repeating_student ADD CONSTRAINT Refeval_seq_detail809 
    FOREIGN KEY (evalDetailSeqId)
    REFERENCES eval_seq_detail(id)
;

ALTER TABLE repeating_student ADD CONSTRAINT Refprog_batch_period_config810 
    FOREIGN KEY (programBatchPeriodConfigId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE repeating_student ADD CONSTRAINT Reffee_plan811 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;

ALTER TABLE repeating_student ADD CONSTRAINT Refusers1393 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: report_audit 
--

ALTER TABLE report_audit ADD CONSTRAINT Refsystem_reports398 
    FOREIGN KEY (systemReportId)
    REFERENCES system_reports(id)
;

ALTER TABLE report_audit ADD CONSTRAINT Refusers912 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE report_audit ADD CONSTRAINT Refusers1394 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: req_against_bill_details 
--

ALTER TABLE req_against_bill_details ADD CONSTRAINT Reffee_related_request_details2287 
    FOREIGN KEY (feeRelatedRequestDetailId)
    REFERENCES fee_related_request_details(detailId)
;

ALTER TABLE req_against_bill_details ADD CONSTRAINT Refbill_header2288 
    FOREIGN KEY (billHeaderId)
    REFERENCES bill_header(id)
;


-- 
-- TABLE: req_against_feehead_details 
--

ALTER TABLE req_against_feehead_details ADD CONSTRAINT Reffee_related_request_details2285 
    FOREIGN KEY (feeRelatedRequestDetailId)
    REFERENCES fee_related_request_details(detailId)
;

ALTER TABLE req_against_feehead_details ADD CONSTRAINT Reffee_heads2286 
    FOREIGN KEY (feeHeadId)
    REFERENCES fee_heads(id)
;


-- 
-- TABLE: req_documents_submitted 
--

ALTER TABLE req_documents_submitted ADD CONSTRAINT Refservice_request245 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_request(id)
;

ALTER TABLE req_documents_submitted ADD CONSTRAINT Refusers1395 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: request_followup 
--

ALTER TABLE request_followup ADD CONSTRAINT Refservice_request560 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_request(id)
;

ALTER TABLE request_followup ADD CONSTRAINT Refusers1396 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE request_followup ADD CONSTRAINT Refusers1826 
    FOREIGN KEY (approverId)
    REFERENCES users(id)
;


-- 
-- TABLE: request_for_installment 
--

ALTER TABLE request_for_installment ADD CONSTRAINT Reffee_request615 
    FOREIGN KEY (feeRequestId)
    REFERENCES fee_request(id)
;

ALTER TABLE request_for_installment ADD CONSTRAINT Refusers1397 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: request_handover_modes 
--

ALTER TABLE request_handover_modes ADD CONSTRAINT Refusers2242 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: request_type_categories 
--

ALTER TABLE request_type_categories ADD CONSTRAINT Refrequest_types2339 
    FOREIGN KEY (requestTypeId)
    REFERENCES request_types(id)
;

ALTER TABLE request_type_categories ADD CONSTRAINT Refusers2340 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: request_types 
--

ALTER TABLE request_types ADD CONSTRAINT Refusers2208 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: res_acad_loc_prog_batches 
--

ALTER TABLE res_acad_loc_prog_batches ADD CONSTRAINT Refbatches1002 
    FOREIGN KEY (batchId)
    REFERENCES batches(id)
;

ALTER TABLE res_acad_loc_prog_batches ADD CONSTRAINT Refusers1003 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE res_acad_loc_prog_batches ADD CONSTRAINT Refres_acad_location_programs1004 
    FOREIGN KEY (resAcadLocationProgramId)
    REFERENCES res_acad_location_programs(id)
;


-- 
-- TABLE: res_acad_location_programs 
--

ALTER TABLE res_acad_location_programs ADD CONSTRAINT Refresource_academy_locations998 
    FOREIGN KEY (resourceAcademyLocationId)
    REFERENCES resource_academy_locations(id)
;

ALTER TABLE res_acad_location_programs ADD CONSTRAINT Refprograms999 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE res_acad_location_programs ADD CONSTRAINT Refusers1000 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: res_temp_unavail_infos 
--

ALTER TABLE res_temp_unavail_infos ADD CONSTRAINT Refres_unavail_infos990 
    FOREIGN KEY (resUnavailInfoId)
    REFERENCES res_unavail_infos(id)
;


-- 
-- TABLE: res_temp_unavail_slots 
--

ALTER TABLE res_temp_unavail_slots ADD CONSTRAINT Refres_temp_unavail_infos992 
    FOREIGN KEY (resTempUnavailInfoId)
    REFERENCES res_temp_unavail_infos(resUnavailInfoId)
;

ALTER TABLE res_temp_unavail_slots ADD CONSTRAINT Refusers993 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: res_unavail_infos 
--

ALTER TABLE res_unavail_infos ADD CONSTRAINT Refusers985 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE res_unavail_infos ADD CONSTRAINT Refresources989 
    FOREIGN KEY (resourceId)
    REFERENCES resources(id)
;


-- 
-- TABLE: reservation_category 
--

ALTER TABLE reservation_category ADD CONSTRAINT Refaddress_type333 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES address_type(id)
;


-- 
-- TABLE: resource_academy_locations 
--

ALTER TABLE resource_academy_locations ADD CONSTRAINT Refresources57 
    FOREIGN KEY (resourceId)
    REFERENCES resources(id)
;

ALTER TABLE resource_academy_locations ADD CONSTRAINT Refusers286 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE resource_academy_locations ADD CONSTRAINT Refacademy_location593 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;


-- 
-- TABLE: resource_booking_adhocs 
--

ALTER TABLE resource_booking_adhocs ADD CONSTRAINT Refusers583 
    FOREIGN KEY (internalUser)
    REFERENCES users(id)
;

ALTER TABLE resource_booking_adhocs ADD CONSTRAINT Refusers588 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE resource_booking_adhocs ADD CONSTRAINT Refresource_bookings1025 
    FOREIGN KEY (resourceBookingId)
    REFERENCES resource_bookings(id)
;

ALTER TABLE resource_booking_adhocs ADD CONSTRAINT Refresource_types1026 
    FOREIGN KEY (resourceTypeId)
    REFERENCES resource_types(id)
;


-- 
-- TABLE: resource_booking_courses 
--

ALTER TABLE resource_booking_courses ADD CONSTRAINT Refcourses577 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE resource_booking_courses ADD CONSTRAINT Refusers586 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE resource_booking_courses ADD CONSTRAINT Refresource_bookings1023 
    FOREIGN KEY (resourceBookingId)
    REFERENCES resource_bookings(id)
;


-- 
-- TABLE: resource_booking_faculties 
--

ALTER TABLE resource_booking_faculties ADD CONSTRAINT Refresource_bookings1633 
    FOREIGN KEY (resourceBookingId)
    REFERENCES resource_bookings(id)
;

ALTER TABLE resource_booking_faculties ADD CONSTRAINT Refusers1635 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE resource_booking_faculties ADD CONSTRAINT Reffaculties2122 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;


-- 
-- TABLE: resource_booking_programs 
--

ALTER TABLE resource_booking_programs ADD CONSTRAINT Refresource_bookings1017 
    FOREIGN KEY (resourceBookingId)
    REFERENCES resource_bookings(id)
;

ALTER TABLE resource_booking_programs ADD CONSTRAINT Refprograms1018 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE resource_booking_programs ADD CONSTRAINT Refbatches1019 
    FOREIGN KEY (batchId)
    REFERENCES batches(id)
;

ALTER TABLE resource_booking_programs ADD CONSTRAINT Refsections1020 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;

ALTER TABLE resource_booking_programs ADD CONSTRAINT Refusers1022 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE resource_booking_programs ADD CONSTRAINT Refcourse_topics2033 
    FOREIGN KEY (courseTopicId)
    REFERENCES course_topics(id)
;


-- 
-- TABLE: resource_booking_purposes 
--

ALTER TABLE resource_booking_purposes ADD CONSTRAINT Refresources994 
    FOREIGN KEY (resourceId)
    REFERENCES resources(id)
;

ALTER TABLE resource_booking_purposes ADD CONSTRAINT Refbooking_purposes995 
    FOREIGN KEY (bookingPurposeId)
    REFERENCES booking_purposes(id)
;

ALTER TABLE resource_booking_purposes ADD CONSTRAINT Refusers996 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: resource_booking_resources 
--

ALTER TABLE resource_booking_resources ADD CONSTRAINT Refresources1013 
    FOREIGN KEY (resourceId)
    REFERENCES resources(id)
;

ALTER TABLE resource_booking_resources ADD CONSTRAINT Refresource_bookings1014 
    FOREIGN KEY (resourceBookingId)
    REFERENCES resource_bookings(id)
;

ALTER TABLE resource_booking_resources ADD CONSTRAINT Refusers1015 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: resource_booking_users 
--

ALTER TABLE resource_booking_users ADD CONSTRAINT Refusers80 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE resource_booking_users ADD CONSTRAINT Refusers293 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE resource_booking_users ADD CONSTRAINT Refresource_bookings1016 
    FOREIGN KEY (resourceBookingId)
    REFERENCES resource_bookings(id)
;


-- 
-- TABLE: resource_bookings 
--

ALTER TABLE resource_bookings ADD CONSTRAINT Reflocations1008 
    FOREIGN KEY (locationId)
    REFERENCES locations(id)
;

ALTER TABLE resource_bookings ADD CONSTRAINT Refusers1009 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE resource_bookings ADD CONSTRAINT Refusers1010 
    FOREIGN KEY (approvedBy)
    REFERENCES users(id)
;

ALTER TABLE resource_bookings ADD CONSTRAINT Refusers1011 
    FOREIGN KEY (bookedBy)
    REFERENCES users(id)
;

ALTER TABLE resource_bookings ADD CONSTRAINT Refbooking_purposes1012 
    FOREIGN KEY (bookingPurposeId)
    REFERENCES booking_purposes(id)
;


-- 
-- TABLE: resource_cf_data 
--

ALTER TABLE resource_cf_data ADD CONSTRAINT Refresources1586 
    FOREIGN KEY (resourceId)
    REFERENCES resources(id)
;

ALTER TABLE resource_cf_data ADD CONSTRAINT Refusers1587 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: resource_classifications 
--

ALTER TABLE resource_classifications ADD CONSTRAINT Refresources522 
    FOREIGN KEY (resourceId)
    REFERENCES resources(id)
;

ALTER TABLE resource_classifications ADD CONSTRAINT Refusers977 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE resource_classifications ADD CONSTRAINT Refclassifications979 
    FOREIGN KEY (classificationId)
    REFERENCES classifications(id)
;


-- 
-- TABLE: resource_types 
--

ALTER TABLE resource_types ADD CONSTRAINT Refusers283 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: resources 
--

ALTER TABLE resources ADD CONSTRAINT Refresource_types43 
    FOREIGN KEY (resourceTypeId)
    REFERENCES resource_types(id)
;

ALTER TABLE resources ADD CONSTRAINT Refusers285 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: resrc_acad_location_courses 
--

ALTER TABLE resrc_acad_location_courses ADD CONSTRAINT Refresource_academy_locations1005 
    FOREIGN KEY (resourceAcadLocationId)
    REFERENCES resource_academy_locations(id)
;

ALTER TABLE resrc_acad_location_courses ADD CONSTRAINT Refusers1006 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE resrc_acad_location_courses ADD CONSTRAINT Refcourses1007 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;


-- 
-- TABLE: resrc_booking_acad_locations 
--

ALTER TABLE resrc_booking_acad_locations ADD CONSTRAINT Refacademy_location1028 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;

ALTER TABLE resrc_booking_acad_locations ADD CONSTRAINT Refresource_bookings1029 
    FOREIGN KEY (resourceBookingId)
    REFERENCES resource_bookings(id)
;

ALTER TABLE resrc_booking_acad_locations ADD CONSTRAINT Refusers1030 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: result_details 
--

ALTER TABLE result_details ADD CONSTRAINT Refexamination_result650 
    FOREIGN KEY (examinationResultId)
    REFERENCES examination_result(id)
;

ALTER TABLE result_details ADD CONSTRAINT Refquestion_bank_questions742 
    FOREIGN KEY (questionId)
    REFERENCES question_bank_questions(id)
;

ALTER TABLE result_details ADD CONSTRAINT Refusers1398 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: role_portals 
--

ALTER TABLE role_portals ADD CONSTRAINT Refroles84 
    FOREIGN KEY (roleId)
    REFERENCES roles(id)
;

ALTER TABLE role_portals ADD CONSTRAINT Refportals87 
    FOREIGN KEY (portalId)
    REFERENCES portals(id)
;

ALTER TABLE role_portals ADD CONSTRAINT Refusers270 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: role_privileges 
--

ALTER TABLE role_privileges ADD CONSTRAINT Reffeature_privilege952 
    FOREIGN KEY (featurePrivilegeId)
    REFERENCES feature_privilege(id)
;

ALTER TABLE role_privileges ADD CONSTRAINT Refroles953 
    FOREIGN KEY (roleId)
    REFERENCES roles(id)
;

ALTER TABLE role_privileges ADD CONSTRAINT Refusers955 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: roles 
--

ALTER TABLE roles ADD CONSTRAINT Refusers269 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: salutations 
--

ALTER TABLE salutations ADD CONSTRAINT Refusers1089 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: saved_search 
--

ALTER TABLE saved_search ADD CONSTRAINT Refsearch_result_view1736 
    FOREIGN KEY (searchViewId)
    REFERENCES search_result_view(id)
;

ALTER TABLE saved_search ADD CONSTRAINT Refsearch_config1760 
    FOREIGN KEY (searchConfigId)
    REFERENCES search_config(id)
;


-- 
-- TABLE: saved_search_criteria 
--

ALTER TABLE saved_search_criteria ADD CONSTRAINT Refsearch_table_column1723 
    FOREIGN KEY (searchTableColumnId)
    REFERENCES search_table_column(id)
;

ALTER TABLE saved_search_criteria ADD CONSTRAINT Refsearch_criteria_operator1724 
    FOREIGN KEY (searchCriteriaOperatorId)
    REFERENCES search_criteria_operator(id)
;

ALTER TABLE saved_search_criteria ADD CONSTRAINT Refsearch_config_table1747 
    FOREIGN KEY (searchConfigTableId)
    REFERENCES search_config_table(id)
;

ALTER TABLE saved_search_criteria ADD CONSTRAINT Refsaved_search_criteria1761 
    FOREIGN KEY (parentId)
    REFERENCES saved_search_criteria(id)
;

ALTER TABLE saved_search_criteria ADD CONSTRAINT Refsaved_search1893 
    FOREIGN KEY (savedSearchId)
    REFERENCES saved_search(id)
;


-- 
-- TABLE: saved_search_sort_criteria 
--

ALTER TABLE saved_search_sort_criteria ADD CONSTRAINT Refsaved_search1732 
    FOREIGN KEY (savedSearchId)
    REFERENCES saved_search(id)
;

ALTER TABLE saved_search_sort_criteria ADD CONSTRAINT Refsearch_result_view_column1737 
    FOREIGN KEY (searchResultViewColumnId)
    REFERENCES search_result_view_column(id)
;


-- 
-- TABLE: scholarship 
--

ALTER TABLE scholarship ADD CONSTRAINT Refusers1402 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE scholarship ADD CONSTRAINT Refcurrency1917 
    FOREIGN KEY (currencyId)
    REFERENCES currency(id)
;

ALTER TABLE scholarship ADD CONSTRAINT Refscholarship_organizations1924 
    FOREIGN KEY (scholarshipOrganizationId)
    REFERENCES scholarship_organizations(id)
;


-- 
-- TABLE: scholarship_academy_locations 
--

ALTER TABLE scholarship_academy_locations ADD CONSTRAINT Refacademy_location909 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;

ALTER TABLE scholarship_academy_locations ADD CONSTRAINT Refscholarship1922 
    FOREIGN KEY (scholarshipId)
    REFERENCES scholarship(id)
;


-- 
-- TABLE: scholarship_account_details 
--

ALTER TABLE scholarship_account_details ADD CONSTRAINT Refusers1404 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE scholarship_account_details ADD CONSTRAINT Refconfig_control_account1504 
    FOREIGN KEY (configControlAccountId)
    REFERENCES config_control_account(id)
;

ALTER TABLE scholarship_account_details ADD CONSTRAINT Refaccount_config1505 
    FOREIGN KEY (accountingConfigId)
    REFERENCES account_config(id)
;

ALTER TABLE scholarship_account_details ADD CONSTRAINT Refscholarship1941 
    FOREIGN KEY (scholarshipId)
    REFERENCES scholarship(id)
;


-- 
-- TABLE: scholarship_awardees 
--

ALTER TABLE scholarship_awardees ADD CONSTRAINT Refscholarship1932 
    FOREIGN KEY (scholarshipId)
    REFERENCES scholarship(id)
;

ALTER TABLE scholarship_awardees ADD CONSTRAINT Refusers1933 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE scholarship_awardees ADD CONSTRAINT Refadmission1937 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE scholarship_awardees ADD CONSTRAINT Refprograms1939 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE scholarship_awardees ADD CONSTRAINT Refcourse_variants1940 
    FOREIGN KEY (courseVariantId)
    REFERENCES course_variants(id)
;

ALTER TABLE scholarship_awardees ADD CONSTRAINT Refstudents2135 
    FOREIGN KEY (studentId)
    REFERENCES students(personId)
;


-- 
-- TABLE: scholarship_batches 
--

ALTER TABLE scholarship_batches ADD CONSTRAINT Refscholarship2167 
    FOREIGN KEY (scholarshipId)
    REFERENCES scholarship(id)
;

ALTER TABLE scholarship_batches ADD CONSTRAINT Refbatches2168 
    FOREIGN KEY (batchId)
    REFERENCES batches(id)
;

ALTER TABLE scholarship_batches ADD CONSTRAINT Refusers2169 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: scholarship_courses 
--

ALTER TABLE scholarship_courses ADD CONSTRAINT Refscholarship1926 
    FOREIGN KEY (scholarshipId)
    REFERENCES scholarship(id)
;

ALTER TABLE scholarship_courses ADD CONSTRAINT Refusers1928 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE scholarship_courses ADD CONSTRAINT Refcourses2166 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;


-- 
-- TABLE: scholarship_installments 
--

ALTER TABLE scholarship_installments ADD CONSTRAINT Refusers1920 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE scholarship_installments ADD CONSTRAINT Refscholarship1921 
    FOREIGN KEY (scholarshipId)
    REFERENCES scholarship(id)
;


-- 
-- TABLE: scholarship_organizations 
--

ALTER TABLE scholarship_organizations ADD CONSTRAINT Refusers1923 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: scholarship_programs 
--

ALTER TABLE scholarship_programs ADD CONSTRAINT Refscholarship1925 
    FOREIGN KEY (scholarshipId)
    REFERENCES scholarship(id)
;

ALTER TABLE scholarship_programs ADD CONSTRAINT Refusers1927 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE scholarship_programs ADD CONSTRAINT Refprograms1929 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;


-- 
-- TABLE: scholarship_request_details 
--

ALTER TABLE scholarship_request_details ADD CONSTRAINT Refservice_request_details2301 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;


-- 
-- TABLE: scholarship_transactions 
--

ALTER TABLE scholarship_transactions ADD CONSTRAINT Refusers1935 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE scholarship_transactions ADD CONSTRAINT Refscholarship_awardees1936 
    FOREIGN KEY (scholarshipAwardeeId)
    REFERENCES scholarship_awardees(id)
;


-- 
-- TABLE: search_aggregation_column 
--

ALTER TABLE search_aggregation_column ADD CONSTRAINT Refsearch_table1752 
    FOREIGN KEY (searchTableId)
    REFERENCES search_table(id)
;

ALTER TABLE search_aggregation_column ADD CONSTRAINT Refsearch_table_column1753 
    FOREIGN KEY (searchTableColumnId)
    REFERENCES search_table_column(id)
;


-- 
-- TABLE: search_config 
--

ALTER TABLE search_config ADD CONSTRAINT Refsearch_result_view1733 
    FOREIGN KEY (defaultSearchResultViewId)
    REFERENCES search_result_view(id)
;

ALTER TABLE search_config ADD CONSTRAINT Refsearch_config_table1740 
    FOREIGN KEY (rootSearchConfigTableId)
    REFERENCES search_config_table(id)
;


-- 
-- TABLE: search_config_table 
--

ALTER TABLE search_config_table ADD CONSTRAINT Refsearch_table1735 
    FOREIGN KEY (searchTableId)
    REFERENCES search_table(id)
;

ALTER TABLE search_config_table ADD CONSTRAINT Refsearch_config1749 
    FOREIGN KEY (searchConfigId)
    REFERENCES search_config(id)
;

ALTER TABLE search_config_table ADD CONSTRAINT Refsearch_table_relation1750 
    FOREIGN KEY (joinClause)
    REFERENCES search_table_relation(id)
;

ALTER TABLE search_config_table ADD CONSTRAINT Refsearch_config_table1751 
    FOREIGN KEY (relationLinkId)
    REFERENCES search_config_table(id)
;


-- 
-- TABLE: search_implicit_criteria 
--

ALTER TABLE search_implicit_criteria ADD CONSTRAINT Refsearch_config1754 
    FOREIGN KEY (searchConfigId)
    REFERENCES search_config(id)
;

ALTER TABLE search_implicit_criteria ADD CONSTRAINT Refsearch_config_table1755 
    FOREIGN KEY (searchConfigTableId)
    REFERENCES search_config_table(id)
;

ALTER TABLE search_implicit_criteria ADD CONSTRAINT Refsearch_table_column2034 
    FOREIGN KEY (searchTableColumnId)
    REFERENCES search_table_column(id)
;


-- 
-- TABLE: search_result_enhancer 
--

ALTER TABLE search_result_enhancer ADD CONSTRAINT Refsearch_config2026 
    FOREIGN KEY (searchConfigId)
    REFERENCES search_config(id)
;


-- 
-- TABLE: search_result_view 
--

ALTER TABLE search_result_view ADD CONSTRAINT Refsearch_config1731 
    FOREIGN KEY (searchConfigId)
    REFERENCES search_config(id)
;


-- 
-- TABLE: search_result_view_column 
--

ALTER TABLE search_result_view_column ADD CONSTRAINT Refsearch_config_table1725 
    FOREIGN KEY (searchConfigTableId)
    REFERENCES search_config_table(id)
;

ALTER TABLE search_result_view_column ADD CONSTRAINT Refsearch_result_view1730 
    FOREIGN KEY (searchResultViewId)
    REFERENCES search_result_view(id)
;

ALTER TABLE search_result_view_column ADD CONSTRAINT Refsearch_sql_group1746 
    FOREIGN KEY (searchSQLGroupId)
    REFERENCES search_sql_group(id)
;

ALTER TABLE search_result_view_column ADD CONSTRAINT Refsearch_config_table1757 
    FOREIGN KEY (searchConfigTableId)
    REFERENCES search_config_table(id)
;

ALTER TABLE search_result_view_column ADD CONSTRAINT Refsearch_table_column1758 
    FOREIGN KEY (searchTableColumnId)
    REFERENCES search_table_column(id)
;

ALTER TABLE search_result_view_column ADD CONSTRAINT Refsearch_aggregation_column1759 
    FOREIGN KEY (searchAggregateColumnId)
    REFERENCES search_aggregation_column(id)
;

ALTER TABLE search_result_view_column ADD CONSTRAINT Refsearch_result_formatter_params2160 
    FOREIGN KEY (formatParams)
    REFERENCES search_result_formatter_params(id)
;


-- 
-- TABLE: search_result_view_sort 
--

ALTER TABLE search_result_view_sort ADD CONSTRAINT Refsearch_result_view1738 
    FOREIGN KEY (searchResultViewId)
    REFERENCES search_result_view(id)
;

ALTER TABLE search_result_view_sort ADD CONSTRAINT Refsearch_result_view_column1739 
    FOREIGN KEY (searchResultViewColumnId)
    REFERENCES search_result_view_column(id)
;


-- 
-- TABLE: search_sql_group 
--

ALTER TABLE search_sql_group ADD CONSTRAINT Refsearch_result_view1741 
    FOREIGN KEY (searchResultViewId)
    REFERENCES search_result_view(id)
;


-- 
-- TABLE: search_sql_groupby 
--

ALTER TABLE search_sql_groupby ADD CONSTRAINT Refsearch_sql_group1742 
    FOREIGN KEY (searchSQLGroupId)
    REFERENCES search_sql_group(id)
;

ALTER TABLE search_sql_groupby ADD CONSTRAINT Refsearch_result_view_column1744 
    FOREIGN KEY (searchResultViewColumnId)
    REFERENCES search_result_view_column(id)
;


-- 
-- TABLE: search_table_column 
--

ALTER TABLE search_table_column ADD CONSTRAINT Refsearch_table1748 
    FOREIGN KEY (searchTableId)
    REFERENCES search_table(id)
;


-- 
-- TABLE: search_table_relation 
--

ALTER TABLE search_table_relation ADD CONSTRAINT Refsearch_table1743 
    FOREIGN KEY (fromTableId)
    REFERENCES search_table(id)
;

ALTER TABLE search_table_relation ADD CONSTRAINT Refsearch_table1745 
    FOREIGN KEY (toTableId)
    REFERENCES search_table(id)
;


-- 
-- TABLE: seat_types 
--

ALTER TABLE seat_types ADD CONSTRAINT Refusers1106 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: section_xfer_request_details 
--

ALTER TABLE section_xfer_request_details ADD CONSTRAINT Refservice_request_details2302 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;

ALTER TABLE section_xfer_request_details ADD CONSTRAINT Refsections2305 
    FOREIGN KEY (fromSectionId)
    REFERENCES sections(id)
;

ALTER TABLE section_xfer_request_details ADD CONSTRAINT Refsections2306 
    FOREIGN KEY (toSectionId)
    REFERENCES sections(id)
;


-- 
-- TABLE: sections 
--

ALTER TABLE sections ADD CONSTRAINT Refusers1409 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE sections ADD CONSTRAINT Refcourse_variants2163 
    FOREIGN KEY (courseVariantId)
    REFERENCES course_variants(id)
;

ALTER TABLE sections ADD CONSTRAINT Refprog_batch_period_config2165 
    FOREIGN KEY (periodId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE sections ADD CONSTRAINT Refinternal_resources2178 
    FOREIGN KEY (roomId)
    REFERENCES internal_resources(resourceId)
;


-- 
-- TABLE: selection_override 
--

ALTER TABLE selection_override ADD CONSTRAINT Refselection_stage856 
    FOREIGN KEY (selectStageId)
    REFERENCES selection_stage(id)
;

ALTER TABLE selection_override ADD CONSTRAINT Refusers1410 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE selection_override ADD CONSTRAINT Refseat_types1886 
    FOREIGN KEY (seatTypeId)
    REFERENCES seat_types(id)
;

ALTER TABLE selection_override ADD CONSTRAINT Refusers1887 
    FOREIGN KEY (approvedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: selection_stage 
--

ALTER TABLE selection_stage ADD CONSTRAINT Refusers1412 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: seq_academy_location 
--

ALTER TABLE seq_academy_location ADD CONSTRAINT Refsequence_header1185 
    FOREIGN KEY (sequenceId)
    REFERENCES sequence_header(id)
;

ALTER TABLE seq_academy_location ADD CONSTRAINT Refusers1413 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE seq_academy_location ADD CONSTRAINT Refacademy_location1710 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;

ALTER TABLE seq_academy_location ADD CONSTRAINT Refevaluation_plan1711 
    FOREIGN KEY (evaluationPlanId)
    REFERENCES evaluation_plan(id)
;

ALTER TABLE seq_academy_location ADD CONSTRAINT Refbatches1907 
    FOREIGN KEY (programBatchId)
    REFERENCES batches(id)
;


-- 
-- TABLE: sequence_header 
--

ALTER TABLE sequence_header ADD CONSTRAINT Refusers1414 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: service 
--

ALTER TABLE service ADD CONSTRAINT Refusers1689 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: service_request 
--

ALTER TABLE service_request ADD CONSTRAINT Refusers558 
    FOREIGN KEY (facultyId)
    REFERENCES users(id)
;

ALTER TABLE service_request ADD CONSTRAINT Refusers860 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE service_request ADD CONSTRAINT Refusers1415 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE service_request ADD CONSTRAINT Refrequest_followup1799 
    FOREIGN KEY (requestFollowUpId)
    REFERENCES request_followup(id)
;

ALTER TABLE service_request ADD CONSTRAINT Refexecution_request1800 
    FOREIGN KEY (executionRequestId)
    REFERENCES execution_request(id)
;

ALTER TABLE service_request ADD CONSTRAINT Refusers1801 
    FOREIGN KEY (requestBy)
    REFERENCES users(id)
;

ALTER TABLE service_request ADD CONSTRAINT Refstudents2139 
    FOREIGN KEY (studentId)
    REFERENCES students(personId)
;


-- 
-- TABLE: service_request_details 
--

ALTER TABLE service_request_details ADD CONSTRAINT Refusers2243 
    FOREIGN KEY (enteredByUserId)
    REFERENCES users(id)
;

ALTER TABLE service_request_details ADD CONSTRAINT Refusers2244 
    FOREIGN KEY (requesterUserId)
    REFERENCES users(id)
;

ALTER TABLE service_request_details ADD CONSTRAINT Refusers2245 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE service_request_details ADD CONSTRAINT Refservice_requests2246 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_requests(id)
;


-- 
-- TABLE: service_request_documents 
--

ALTER TABLE service_request_documents ADD CONSTRAINT Refservice_requests2227 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_requests(id)
;

ALTER TABLE service_request_documents ADD CONSTRAINT Refdocuments2228 
    FOREIGN KEY (documentId)
    REFERENCES documents(id)
;


-- 
-- TABLE: service_request_settings 
--

ALTER TABLE service_request_settings ADD CONSTRAINT Reffee_heads2213 
    FOREIGN KEY (feeHeadId)
    REFERENCES fee_heads(id)
;

ALTER TABLE service_request_settings ADD CONSTRAINT Refrequest_types2214 
    FOREIGN KEY (requestTypeId)
    REFERENCES request_types(id)
;

ALTER TABLE service_request_settings ADD CONSTRAINT Refacademy_location2215 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;

ALTER TABLE service_request_settings ADD CONSTRAINT Refusers2216 
    FOREIGN KEY (defaultAssigneeUserId)
    REFERENCES users(id)
;

ALTER TABLE service_request_settings ADD CONSTRAINT Refusers2217 
    FOREIGN KEY (defaultApproverUserId)
    REFERENCES users(id)
;

ALTER TABLE service_request_settings ADD CONSTRAINT Refusers2338 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: service_requests 
--

ALTER TABLE service_requests ADD CONSTRAINT Refservice_request_settings2225 
    FOREIGN KEY (serviceRequestSettingId)
    REFERENCES service_request_settings(id)
;

ALTER TABLE service_requests ADD CONSTRAINT Refusers2226 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE service_requests ADD CONSTRAINT Refservice_request_details2329 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;


-- 
-- TABLE: service_sw_request_details 
--

ALTER TABLE service_sw_request_details ADD CONSTRAINT Refservice_request_details2308 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;


-- 
-- TABLE: session_attedance 
--

ALTER TABLE session_attedance ADD CONSTRAINT Refusers1416 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE session_attedance ADD CONSTRAINT Refcourse_topic_session1827 
    FOREIGN KEY (courseTopicSessionId)
    REFERENCES course_topic_session(id)
;


-- 
-- TABLE: slctn_process 
--

ALTER TABLE slctn_process ADD CONSTRAINT Refusers1411 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: slctn_process_quota_type 
--

ALTER TABLE slctn_process_quota_type ADD CONSTRAINT Refquota_type781 
    FOREIGN KEY (quotaTypeId)
    REFERENCES quota_type(id)
;

ALTER TABLE slctn_process_quota_type ADD CONSTRAINT Refusers1352 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE slctn_process_quota_type ADD CONSTRAINT Refslctn_process1952 
    FOREIGN KEY (selectionProcessId)
    REFERENCES slctn_process(id)
;


-- 
-- TABLE: slctn_process_stage 
--

ALTER TABLE slctn_process_stage ADD CONSTRAINT Refselection_stage342 
    FOREIGN KEY (stageId)
    REFERENCES selection_stage(id)
;

ALTER TABLE slctn_process_stage ADD CONSTRAINT Refusers1353 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE slctn_process_stage ADD CONSTRAINT Refslctn_process1953 
    FOREIGN KEY (selectionProcessId)
    REFERENCES slctn_process(id)
;


-- 
-- TABLE: slctn_process_stage_eval_param 
--

ALTER TABLE slctn_process_stage_eval_param ADD CONSTRAINT Refslctn_process_stage339 
    FOREIGN KEY (selectionProcessStageId)
    REFERENCES slctn_process_stage(id)
;

ALTER TABLE slctn_process_stage_eval_param ADD CONSTRAINT Refusers1355 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: slctn_stage_cndtnl_marks 
--

ALTER TABLE slctn_stage_cndtnl_marks ADD CONSTRAINT Refslctn_process_stage_eval_param1956 
    FOREIGN KEY (stageEvalParamId)
    REFERENCES slctn_process_stage_eval_param(id)
;

ALTER TABLE slctn_stage_cndtnl_marks ADD CONSTRAINT Refusers1959 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: slctn_stage_documents 
--

ALTER TABLE slctn_stage_documents ADD CONSTRAINT Refslctn_process_stage340 
    FOREIGN KEY (selectionProcessStageId)
    REFERENCES slctn_process_stage(id)
;

ALTER TABLE slctn_stage_documents ADD CONSTRAINT Refusers1354 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE slctn_stage_documents ADD CONSTRAINT Refdocuments1684 
    FOREIGN KEY (documentId)
    REFERENCES documents(id)
;


-- 
-- TABLE: slctn_stage_eval_prm_weightage 
--

ALTER TABLE slctn_stage_eval_prm_weightage ADD CONSTRAINT Refslctn_process_stage_eval_param343 
    FOREIGN KEY (stageEvalParamId)
    REFERENCES slctn_process_stage_eval_param(id)
;

ALTER TABLE slctn_stage_eval_prm_weightage ADD CONSTRAINT Refusers1357 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: slctn_stage_prvs_weightage 
--

ALTER TABLE slctn_stage_prvs_weightage ADD CONSTRAINT Refslctn_process_stage_eval_param1954 
    FOREIGN KEY (stageEvalParamId)
    REFERENCES slctn_process_stage_eval_param(id)
;

ALTER TABLE slctn_stage_prvs_weightage ADD CONSTRAINT Refselection_stage1955 
    FOREIGN KEY (previousStageId)
    REFERENCES selection_stage(id)
;

ALTER TABLE slctn_stage_prvs_weightage ADD CONSTRAINT Refusers1960 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: slctn_stage_resource_plan 
--

ALTER TABLE slctn_stage_resource_plan ADD CONSTRAINT Refslctn_process_stage521 
    FOREIGN KEY (selectionProcessStageId)
    REFERENCES slctn_process_stage(id)
;

ALTER TABLE slctn_stage_resource_plan ADD CONSTRAINT Refusers1358 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE slctn_stage_resource_plan ADD CONSTRAINT Refresource_types1713 
    FOREIGN KEY (resourceTypeId)
    REFERENCES resource_types(id)
;


-- 
-- TABLE: specialization 
--

ALTER TABLE specialization ADD CONSTRAINT Refusers1427 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: specialization_group 
--

ALTER TABLE specialization_group ADD CONSTRAINT Refspecialization1049 
    FOREIGN KEY (specializationId)
    REFERENCES specialization(id)
;

ALTER TABLE specialization_group ADD CONSTRAINT Refcourse_group1141 
    FOREIGN KEY (courseGroupId)
    REFERENCES course_group(id)
;

ALTER TABLE specialization_group ADD CONSTRAINT Refusers1428 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: sponsor_account_details 
--

ALTER TABLE sponsor_account_details ADD CONSTRAINT Refusers1430 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE sponsor_account_details ADD CONSTRAINT Refconfig_control_account1506 
    FOREIGN KEY (configControlAccountId)
    REFERENCES config_control_account(id)
;

ALTER TABLE sponsor_account_details ADD CONSTRAINT Refaccount_config1507 
    FOREIGN KEY (accountingConfigId)
    REFERENCES account_config(id)
;


-- 
-- TABLE: sponsor_contacts 
--

ALTER TABLE sponsor_contacts ADD CONSTRAINT Refsponsors656 
    FOREIGN KEY (sponsorId)
    REFERENCES sponsors(id)
;

ALTER TABLE sponsor_contacts ADD CONSTRAINT Refusers1431 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE sponsor_contacts ADD CONSTRAINT Refaddress1942 
    FOREIGN KEY (addressId)
    REFERENCES address(id)
;


-- 
-- TABLE: sponsor_receipt_disbursments 
--

ALTER TABLE sponsor_receipt_disbursments ADD CONSTRAINT Refusers1433 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: sponsors 
--

ALTER TABLE sponsors ADD CONSTRAINT Refusers1434 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: sponsorship_awarded_items 
--

ALTER TABLE sponsorship_awarded_items ADD CONSTRAINT Refsponsorship_awardees1943 
    FOREIGN KEY (sponsorshipAwardeeId)
    REFERENCES sponsorship_awardees(id)
;

ALTER TABLE sponsorship_awarded_items ADD CONSTRAINT Refusers1947 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE sponsorship_awarded_items ADD CONSTRAINT Reffee_plan1948 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;

ALTER TABLE sponsorship_awarded_items ADD CONSTRAINT Reffee_heads1949 
    FOREIGN KEY (feeHeadId)
    REFERENCES fee_heads(id)
;

ALTER TABLE sponsorship_awarded_items ADD CONSTRAINT Reffee_stage_head_config1950 
    FOREIGN KEY (feeStageHeadConfigId)
    REFERENCES fee_stage_head_config(id)
;


-- 
-- TABLE: sponsorship_awardees 
--

ALTER TABLE sponsorship_awardees ADD CONSTRAINT Refsponsors1944 
    FOREIGN KEY (sponsorId)
    REFERENCES sponsors(id)
;

ALTER TABLE sponsorship_awardees ADD CONSTRAINT Refadmission1945 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE sponsorship_awardees ADD CONSTRAINT Refusers1946 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE sponsorship_awardees ADD CONSTRAINT Refstudents2150 
    FOREIGN KEY (studentId)
    REFERENCES students(personId)
;


-- 
-- TABLE: srvc_sw_req_detail_s_services 
--

ALTER TABLE srvc_sw_req_detail_s_services ADD CONSTRAINT Refservice_sw_request_details2325 
    FOREIGN KEY (serviceSWRequestDetailId)
    REFERENCES service_sw_request_details(detailId)
;

ALTER TABLE srvc_sw_req_detail_s_services ADD CONSTRAINT Refservice2327 
    FOREIGN KEY (subscribedServiceId)
    REFERENCES service(id)
;


-- 
-- TABLE: srvc_sw_req_detail_w_services 
--

ALTER TABLE srvc_sw_req_detail_w_services ADD CONSTRAINT Refservice_sw_request_details2326 
    FOREIGN KEY (serviceSWRequestDetailId)
    REFERENCES service_sw_request_details(detailId)
;

ALTER TABLE srvc_sw_req_detail_w_services ADD CONSTRAINT Refservice2328 
    FOREIGN KEY (withdrawnServiceId)
    REFERENCES service(id)
;


-- 
-- TABLE: stage_resource_plan 
--

ALTER TABLE stage_resource_plan ADD CONSTRAINT Refslctn_process_stage895 
    FOREIGN KEY (processStageId)
    REFERENCES slctn_process_stage(id)
;

ALTER TABLE stage_resource_plan ADD CONSTRAINT Refusers896 
    FOREIGN KEY (employeeId)
    REFERENCES users(id)
;

ALTER TABLE stage_resource_plan ADD CONSTRAINT Refresource_types897 
    FOREIGN KEY (resourceTypeId)
    REFERENCES resource_types(id)
;

ALTER TABLE stage_resource_plan ADD CONSTRAINT Refusers1435 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: standard_master 
--

ALTER TABLE standard_master ADD CONSTRAINT Refusers1117 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE standard_master ADD CONSTRAINT Refstandard_master1828 
    FOREIGN KEY (childMaster)
    REFERENCES standard_master(id)
;


-- 
-- TABLE: standard_master_items 
--

ALTER TABLE standard_master_items ADD CONSTRAINT Refstandard_master1107 
    FOREIGN KEY (standardMasterId)
    REFERENCES standard_master(id)
;

ALTER TABLE standard_master_items ADD CONSTRAINT Refusers1118 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: structure_leaf_node 
--

ALTER TABLE structure_leaf_node ADD CONSTRAINT Refstructure_level_three1174 
    FOREIGN KEY (structureLevelThreeId)
    REFERENCES structure_level_three(id)
;

ALTER TABLE structure_leaf_node ADD CONSTRAINT Refusers1436 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: structure_level_one 
--

ALTER TABLE structure_level_one ADD CONSTRAINT Refquestion_paper_structure652 
    FOREIGN KEY (questionPaperStructId)
    REFERENCES question_paper_structure(id)
;

ALTER TABLE structure_level_one ADD CONSTRAINT Refusers1437 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: structure_level_three 
--

ALTER TABLE structure_level_three ADD CONSTRAINT Refstructure_level_two654 
    FOREIGN KEY (structureLevelTwoId)
    REFERENCES structure_level_two(id)
;

ALTER TABLE structure_level_three ADD CONSTRAINT Refusers1438 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: structure_level_two 
--

ALTER TABLE structure_level_two ADD CONSTRAINT Refstructure_level_one653 
    FOREIGN KEY (structureLevelOneId)
    REFERENCES structure_level_one(id)
;

ALTER TABLE structure_level_two ADD CONSTRAINT Refusers1439 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: stu_account_receipts 
--

ALTER TABLE stu_account_receipts ADD CONSTRAINT Refusers1440 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE stu_account_receipts ADD CONSTRAINT Refcurrency1659 
    FOREIGN KEY (currencyId)
    REFERENCES currency(id)
;

ALTER TABLE stu_account_receipts ADD CONSTRAINT Refcurrency1660 
    FOREIGN KEY (currencyBaseId)
    REFERENCES currency(id)
;

ALTER TABLE stu_account_receipts ADD CONSTRAINT Refstudents2140 
    FOREIGN KEY (studentId)
    REFERENCES students(personId)
;


-- 
-- TABLE: student_account 
--

ALTER TABLE student_account ADD CONSTRAINT Refaccount_config606 
    FOREIGN KEY (accountConfigId)
    REFERENCES account_config(id)
;

ALTER TABLE student_account ADD CONSTRAINT Refusers1443 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: student_attendance 
--

ALTER TABLE student_attendance ADD CONSTRAINT Refprograms202 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE student_attendance ADD CONSTRAINT Refbatches203 
    FOREIGN KEY (batchId)
    REFERENCES batches(id)
;

ALTER TABLE student_attendance ADD CONSTRAINT Refcourses204 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE student_attendance ADD CONSTRAINT Refcourse_variants205 
    FOREIGN KEY (courseVariantId)
    REFERENCES course_variants(id)
;

ALTER TABLE student_attendance ADD CONSTRAINT Refsections510 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;

ALTER TABLE student_attendance ADD CONSTRAINT Refadmission842 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE student_attendance ADD CONSTRAINT Refusers1465 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: student_attendance_details 
--

ALTER TABLE student_attendance_details ADD CONSTRAINT Refusers1464 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE student_attendance_details ADD CONSTRAINT Refstudent_attendance1837 
    FOREIGN KEY (attendanceId)
    REFERENCES student_attendance(id)
;


-- 
-- TABLE: student_cert_request 
--

ALTER TABLE student_cert_request ADD CONSTRAINT Refservice_request228 
    FOREIGN KEY (serviceRequestId)
    REFERENCES service_request(id)
;

ALTER TABLE student_cert_request ADD CONSTRAINT Refexecution_request1665 
    FOREIGN KEY (executionRequestId)
    REFERENCES execution_request(id)
;

ALTER TABLE student_cert_request ADD CONSTRAINT Refusers1669 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE student_cert_request ADD CONSTRAINT Reffee_plan1670 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;

ALTER TABLE student_cert_request ADD CONSTRAINT Refrequest_followup1671 
    FOREIGN KEY (requestFollowUpId)
    REFERENCES request_followup(id)
;

ALTER TABLE student_cert_request ADD CONSTRAINT Refcertificate1722 
    FOREIGN KEY (certificateId)
    REFERENCES certificate(id)
;


-- 
-- TABLE: student_course_enrollment 
--

ALTER TABLE student_course_enrollment ADD CONSTRAINT Refcourse_variants213 
    FOREIGN KEY (courseVarientId)
    REFERENCES course_variants(id)
;

ALTER TABLE student_course_enrollment ADD CONSTRAINT Refsections501 
    FOREIGN KEY (sectionId)
    REFERENCES sections(id)
;

ALTER TABLE student_course_enrollment ADD CONSTRAINT Refprog_batch_period_config776 
    FOREIGN KEY (programBatchPeriodConfigId)
    REFERENCES prog_batch_period_config(id)
;

ALTER TABLE student_course_enrollment ADD CONSTRAINT Refadmission831 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE student_course_enrollment ADD CONSTRAINT Refusers1461 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: student_distribution_list 
--

ALTER TABLE student_distribution_list ADD CONSTRAINT Refdistribution_list1040 
    FOREIGN KEY (distributionListId)
    REFERENCES distribution_list(id)
;

ALTER TABLE student_distribution_list ADD CONSTRAINT Refusers1047 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE student_distribution_list ADD CONSTRAINT Refstudents2136 
    FOREIGN KEY (studentId)
    REFERENCES students(personId)
;

ALTER TABLE student_distribution_list ADD CONSTRAINT Refusers2392 
    FOREIGN KEY (approvedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: student_exam 
--

ALTER TABLE student_exam ADD CONSTRAINT Refadmission423 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE student_exam ADD CONSTRAINT Refapplication_form436 
    FOREIGN KEY (applicationId)
    REFERENCES application_form(id)
;

ALTER TABLE student_exam ADD CONSTRAINT Refusers1459 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE student_exam ADD CONSTRAINT Refusers1838 
    FOREIGN KEY (conductedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: student_exam_subject 
--

ALTER TABLE student_exam_subject ADD CONSTRAINT Refstudent_exam217 
    FOREIGN KEY (studentExamId)
    REFERENCES student_exam(id)
;

ALTER TABLE student_exam_subject ADD CONSTRAINT Refusers1458 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE student_exam_subject ADD CONSTRAINT Refstudents2149 
    FOREIGN KEY (studentId)
    REFERENCES students(personId)
;


-- 
-- TABLE: student_faculty_attendance 
--

ALTER TABLE student_faculty_attendance ADD CONSTRAINT Refusers1457 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE student_faculty_attendance ADD CONSTRAINT Reffaculties2118 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;


-- 
-- TABLE: student_feedback 
--

ALTER TABLE student_feedback ADD CONSTRAINT Refusers1456 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE student_feedback ADD CONSTRAINT Refcourses1657 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE student_feedback ADD CONSTRAINT Refusers1718 
    FOREIGN KEY (feedbackGivenTo)
    REFERENCES users(id)
;

ALTER TABLE student_feedback ADD CONSTRAINT Refstudents2145 
    FOREIGN KEY (studentId)
    REFERENCES students(personId)
;

ALTER TABLE student_feedback ADD CONSTRAINT Refstudents2148 
    FOREIGN KEY (feedbackGivenBy)
    REFERENCES students(personId)
;


-- 
-- TABLE: student_feedback_details 
--

ALTER TABLE student_feedback_details ADD CONSTRAINT Refstudent_feedback777 
    FOREIGN KEY (studentFeedbackId)
    REFERENCES student_feedback(id)
;

ALTER TABLE student_feedback_details ADD CONSTRAINT Refusers1455 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE student_feedback_details ADD CONSTRAINT Refquestionnaire1839 
    FOREIGN KEY (questionnaireId)
    REFERENCES questionnaire(id)
;


-- 
-- TABLE: student_hw_file_download 
--

ALTER TABLE student_hw_file_download ADD CONSTRAINT Refgroup_hw_assignment1054 
    FOREIGN KEY (studentHwGroupId)
    REFERENCES group_hw_assignment(id)
;

ALTER TABLE student_hw_file_download ADD CONSTRAINT Refusers1454 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: student_hw_file_upload 
--

ALTER TABLE student_hw_file_upload ADD CONSTRAINT Refgroup_hw_assignment208 
    FOREIGN KEY (studentHwGroupId)
    REFERENCES group_hw_assignment(id)
;

ALTER TABLE student_hw_file_upload ADD CONSTRAINT Refusers1453 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: student_pdc 
--

ALTER TABLE student_pdc ADD CONSTRAINT Refadmission766 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE student_pdc ADD CONSTRAINT Reffee_plan767 
    FOREIGN KEY (feePlanId)
    REFERENCES fee_plan(id)
;

ALTER TABLE student_pdc ADD CONSTRAINT Refusers1449 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: student_promotions 
--

ALTER TABLE student_promotions ADD CONSTRAINT Refadmission687 
    FOREIGN KEY (admissionId)
    REFERENCES admission(id)
;

ALTER TABLE student_promotions ADD CONSTRAINT Refusers1448 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: student_revaluation 
--

ALTER TABLE student_revaluation ADD CONSTRAINT Refusers1447 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE student_revaluation ADD CONSTRAINT Refusers1841 
    FOREIGN KEY (employeeId)
    REFERENCES users(id)
;

ALTER TABLE student_revaluation ADD CONSTRAINT Refservice_request1842 
    FOREIGN KEY (requestId)
    REFERENCES service_request(id)
;


-- 
-- TABLE: student_stakeholders 
--

ALTER TABLE student_stakeholders ADD CONSTRAINT Refapplication_form433 
    FOREIGN KEY (applicationId)
    REFERENCES application_form(id)
;

ALTER TABLE student_stakeholders ADD CONSTRAINT Refusers1425 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE student_stakeholders ADD CONSTRAINT Refincome_slabs1651 
    FOREIGN KEY (incomeId)
    REFERENCES income_slabs(id)
;

ALTER TABLE student_stakeholders ADD CONSTRAINT Refusers1652 
    FOREIGN KEY (employeeId)
    REFERENCES users(id)
;

ALTER TABLE student_stakeholders ADD CONSTRAINT Refsalutations1891 
    FOREIGN KEY (salutationId)
    REFERENCES salutations(id)
;

ALTER TABLE student_stakeholders ADD CONSTRAINT Refstudents2141 
    FOREIGN KEY (studentId)
    REFERENCES students(personId)
;


-- 
-- TABLE: student_stakeholders_adress 
--

ALTER TABLE student_stakeholders_adress ADD CONSTRAINT Refstudent_stakeholders854 
    FOREIGN KEY (studentStakeholderId)
    REFERENCES student_stakeholders(id)
;

ALTER TABLE student_stakeholders_adress ADD CONSTRAINT Refaddress855 
    FOREIGN KEY (addressId)
    REFERENCES address(id)
;

ALTER TABLE student_stakeholders_adress ADD CONSTRAINT Refusers1424 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: student_trans_terminate 
--

ALTER TABLE student_trans_terminate ADD CONSTRAINT Refprograms865 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE student_trans_terminate ADD CONSTRAINT Refcourses866 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;

ALTER TABLE student_trans_terminate ADD CONSTRAINT Refrequest_followup867 
    FOREIGN KEY (requestFollowUpId)
    REFERENCES request_followup(id)
;

ALTER TABLE student_trans_terminate ADD CONSTRAINT Refexecution_request868 
    FOREIGN KEY (executionRequestId)
    REFERENCES execution_request(id)
;

ALTER TABLE student_trans_terminate ADD CONSTRAINT Refusers1423 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE student_trans_terminate ADD CONSTRAINT Refusers1661 
    FOREIGN KEY (initiatedBy)
    REFERENCES users(id)
;

ALTER TABLE student_trans_terminate ADD CONSTRAINT Refstudents2138 
    FOREIGN KEY (studentId)
    REFERENCES students(personId)
;


-- 
-- TABLE: students 
--

ALTER TABLE students ADD CONSTRAINT Refusers2126 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE students ADD CONSTRAINT Refpersons2127 
    FOREIGN KEY (personId)
    REFERENCES persons(id)
;


-- 
-- TABLE: subject_mark_info 
--

ALTER TABLE subject_mark_info ADD CONSTRAINT Refusers2047 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE subject_mark_info ADD CONSTRAINT Refeducation_histories2078 
    FOREIGN KEY (educationHistoryId)
    REFERENCES education_histories(id)
;


-- 
-- TABLE: subject_mark_to_be_changed 
--

ALTER TABLE subject_mark_to_be_changed ADD CONSTRAINT Refeducation_data_to_be_changed2335 
    FOREIGN KEY (dataToBeChangedId)
    REFERENCES education_data_to_be_changed(dataToBeChangedId)
;


-- 
-- TABLE: supervisor_allocation 
--

ALTER TABLE supervisor_allocation ADD CONSTRAINT Refusers1573 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE supervisor_allocation ADD CONSTRAINT Refgroup_date_batch_center1574 
    FOREIGN KEY (groupDateBatchCenterId)
    REFERENCES group_date_batch_center(id)
;

ALTER TABLE supervisor_allocation ADD CONSTRAINT Refusers1575 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: survey 
--

ALTER TABLE survey ADD CONSTRAINT Refusers1420 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE survey ADD CONSTRAINT Refusers1843 
    FOREIGN KEY (surveyCreatedBy)
    REFERENCES users(id)
;

ALTER TABLE survey ADD CONSTRAINT Refprograms1844 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;


-- 
-- TABLE: survey_distribution_list 
--

ALTER TABLE survey_distribution_list ADD CONSTRAINT Refsurvey454 
    FOREIGN KEY (surveyId)
    REFERENCES survey(id)
;

ALTER TABLE survey_distribution_list ADD CONSTRAINT Refusers744 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE survey_distribution_list ADD CONSTRAINT Refusers1419 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE survey_distribution_list ADD CONSTRAINT Reffaculties2121 
    FOREIGN KEY (personId)
    REFERENCES faculties(personId)
;

ALTER TABLE survey_distribution_list ADD CONSTRAINT Refstudents2137 
    FOREIGN KEY (personId)
    REFERENCES students(personId)
;


-- 
-- TABLE: survey_question_options 
--

ALTER TABLE survey_question_options ADD CONSTRAINT Refsurvey_questions453 
    FOREIGN KEY (questionId)
    REFERENCES survey_questions(id)
;

ALTER TABLE survey_question_options ADD CONSTRAINT Refusers1418 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: survey_questions 
--

ALTER TABLE survey_questions ADD CONSTRAINT Refsurvey_section_question671 
    FOREIGN KEY (surveySectionQuestionId)
    REFERENCES survey_section_question(id)
;

ALTER TABLE survey_questions ADD CONSTRAINT Refusers1417 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: survey_section 
--

ALTER TABLE survey_section ADD CONSTRAINT Refsurvey670 
    FOREIGN KEY (surveyId)
    REFERENCES survey(id)
;

ALTER TABLE survey_section ADD CONSTRAINT Refusers1139 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: survey_section_question 
--

ALTER TABLE survey_section_question ADD CONSTRAINT Refsurvey451 
    FOREIGN KEY (surveyId)
    REFERENCES survey(id)
;

ALTER TABLE survey_section_question ADD CONSTRAINT Refsurvey_section669 
    FOREIGN KEY (surveySectionId)
    REFERENCES survey_section(id)
;

ALTER TABLE survey_section_question ADD CONSTRAINT Refusers1138 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: system_menu 
--

ALTER TABLE system_menu ADD CONSTRAINT Refsystem_menu1475 
    FOREIGN KEY (parentMenuId)
    REFERENCES system_menu(id)
;

ALTER TABLE system_menu ADD CONSTRAINT Refportals1476 
    FOREIGN KEY (portalId)
    REFERENCES portals(id)
;

ALTER TABLE system_menu ADD CONSTRAINT Refusers1477 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE system_menu ADD CONSTRAINT Reffeature_privilege1478 
    FOREIGN KEY (featurePrivilegeId)
    REFERENCES feature_privilege(id)
;


-- 
-- TABLE: system_modules 
--

ALTER TABLE system_modules ADD CONSTRAINT Refusers280 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE system_modules ADD CONSTRAINT Refportals938 
    FOREIGN KEY (portalId)
    REFERENCES portals(id)
;

ALTER TABLE system_modules ADD CONSTRAINT Refsystem_modules943 
    FOREIGN KEY (parentId)
    REFERENCES system_modules(id)
;


-- 
-- TABLE: system_reports 
--

ALTER TABLE system_reports ADD CONSTRAINT Refusers1087 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE system_reports ADD CONSTRAINT Refusers1137 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: termination_reasons 
--

ALTER TABLE termination_reasons ADD CONSTRAINT Refusers2316 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: termination_request_details 
--

ALTER TABLE termination_request_details ADD CONSTRAINT Refservice_request_details2309 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;

ALTER TABLE termination_request_details ADD CONSTRAINT Refprograms2310 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE termination_request_details ADD CONSTRAINT Reftermination_reasons2311 
    FOREIGN KEY (terminationReasonId)
    REFERENCES termination_reasons(id)
;


-- 
-- TABLE: topic_depth 
--

ALTER TABLE topic_depth ADD CONSTRAINT Refusers1965 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: training_category 
--

ALTER TABLE training_category ADD CONSTRAINT Refusers2159 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: transfer_reasons 
--

ALTER TABLE transfer_reasons ADD CONSTRAINT Refusers2315 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: transfer_request_details 
--

ALTER TABLE transfer_request_details ADD CONSTRAINT Refservice_request_details2312 
    FOREIGN KEY (detailId)
    REFERENCES service_request_details(id)
;

ALTER TABLE transfer_request_details ADD CONSTRAINT Refprograms2313 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE transfer_request_details ADD CONSTRAINT Reftransfer_reasons2314 
    FOREIGN KEY (transferReasonId)
    REFERENCES transfer_reasons(id)
;


-- 
-- TABLE: user_acad_loc_role_privileges 
--

ALTER TABLE user_acad_loc_role_privileges ADD CONSTRAINT Refuser_academy_locations1119 
    FOREIGN KEY (userAcadLocationId)
    REFERENCES user_academy_locations(id)
;

ALTER TABLE user_acad_loc_role_privileges ADD CONSTRAINT Refrole_privileges1120 
    FOREIGN KEY (rolePrivilegeId)
    REFERENCES role_privileges(id)
;

ALTER TABLE user_acad_loc_role_privileges ADD CONSTRAINT Refusers1133 
    FOREIGN KEY (lastUpadtedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: user_acad_loc_roles 
--

ALTER TABLE user_acad_loc_roles ADD CONSTRAINT Refroles73 
    FOREIGN KEY (roleId)
    REFERENCES roles(id)
;

ALTER TABLE user_acad_loc_roles ADD CONSTRAINT Refuser_academy_locations74 
    FOREIGN KEY (userAcadLocationId)
    REFERENCES user_academy_locations(id)
;

ALTER TABLE user_acad_loc_roles ADD CONSTRAINT Refusers1130 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: user_academy_locations 
--

ALTER TABLE user_academy_locations ADD CONSTRAINT Refusers72 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE user_academy_locations ADD CONSTRAINT Refusers276 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE user_academy_locations ADD CONSTRAINT Refacademy_location1845 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;


-- 
-- TABLE: user_account_locked 
--

ALTER TABLE user_account_locked ADD CONSTRAINT Refusers1473 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;


-- 
-- TABLE: user_cf_data 
--

ALTER TABLE user_cf_data ADD CONSTRAINT Refusers1593 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE user_cf_data ADD CONSTRAINT Refentity_field_meta_data2035 
    FOREIGN KEY (entityFieldMetaDataId)
    REFERENCES entity_field_meta_data(id)
;


-- 
-- TABLE: user_courses 
--

ALTER TABLE user_courses ADD CONSTRAINT Refuser_programs75 
    FOREIGN KEY (userProgramId)
    REFERENCES user_programs(id)
;

ALTER TABLE user_courses ADD CONSTRAINT Refusers272 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE user_courses ADD CONSTRAINT Refcourse_group1846 
    FOREIGN KEY (courseGroupId)
    REFERENCES course_group(id)
;

ALTER TABLE user_courses ADD CONSTRAINT Refcourses1847 
    FOREIGN KEY (courseId)
    REFERENCES courses(id)
;


-- 
-- TABLE: user_groups 
--

ALTER TABLE user_groups ADD CONSTRAINT Refusers1122 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: user_login 
--

ALTER TABLE user_login ADD CONSTRAINT Refusers399 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;

ALTER TABLE user_login ADD CONSTRAINT Refusers1132 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: user_login_history 
--

ALTER TABLE user_login_history ADD CONSTRAINT Refusers1915 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;


-- 
-- TABLE: user_password_policy 
--

ALTER TABLE user_password_policy ADD CONSTRAINT Refusers282 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: user_privilege_overrides 
--

ALTER TABLE user_privilege_overrides ADD CONSTRAINT Refuser_acad_loc_roles1470 
    FOREIGN KEY (userAcademyLocationRoleId)
    REFERENCES user_acad_loc_roles(id)
;

ALTER TABLE user_privilege_overrides ADD CONSTRAINT Reffeature_privilege1471 
    FOREIGN KEY (featurePrivilegeId)
    REFERENCES feature_privilege(id)
;

ALTER TABLE user_privilege_overrides ADD CONSTRAINT Refusers1472 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: user_programs 
--

ALTER TABLE user_programs ADD CONSTRAINT Refusers271 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE user_programs ADD CONSTRAINT Refprograms1848 
    FOREIGN KEY (programId)
    REFERENCES programs(id)
;

ALTER TABLE user_programs ADD CONSTRAINT Refacademy_location1849 
    FOREIGN KEY (academyLocationId)
    REFERENCES academy_location(id)
;


-- 
-- TABLE: users 
--

ALTER TABLE users ADD CONSTRAINT Refsalutations1091 
    FOREIGN KEY (salutationId)
    REFERENCES salutations(id)
;

ALTER TABLE users ADD CONSTRAINT Refcalendars1092 
    FOREIGN KEY (calendarId)
    REFERENCES calendars(id)
;

ALTER TABLE users ADD CONSTRAINT Refdepartment1093 
    FOREIGN KEY (departmentId)
    REFERENCES department(id)
;

ALTER TABLE users ADD CONSTRAINT Refdepartment1094 
    FOREIGN KEY (subDepartmentId)
    REFERENCES department(id)
;

ALTER TABLE users ADD CONSTRAINT Refuser_groups1121 
    FOREIGN KEY (userGroupId)
    REFERENCES user_groups(id)
;

ALTER TABLE users ADD CONSTRAINT Refusers1469 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;


-- 
-- TABLE: users_system_usage_log 
--

ALTER TABLE users_system_usage_log ADD CONSTRAINT Refsystem_menu1970 
    FOREIGN KEY (systemMenuId)
    REFERENCES system_menu(id)
;

ALTER TABLE users_system_usage_log ADD CONSTRAINT Refusers1971 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;


-- 
-- TABLE: usertries 
--

ALTER TABLE usertries ADD CONSTRAINT Refusers402 
    FOREIGN KEY (userId)
    REFERENCES users(id)
;


-- 
-- TABLE: vaccin_data_to_be_changed 
--

ALTER TABLE vaccin_data_to_be_changed ADD CONSTRAINT Refdata_to_be_changed2205 
    FOREIGN KEY (dataToBeChangedId)
    REFERENCES data_to_be_changed(id)
;


-- 
-- TABLE: vaccination_info 
--

ALTER TABLE vaccination_info ADD CONSTRAINT Refusers2051 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE vaccination_info ADD CONSTRAINT Refpersons2059 
    FOREIGN KEY (personId)
    REFERENCES persons(id)
;


-- 
-- TABLE: work_data_to_be_changed 
--

ALTER TABLE work_data_to_be_changed ADD CONSTRAINT Refdata_to_be_changed2206 
    FOREIGN KEY (dataToBeChangedId)
    REFERENCES data_to_be_changed(id)
;


-- 
-- TABLE: work_experience 
--

ALTER TABLE work_experience ADD CONSTRAINT Refusers2045 
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users(id)
;

ALTER TABLE work_experience ADD CONSTRAINT Refpersons2062 
    FOREIGN KEY (personId)
    REFERENCES persons(id)
;



