CREATE 
    OR REPLACE
VIEW `fee_dashboard_bill_headwise_all` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')));

CREATE 
     OR REPLACE
VIEW `fee_dashboard_bill_headwise_application` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `applicant_person`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `application`.`id` AS `applicantId`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `application` ON ((`bill_header`.`applicantId` = `application`.`id`)))
        left join `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
        left join `applicant_person` ON ((`application`.`applicantPersonId` = `applicant_person`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`applicantId` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Application' , 'Program')));

CREATE 
    OR REPLACE 
VIEW `fee_dashboard_bill_headwise_program` AS
    select 
        `fee_dashboard_bill_headwise_all`.`feeHeadName` AS `feeHeadName`,
        `fee_dashboard_bill_headwise_all`.`billedAmount` AS `billedAmount`,
        `fee_dashboard_bill_headwise_all`.`sattledAmount` AS `sattledAmount`,
        `fee_dashboard_bill_headwise_all`.`pendingAmout` AS `pendingAmout`,
        `fee_dashboard_bill_headwise_all`.`printName` AS `printName`,
        `fee_dashboard_bill_headwise_all`.`feePlanType` AS `feePlanType`,
        `fee_dashboard_bill_headwise_all`.`programName` AS `programName`,
        `fee_dashboard_bill_headwise_all`.`batchName` AS `batchName`,
        `fee_dashboard_bill_headwise_all`.`academyName` AS `academyName`,
        `fee_dashboard_bill_headwise_all`.`locationName` AS `locationName`,
        `fee_dashboard_bill_headwise_all`.`transactionDate` AS `transactionDate`,
        `fee_dashboard_bill_headwise_all`.`feeHeadId` AS `feeHeadId`,
        `fee_dashboard_bill_headwise_all`.`feePlanTypeId` AS `feePlanTypeId`,
        `fee_dashboard_bill_headwise_all`.`programId` AS `programId`,
        `fee_dashboard_bill_headwise_all`.`batchId` AS `batchId`,
        `fee_dashboard_bill_headwise_all`.`academyId` AS `academyId`,
        `fee_dashboard_bill_headwise_all`.`locationId` AS `locationId`,
        `fee_dashboard_bill_headwise_all`.`academyLocationId` AS `academyLocationId`,
        `fee_dashboard_bill_headwise_all`.`currencyId` AS `currencyId`,
        `fee_dashboard_bill_headwise_all`.`studentId` AS `studentId`
    from
        `fee_dashboard_bill_headwise_all`
    where
        ((`fee_dashboard_bill_headwise_all`.`feePlanType` = 'Program')
            and (`fee_dashboard_bill_headwise_all`.`studentId` is not null)) 
    union select 
        `fee_dashboard_bill_headwise_application`.`feeHeadName` AS `feeHeadName`,
        `fee_dashboard_bill_headwise_application`.`billedAmount` AS `billedAmount`,
        `fee_dashboard_bill_headwise_application`.`sattledAmount` AS `sattledAmount`,
        `fee_dashboard_bill_headwise_application`.`pendingAmout` AS `pendingAmout`,
        `fee_dashboard_bill_headwise_application`.`printName` AS `printName`,
        `fee_dashboard_bill_headwise_application`.`feePlanType` AS `feePlanType`,
        `fee_dashboard_bill_headwise_application`.`programName` AS `programName`,
        `fee_dashboard_bill_headwise_application`.`batchName` AS `batchName`,
        `fee_dashboard_bill_headwise_application`.`academyName` AS `academyName`,
        `fee_dashboard_bill_headwise_application`.`locationName` AS `locationName`,
        `fee_dashboard_bill_headwise_application`.`transactionDate` AS `transactionDate`,
        `fee_dashboard_bill_headwise_application`.`feeHeadId` AS `feeHeadId`,
        `fee_dashboard_bill_headwise_application`.`feePlanTypeId` AS `feePlanTypeId`,
        `fee_dashboard_bill_headwise_application`.`programId` AS `programId`,
        `fee_dashboard_bill_headwise_application`.`batchId` AS `batchId`,
        `fee_dashboard_bill_headwise_application`.`academyId` AS `academyId`,
        `fee_dashboard_bill_headwise_application`.`locationId` AS `locationId`,
        `fee_dashboard_bill_headwise_application`.`academyLocationId` AS `academyLocationId`,
        `fee_dashboard_bill_headwise_application`.`currencyId` AS `currencyId`,
        `fee_dashboard_bill_headwise_application`.`applicantId` AS `applicantId`
    from
        `fee_dashboard_bill_headwise_application`
    where
        ((`fee_dashboard_bill_headwise_application`.`feePlanType` = 'Program')
            and (`fee_dashboard_bill_headwise_application`.`applicantId` is not null));

CREATE 
     OR REPLACE
VIEW `fee_dashboard_bill_userwise_applicant_detail_first` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        sum(`bill_fee_plan_rule_stage`.`billableAmount`) AS `billedAmount`,
        sum(`bill_fee_plan_rule_stage`.`adjustedAmount`) AS `sattledAmount`,
        sum(`bill_fee_plan_rule_stage`.`balanceAmount`) AS `pendingAmout`,
        `applicant_person`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `application`.`id` AS `applicantId`,
        count(distinct `application`.`id`) AS `totalApplicant`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `application` ON ((`bill_header`.`applicantId` = `application`.`id`)))
        left join `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
        left join `applicant_person` ON ((`application`.`applicantPersonId` = `applicant_person`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`applicantId` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Application' , 'Program')))
    group by `batches`.`id`;

CREATE 
     OR REPLACE
VIEW `fee_dashboard_bill_userwise_applicant_detail_second` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        sum(`bill_fee_plan_rule_stage`.`billableAmount`) AS `billedAmount`,
        sum(`bill_fee_plan_rule_stage`.`adjustedAmount`) AS `sattledAmount`,
        sum(`bill_fee_plan_rule_stage`.`balanceAmount`) AS `pendingAmout`,
        `applicant_person`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `application`.`id` AS `applicantId`,
        `application`.`code` AS `applicationNumber`,
        count(distinct `bill_header`.`id`) AS `no_of_bill_rasied`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `application` ON ((`bill_header`.`applicantId` = `application`.`id`)))
        left join `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
        left join `applicant_person` ON ((`application`.`applicantPersonId` = `applicant_person`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`applicantId` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Application' , 'Program')))
    group by `application`.`id`;

CREATE 
     OR REPLACE
VIEW `fee_dashboard_bill_userwise_applicant_summary` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `applicant_person`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `application`.`id` AS `applicantId`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `application` ON ((`bill_header`.`applicantId` = `application`.`id`)))
        left join `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
        left join `applicant_person` ON ((`application`.`applicantPersonId` = `applicant_person`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`applicantId` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Application' , 'Program')));

CREATE 
     OR REPLACE
VIEW `fee_dashboard_bill_userwise_sponsor_detail_first` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`,
        count(distinct `bill_header`.`sponsorId`) AS `totalSponsor`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`sponsorId` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')))
    group by `batches`.`id`;

CREATE 
     OR REPLACE
VIEW `fee_dashboard_bill_userwise_sponsor_detail_second` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`,
        count(distinct `bill_header`.`id`) AS `totalBillRaise`,
        `sponsors`.`sponsorName` AS `sponsorName`,
        `sponsors`.`sponsorshipCode` AS `code`
    from
        ((((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
        left join `sponsors` ON ((`bill_header`.`sponsorId` = `sponsors`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`sponsorId` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')))
    group by `bill_header`.`sponsorId`;

CREATE 
    OR REPLACE 
VIEW `fee_dashboard_bill_userwise_sponsor_summary` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`,
        count(distinct `bill_header`.`id`) AS `totalBillRasied`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`studentId` is not null)
            and isnull(`bill_header`.`sponsorId`)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')))
    group by `students`.`userId`;

CREATE 
     OR REPLACE
VIEW `fee_dashboard_bill_userwise_student_detail_first` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        sum(`bill_fee_plan_rule_stage`.`billableAmount`) AS `billedAmount`,
        sum(`bill_fee_plan_rule_stage`.`adjustedAmount`) AS `sattledAmount`,
        sum(`bill_fee_plan_rule_stage`.`balanceAmount`) AS `pendingAmout`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`,
        count(distinct `students`.`userId`) AS `totalStudent`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`studentId` is not null)
            and isnull(`bill_header`.`sponsorId`)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')))
    group by `batches`.`id`;

CREATE 
   OR REPLACE  
VIEW `fee_dashboard_bill_userwise_student_detail_second` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        sum(`bill_fee_plan_rule_stage`.`billableAmount`) AS `billedAmount`,
        sum(`bill_fee_plan_rule_stage`.`adjustedAmount`) AS `sattledAmount`,
        sum(`bill_fee_plan_rule_stage`.`balanceAmount`) AS `pendingAmout`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`,
        `admission`.`code` AS `admisionNumber`,
        count(distinct `bill_header`.`id`) AS `totalBillRasied`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`studentId` is not null)
            and isnull(`bill_header`.`sponsorId`)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')))
    group by `students`.`userId`;

CREATE 
    OR REPLACE 
VIEW `fee_dashboard_bill_userwise_student_summary` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`studentId` is not null)
            and isnull(`bill_header`.`sponsorId`)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')));

CREATE 
     OR REPLACE
VIEW `fee_dashboard_collection_headwise_all` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `fee_adjustment_details`.`adjustedAmount` AS `receivedAmount`,
        ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `students` `s` ON ((`bill_header`.`studentId` = `s`.`userId`)))
                        left join `admission` ON ((`s`.`userId` = `admission`.`studentId`)))
                        left join `persons` ON ((`s`.`personId` = `persons`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
                        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
                        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
                        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`s`.`userId` = `students`.`userId`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0) AS `returnedAmount`,
        (`fee_adjustment_details`.`adjustedAmount` - ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `students` `s` ON ((`bill_header`.`studentId` = `s`.`userId`)))
                        left join `admission` ON ((`s`.`userId` = `admission`.`studentId`)))
                        left join `persons` ON ((`s`.`personId` = `persons`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
                        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
                        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
                        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`s`.`userId` = `students`.`userId`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0)) AS `netReceived`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `receipt_header`.`transactionDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `receipt_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`
    from
        (((((((((((((((((((((`fee_adjustment_details`
        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
        left join `receipt_header` ON ((`fee_adjustment_master`.`receiptHeaderId` = `receipt_header`.`id`)))
        left join `receipt_payment_instrument` ON ((`receipt_header`.`id` = `receipt_payment_instrument`.`receiptHeaderId`)))
        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')));

CREATE 
  OR REPLACE   
VIEW `fee_dashboard_collection_headwise_application` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `fee_adjustment_details`.`adjustedAmount` AS `receivedAmount`,
        ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `application` `a` ON ((`bill_header`.`applicantId` = `a`.`id`)))
                        left join `application_program` ON ((`a`.`id` = `application_program`.`applicationId`)))
                        left join `applicant_person` ON ((`a`.`applicantPersonId` = `applicant_person`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`a`.`id` = `application`.`id`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0) AS `returnedAmount`,
        (`fee_adjustment_details`.`adjustedAmount` - ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `application` `a` ON ((`bill_header`.`applicantId` = `a`.`id`)))
                        left join `application_program` ON ((`a`.`id` = `application_program`.`applicationId`)))
                        left join `applicant_person` ON ((`a`.`applicantPersonId` = `applicant_person`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`a`.`id` = `application`.`id`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0)) AS `netReceived`,
        `applicant_person`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `receipt_header`.`transactionDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `receipt_header`.`currencyId` AS `currencyId`,
        `application`.`id` AS `applicationId`
    from
        (((((((((((((((((((((`fee_adjustment_details`
        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
        left join `receipt_header` ON ((`fee_adjustment_master`.`receiptHeaderId` = `receipt_header`.`id`)))
        left join `receipt_payment_instrument` ON ((`receipt_header`.`id` = `receipt_payment_instrument`.`receiptHeaderId`)))
        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
        left join `application` ON ((`bill_header`.`applicantId` = `application`.`id`)))
        left join `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
        left join `applicant_person` ON ((`application`.`applicantPersonId` = `applicant_person`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`fee_plan_type`.`feePlanType` in ('Application' , 'Program')));

CREATE 
    OR REPLACE 
VIEW `fee_dashboard_collection_headwise_program` AS
    select 
        `fee_dashboard_collection_headwise_all`.`feeHeadName` AS `feeHeadName`,
        `fee_dashboard_collection_headwise_all`.`receivedAmount` AS `receivedAmount`,
        `fee_dashboard_collection_headwise_all`.`returnedAmount` AS `returnedAmount`,
        `fee_dashboard_collection_headwise_all`.`netReceived` AS `netReceived`,
        `fee_dashboard_collection_headwise_all`.`printName` AS `printName`,
        `fee_dashboard_collection_headwise_all`.`feePlanType` AS `feePlanType`,
        `fee_dashboard_collection_headwise_all`.`programName` AS `programName`,
        `fee_dashboard_collection_headwise_all`.`batchName` AS `batchName`,
        `fee_dashboard_collection_headwise_all`.`academyName` AS `academyName`,
        `fee_dashboard_collection_headwise_all`.`locationName` AS `locationName`,
        `fee_dashboard_collection_headwise_all`.`transactionDate` AS `transactionDate`,
        `fee_dashboard_collection_headwise_all`.`feeHeadId` AS `feeHeadId`,
        `fee_dashboard_collection_headwise_all`.`feePlanTypeId` AS `feePlanTypeId`,
        `fee_dashboard_collection_headwise_all`.`programId` AS `programId`,
        `fee_dashboard_collection_headwise_all`.`batchId` AS `batchId`,
        `fee_dashboard_collection_headwise_all`.`academyId` AS `academyId`,
        `fee_dashboard_collection_headwise_all`.`locationId` AS `locationId`,
        `fee_dashboard_collection_headwise_all`.`academyLocationId` AS `academyLocationId`,
        `fee_dashboard_collection_headwise_all`.`currencyId` AS `currencyId`,
        `fee_dashboard_collection_headwise_all`.`studentId` AS `studentId`
    from
        `fee_dashboard_collection_headwise_all`
    where
        ((`fee_dashboard_collection_headwise_all`.`feePlanType` = 'Program')
            and (`fee_dashboard_collection_headwise_all`.`studentId` is not null)) 
    union select 
        `fee_dashboard_collection_headwise_application`.`feeHeadName` AS `feeHeadName`,
        `fee_dashboard_collection_headwise_application`.`receivedAmount` AS `receivedAmount`,
        `fee_dashboard_collection_headwise_application`.`returnedAmount` AS `returnedAmount`,
        `fee_dashboard_collection_headwise_application`.`netReceived` AS `netReceived`,
        `fee_dashboard_collection_headwise_application`.`printName` AS `printName`,
        `fee_dashboard_collection_headwise_application`.`feePlanType` AS `feePlanType`,
        `fee_dashboard_collection_headwise_application`.`programName` AS `programName`,
        `fee_dashboard_collection_headwise_application`.`batchName` AS `batchName`,
        `fee_dashboard_collection_headwise_application`.`academyName` AS `academyName`,
        `fee_dashboard_collection_headwise_application`.`locationName` AS `locationName`,
        `fee_dashboard_collection_headwise_application`.`transactionDate` AS `transactionDate`,
        `fee_dashboard_collection_headwise_application`.`feeHeadId` AS `feeHeadId`,
        `fee_dashboard_collection_headwise_application`.`feePlanTypeId` AS `feePlanTypeId`,
        `fee_dashboard_collection_headwise_application`.`programId` AS `programId`,
        `fee_dashboard_collection_headwise_application`.`batchId` AS `batchId`,
        `fee_dashboard_collection_headwise_application`.`academyId` AS `academyId`,
        `fee_dashboard_collection_headwise_application`.`locationId` AS `locationId`,
        `fee_dashboard_collection_headwise_application`.`academyLocationId` AS `academyLocationId`,
        `fee_dashboard_collection_headwise_application`.`currencyId` AS `currencyId`,
        `fee_dashboard_collection_headwise_application`.`applicationId` AS `applicationId`
    from
        `fee_dashboard_collection_headwise_application`
    where
        ((`fee_dashboard_collection_headwise_application`.`feePlanType` = 'Program')
            and (`fee_dashboard_collection_headwise_application`.`applicationId` is not null));

CREATE 
     OR REPLACE
VIEW `fee_dashboard_collection_userwise_applicant_detail_first` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        sum(`fee_adjustment_details`.`adjustedAmount`) AS `receivedAmount`,
        sum(ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `application` `a` ON ((`bill_header`.`applicantId` = `a`.`id`)))
                        left join `application_program` ON ((`a`.`id` = `application_program`.`applicationId`)))
                        left join `applicant_person` ON ((`a`.`applicantPersonId` = `applicant_person`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`a`.`id` = `application`.`id`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0)) AS `returnedAmount`,
        (sum(`fee_adjustment_details`.`adjustedAmount`) - sum(ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `application` `a` ON ((`bill_header`.`applicantId` = `a`.`id`)))
                        left join `application_program` ON ((`a`.`id` = `application_program`.`applicationId`)))
                        left join `applicant_person` ON ((`a`.`applicantPersonId` = `applicant_person`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`a`.`id` = `application`.`id`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0))) AS `netReceived`,
        `applicant_person`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `receipt_header`.`transactionDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `receipt_header`.`currencyId` AS `currencyId`,
        `application`.`id` AS `applicationId`,
        count(distinct `application`.`id`) AS `totalApplicant`
    from
        (((((((((((((((((((((`fee_adjustment_details`
        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
        left join `receipt_header` ON ((`fee_adjustment_master`.`receiptHeaderId` = `receipt_header`.`id`)))
        left join `receipt_payment_instrument` ON ((`receipt_header`.`id` = `receipt_payment_instrument`.`receiptHeaderId`)))
        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
        left join `application` ON ((`bill_header`.`applicantId` = `application`.`id`)))
        left join `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
        left join `applicant_person` ON ((`application`.`applicantPersonId` = `applicant_person`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`application`.`id` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Application' , 'Program')))
    group by `batches`.`id`;

CREATE 
     OR REPLACE
VIEW `fee_dashboard_collection_userwise_applicant_detail_second` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        sum(`fee_adjustment_details`.`adjustedAmount`) AS `receivedAmount`,
        sum(ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `application` `a` ON ((`bill_header`.`applicantId` = `a`.`id`)))
                        left join `application_program` ON ((`a`.`id` = `application_program`.`applicationId`)))
                        left join `applicant_person` ON ((`a`.`applicantPersonId` = `applicant_person`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`a`.`id` = `application`.`id`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0)) AS `returnedAmount`,
        (sum(`fee_adjustment_details`.`adjustedAmount`) - sum(ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `application` `a` ON ((`bill_header`.`applicantId` = `a`.`id`)))
                        left join `application_program` ON ((`a`.`id` = `application_program`.`applicationId`)))
                        left join `applicant_person` ON ((`a`.`applicantPersonId` = `applicant_person`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`a`.`id` = `application`.`id`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0))) AS `netReceived`,
        `applicant_person`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `receipt_header`.`transactionDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `receipt_header`.`currencyId` AS `currencyId`,
        `application`.`id` AS `applicationId`,
        `application`.`code` AS `applicationNumber`
    from
        (((((((((((((((((((((`fee_adjustment_details`
        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
        left join `receipt_header` ON ((`fee_adjustment_master`.`receiptHeaderId` = `receipt_header`.`id`)))
        left join `receipt_payment_instrument` ON ((`receipt_header`.`id` = `receipt_payment_instrument`.`receiptHeaderId`)))
        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
        left join `application` ON ((`bill_header`.`applicantId` = `application`.`id`)))
        left join `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
        left join `applicant_person` ON ((`application`.`applicantPersonId` = `applicant_person`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`application`.`id` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Application' , 'Program')))
    group by `application`.`id`;

CREATE 
     OR REPLACE
VIEW `fee_dashboard_collection_userwise_applicant_summary` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `fee_adjustment_details`.`adjustedAmount` AS `receivedAmount`,
        ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `application` `a` ON ((`bill_header`.`applicantId` = `a`.`id`)))
                        left join `application_program` ON ((`a`.`id` = `application_program`.`applicationId`)))
                        left join `applicant_person` ON ((`a`.`applicantPersonId` = `applicant_person`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`a`.`id` = `application`.`id`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0) AS `returnedAmount`,
        (`fee_adjustment_details`.`adjustedAmount` - ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `application` `a` ON ((`bill_header`.`applicantId` = `a`.`id`)))
                        left join `application_program` ON ((`a`.`id` = `application_program`.`applicationId`)))
                        left join `applicant_person` ON ((`a`.`applicantPersonId` = `applicant_person`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`a`.`id` = `application`.`id`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0)) AS `netReceived`,
        `applicant_person`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `receipt_header`.`transactionDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `receipt_header`.`currencyId` AS `currencyId`,
        `application`.`id` AS `applicationId`
    from
        (((((((((((((((((((((`fee_adjustment_details`
        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
        left join `receipt_header` ON ((`fee_adjustment_master`.`receiptHeaderId` = `receipt_header`.`id`)))
        left join `receipt_payment_instrument` ON ((`receipt_header`.`id` = `receipt_payment_instrument`.`receiptHeaderId`)))
        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
        left join `application` ON ((`bill_header`.`applicantId` = `application`.`id`)))
        left join `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
        left join `applicant_person` ON ((`application`.`applicantPersonId` = `applicant_person`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`application`.`id` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Application' , 'Program')));

CREATE 
     OR REPLACE
VIEW `fee_dashboard_collection_userwise_sponsor_detail_first` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        sum(`fee_adjustment_details`.`adjustedAmount`) AS `receivedAmount`,
        sum(ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `students` `s` ON ((`bill_header`.`studentId` = `s`.`userId`)))
                        left join `admission` ON ((`s`.`userId` = `admission`.`studentId`)))
                        left join `persons` ON ((`s`.`personId` = `persons`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
                        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
                        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
                        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`s`.`userId` = `students`.`userId`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0)) AS `returnedAmount`,
        (sum(`fee_adjustment_details`.`adjustedAmount`) - sum(ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `students` `s` ON ((`bill_header`.`studentId` = `s`.`userId`)))
                        left join `admission` ON ((`s`.`userId` = `admission`.`studentId`)))
                        left join `persons` ON ((`s`.`personId` = `persons`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
                        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
                        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
                        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`s`.`userId` = `students`.`userId`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0))) AS `netReceived`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `receipt_header`.`transactionDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `receipt_header`.`currencyId` AS `currencyId`,
        count(distinct `receipt_header`.`sponsorId`) AS `sponsorCount`
    from
        ((((((((((((((((((((((`fee_adjustment_details`
        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
        left join `receipt_header` ON ((`fee_adjustment_master`.`receiptHeaderId` = `receipt_header`.`id`)))
        left join `receipt_payment_instrument` ON ((`receipt_header`.`id` = `receipt_payment_instrument`.`receiptHeaderId`)))
        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
        left join `sponsors` ON ((`receipt_header`.`sponsorId` = `sponsors`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`receipt_header`.`sponsorId` is not null)
            and isnull(`receipt_header`.`studentId`)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')))
    group by `batches`.`id`;

CREATE 
     OR REPLACE
VIEW `fee_dashboard_collection_userwise_sponsor_detail_second` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        sum(`fee_adjustment_details`.`adjustedAmount`) AS `receivedAmount`,
        sum(ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `students` `s` ON ((`bill_header`.`studentId` = `s`.`userId`)))
                        left join `admission` ON ((`s`.`userId` = `admission`.`studentId`)))
                        left join `persons` ON ((`s`.`personId` = `persons`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
                        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
                        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
                        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`s`.`userId` = `students`.`userId`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0)) AS `returnedAmount`,
        (sum(`fee_adjustment_details`.`adjustedAmount`) - sum(ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `students` `s` ON ((`bill_header`.`studentId` = `s`.`userId`)))
                        left join `admission` ON ((`s`.`userId` = `admission`.`studentId`)))
                        left join `persons` ON ((`s`.`personId` = `persons`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
                        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
                        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
                        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`s`.`userId` = `students`.`userId`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0))) AS `netReceived`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `receipt_header`.`transactionDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `receipt_header`.`currencyId` AS `currencyId`,
        `sponsors`.`sponsorName` AS `sponsorName`,
        `sponsors`.`sponsorshipCode` AS `code`
    from
        ((((((((((((((((((((((`fee_adjustment_details`
        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
        left join `receipt_header` ON ((`fee_adjustment_master`.`receiptHeaderId` = `receipt_header`.`id`)))
        left join `receipt_payment_instrument` ON ((`receipt_header`.`id` = `receipt_payment_instrument`.`receiptHeaderId`)))
        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
        left join `sponsors` ON ((`receipt_header`.`sponsorId` = `sponsors`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`receipt_header`.`sponsorId` is not null)
            and isnull(`receipt_header`.`studentId`)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')))
    group by `sponsors`.`id`;

CREATE 
     OR REPLACE
VIEW `fee_dashboard_collection_userwise_sponsor_summary` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `fee_adjustment_details`.`adjustedAmount` AS `receivedAmount`,
        ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `students` `s` ON ((`bill_header`.`studentId` = `s`.`userId`)))
                        left join `admission` ON ((`s`.`userId` = `admission`.`studentId`)))
                        left join `persons` ON ((`s`.`personId` = `persons`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
                        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
                        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
                        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`s`.`userId` = `students`.`userId`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0) AS `returnedAmount`,
        (`fee_adjustment_details`.`adjustedAmount` - ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `students` `s` ON ((`bill_header`.`studentId` = `s`.`userId`)))
                        left join `admission` ON ((`s`.`userId` = `admission`.`studentId`)))
                        left join `persons` ON ((`s`.`personId` = `persons`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
                        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
                        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
                        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`s`.`userId` = `students`.`userId`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0)) AS `netReceived`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `receipt_header`.`transactionDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `receipt_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`
    from
        (((((((((((((((((((((`fee_adjustment_details`
        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
        left join `receipt_header` ON ((`fee_adjustment_master`.`receiptHeaderId` = `receipt_header`.`id`)))
        left join `receipt_payment_instrument` ON ((`receipt_header`.`id` = `receipt_payment_instrument`.`receiptHeaderId`)))
        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`receipt_header`.`sponsorId` is not null)
            and isnull(`receipt_header`.`studentId`)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')));

CREATE 
     OR REPLACE
VIEW `fee_dashboard_collection_userwise_student_detail_first` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        sum(`fee_adjustment_details`.`adjustedAmount`) AS `receivedAmount`,
        sum(ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `students` `s` ON ((`bill_header`.`studentId` = `s`.`userId`)))
                        left join `admission` ON ((`s`.`userId` = `admission`.`studentId`)))
                        left join `persons` ON ((`s`.`personId` = `persons`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
                        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
                        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
                        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`s`.`userId` = `students`.`userId`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0)) AS `returnedAmount`,
        (sum(`fee_adjustment_details`.`adjustedAmount`) - sum(ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `students` `s` ON ((`bill_header`.`studentId` = `s`.`userId`)))
                        left join `admission` ON ((`s`.`userId` = `admission`.`studentId`)))
                        left join `persons` ON ((`s`.`personId` = `persons`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
                        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
                        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
                        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`s`.`userId` = `students`.`userId`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0))) AS `netReceived`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `receipt_header`.`transactionDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `receipt_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`,
        count(distinct `students`.`userId`) AS `totalStudent`
    from
        (((((((((((((((((((((`fee_adjustment_details`
        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
        left join `receipt_header` ON ((`fee_adjustment_master`.`receiptHeaderId` = `receipt_header`.`id`)))
        left join `receipt_payment_instrument` ON ((`receipt_header`.`id` = `receipt_payment_instrument`.`receiptHeaderId`)))
        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`students`.`userId` is not null)
            and isnull(`receipt_header`.`sponsorId`)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')))
    group by `batches`.`id`;

CREATE 
    OR REPLACE 
VIEW `fee_dashboard_collection_userwise_student_detail_second` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        sum(`fee_adjustment_details`.`adjustedAmount`) AS `receivedAmount`,
        sum(ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `students` `s` ON ((`bill_header`.`studentId` = `s`.`userId`)))
                        left join `admission` ON ((`s`.`userId` = `admission`.`studentId`)))
                        left join `persons` ON ((`s`.`personId` = `persons`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
                        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
                        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
                        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`s`.`userId` = `students`.`userId`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0)) AS `returnedAmount`,
        (sum(`fee_adjustment_details`.`adjustedAmount`) - sum(ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `students` `s` ON ((`bill_header`.`studentId` = `s`.`userId`)))
                        left join `admission` ON ((`s`.`userId` = `admission`.`studentId`)))
                        left join `persons` ON ((`s`.`personId` = `persons`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
                        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
                        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
                        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`s`.`userId` = `students`.`userId`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0))) AS `netReceived`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `receipt_header`.`transactionDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `receipt_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`,
        `admission`.`code` AS `admisionNumber`
    from
        (((((((((((((((((((((`fee_adjustment_details`
        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
        left join `receipt_header` ON ((`fee_adjustment_master`.`receiptHeaderId` = `receipt_header`.`id`)))
        left join `receipt_payment_instrument` ON ((`receipt_header`.`id` = `receipt_payment_instrument`.`receiptHeaderId`)))
        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`students`.`userId` is not null)
            and isnull(`receipt_header`.`sponsorId`)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')))
    group by `students`.`userId`;

CREATE 
     OR REPLACE
VIEW `fee_dashboard_collection_userwise_student_summary` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `fee_adjustment_details`.`adjustedAmount` AS `receivedAmount`,
        ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `students` `s` ON ((`bill_header`.`studentId` = `s`.`userId`)))
                        left join `admission` ON ((`s`.`userId` = `admission`.`studentId`)))
                        left join `persons` ON ((`s`.`personId` = `persons`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
                        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
                        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
                        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`s`.`userId` = `students`.`userId`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0) AS `returnedAmount`,
        (`fee_adjustment_details`.`adjustedAmount` - ifnull((select 
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `students` `s` ON ((`bill_header`.`studentId` = `s`.`userId`)))
                        left join `admission` ON ((`s`.`userId` = `admission`.`studentId`)))
                        left join `persons` ON ((`s`.`personId` = `persons`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
                        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
                        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
                        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
                        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`s`.`userId` = `students`.`userId`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0)) AS `netReceived`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `receipt_header`.`transactionDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `receipt_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`
    from
        (((((((((((((((((((((`fee_adjustment_details`
        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
        left join `receipt_header` ON ((`fee_adjustment_master`.`receiptHeaderId` = `receipt_header`.`id`)))
        left join `receipt_payment_instrument` ON ((`receipt_header`.`id` = `receipt_payment_instrument`.`receiptHeaderId`)))
        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`students`.`userId` is not null)
            and isnull(`receipt_header`.`sponsorId`)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')));

CREATE 
     OR REPLACE
VIEW `fee_dashboard_outstanding_headwise_all` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')));

CREATE 
     OR REPLACE
VIEW `fee_dashboard_outstanding_headwise_application` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `applicant_person`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `application`.`id` AS `applicantId`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `application` ON ((`bill_header`.`applicantId` = `application`.`id`)))
        left join `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
        left join `applicant_person` ON ((`application`.`applicantPersonId` = `applicant_person`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`applicantId` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Application' , 'Program')));

CREATE 
   OR REPLACE  
VIEW `fee_dashboard_outstanding_headwise_program` AS
    select 
        `fee_dashboard_bill_headwise_all`.`feeHeadName` AS `feeHeadName`,
        `fee_dashboard_bill_headwise_all`.`billedAmount` AS `billedAmount`,
        `fee_dashboard_bill_headwise_all`.`sattledAmount` AS `sattledAmount`,
        `fee_dashboard_bill_headwise_all`.`pendingAmout` AS `pendingAmout`,
        `fee_dashboard_bill_headwise_all`.`printName` AS `printName`,
        `fee_dashboard_bill_headwise_all`.`feePlanType` AS `feePlanType`,
        `fee_dashboard_bill_headwise_all`.`programName` AS `programName`,
        `fee_dashboard_bill_headwise_all`.`batchName` AS `batchName`,
        `fee_dashboard_bill_headwise_all`.`academyName` AS `academyName`,
        `fee_dashboard_bill_headwise_all`.`locationName` AS `locationName`,
        `fee_dashboard_bill_headwise_all`.`transactionDate` AS `transactionDate`,
        `fee_dashboard_bill_headwise_all`.`feeHeadId` AS `feeHeadId`,
        `fee_dashboard_bill_headwise_all`.`feePlanTypeId` AS `feePlanTypeId`,
        `fee_dashboard_bill_headwise_all`.`programId` AS `programId`,
        `fee_dashboard_bill_headwise_all`.`batchId` AS `batchId`,
        `fee_dashboard_bill_headwise_all`.`academyId` AS `academyId`,
        `fee_dashboard_bill_headwise_all`.`locationId` AS `locationId`,
        `fee_dashboard_bill_headwise_all`.`academyLocationId` AS `academyLocationId`,
        `fee_dashboard_bill_headwise_all`.`currencyId` AS `currencyId`,
        `fee_dashboard_bill_headwise_all`.`studentId` AS `studentId`
    from
        `fee_dashboard_bill_headwise_all`
    where
        ((`fee_dashboard_bill_headwise_all`.`feePlanType` = 'Program')
            and (`fee_dashboard_bill_headwise_all`.`studentId` is not null)) 
    union select 
        `fee_dashboard_bill_headwise_application`.`feeHeadName` AS `feeHeadName`,
        `fee_dashboard_bill_headwise_application`.`billedAmount` AS `billedAmount`,
        `fee_dashboard_bill_headwise_application`.`sattledAmount` AS `sattledAmount`,
        `fee_dashboard_bill_headwise_application`.`pendingAmout` AS `pendingAmout`,
        `fee_dashboard_bill_headwise_application`.`printName` AS `printName`,
        `fee_dashboard_bill_headwise_application`.`feePlanType` AS `feePlanType`,
        `fee_dashboard_bill_headwise_application`.`programName` AS `programName`,
        `fee_dashboard_bill_headwise_application`.`batchName` AS `batchName`,
        `fee_dashboard_bill_headwise_application`.`academyName` AS `academyName`,
        `fee_dashboard_bill_headwise_application`.`locationName` AS `locationName`,
        `fee_dashboard_bill_headwise_application`.`transactionDate` AS `transactionDate`,
        `fee_dashboard_bill_headwise_application`.`feeHeadId` AS `feeHeadId`,
        `fee_dashboard_bill_headwise_application`.`feePlanTypeId` AS `feePlanTypeId`,
        `fee_dashboard_bill_headwise_application`.`programId` AS `programId`,
        `fee_dashboard_bill_headwise_application`.`batchId` AS `batchId`,
        `fee_dashboard_bill_headwise_application`.`academyId` AS `academyId`,
        `fee_dashboard_bill_headwise_application`.`locationId` AS `locationId`,
        `fee_dashboard_bill_headwise_application`.`academyLocationId` AS `academyLocationId`,
        `fee_dashboard_bill_headwise_application`.`currencyId` AS `currencyId`,
        `fee_dashboard_bill_headwise_application`.`applicantId` AS `applicantId`
    from
        `fee_dashboard_bill_headwise_application`
    where
        ((`fee_dashboard_bill_headwise_application`.`feePlanType` = 'Program')
            and (`fee_dashboard_bill_headwise_application`.`applicantId` is not null));

CREATE 
     OR REPLACE
VIEW `fee_dashboard_outstanding_userwise_applicant_detail_first` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        sum(`bill_fee_plan_rule_stage`.`billableAmount`) AS `billedAmount`,
        sum(`bill_fee_plan_rule_stage`.`adjustedAmount`) AS `sattledAmount`,
        sum(`bill_fee_plan_rule_stage`.`balanceAmount`) AS `pendingAmout`,
        `applicant_person`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `application`.`id` AS `applicantId`,
        count(distinct `application`.`id`) AS `totalApplicant`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `application` ON ((`bill_header`.`applicantId` = `application`.`id`)))
        left join `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
        left join `applicant_person` ON ((`application`.`applicantPersonId` = `applicant_person`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`applicantId` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Application' , 'Program')))
    group by `batches`.`id`;

CREATE 
    OR REPLACE 
VIEW `fee_dashboard_outstanding_userwise_applicant_detail_second` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        sum(`bill_fee_plan_rule_stage`.`billableAmount`) AS `billedAmount`,
        sum(`bill_fee_plan_rule_stage`.`adjustedAmount`) AS `sattledAmount`,
        sum(`bill_fee_plan_rule_stage`.`balanceAmount`) AS `pendingAmout`,
        `applicant_person`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `application`.`id` AS `applicantId`,
        `application`.`code` AS `applicationNumber`,
        count(distinct `bill_header`.`id`) AS `no_of_bill_rasied`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `application` ON ((`bill_header`.`applicantId` = `application`.`id`)))
        left join `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
        left join `applicant_person` ON ((`application`.`applicantPersonId` = `applicant_person`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`applicantId` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Application' , 'Program')))
    group by `application`.`id`;

CREATE 
     OR REPLACE
VIEW `fee_dashboard_outstanding_userwise_applicant_summary` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `applicant_person`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `application`.`id` AS `applicantId`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `application` ON ((`bill_header`.`applicantId` = `application`.`id`)))
        left join `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
        left join `applicant_person` ON ((`application`.`applicantPersonId` = `applicant_person`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`applicantId` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Application' , 'Program')));

CREATE 
     OR REPLACE
VIEW `fee_dashboard_outstanding_userwise_sponsor_detail_first` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`,
        count(distinct `bill_header`.`sponsorId`) AS `totalSponsor`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`sponsorId` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')))
    group by `batches`.`id`;

CREATE 
     OR REPLACE
VIEW `fee_dashboard_outstanding_userwise_sponsor_detail_second` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`,
        count(distinct `bill_header`.`id`) AS `totalBillRaise`,
        `sponsors`.`sponsorName` AS `sponsorName`,
        `sponsors`.`sponsorshipCode` AS `code`
    from
        ((((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
        left join `sponsors` ON ((`bill_header`.`sponsorId` = `sponsors`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`sponsorId` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')))
    group by `bill_header`.`sponsorId`;

CREATE 
     OR REPLACE
VIEW `fee_dashboard_outstanding_userwise_sponsor_summary` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        `bill_fee_plan_rule_stage`.`billableAmount` AS `billedAmount`,
        `bill_fee_plan_rule_stage`.`adjustedAmount` AS `sattledAmount`,
        `bill_fee_plan_rule_stage`.`balanceAmount` AS `pendingAmout`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`,
        count(distinct `bill_header`.`id`) AS `totalBillRasied`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`studentId` is not null)
            and isnull(`bill_header`.`sponsorId`)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')))
    group by `students`.`userId`;

CREATE 
     OR REPLACE
VIEW `fee_dashboard_outstanding_userwise_student_detail_first` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        sum(`bill_fee_plan_rule_stage`.`billableAmount`) AS `billedAmount`,
        sum(`bill_fee_plan_rule_stage`.`adjustedAmount`) AS `sattledAmount`,
        sum(`bill_fee_plan_rule_stage`.`balanceAmount`) AS `pendingAmout`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`,
        count(distinct `students`.`userId`) AS `totalStudent`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`studentId` is not null)
            and isnull(`bill_header`.`sponsorId`)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')))
    group by `batches`.`id`;

CREATE 
     OR REPLACE
VIEW `fee_dashboard_outstanding_userwise_student_detail_second` AS
    select 
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        sum(`bill_fee_plan_rule_stage`.`billableAmount`) AS `billedAmount`,
        sum(`bill_fee_plan_rule_stage`.`adjustedAmount`) AS `sattledAmount`,
        sum(`bill_fee_plan_rule_stage`.`balanceAmount`) AS `pendingAmout`,
        `persons`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `students`.`userId` AS `studentId`,
        `admission`.`code` AS `admisionNumber`,
        count(distinct `bill_header`.`id`) AS `totalBillRasied`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `students` ON ((`bill_header`.`studentId` = `students`.`userId`)))
        left join `admission` ON ((`students`.`userId` = `admission`.`studentId`)))
        left join `persons` ON ((`students`.`personId` = `persons`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`admission`.`programBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`studentId` is not null)
            and isnull(`bill_header`.`sponsorId`)
            and (`fee_plan_type`.`feePlanType` in ('Program' , 'Services', 'Courses', 'Exam')))
    group by `students`.`userId`;
