
CREATE OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `evaluation_group_specific` AS
    select 
        `batches`.`programId` AS `programId`,
        `program_batch_students`.`programBatchId` AS `programBatchId`,
        `evaluation_group`.`id` AS `id`,
        `examination_result`.`admissionId` AS `admissionId`,
        `users`.`printName` AS `printName`,
        `evaluation_group`.`evaluationGroupCode` AS `evaluationGroupCode`,
        sum(`eval_seq_detail`.`maxMarks`) AS `markObtainedFrom`,
        sum(`examination_result`.`finalMarks`) AS `markObtained`,
        avg(`examination_result`.`gradePoints`) AS `gradePoint`,
        `program_batch_students`.`isCurrentPeriod` AS `isCurrentPeriod`,
        `program_batch_students`.`isCurrentSection` AS `isCurrentSection`,
		`evaluation_plan`.`id` AS `evaluationPlanId`
    from
        ((((((((((((`examination_result`
        left join `program_batch_students` ON ((`examination_result`.`admissionId` = `program_batch_students`.`admissionId`)))
        left join `eval_seq_detail` ON ((`examination_result`.`evaluationDetailSequenceId` = `eval_seq_detail`.`id`)))
        left join `evaluation_group` ON ((`examination_result`.`evaluationGroupId` = `evaluation_group`.`id`)))
        left join `admission` ON ((`examination_result`.`admissionId` = `admission`.`id`)))
        left join `students` ON ((`admission`.`studentId` = `students`.`userId`)))
        left join `users` ON ((`students`.`userId` = `users`.`id`)))
        left join `batches` ON ((`program_batch_students`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `evaluation_sequence` ON ((`eval_seq_detail`.`evalSequenceId` = `evaluation_sequence`.`id`)))
        left join `evaluation_plan_level_two` ON ((`evaluation_sequence`.`evalPlanLevelTwoId` = `evaluation_plan_level_two`.`id`)))
        left join `evaluation_plan_level_one` ON ((`evaluation_plan_level_two`.`evalPlanLevelOneId` = `evaluation_plan_level_one`.`id`)))
        left join `evaluation_plan` ON ((`evaluation_plan_level_one`.`evaluationPlanId` = `evaluation_plan`.`id`)))
    where
        ((`program_batch_students`.`isCurrentPeriod` = 1)
            and (`program_batch_students`.`isCurrentSection` = 1))
    group by `examination_result`.`evaluationGroupId` , `examination_result`.`admissionId`;