CREATE
    OR REPLACE
VIEW `fee_dashboard_collection_userwise_applicant_detail_first` AS
    select
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        sum(`fee_adjustment_details`.`adjustedAmount`) AS `receivedAmount`,
        sum(ifnull((select
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `application` `a` ON ((`bill_header`.`applicantId` = `a`.`id`)))
                        left join `application_program` ON ((`a`.`id` = `application_program`.`applicationId`)))
                        left join `applicant_person` ON ((`a`.`applicantPersonId` = `applicant_person`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`a`.`id` = `application`.`id`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0)) AS `returnedAmount`,
        (sum(`fee_adjustment_details`.`adjustedAmount`) - sum(ifnull((select
                        `fee_adjustment_details`.`adjustedAmount`
                    from
                        ((((((((((((((`fee_adjustment_details`
                        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
                        left join `payment_header` ON ((`fee_adjustment_master`.`paymentHeaderId` = `payment_header`.`id`)))
                        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
                        left join `fee_stage_head_config` `feeStageHeadConfig` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `feeStageHeadConfig`.`id`)))
                        left join `fee_heads` ON ((`feeStageHeadConfig`.`feeHeadId` = `fee_heads`.`id`)))
                        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
                        left join `application` `a` ON ((`bill_header`.`applicantId` = `a`.`id`)))
                        left join `application_program` ON ((`a`.`id` = `application_program`.`applicationId`)))
                        left join `applicant_person` ON ((`a`.`applicantPersonId` = `applicant_person`.`id`)))
                        left join `fee_plan_rule_stage` ON ((`feeStageHeadConfig`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
                        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
                        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
                        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
                            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
                        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
                    where
                        ((`bill_header`.`raiseBillCategory` = 'BILL_PAYABLE')
                            and (`a`.`id` = `application`.`id`)
                            and (`feeStageHeadConfig`.`id` = `fee_stage_head_config`.`id`))),
                0))) AS `netReceived`,
        `applicant_person`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `receipt_header`.`transactionDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `receipt_header`.`currencyId` AS `currencyId`,
        `application`.`id` AS `applicationId`,
        count(distinct `application`.`id`) AS `totalApplicant`
    from
        (((((((((((((((((((((`fee_adjustment_details`
        left join `fee_adjustment_master` ON ((`fee_adjustment_details`.`adjustmentMasterId` = `fee_adjustment_master`.`id`)))
        left join `receipt_header` ON ((`fee_adjustment_master`.`receiptHeaderId` = `receipt_header`.`id`)))
        left join `receipt_payment_instrument` ON ((`receipt_header`.`id` = `receipt_payment_instrument`.`receiptHeaderId`)))
        left join `bill_fee_plan_rule_stage` ON ((`fee_adjustment_details`.`billFeeRuleStageId` = `bill_fee_plan_rule_stage`.`id`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `bill_header` ON ((`fee_adjustment_details`.`billHeaderId` = `bill_header`.`id`)))
        left join `application` ON ((`bill_header`.`applicantId` = `application`.`id`)))
        left join `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
        left join `applicant_person` ON ((`application`.`applicantPersonId` = `applicant_person`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`application`.`id` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Application' , 'Program')))
    group by `batches`.`id` , `fee_plan_type`.`feePlanType`;


   CREATE
    OR REPLACE
VIEW `fee_dashboard_bill_userwise_applicant_detail_second` AS
    select
        `fee_heads`.`feeHeadName` AS `feeHeadName`,
        sum(`bill_fee_plan_rule_stage`.`billableAmount`) AS `billedAmount`,
        sum(`bill_fee_plan_rule_stage`.`adjustedAmount`) AS `sattledAmount`,
        sum(`bill_fee_plan_rule_stage`.`balanceAmount`) AS `pendingAmout`,
        `applicant_person`.`printName` AS `printName`,
        `fee_plan_type`.`feePlanType` AS `feePlanType`,
        `programs`.`programName` AS `programName`,
        `batches`.`batchName` AS `batchName`,
        `academies`.`academyName` AS `academyName`,
        `locations`.`locationName` AS `locationName`,
        `bill_header`.`billingDate` AS `transactionDate`,
        `fee_heads`.`id` AS `feeHeadId`,
        `fee_plan_type`.`id` AS `feePlanTypeId`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `academies`.`id` AS `academyId`,
        `locations`.`id` AS `locationId`,
        `academy_location`.`id` AS `academyLocationId`,
        `bill_header`.`currencyId` AS `currencyId`,
        `application`.`id` AS `applicantId`,
        `application`.`code` AS `applicationNumber`,
        count(distinct `bill_header`.`id`) AS `no_of_bill_rasied`
    from
        (((((((((((((((((`bill_header`
        left join `bill_fee_plan_rule_stage` ON ((`bill_header`.`id` = `bill_fee_plan_rule_stage`.`billId`)))
        left join `fee_stage_head_config` ON ((`bill_fee_plan_rule_stage`.`feeStageHeadConfigId` = `fee_stage_head_config`.`id`)))
        left join `fee_heads` ON ((`fee_stage_head_config`.`feeHeadId` = `fee_heads`.`id`)))
        left join `application` ON ((`bill_header`.`applicantId` = `application`.`id`)))
        left join `application_program` ON ((`application`.`id` = `application_program`.`applicationId`)))
        left join `applicant_person` ON ((`application`.`applicantPersonId` = `applicant_person`.`id`)))
        left join `fee_plan_rule_stage` ON ((`fee_stage_head_config`.`feePlanRuleStageId` = `fee_plan_rule_stage`.`id`)))
        left join `fee_plan_rules` ON ((`fee_plan_rule_stage`.`feePlanRuleId` = `fee_plan_rules`.`id`)))
        left join `fee_plan` ON ((`fee_plan_rules`.`feePlanId` = `fee_plan`.`id`)))
        left join `fee_plan_acad_locations` ON (((`fee_plan`.`id` = `fee_plan_acad_locations`.`feePlanId`)
            and (`application_program`.`progBatchSeatConfigId` = `fee_plan_acad_locations`.`progBatchSeatConfigId`))))
        left join `prog_batch_seat_config` ON ((`fee_plan_acad_locations`.`progBatchSeatConfigId` = `prog_batch_seat_config`.`id`)))
        left join `batches` ON ((`prog_batch_seat_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `fee_plan_type` ON ((`fee_plan`.`feePlanType` = `fee_plan_type`.`id`)))
        left join `academy_location` ON ((`programs`.`academyLocationId` = `academy_location`.`id`)))
        left join `academies` ON ((`academy_location`.`academyId` = `academies`.`id`)))
        left join `locations` ON ((`academy_location`.`locationId` = `locations`.`id`)))
    where
        ((`bill_header`.`raiseBillCategory` = 'BILL_RECEIVABLE')
            and (`bill_header`.`applicantId` is not null)
            and (`fee_plan_type`.`feePlanType` in ('Application' , 'Program')))
    group by `application`.`id` , `fee_plan_type`.`feePlanType`;
