CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `pnc_dashboard_top_and_bottom_program_absenteeism` AS
    select 
        `programs`.`id` AS `programId`,
        concat(`academy_location`.`academyName`,
                ' - ',
                `academy_location`.`locationName`) AS `AcademyLocation`,
        `batches`.`id` AS `batchId`,
        `programs`.`programCode` AS `programCode`,
        `programs`.`programNameToBePrint` AS `programNameToBePrint`,
        `batches`.`batchName` AS `batchName`,
        `sections`.`sectionCode` AS `sectionCode`,
        `student_attendance_dashboard_section_wise`.`academyLocationId` AS `academyLocationId`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `prog_batch_period_config`.`programPeriodName` AS `programPeriodName`,
        `student_attendance_dashboard_section_wise`.`sectionId` AS `sectionId`,
        `student_attendance_dashboard_section_wise`.`date` AS `date`,
        sum(`student_attendance_dashboard_section_wise`.`totalRecords`) AS `total`,
        sum(`student_attendance_dashboard_section_wise`.`presentRecords`) AS `present`,
        sum(`student_attendance_dashboard_section_wise`.`absentRecords`) AS `absent`,
        round(((sum(`student_attendance_dashboard_section_wise`.`presentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100),
                0) AS `presentPercent`,
        round(((sum(`student_attendance_dashboard_section_wise`.`absentRecords`) / sum(`student_attendance_dashboard_section_wise`.`totalRecords`)) * 100),
                0) AS `absentPercent`
    from
        (((((`student_attendance_dashboard_section_wise`
        left join `sections` ON ((`student_attendance_dashboard_section_wise`.`sectionId` = `sections`.`id`)))
        left join `prog_batch_period_config` ON ((`sections`.`periodId` = `prog_batch_period_config`.`id`)))
        left join `batches` ON ((`prog_batch_period_config`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `academy_location` ON ((`student_attendance_dashboard_section_wise`.`academyLocationId` = `academy_location`.`id`)))
    where
        (`sections`.`periodId` is not null)
    group by `student_attendance_dashboard_section_wise`.`sectionId`;