CREATE 
    OR REPLACE
VIEW `student_period_report` AS
    select 
        `admission`.`id` AS `admissionId`,
        `admission`.`studentId` AS `studentId`,
        `evaluation_period_rank`.`id` AS `periodRankId`,
        `admission`.`code` AS `admissionCode`,
        `programs`.`id` AS `programId`,
        `programs`.`programName` AS `programName`,
        `batches`.`id` AS `batchId`,
        `batches`.`batchName` AS `batchName`,
        `prog_batch_period_config`.`id` AS `periodId`,
        `prog_batch_period_config`.`programPeriodName` AS `periodName`,
        `sections`.`id` AS `sectionId`,
        `sections`.`sectionCode` AS `sectionName`,
        count(distinct `student_course_enrollment`.`courseVarientId`) AS `totalNoOfCourse`,
        count(distinct (case
                when (`student_course_enrollment`.`whetherOptional` = 0) then `student_course_enrollment`.`courseVarientId`
            end)) AS `mandatoryCourseCount`,
        count(distinct (case
                when (`student_course_enrollment`.`whetherOptional` = 1) then `student_course_enrollment`.`courseVarientId`
            end)) AS `optionalCourseCount`,
        (case
            when isnull(`evaluation_period_rank`.`obtainedMarks`) then (case when (`marksheet_job_details`.`isPublishMarksheet` =1) then `evaluation_period_rank`.`sgpa` end)
            else (case when (`marksheet_job_details`.`isPublishMarksheet` = 1) then `evaluation_period_rank`.`obtainedMarks` end)
        end) AS `SGPAORMarks`,
        (case
            when (`marksheet_job_details`.`isPublishMarksheet` = 1) then `evaluation_period_rank`.`status`
			end) AS `ResultStatus`,
        (case
            when (`marksheet_job_details`.`isPublishMarksheet` = 1) then `marksheet_job_details`.`marksheetPath`
        end) AS `marksheetPath`
    from
        ((((((((`program_batch_students`
        left join `admission` ON ((`program_batch_students`.`admissionId` = `admission`.`id`)))
        left join `prog_batch_period_config` ON ((`program_batch_students`.`progBatchPeriodConfigId` = `prog_batch_period_config`.`id`)))
        left join `batches` ON ((`program_batch_students`.`programBatchId` = `batches`.`id`)))
        left join `programs` ON ((`batches`.`programId` = `programs`.`id`)))
        left join `evaluation_period_rank` ON (((`evaluation_period_rank`.`admissionId` = `admission`.`id`)
            and (`evaluation_period_rank`.`periodId` = `prog_batch_period_config`.`id`))))
        left join `student_course_enrollment` ON ((`student_course_enrollment`.`admissionId` = `admission`.`id`)))
        left join `sections` ON ((`student_course_enrollment`.`sectionId` = `sections`.`id`)))
        left join `marksheet_job_details` ON (((`marksheet_job_details`.`admissionId` = `admission`.`id`)
            and (`marksheet_job_details`.`periodId` = `prog_batch_period_config`.`id`))))
    group by `prog_batch_period_config`.`id` , `admission`.`id`;
    
    
    
    
    CREATE 
   	OR REPLACE
VIEW `student_course_report` AS
    select 
        `student_course_enrollment`.`id` AS `studentCourseEnrollmentId`,
        `prog_batch_period_config`.`programPeriodName` AS `programPeriodName`,
        `courses`.`courseCode` AS `courseCode`,
        `courses`.`courseName` AS `courseName`,
        `course_variants`.`courseVariantCode` AS `courseVariantCode`,
        `student_course_enrollment`.`whetherOptional` AS `whetherOptional`,
        (case
            when (`marksheet_job_details`.`isPublishMarksheet` = 1) then `student_course_enrollment`.`marksObtained`
            else ''
        end) AS `marksObtained`,
        (case
            when (`marksheet_job_details`.`isPublishMarksheet` = 1) then `student_course_enrollment`.`whetherPassed`
        end) AS `whetherPassed`,
        `marksheet_job_details`.`id` AS `marksJobDetailsId`,
        `marksheet_job_details`.`isPublishMarksheet` AS `isPublishMarksheet`,
        `programs`.`id` AS `programId`,
        `batches`.`id` AS `batchId`,
        `admission`.`studentId` AS `studentId`,
        `prog_batch_period_config`.`id` AS `periodId`
    from
        (((((((`student_course_enrollment`
        left join `course_variants` ON ((`course_variants`.`id` = `student_course_enrollment`.`courseVarientId`)))
        left join `prog_batch_period_config` ON ((`prog_batch_period_config`.`id` = `student_course_enrollment`.`programBatchPeriodConfigId`)))
        left join `admission` ON ((`admission`.`id` = `student_course_enrollment`.`admissionId`)))
        left join `courses` ON ((`courses`.`id` = `course_variants`.`courseId`)))
        left join `marksheet_job_details` ON ((`marksheet_job_details`.`admissionId` = `admission`.`id`)))
        left join `programs` ON ((`programs`.`id` = `admission`.`programId`)))
        left join `batches` ON ((`batches`.`id` = `admission`.`batchId`)))
    group by `courses`.`id`;