DROP PROCEDURE IF EXISTS UpdateEPForMultipleCourseAndAL;

DELIMITER $$
CREATE PROCEDURE UpdateEPForMultipleCourseAndAL()
BEGIN
		DECLARE id_course BIGINT(20);
		DECLARE id_evalPlan BIGINT(20);
		DECLARE id_academyLocation BIGINT(20);
		DECLARE id_courseVariant BIGINT(20);
		DECLARE id_section BIGINT(20);
		DECLARE is_LongDistance BIT(1);
		DECLARE course_no_more_rows boolean default false;
		DECLARE academyLocation_no_more_rows boolean default false;
		DECLARE course_variant_no_more_rows boolean default false;
		DECLARE CVSection_no_more_rows boolean default false;
-- create temporary table if not exists templog_createmarksheetjob (msg varchar(512));

START TRANSACTION;

 BLOCK1: begin
    
	DECLARE csr_allCourseIds CURSOR FOR
	select evaluation_plan.id, evaluation_plan.courseId from evaluation_plan
    where evaluation_plan.courseId is not null
    group By evaluation_plan.id;
           
	declare continue handler for not found  set course_no_more_rows := true;
	OPEN csr_allCourseIds;
		csr_allCourseIds: LOOP
		fetch csr_allCourseIds into id_evalPlan, id_course;

		if course_no_more_rows then 
			set course_no_more_rows := false;
			close csr_allCourseIds;
			leave csr_allCourseIds;
		end if;
            
		INSERT INTO `evaluation_plan_courses` (`evaluationPlanId`, `courseId`, `lastUpdatedBy`, `isPrimaryCourse`) 
        VALUES (id_evalPlan, id_course, '1', b'1');

		BLOCK2: begin
        
			DECLARE csr_allacademyLocationIds CURSOR FOR
			select course_academy_location.academyLocationId from course_academy_location 
				where course_academy_location.courseId=id_course
				group by course_academy_location.academyLocationId;

			declare continue handler for not found set academyLocation_no_more_rows := true;
			OPEN csr_allacademyLocationIds;
			csr_allacademyLocationIds: LOOP

			fetch csr_allacademyLocationIds into id_academyLocation;
				if academyLocation_no_more_rows then 
					set academyLocation_no_more_rows := false;
					close csr_allacademyLocationIds;
					leave csr_allacademyLocationIds;
				end if;
				INSERT INTO `evaluation_plan_academy_location` (`evaluationPlanId`, `academyLocationId`, `lastUpdatedBy`) 
				VALUES (id_evalPlan, id_academyLocation, '1');
		
			END LOOP csr_allacademyLocationIds;
		end BLOCK2;
                
		BLOCK3: begin
			DECLARE csr_allCourseVariantIds CURSOR FOR
			select evaluation_type_course.courseVariantId from evaluation_type_course
				where evaluation_type_course.evaluationPlanId=id_evalPlan
				group by evaluation_type_course.courseVariantId;

			declare continue handler for not found  set course_variant_no_more_rows := true;
			OPEN csr_allCourseVariantIds;
			csr_allCourseVariantIds: LOOP
			fetch csr_allCourseVariantIds into id_courseVariant;
                                               
            if course_variant_no_more_rows then 
				set course_variant_no_more_rows := false;
				close csr_allCourseVariantIds;
				leave csr_allCourseVariantIds;
            end if;
            
			BLOCK4: begin
				DECLARE csr_allCVSectionIds CURSOR FOR
				select program_batch_course_param.sectionId, programs.isLongDistanceProgram from program_batch_course_param
					left join batches on program_batch_course_param.programBatchId=batches.id
					left join programs on batches.programId=programs.id
					where program_batch_course_param.courseVarientId=id_courseVariant
					and program_batch_course_param.sectionId is not null
					group by program_batch_course_param.sectionId;

				declare continue handler for not found  set CVSection_no_more_rows := true;
				OPEN csr_allCVSectionIds;
					csr_allCVSectionIds: LOOP
					fetch csr_allCVSectionIds into id_section, is_LongDistance;
										
				if CVSection_no_more_rows then 
					set CVSection_no_more_rows := false;
					close csr_allCVSectionIds;
					leave csr_allCVSectionIds;
				end if;
            
				  INSERT INTO `evaluation_type_course` (`evaluationPlanId`, `courseVariantId`, `sectionId`, `isLongDistance`,
				  `eligibleForRankCalculation`, `lastUpdatedBy`) 
				  VALUES (id_evalPlan, id_courseVariant, id_section, is_LongDistance, b'0', '1');
         															
					END LOOP csr_allCVSectionIds;
				end BLOCK4;
			END LOOP csr_allCourseVariantIds;
		end BLOCK3;
	END LOOP csr_allCourseIds;
END BLOCK1;
   
SET FOREIGN_KEY_CHECKS=0;
delete from evaluation_type_course where
 evaluation_type_course.sectionId is null and evaluation_type_course.completionStatus is not null;
SET FOREIGN_KEY_CHECKS=1;
COMMIT;      
END$$
DELIMITER ;

call UpdateEPForMultipleCourseAndAL();
