CREATE TABLE `hr_leave_document_master` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_hr_leave_document_maste_1_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_hr_leave_document_maste_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `hr_leave_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `leaveCode` varchar(255) DEFAULT NULL,
  `leaveType` varchar(255) DEFAULT NULL,
  `description` text,
  `eligibilityCriteria` varchar(45) DEFAULT NULL,
  `isAllowedInNoticePeriod` bit(1) DEFAULT NULL,
  `isExtendsNoticePeriod` bit(1) DEFAULT NULL,
  `isPayrateDeduction` bit(1) DEFAULT NULL,
  `percentOfPayDeduction` double(10,2) DEFAULT NULL,
  `validFrom` date DEFAULT NULL,
  `vaildTill` date DEFAULT NULL,
  `leaveStatus` varchar(45) DEFAULT NULL,
  `isDocumentRequired` bit(1) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_hr_leave_type_1_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_hr_leave_type_1` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



CREATE TABLE `hr_leave_type_document` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `leaveTypeId` bigint(20) DEFAULT NULL,
  `leaveDoumentMasterId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_hr_leave_type_document_1_idx` (`leaveTypeId`),
  KEY `fk_hr_leave_type_document_2_idx` (`leaveDoumentMasterId`),
  KEY `fk_hr_leave_type_document_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_hr_leave_type_document_1` FOREIGN KEY (`leaveTypeId`) REFERENCES `hr_leave_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hr_leave_type_document_2` FOREIGN KEY (`leaveDoumentMasterId`) REFERENCES `hr_leave_type_document` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hr_leave_type_document_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hr_eligibility_setting` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `eligibilityCode` varchar(255) DEFAULT NULL,
  `availabilityPeriodType` varchar(45) DEFAULT NULL,
  `availableLeaveDays` double(10,2) DEFAULT NULL,
  `periodStartFrom` bigint(20) DEFAULT NULL,
  `isDifferentCreditPeriod` bit(1) DEFAULT NULL,
  `creditPeriodType` varchar(45) DEFAULT NULL,
  `leaveDaysToCredit` double(10,2) DEFAULT NULL,
  `isAllowAdvanceCredit` bit(1) DEFAULT NULL,
  `isBasedOnJoiningDate` bit(1) DEFAULT NULL,
  `isEligibleForCompOff` bit(1) DEFAULT NULL,
  `isBasedOnServicePeriod` bit(1) DEFAULT NULL,
  `servicePeriodType` varchar(45) DEFAULT NULL,
  `minimumServiceTerm` double(10,2) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_hr_eligibility_settings_1_idx` (`periodStartFrom`),
  KEY `fk_hr_eligibility_settings_2_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_hr_eligibility_settings_1` FOREIGN KEY (`periodStartFrom`) REFERENCES `months` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hr_eligibility_settings_2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



CREATE TABLE `hr_eligibility_leave_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `eligibilitySettingsId` bigint(20) DEFAULT NULL,
  `eligibilityCtiteria` varchar(45) DEFAULT NULL,
  `leaveTypeId` bigint(20) DEFAULT NULL,
  `employeeAttributeType` varchar(45) DEFAULT NULL,
  `employeeAttributeValue` varchar(45) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_hr_eligibility_setting_leave_type_1_idx` (`eligibilitySettingsId`),
  KEY `fk_hr_eligibility_setting_leave_type_2_idx` (`leaveTypeId`),
  KEY `fk_hr_eligibility_setting_leave_type_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_hr_eligibility_setting_leave_type_1` FOREIGN KEY (`eligibilitySettingsId`) REFERENCES `hr_eligibility_setting` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hr_eligibility_setting_leave_type_2` FOREIGN KEY (`leaveTypeId`) REFERENCES `hr_leave_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hr_eligibility_setting_leave_type_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `hr_eligibility_leave_type_al` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `eligibilityLeaveTypeId` bigint(20) DEFAULT NULL,
  `academyLocationId` bigint(20) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_hr_eligibility_setting_leave_type_al_1_idx` (`eligibilityLeaveTypeId`),
  KEY `fk_hr_eligibility_setting_leave_type_al_2_idx` (`academyLocationId`),
  KEY `fk_hr_eligibility_setting_leave_type_al_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_hr_eligibility_setting_leave_type_al_1` FOREIGN KEY (`eligibilityLeaveTypeId`) REFERENCES `hr_eligibility_leave_type` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hr_eligibility_setting_leave_type_al_2` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_hr_eligibility_setting_leave_type_al_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;





