CREATE TABLE `employee_leave_request_detail` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `fromDate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `toDate` TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00',
  `serviceRequestId` BIGINT(20) NOT NULL,
  `leaveTypeId` BIGINT(20) NOT NULL,
  `version` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `Employee_Leave_Req_SR_FK_idx` (`serviceRequestId` ASC),
  INDEX `Employee_Leave_Leave_Type_FK_idx` (`leaveTypeId` ASC),
  INDEX `Employee_Leave_Last_Update_FK_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `Employee_Leave_Req_SR_FK`
    FOREIGN KEY (`serviceRequestId`)
    REFERENCES `service_requests` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `Employee_Leave_Leave_Type_FK`
    FOREIGN KEY (`leaveTypeId`)
    REFERENCES `hr_leave_type` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `Employee_Leave_Last_Update_FK`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
    
insert  into `request_types`(`id`,`serviceRequestGroup`,`whetherDeleted`,`requestTypeCode`,`requestTypeName`,`lastUpdatedBy`,`lastUpdate`,`type`,`feeRelatedCategory`) 
values (47,'OTHER','\0','EMPL','Employee Leave',1,'2014-08-01 07:13:42','COMMON',NULL);
UPDATE `request_type_categories` SET `requestTypeId`='47' WHERE `id`='18';

