	-- mobile bill mapping table
	CREATE TABLE IF NOT EXISTS `mobile_bill` (
	  `id` bigint(20) NOT NULL AUTO_INCREMENT,
	  `billId` bigint(20) NOT NULL,
	  `headName` varchar(100) DEFAULT NULL,
	  `mobileBillId` varchar(255) DEFAULT NULL,
	  `billStageId` varchar(255) DEFAULT NULL,
	  `groupId` bigint(20) DEFAULT NULL,
	  `instituteId` varchar(255) DEFAULT NULL,
	  `apiAction` varchar(20) DEFAULT NULL,
	  `status` varchar(20) DEFAULT NULL,
	  `errorMessage` TEXT DEFAULT NULL,
	  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	  `lastUpdatedBy` bigint(20) NOT NULL,
	  PRIMARY KEY (`id`),
	  KEY `fk_mobile_bill_groupId` (`groupId`),
	  KEY `fk_mobile_bill_updatedby` (`lastUpdatedBy`),
	  CONSTRAINT `fk_mobile_bill_groupId` FOREIGN KEY (`groupId`) REFERENCES `mobile_group` (`id`),
	  CONSTRAINT `fk_mobile_bill_updatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
	) ENGINE=InnoDB DEFAULT CHARSET=utf8;


	-- mobile receipt mapping table
	CREATE TABLE IF NOT EXISTS `mobile_receipt` (
	  `id` bigint(20) NOT NULL AUTO_INCREMENT,
	  `receiptId` bigint(20) NOT NULL,
	  `mobileReceiptId` varchar(255) DEFAULT NULL,
	  `instituteId` varchar(255) DEFAULT NULL,
	  `voucherMode` varchar(255) DEFAULT NULL,
	  `apiAction` varchar(20) DEFAULT NULL,
	  `status` varchar(20) DEFAULT NULL,
	  `errorMessage` TEXT DEFAULT NULL,
	  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	  `lastUpdatedBy` bigint(20) NOT NULL,
	  PRIMARY KEY (`id`),
	  KEY `fk_mobile_receipt_updatedby` (`lastUpdatedBy`),
	  CONSTRAINT `fk_mobile_receipt_updatedby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
	) ENGINE=InnoDB DEFAULT CHARSET=utf8;