CREATE TABLE `academic_topics` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(255) NOT NULL,
  `itemValue` varchar(255) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_academic_topics_1_idx` (`lastUpdatedBy`),
  UNIQUE INDEX `fk_academic_topics_unique_code_idx` (`itemCode` ASC),
  UNIQUE INDEX `fk_academic_topics_unique_value_idx` (`itemValue` ASC),
  CONSTRAINT `fk_academic_topics_1_idx` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `academic_sub_topics` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academicTopicId` bigint(20) NOT NULL,
  `subTopicName` varchar(255) NOT NULL,
  `showInMarksheet` BIT(1) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_academic_sub_topics_idx1` (`academicTopicId`),
  KEY `fk_academic_sub_topics_idx2` (`lastUpdatedBy`),
  CONSTRAINT `fk_academic_sub_topics_idx1` FOREIGN KEY (`academicTopicId`) REFERENCES `academic_topics` (`id`),
  CONSTRAINT `fk_academic_sub_topics_idx2` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


set sql_safe_updates=0;
SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master` (`id`, `tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, 'academic_topics', 'ACADEMIC_TOPICS','Student Profile','COMMON_MASTER', 0, 1, '1',@currentTimeStamp),
(@standardMasterMaxId+2, 'academic_sub_topics', 'ACADEMIC_SUB_TOPICS','Student Profile','COMMON_MASTER', 1, 0, '1',@currentTimeStamp);
UPDATE `standard_master` SET `childMaster`=@standardMasterMaxId+2 WHERE `id`=@standardMasterMaxId+1;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO `standard_master_items`(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`,`lastUpdate`) 
VALUES (@ItemsMaxId+1, 'itemCode', 'ITEM_CODE', @standardMasterMaxId+1, 'Varchar', '1', 0, 0, 0, 0, '1',@currentTimeStamp),
(@ItemsMaxId+2, 'itemValue', 'ITEM_VALUE', @standardMasterMaxId+1, 'Varchar', '2', 0, 0, 0, 0, '1',@currentTimeStamp),
(@ItemsMaxId+3, 'subTopicName', 'SUB_TOPIC_NAME', @standardMasterMaxId+2, 'Varchar', '2', 0, 0, 0, 0, '1',@currentTimeStamp),
(@ItemsMaxId+4, 'showInMarksheet', 'SHOW_IN_MARKSHEET', @standardMasterMaxId+2, 'Boolean', '1', 0, 0, 0, 0, '1',@currentTimeStamp);
set sql_safe_updates=1;

drop table if exists book_reading_program;

CREATE TABLE `student_academic_topics` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `admissionId` bigint(20) NOT NULL,
  `batchId` bigint(20) NOT NULL,
  `academicSubTopicId` bigint(20) NOT NULL,
  `periodId` bigint(20) DEFAULT NULL,
  `description` LONGTEXT DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_student_academic_topics_lastUpdatedBy_idx` (`lastUpdatedBy`),
  KEY `fk_student_academic_topics_admissionId_idx` (`admissionId`),
  KEY `fk_student_academic_topics_batchId_idx` (`batchId`),
  KEY `fk_student_academic_topics_periodId_idx` (`periodId`),
  KEY `fk_student_academic_topics_academicSubTopicId_idx` (`academicSubTopicId`),
  CONSTRAINT `fk_student_academic_topics_admissionId` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`),
  CONSTRAINT `fk_student_academic_topics_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_student_academic_topics_batchId` FOREIGN KEY (`batchId`) REFERENCES `batches` (`id`),
  CONSTRAINT `fk_student_academic_topics_academicSubTopicId_idx` FOREIGN KEY (`academicSubTopicId`) REFERENCES `academic_sub_topics` (`id`),
  CONSTRAINT `fk_student_academic_topics_periodId` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;