CREATE TABLE `payment_gateway_master`( 
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
	`academyLocationId` BIGINT(20), 
	`environment` VARCHAR(255),
 	`userName` VARCHAR(255),
	 `password` VARCHAR(255),
         `safekey` VARCHAR(255),
         `isActive` BIT(1),
	 `isDefault` BIT(1),
	`lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	 `lastUpdatedBy` BIGINT(20),
	  PRIMARY KEY (`id`), 
	  CONSTRAINT `payment_gateway_master_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`), 
	  CONSTRAINT `payment_gateway_master_academyLocationId_FK` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location`(`id`) ) ENGINE=INNODB DEFAULT 

CHARSET=utf8; 



INSERT INTO standard_master(`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`) VALUES ('payment_gateway_master', 'PAYMENT_GATEWAY_MASTER', 'Payment Gateway', 'MASTER_WITH_AL', 0, 0, '1', SYSDATE());


 
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);



INSERT INTO standard_master_items(`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`,
`fkTable`, `fkFieldName`, 

`fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)

 VALUES 

('academyLocation', 'ACADEMY_LOCATION', @standardMasterMaxId, 'Varchar','1',1,'academy_location', 'id','academyLocationName', 0, 0, 0, '1',SYSDATE()),
 ('environment', 'ENVIRONMENT', @standardMasterMaxId, 'Varchar', '2', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('username', 'USERNAME', @standardMasterMaxId, 'Varchar', '3', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),
('password', 'PASSWORD',@standardMasterMaxId, 'Varchar', '4', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),


('safekey', 'SAFEKEY', @standardMasterMaxId, 'Varchar', '5', 0, NULL, NULL,NULL, 0, 0, 0, '1', SYSDATE()),

('isActive', 'IS_ACTIVE', @standardMasterMaxId, 'Boolean', '6', 0, NULL, NULL,NULL, 0, 0, 1, '1', SYSDATE()),
 ('isDefault', 'IS_DEFAULT', @standardMasterMaxId, 'Boolean', '7', 0, NULL, NULL,NULL, 0, 0, 1, '1', SYSDATE());
