CREATE TABLE IF NOT EXISTS `drool_batch_mapping` (
	  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	  `droolId` BIGINT(20) NOT NULL,
	  `batchId` BIGINT(20) NOT NULL,
	  `droolCode` VARCHAR(255) NOT NULL,
	  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
	  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	  PRIMARY KEY (`id`),
	  INDEX `fk_drool_batch_mapping_droolId_idx` (`droolId` ASC),
	  INDEX `fk_drool_batch_mapping_batchId_idx` (`batchId` ASC),
	  INDEX `fk_drool_batch_mapping_lastUpdatedBy_idx` (`lastUpdatedBy` ASC),
	  UNIQUE INDEX `droolId_batchId_unique` (`droolId` ASC, `batchId` ASC),
	  CONSTRAINT `fk_drool_batch_mapping_droolId`
		FOREIGN KEY (`droolId`)
		REFERENCES `drool_rules` (`id`)
		ON DELETE NO ACTION
		ON UPDATE NO ACTION,
	  CONSTRAINT `fk_drool_batch_mapping_batchId`
		FOREIGN KEY (`batchId`)
		REFERENCES `batches` (`id`)
		ON DELETE NO ACTION
		ON UPDATE NO ACTION,
	  CONSTRAINT `fk_drool_batch_mapping_lastUpdatedBy`
		FOREIGN KEY (`lastUpdatedBy`)
		REFERENCES  `users` (`id`)
		ON DELETE NO ACTION
		ON UPDATE NO ACTION);