/*===============================================================================================
-- CREATE TABLE `export_program_config
===============================================================================================*/
DROP TABLE IF EXISTS  export_program_config;
CREATE TABLE `export_program_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) NOT NULL DEFAULT '0',
  `academyName` varchar(100) NOT NULL,
  `programId` bigint(20) NOT NULL DEFAULT '0',
  `programName` varchar(255) NOT NULL,
  `FIM` tinyint(1) NOT NULL DEFAULT '0',
  `MS_TEAM` tinyint(1) NOT NULL DEFAULT '0',
  `SASAMS` varchar(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `Idx_progId_academyLocationId` (`academyLocationId`,`programId`)
) ENGINE=InnoDB AUTO_INCREMENT=1036 DEFAULT CHARSET=utf8;

INSERT INTO export_program_config (academyLocationId,academyName,programId,programName, FIM,MS_TEAM, SASAMS)
(SELECT DISTINCT
    al.id AS academyLocationId,
    al.academyName,
    p.id AS programId,
    p.programName,
    IF((p.programName IN ('Grade 0' , 'Grade 00',
            'Grade 000',
            'Grade 0000',
            'Babies',
            'KG 1',
            'KG 2',
            'Reception',
            'Toddlers')),
        0,
        1) AS FIM,
     IF ((p.programName IN ('Grade 0' , 'Grade 00',
            'Grade 000',
            'Grade 0000',
            'Babies',
            'KG 1',
            'KG 2',
            'Reception',
            'Toddlers',
            'Standard 1',
            'Standard 2',
            'Standard 3',
            'Year 1',
			'Year 2',
            'Year 3')),
        0,
        1) AS MS_TEAM,
        '1' as SASAMS
FROM
    programs AS p
        INNER JOIN
    academy_location AS al ON p.academyLocationId = al.id
order by academyLocationId , programId);


/*===============================================================================================
-- TRIGGERS CREATION
===============================================================================================*/
-- AFTER INSERT TRIGGER

DELIMITER $$
DROP TRIGGER IF EXISTS PROGRAMS_AFTER_INSERT$$
CREATE  TRIGGER `PROGRAMS_AFTER_INSERT` AFTER INSERT ON `programs` FOR EACH ROW
BEGIN
INSERT INTO export_program_config (academyLocationId, academyName, programId,programName) 
VALUES (NEW.academyLocationId, (select academyName from academy_location where id=NEW.academyLocationId limit 1), NEW.id, NEW.programName);
END$$
DELIMITER ;	

-- AFTER UPDATE TRIGGER


DROP TRIGGER IF EXISTS program_marksheet_trigger;
DELIMITER //
CREATE TRIGGER program_marksheet_trigger 
 AFTER UPDATE ON programs 
 FOR EACH ROW 
BEGIN
IF NEW.programNameToBePrint <=> OLD.programNameToBePrint || NEW.programNameToBePrint <> OLD.programNameToBePrint THEN
	set sql_safe_updates=0;

UPDATE marksheet 
SET 
    programName = NEW.programNameToBePrint
WHERE
    programId = OLD.id;
	 -- update marksheet
	-- join evaluation_plan_level_one on marksheet.evaluationPlanLevelOneId=evaluation_plan_level_one.id
	-- set marksheet.evaluationLevelOne=evaluation_plan_level_one.levelName,
	-- marksheet.levelOnePrintName=evaluation_plan_level_one.printNameInMarksheet;
	set sql_safe_updates=1;
END IF;
IF NEW.programName <=> OLD.programName || NEW.programName <> OLD.programName || OLD.academyLocationId <> NEW.academyLocationId THEN
-- To Update export_program_config Entry for corresponding program row update
set sql_safe_updates=0;
UPDATE export_program_config AS epc 
SET 
    epc.programName = NEW.programName,
    epc.academyName = (SELECT 
            academyName
        FROM
            academy_location
        WHERE
            id = NEW.academyLocationId
        LIMIT 1),
    epc.academyLocationId = NEW.academyLocationId
WHERE
    epc.programId = NEW.id;
set sql_safe_updates=1;

END IF;

END;//
DELIMITER ;

-- AFTER DELETE TRIGGER

DELIMITER $$
DROP TRIGGER IF EXISTS PROGRAMS_AFTER_DELETE$$
CREATE TRIGGER `PROGRAMS_AFTER_DELETE` AFTER DELETE ON `programs` FOR EACH ROW
BEGIN
DELETE FROM export_program_config 
    WHERE  programId= OLD.id AND academyLocationId=OLD.academyLocationId;
END$$
DELIMITER ;

/*===============================================================================================
-- PROCEDURES FOR CSV
===============================================================================================*/

-- 1. Schools 

DROP procedure IF EXISTS `SP_MSTeam_Schools`;
DELIMITER $$
CREATE PROCEDURE `SP_MSTeam_Schools`()
BEGIN
SELECT 
    al.id AS 'SIS ID',
    CONCAT(al.displayName, ' - ', al.locationCode) AS Name,
    cr.code AS State_ID,
    low_grade.programName AS 'Grade Low',
    high_grade.programName AS 'Grade High',
    u.id AS 'Principal SIS ID',
    u.printName AS 'Principal Name',
    a.addressText AS Address,
    c.cityName AS City,
    cr.code AS State,
    con.countryName AS Country,
    a.pincode AS Zip,
    pg.sequenceNo AS Zone
FROM 
    program_group_details AS pgd
        JOIN
    academy_location AS al ON pgd.academyLocationId = al.id
        JOIN
    program_group_addresses AS pga ON pga.programGroupDetailId = pgd.id
        JOIN
    program_group AS pg ON pg.id = pgd.programGroupId
        JOIN
        programs as p on p.academyLocationId=al.id
        JOIN
    address AS a ON a.id = pga.addressId
        JOIN
    city AS c ON c.id = a.cityId
        JOIN
    country_region AS cr ON cr.id = a.parentRegionId
        LEFT JOIN
    country AS con ON cr.countryId = con.id
        LEFT JOIN
    (SELECT 
        lg.min_progSeq,
            p.academyLocationId,
            p.programName,
            p.programGroupId
    FROM
        programs AS p
    JOIN (SELECT 
        MIN(p.programSequence) AS min_progSeq,
            p.programName,
            p.academyLocationId
    FROM
        programs p
    GROUP BY p.academyLocationId) AS lg ON lg.min_progSeq = p.programSequence
        AND p.academyLocationId = lg.academyLocationId
    GROUP BY p.academyLocationId
	) AS low_grade ON (low_grade.academyLocationId = al.id)
        LEFT JOIN
    (SELECT 
        hg.max_progSeq,
            p.academyLocationId,
            p.programName,
            p.programGroupId
    FROM
        programs AS p
    JOIN (SELECT 
        MAX(p.programSequence) AS max_progSeq,
            p.programName,
            p.academyLocationId
    FROM
        programs p
    GROUP BY p.academyLocationId) AS hg ON hg.max_progSeq = p.programSequence
        AND p.academyLocationId = hg.academyLocationId
    GROUP BY p.academyLocationId
	) AS high_grade ON (high_grade.academyLocationId = al.id)
        LEFT JOIN
    users AS u ON u.id = pgd.principalId

   JOIN `export_program_config` as `epc` on (p.`id`=`epc`.programId and p.`academyLocationId`=`epc`.academyLocationId and epc.MS_TEAM=1)
where al.id<>52
GROUP BY al.id;
END$$

DELIMITER ;

/*===============================================================================================
-- 2. Sections List 
===============================================================================================*/

DROP procedure IF EXISTS `SP_MSTeam_Sections`;
DELIMITER $$
CREATE PROCEDURE `SP_MSTeam_Sections`()
BEGIN

SELECT 
    section.id AS 'SIS ID',
    courseAcademylocation.academyLocationId AS 'School SIS ID',
    p.programName,
    aterm.itemCode,
    CONCAT(course.nameToBePrinted,
            ' - ',
            REPLACE((CASE
                    WHEN
                        (LENGTH(SUBSTRING_INDEX(`p`.`programName`, ' ', -(1))) = 1)
                    THEN
                        CONCAT(SUBSTRING_INDEX(`p`.`programName`, ' ', 1),
                                LPAD(SUBSTRING_INDEX(`p`.`programName`, ' ', -(1)),
                                        2,
                                        0))
                    ELSE `p`.`programName`
                END),
                ' ',
                ''),
            '', ' - ',
            replace(section.sectionCode, '/', ' - ' )) AS 'Section Name',
    section.id AS 'Section Number',
    aterm.id AS 'Term SIS ID',
    aterm.itemValue AS 'Term Name',
    period.programPeriodStart AS 'Term StartDate',
    period.programPeriodEnd AS 'Term EndDate',
    course.id AS 'Course SIS ID',
    course.courseName AS 'Course Name',
    course.courseCode AS 'Course Number',
    CASE
        WHEN courseCategory.categoryName IS NOT NULL THEN courseCategory.categoryName
        ELSE course.courseShortDescription
    END AS CourseDescription,
    '' AS Periods,
    'Active' AS Status
FROM
    course_academy_location AS courseAcademylocation
        LEFT JOIN
    academy_location ON academy_location.id = courseAcademylocation.academyLocationId
        LEFT JOIN
    locations ON academy_location.locationId = locations.id
        LEFT JOIN
    courses AS course ON course.id = courseAcademylocation.courseId
        JOIN
    course_variants AS cv ON cv.courseId = course.id AND course.id
        AND cv.academyLocationId = academy_location.id
        JOIN
    sections AS section ON section.courseVariantId = cv.id
        LEFT JOIN
    academic_term AS aterm ON aterm.id = section.academicTermId
        JOIN
    program_batch_course_param AS param ON cv.id = param.courseVarientId
        JOIN
    batches AS b ON param.programBatchId = b.id
        JOIN
    programs AS p ON p.id = b.programId
        JOIN `export_program_config` as `epc` on (p.`id`=`epc`.programId and p.`academyLocationId`=`epc`.academyLocationId and epc.MS_TEAM=1)
        LEFT JOIN
    prog_batch_period_config AS period ON period.id = param.progBatchPeriodConfigId
        LEFT JOIN
    course_category courseCategory ON courseCategory.id = course.courseCategoryId
        
where aterm.itemCode = (select year(current_date())) and academy_location.id<>52
GROUP BY courseAcademylocation.id, section.id
ORDER BY courseAcademylocation.academyLocationId , course.nameToBePrinted , section.id;
END$$

DELIMITER ;

/*===============================================================================================
-- 3. Student List 
===============================================================================================*/

DROP procedure IF EXISTS `SP_MSTeam_Students`;
DELIMITER $$
CREATE PROCEDURE `SP_MSTeam_Students`()
BEGIN

SELECT 
	usr.id AS 'SIS ID',
    prg.academyLocationId AS 'School SIS ID',
    usr.emailId AS Username,
    usr.code AS StudentNumber,
    prg.programNameToBePrint AS Grade
FROM
    admission as adm
        INNER JOIN
    users usr ON adm.studentId = usr.id and adm.activeStatus = 1
        AND usr.status = 1
        INNER JOIN
    program_batch_students pbs ON adm.id = pbs.admissionId
        INNER JOIN
    batches bch ON bch.id = pbs.programBatchId
        INNER JOIN
    programs prg ON prg.id = bch.programId
		INNER JOIN
    export_program_config as `epc` on (prg.`id`=`epc`.programId and prg.`academyLocationId`=`epc`.academyLocationId and epc.MS_TEAM=1)
          
WHERE   pbs.isCurrentSection = 1
        AND pbs.isCurrentPeriod = 1 and pbs.exitDate is null
        AND prg.academyLocationId<>52     
GROUP BY pbs.admissionId;
END$$
DELIMITER ;


/*===============================================================================================
-- 4. Student Enrolment
===============================================================================================*/

DROP procedure IF EXISTS `SP_MSTeam_Student_Enrolment`;
DELIMITER $$
CREATE PROCEDURE `SP_MSTeam_Student_Enrolment`()
BEGIN

SELECT section.id  AS 'Section SIS ID' , usr.id AS 'SIS ID'
    
FROM
	   program_batch_students pbs
        JOIN
        student_course_enrollment sce ON sce.admissionId = pbs.admissionId 
        AND pbs.progBatchPeriodConfigId = sce.programBatchPeriodConfigId 
        AND sce.isCurrentSection = TRUE
        JOIN
        course_variants cv ON cv.id = sce.courseVarientId 
 	    JOIN
		sections AS section ON section.id = sce.sectionId
        JOIN
        academic_term AS aterm ON aterm.id = section.academicTermId
        JOIN
        course_academy_location cal ON cal.courseId = cv.courseId AND cal.academyLocationId = cv.academyLocationId
        JOIN
	    prog_batch_period_config AS period ON sce.programBatchPeriodConfigId = period.id
        AND period.isCurrentPeriodOfProgram = TRUE
        JOIN
        batches bch ON bch.id = pbs.programBatchId
        JOIN
        programs prg ON prg.id = bch.programId
        JOIN
	    admission adm ON adm.id = pbs.admissionId AND adm.activeStatus = 1
        JOIN
        users usr ON usr.id = adm.studentId AND usr.status = 1
        JOIN
        export_program_config as `epc` on (prg.`id`=`epc`.programId and prg.`academyLocationId`=`epc`.academyLocationId and epc.MS_TEAM=1)
        
WHERE
        pbs.isCurrentSection = 1
        AND pbs.exitDate IS NULL
        AND sce.exitDate IS NULL
        AND aterm.itemCode = (select year(current_date())) 
        AND cal.academyLocationId <> 52
GROUP BY cal.id, section.id, adm.id 
ORDER BY  section.id, usr.id;
END$$

DELIMITER ;

/*===================================================================================
-- 5. Teachers
===================================================================================*/

DROP procedure IF EXISTS `SP_MSTeam_Teachers`;
DELIMITER $$
CREATE PROCEDURE `SP_MSTeam_Teachers`()
BEGIN

SELECT 
    u.id AS 'SIS ID',
    p.academyLocationId AS 'School SIS ID',
    pp.emailId AS Username, p.programName, al.academyName, u.status, f.progBatchCourseParamId
FROM
    prog_batch_course_faculty AS f
        JOIN
    users AS u ON f.facultyId = u.id
        JOIN
    staffs s ON s.userId = u.id
        JOIN
    persons pp ON pp.id = s.personId
        JOIN
    (SELECT '%abbotts.co.za' AS domain UNION SELECT '%advtech.co.za' AS domain UNION SELECT '%centuruscolleges.co.za' AS domain UNION SELECT '%charterhouse.co.za' AS domain UNION SELECT '%connect.edu.za' AS domain UNION SELECT '%copperleafcollege.co.za' AS domain UNION SELECT '%crawford.africa' AS domain UNION SELECT '%crawfordinternationalschool.com' AS domain UNION SELECT '%crawfordschools.co.za' AS domain UNION SELECT '%elkanah.co.za' AS domain UNION SELECT '%foundershillcollege.co.za' AS domain UNION SELECT '%gis.co.bw' AS domain UNION SELECT '%Glenwoodhouse.co.za' AS domain UNION SELECT '%greenwoodbaycollege.co.za' AS domain UNION SELECT '%iie.ac.za' AS domain UNION SELECT '%iie.edu.za' AS domain UNION SELECT '%juniorcolleges.co.za' AS domain UNION SELECT '%kathstancollege.co.za' AS domain UNION SELECT '%maragon.co.za' AS domain UNION SELECT '%pecanwoodcollege.co.za' AS domain UNION SELECT '%pinnaclecolleges.co.za' AS domain UNION SELECT '%southdownscollege.co.za' AS domain UNION SELECT '%summitcollege.co.za' AS domain UNION SELECT '%thebridgeschool.co.za' AS domain UNION SELECT '%trinityhouse.co.za' AS domain UNION SELECT '%tygervalleycollege.co.za' AS domain) AS d ON pp.emailId LIKE d.domain
        JOIN
    program_batch_course_param AS param ON param.id = f.progBatchCourseParamId
        JOIN
    batches AS b ON b.id = param.programBatchId
        JOIN
    programs AS p ON p.id = b.programId
    JOIN academy_location as al on (p.academyLocationId=al.id)
        JOIN
    program_group_details AS pgd ON pgd.programGroupId = p.programGroupId
        AND pgd.academyLocationId = p.academyLocationId
        JOIN
    (SELECT 
        al.id,
            al.academyName,
            al.locationName,
            p.id AS prog_id,
            p.programName,
            p.programSequence,
            min_prog.programSequence AS min_prog_seq
    FROM
        programs AS p, academy_location AS al
    LEFT JOIN 
    (SELECT 
        p.programName, p.academyLocationId, p.programSequence
    FROM
        programs p
    WHERE
        (programSequence , academyLocationId) IN 
        (SELECT 
                MIN(programSequence), programs.academyLocationId
            FROM
                programs JOIN `export_program_config` as `epc` on (programs.`id`=`epc`.programId and programs.`academyLocationId`=`epc`.academyLocationId)
          
				WHERE epc.MS_TEAM=1
            GROUP BY academyLocationId
		 )
		) AS min_prog ON min_prog.academyLocationId = al.id
    WHERE
        p.academyLocationId = al.id
            AND p.programSequence >= min_prog.programSequence
	) AS al_req ON p.academyLocationId = al_req.id
where p.academyLocationId <> 52  
and u.status =1  
GROUP BY u.id , p.academyLocationId
ORDER BY p.academyLocationId;
END$$

DELIMITER ;

/*===================================================================================
-- 6. Teacherroster
=====================================================================================*/

DROP procedure IF EXISTS `SP_MSTeam_Teacher_Roster`;
DELIMITER $$
CREATE PROCEDURE `SP_MSTeam_Teacher_Roster`()
BEGIN


SELECT 
    section.id AS 'Section SIS ID',
    u.id AS 'SIS ID'
FROM
    prog_batch_course_faculty AS f
        JOIN
    program_batch_course_param AS param ON f.progBatchCourseParamId = param.id
        JOIN
    batches AS b ON b.id = param.programBatchId
        JOIN
    programs AS p ON p.id = b.programId
        JOIN
    course_variants AS cv ON param.courseVarientId = cv.id
        JOIN
		sections AS section ON section.id = param.sectionId
        JOIN
        academic_term AS aterm ON aterm.id = section.academicTermId
        JOIN
    course_academy_location AS courseAcademylocation ON cv.courseId = courseAcademylocation.courseId
        AND cv.academyLocationId = courseAcademylocation.academyLocationId
        JOIN
    users AS u ON f.facultyId = u.id
        JOIN
    staffs s ON s.userId = u.id
        JOIN
    persons pp ON pp.id = s.personId
        JOIN
    (SELECT '%abbotts.co.za' AS domain UNION SELECT '%advtech.co.za' AS domain UNION SELECT '%centuruscolleges.co.za' AS domain UNION SELECT '%charterhouse.co.za' AS domain UNION SELECT '%connect.edu.za' AS domain UNION SELECT '%copperleafcollege.co.za' AS domain UNION SELECT '%crawford.africa' AS domain UNION SELECT '%crawfordinternationalschool.com' AS domain UNION SELECT '%crawfordschools.co.za' AS domain UNION SELECT '%elkanah.co.za' AS domain UNION SELECT '%foundershillcollege.co.za' AS domain UNION SELECT '%gis.co.bw' AS domain UNION SELECT '%Glenwoodhouse.co.za' AS domain UNION SELECT '%greenwoodbaycollege.co.za' AS domain UNION SELECT '%iie.ac.za' AS domain UNION SELECT '%iie.edu.za' AS domain UNION SELECT '%juniorcolleges.co.za' AS domain UNION SELECT '%kathstancollege.co.za' AS domain UNION SELECT '%maragon.co.za' AS domain UNION SELECT '%pecanwoodcollege.co.za' AS domain UNION SELECT '%pinnaclecolleges.co.za' AS domain UNION SELECT '%southdownscollege.co.za' AS domain UNION SELECT '%summitcollege.co.za' AS domain UNION SELECT '%thebridgeschool.co.za' AS domain UNION SELECT '%trinityhouse.co.za' AS domain UNION SELECT '%tygervalleycollege.co.za' AS domain) AS d ON pp.emailId LIKE d.domain
        JOIN
        export_program_config as `epc` on (p.`id`=`epc`.programId and p.`academyLocationId`=`epc`.academyLocationId and epc.MS_TEAM=1)
where courseAcademylocation.academyLocationId <> 52 AND aterm.itemCode = (select year(current_date())) and u.status =1  
GROUP BY courseAcademylocation.id,section.id, u.id
ORDER BY courseAcademylocation.id,section.id, u.id;
END$$

DELIMITER ;






