DROP TRIGGER IF EXISTS marksheet_remark_insert_trigger;
DELIMITER //
CREATE TRIGGER marksheet_remark_insert_trigger 
AFTER INSERT ON evaluation_student_remark 
FOR EACH ROW 
BEGIN
set sql_safe_updates=0;
-- drop table if exists templog_remark;
-- create temporary table if not exists templog_remark (msg varchar(8192));
if(
select count(marksheet.id) 
from marksheet 
where marksheet.admissionId=NEW.admissionId 
and (
	(NEW.courseVariantId is null and marksheet.courseVariantId is null)
	or NEW.courseVariantId = marksheet.courseVariantId 
    )
and NEW.sectionId=marksheet.sectionId and NEW.periodId=marksheet.periodId and NEW.evaluationPlanId=marksheet.evaluationPlanId
and NEW.evalPlanLevelOneId is not null and NEW.evalPlanLevelOneId=marksheet.evaluationPlanLevelOneId 
    and marksheet.evaluationPlanLevelTwoId is null limit 1) = 0 && NEW.evalPlanLevelOneId is not null
then 
-- insert into templog_remark values('Type level row created');
	INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `remark`, `levelOnePrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
	select admission.id, admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, type_plan.id, type_plan.evaluationPlanNumber,type.id,type.levelName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark,type.printNameInMarksheet,type_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_one type on remark.evalPlanLevelOneId=type.id
	left join evaluation_plan type_plan on type.evaluationPlanId=type_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
elseif NEW.evalPlanLevelOneId is not null then
-- insert into templog_remark values('Type level row updated');
UPDATE marksheet set remark=NEW.remark where ((NEW.courseVariantId is null and marksheet.courseVariantId is null)
	or NEW.courseVariantId = marksheet.courseVariantId) and evaluationPlanLevelOneId=NEW.evalPlanLevelOneId
		and sectionId=NEW.sectionId
		and periodId=NEW.periodId and admissionId=NEW.admissionId and evaluationPlanLevelTwoId IS NULL;
end if;

if(
select count(marksheet.id) 
from marksheet
where marksheet.admissionId=NEW.admissionId 
and (
	(NEW.courseVariantId is null and marksheet.courseVariantId is null)
	or NEW.courseVariantId = marksheet.courseVariantId 
    )
and NEW.sectionId=marksheet.sectionId and NEW.periodId=marksheet.periodId and NEW.evaluationPlanId=marksheet.evaluationPlanId
and NEW.evalPlanLevelOneId is not null and marksheet.evaluationPlanLevelOneId is null
limit 1) = 0 && NEW.evalPlanLevelOneId is not null
then
-- insert into templog_remark values('Type plan level row created');
	INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `planPrintName`, `parentCourseId`, `parentCourseName`)
    select admission.id, admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, type_plan.id, type_plan.evaluationPlanNumber, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, type_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_one type on remark.evalPlanLevelOneId=type.id
	left join evaluation_plan type_plan on type.evaluationPlanId=type_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
end if;

if(
select count(marksheet.id) 
from marksheet 
where marksheet.admissionId=NEW.admissionId 
and (
	(NEW.courseVariantId is null and marksheet.courseVariantId is null)
	or NEW.courseVariantId = marksheet.courseVariantId 
    )
and NEW.sectionId=marksheet.sectionId and NEW.periodId=marksheet.periodId and NEW.evaluationPlanId=marksheet.evaluationPlanId
and NEW.evalPlanLevelTwoId is not null and NEW.evalPlanLevelTwoId=marksheet.evaluationPlanLevelTwoId 
    and marksheet.evaluationPlanThreeId is null
limit 1) = 0 && NEW.evalPlanLevelTwoId is not null then
-- insert into templog_remark values('SubType level row created');
	INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `remark`, `levelOnePrintName`, `levelTwoPrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
	select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, subType_plan.id, subType_plan.evaluationPlanNumber,subType_type.id,subType_type.levelName,subType.id,subType.levelName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark, subType_type.printNameInMarksheet,subType.printNameInMarksheet,subType_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
elseif NEW.evalPlanLevelTwoId is not null then
-- insert into templog_remark values('SubType level row updated');
UPDATE marksheet set remark=NEW.remark where
		evaluationPlanLevelTwoId=NEW.evalPlanLevelTwoId and ((NEW.courseVariantId is null and marksheet.courseVariantId is null)
	or NEW.courseVariantId = marksheet.courseVariantId ) and sectionId=NEW.sectionId and periodId=NEW.periodId and admissionId=NEW.admissionId and evaluationPlanThreeId IS NULL;
end if;

if(
select count(marksheet.id) 
from marksheet 
join evaluation_plan_level_two subType on NEW.evalPlanLevelTwoId=subType.id
where marksheet.admissionId=NEW.admissionId 
and (
	(NEW.courseVariantId is null and marksheet.courseVariantId is null)
	or NEW.courseVariantId = marksheet.courseVariantId 
    )
and NEW.sectionId=marksheet.sectionId and NEW.periodId=marksheet.periodId and NEW.evaluationPlanId=marksheet.evaluationPlanId
and NEW.evalPlanLevelTwoId is not null and subType.evalPlanLevelOneId=marksheet.evaluationPlanLevelOneId 
    and marksheet.evaluationPlanLevelTwoId is null
limit 1) = 0 && NEW.evalPlanLevelTwoId is not null then
-- insert into templog_remark values('SubType type level row created');
	INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `levelOnePrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
    select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, subType_plan.id, subType_plan.evaluationPlanNumber,subType_type.id,subType_type.levelName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, subType_type.printNameInMarksheet,subType_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
end if;
if(
select count(marksheet.id) 
from marksheet
where marksheet.admissionId=NEW.admissionId 
and (
	(NEW.courseVariantId is null and marksheet.courseVariantId is null)
	or NEW.courseVariantId = marksheet.courseVariantId 
    )
and NEW.sectionId=marksheet.sectionId and NEW.periodId=marksheet.periodId and NEW.evaluationPlanId=marksheet.evaluationPlanId
and NEW.evalPlanLevelTwoId is not null and marksheet.evaluationPlanLevelOneId is null
limit 1) = 0 && NEW.evalPlanLevelTwoId is not null
then
-- insert into templog_remark values('SubType Plan level row created');
	INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `planPrintName`, `parentCourseId`, `parentCourseName`)
    select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, subType_plan.id, subType_plan.evaluationPlanNumber, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id,subType_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
end if;
if(
select count(marksheet.id) 
from marksheet 
where marksheet.admissionId=NEW.admissionId 
and (
	(NEW.courseVariantId is null and marksheet.courseVariantId is null)
	or NEW.courseVariantId = marksheet.courseVariantId 
    )
and NEW.sectionId=marksheet.sectionId and NEW.periodId=marksheet.periodId and NEW.evaluationPlanId=marksheet.evaluationPlanId
and NEW.evalSequenceId is not null and NEW.evalSequenceId=marksheet.evaluationPlanThreeId limit 1) = 0 && NEW.evalSequenceId is not null then
-- insert into templog_remark values('Method level row created');
	INSERT INTO `marksheet`
(`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `evaluationPlanThreeId`, `evaluationLevelThree`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `remark`, `levelOnePrintName`, `levelTwoPrintName`, `levelThreePrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
	select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, method_plan.id, method_plan.evaluationPlanNumber,method_type.id,method_type.levelName,method_subType.id,method_subType.levelName,method.id, sequence_header.sequenceName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark, method_type.printNameInMarksheet,method_subType.printNameInMarksheet,method.printNameInMarksheet, method_plan.printNameInMarksheet,parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join sequence_header on method.evalSequenceId=sequence_header.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
elseif NEW.evalSequenceId is not null then
-- insert into templog_remark values('Method level row updated');
UPDATE marksheet set remark=NEW.remark where
		evaluationPlanThreeId=NEW.evalSequenceId and ((NEW.courseVariantId is null and marksheet.courseVariantId is null)
	or NEW.courseVariantId = marksheet.courseVariantId) and sectionId=NEW.sectionId
		and periodId=NEW.periodId and admissionId=NEW.admissionId and evaluationPlanLevelFourId IS NULL;
end if;
if(
select count(marksheet.id) 
from marksheet 
join evaluation_sequence method on NEW.evalSequenceId=method.id
where marksheet.admissionId=NEW.admissionId 
and (
	(NEW.courseVariantId is null and marksheet.courseVariantId is null)
	or NEW.courseVariantId = marksheet.courseVariantId 
    )
and NEW.sectionId=marksheet.sectionId and NEW.periodId=marksheet.periodId and NEW.evaluationPlanId=marksheet.evaluationPlanId
and NEW.evalSequenceId is not null and method.evalPlanLevelTwoId=marksheet.evaluationPlanLevelTwoId 
    and marksheet.evaluationPlanThreeId is null
limit 1) = 0 && NEW.evalSequenceId is not null then
-- insert into templog_remark values('Method subType level row created');
	INSERT INTO `marksheet`
(`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `levelOnePrintName`, `levelTwoPrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
    select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, method_plan.id, method_plan.evaluationPlanNumber,method_type.id,method_type.levelName,method_subType.id,method_subType.levelName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, method_type.printNameInMarksheet,method_subType.printNameInMarksheet, method_plan.printNameInMarksheet,parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
end if;
if(
select count(marksheet.id) 
from marksheet 
join evaluation_sequence method on NEW.evalSequenceId=method.id
join evaluation_plan_level_two subType on method.evalPlanLevelTwoId=subType.id
where marksheet.admissionId=NEW.admissionId 
and (
	(NEW.courseVariantId is null and marksheet.courseVariantId is null)
	or NEW.courseVariantId = marksheet.courseVariantId 
    )
and NEW.sectionId=marksheet.sectionId and NEW.periodId=marksheet.periodId and NEW.evaluationPlanId=marksheet.evaluationPlanId
and NEW.evalSequenceId is not null and subType.evalPlanLevelOneId=marksheet.evaluationPlanLevelOneId 
    and marksheet.evaluationPlanLevelTwoId is null
limit 1) = 0 && NEW.evalSequenceId is not null then
-- insert into templog_remark values('Method type level row created');
	INSERT INTO `marksheet`
(`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`,`whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `levelOnePrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
    select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, method_plan.id, method_plan.evaluationPlanNumber,method_type.id,method_type.levelName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, method_type.printNameInMarksheet, method_plan.printNameInMarksheet,parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
end if;
if(
select count(marksheet.id) 
from marksheet 
where marksheet.admissionId=NEW.admissionId 
and (
	(NEW.courseVariantId is null and marksheet.courseVariantId is null)
	or NEW.courseVariantId = marksheet.courseVariantId 
    )
and NEW.sectionId=marksheet.sectionId and NEW.periodId=marksheet.periodId and NEW.evaluationPlanId=marksheet.evaluationPlanId
and NEW.evalSequenceId is not null and marksheet.evaluationPlanLevelOneId is null
limit 1) = 0 && NEW.evalSequenceId is not null then
-- insert into templog_remark values('Method plan level row created');
	INSERT INTO `marksheet`
(`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`,`whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `planPrintName`, `parentCourseId`, `parentCourseName`)
    select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, method_plan.id, method_plan.evaluationPlanNumber, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, method_plan.printNameInMarksheet,parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
	end if;
set sql_safe_updates=1;
END //
DELIMITER ;


DELIMITER $$

DROP TRIGGER IF EXISTS evaluation_student_remark_marksheet_trigger$$
CREATE TRIGGER evaluation_student_remark_marksheet_trigger 
 AFTER UPDATE ON evaluation_student_remark 
 FOR EACH ROW 
BEGIN
IF NEW.remark <=> OLD.remark || NEW.remark <> OLD.remark || NEW.remark IS NULL || (OLD.remark IS NULL && NEW.remark IS NOT NULL) THEN
	set sql_safe_updates=0;

		-- Type Level Subject Remark
		IF(OLD.courseVariantId IS NOT NULL && OLD.evalPlanLevelOneId IS NOT NULL) then
			if(
			select count(marksheet.id) 
			from marksheet 
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId = marksheet.courseVariantId 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
			and NEW.evalPlanLevelOneId=marksheet.evaluationPlanLevelOneId 
				and marksheet.evaluationPlanLevelTwoId is null
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `remark`, `levelOnePrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
	select admission.id, admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, type_plan.id, type_plan.evaluationPlanNumber,type.id,type.levelName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark,type.printNameInMarksheet,type_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_one type on remark.evalPlanLevelOneId=type.id
	left join evaluation_plan type_plan on type.evaluationPlanId=type_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
    if(
			select count(marksheet.id) 
			from marksheet 
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId = marksheet.courseVariantId 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
				and marksheet.evaluationPlanLevelOneId is null
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `remark`, `levelOnePrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
    select admission.id, admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, type_plan.id, type_plan.evaluationPlanNumber,null,null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark,null,type_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_one type on remark.evalPlanLevelOneId=type.id
	left join evaluation_plan type_plan on type.evaluationPlanId=type_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    ;
    end if;
    else
		UPDATE marksheet set remark=NEW.remark where courseVariantId=OLD.courseVariantId
		and evaluationPlanLevelOneId=OLD.evalPlanLevelOneId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanLevelTwoId IS NULL;
	end if;
		-- Type Level Remark
		ELSEIF (OLD.courseVariantId IS NULL && OLD.evalPlanLevelOneId IS NOT NULL) THEN
			if(
			select count(marksheet.id) 
			from marksheet 
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId is null and marksheet.courseVariantId is null
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
			and NEW.evalPlanLevelOneId=marksheet.evaluationPlanLevelOneId 
				and marksheet.evaluationPlanLevelTwoId is null
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `remark`, `levelOnePrintName`, `planPrintName`)
	select admission.id, admission.code, users.id, users.printName, type_plan.id, type_plan.evaluationPlanNumber,type.id,type.levelName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, remark.remark,type.printNameInMarksheet,type_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_plan_level_one type on remark.evalPlanLevelOneId=type.id
	left join evaluation_plan type_plan on type.evaluationPlanId=type_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
    if(
			select count(marksheet.id) 
			from marksheet 
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId is null and marksheet.courseVariantId is null
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
				and marksheet.evaluationPlanLevelOneId is null
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `remark`, `levelOnePrintName`, `planPrintName`)
    select admission.id, admission.code, users.id, users.printName, type_plan.id, type_plan.evaluationPlanNumber,null,null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, remark.remark,null,type_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_plan_level_one type on remark.evalPlanLevelOneId=type.id
	left join evaluation_plan type_plan on type.evaluationPlanId=type_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    ;
    end if;
    else

		UPDATE marksheet set remark=NEW.remark where courseVariantId is null
		and evaluationPlanLevelOneId=OLD.evalPlanLevelOneId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanLevelTwoId IS NULL;
	end if;
		
		-- Sub Type Level Subject Remark
		ELSEIF (OLD.courseVariantId IS NOT NULL && OLD.evalPlanLevelTwoId IS NOT NULL) THEN
		if(
			select count(marksheet.id) 
			from marksheet 
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId = marksheet.courseVariantId 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
			and marksheet.evaluationPlanLevelTwoId = NEW.evalPlanLevelTwoId
            and marksheet.evaluationPlanThreeId IS NULL
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `remark`, `levelOnePrintName`, `levelTwoPrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
	select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, subType_plan.id, subType_plan.evaluationPlanNumber,subType_type.id,subType_type.levelName,subType.id,subType.levelName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark, subType_type.printNameInMarksheet,subType.printNameInMarksheet,subType_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
    if(
			select count(marksheet.id) 
			from marksheet 
            join evaluation_plan_level_two subType on evaluation_plan_level_two.id = NEW.evalPlanLevelTwoId
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId = marksheet.courseVariantId 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId and
			subType.evalPlanLevelOneId=marksheet.evaluationPlanLevelOneId
            and marksheet.evalPlanLevelTwoId IS NULL
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `remark`, `levelOnePrintName`, `levelTwoPrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
    select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, subType_plan.id, subType_plan.evaluationPlanNumber,subType_type.id,subType_type.levelName,null,null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark, subType_type.printNameInMarksheet,null,subType_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id;
    end if;
     if(
			select count(marksheet.id) 
			from marksheet
			where marksheet.admissionId=NEW.admissionId 
			and NEW.courseVariantId = marksheet.courseVariantId 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
            and marksheet.evaluationPlanLevelOneId IS NULL
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `remark`, `levelOnePrintName`, `levelTwoPrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
    select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, subType_plan.id, subType_plan.evaluationPlanNumber,null,null,null,null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark, null,null,subType_plan.printNameInMarksheet, parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    ;
    end if;
     else       
		UPDATE marksheet set remark=NEW.remark where
		evaluationPlanLevelTwoId=OLD.evalPlanLevelTwoId and courseVariantId=OLD.courseVariantId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanThreeId IS NULL;
end if;
		
		-- Sub Type Level Remark
		ELSEIF (OLD.courseVariantId IS NULL && OLD.evalPlanLevelTwoId IS NOT NULL) THEN
		
		if(
			select count(marksheet.id) 
			from marksheet 
			where marksheet.admissionId=NEW.admissionId 
			and marksheet.courseVariantId is null 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
			and marksheet.evaluationPlanLevelTwoId = NEW.evalPlanLevelTwoId
            and marksheet.evaluationPlanThreeId IS NULL
			limit 1) = 0
			then 
            INSERT INTO `marksheet` (`admissionId`, `admissionCode`, `studentId`, `stdName`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `remark`, `levelOnePrintName`, `levelTwoPrintName`, `planPrintName`)
	select admission.id,admission.code, users.id, users.printName, subType_plan.id, subType_plan.evaluationPlanNumber,subType_type.id,subType_type.levelName,subType.id,subType.levelName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, remark.remark, subType_type.printNameInMarksheet,subType.printNameInMarksheet,subType_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    union
    select admission.id,admission.code, users.id, users.printName, subType_plan.id, subType_plan.evaluationPlanNumber,subType_type.id,subType_type.levelName,null,null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, remark.remark, subType_type.printNameInMarksheet,null,subType_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    union
    select admission.id,admission.code, users.id, users.printName, subType_plan.id, subType_plan.evaluationPlanNumber,null,null,null,null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, remark.remark, null,null,subType_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_plan_level_two subType on remark.evalPlanLevelTwoId=subType.id
	left join evaluation_plan_level_one subType_type on subType.evalPlanLevelOneId=subType_type.id
	left join evaluation_plan subType_plan on subType_type.evaluationPlanId=subType_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    ;
     else  
		UPDATE marksheet set remark=NEW.remark where courseVariantId is null
		and evaluationPlanLevelTwoId=OLD.evalPlanLevelTwoId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanThreeId IS NULL;
end if;
		-- Method Level Subject Remark
		ELSEIF (OLD.courseVariantId IS NOT NULL && OLD.evalSequenceId IS NOT NULL) THEN
		
		if(
			select count(marksheet.id) 
			from marksheet 
			where marksheet.admissionId=NEW.admissionId 
			and marksheet.courseVariantId = NEW.courseVariantId
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
            and marksheet.evaluationPlanThreeId = NEW.evalSequenceId
			limit 1) = 0
			then 
            INSERT INTO `marksheet`
(`admissionId`, `admissionCode`, `studentId`, `stdName`, `courseName`, `courseCode`, `courseVariantId`, `courseVariant`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `evaluationPlanThreeId`, `evaluationLevelThree`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `courseId`, `remark`, `levelOnePrintName`, `levelTwoPrintName`, `levelThreePrintName`, `planPrintName`, `parentCourseId`, `parentCourseName`)
	select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, method_plan.id, method_plan.evaluationPlanNumber,method_type.id,method_type.levelName,method_subType.id,method_subType.levelName,method.id, sequence_header.sequenceName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark, method_type.printNameInMarksheet,method_subType.printNameInMarksheet,method.printNameInMarksheet, method_plan.printNameInMarksheet,parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join sequence_header on method.evalSequenceId=sequence_header.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    union
    select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, method_plan.id, method_plan.evaluationPlanNumber,method_type.id,method_type.levelName,method_subType.id,method_subType.levelName,null, null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark, method_type.printNameInMarksheet,method_subType.printNameInMarksheet,null, method_plan.printNameInMarksheet,parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join sequence_header on method.evalSequenceId=sequence_header.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    union
    select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, method_plan.id, method_plan.evaluationPlanNumber,method_type.id,method_type.levelName,null,null,null, null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark, method_type.printNameInMarksheet,null,null, method_plan.printNameInMarksheet,parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join sequence_header on method.evalSequenceId=sequence_header.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    union
    select admission.id,admission.code, users.id, users.printName, course.nameToBePrinted, course.courseCode, cv.id, cv.courseVariantCode, method_plan.id, method_plan.evaluationPlanNumber,null,null,null,null,null, null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, course.id, remark.remark, null,null,null, method_plan.printNameInMarksheet,parentCourse.id, parentCourse.nameToBePrinted
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join sequence_header on method.evalSequenceId=sequence_header.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	left join course_variants cv on remark.courseVariantId=cv.id
	left join courses course on cv.courseId=course.id
	left join courses parentCourse on course.parentCourseId=parentCourse.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    ;
     else       
		UPDATE marksheet set remark=NEW.remark where
		evaluationPlanThreeId=OLD.evalSequenceId and courseVariantId=OLD.courseVariantId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanLevelFourId IS NULL;
end if;
		
		-- Method Level Remark
		ELSEIF (OLD.courseVariantId IS NULL && OLD.evalSequenceId IS NOT NULL) THEN
		
		
		if(
			select count(marksheet.id) 
			from marksheet 
			where marksheet.admissionId=NEW.admissionId 
			and marksheet.courseVariantId is null 
			and NEW.sectionId=marksheet.sectionId and 
			NEW.periodId=marksheet.periodId and 
			NEW.evaluationPlanId=marksheet.evaluationPlanId
            and marksheet.evaluationPlanThreeId = NEW.evalSequenceId
			limit 1) = 0
			then 
            INSERT INTO `marksheet`
(`admissionId`, `admissionCode`, `studentId`, `stdName`, `evaluationPlanId`, `evaluationPlan`, `evaluationPlanLevelOneId`, `evaluationLevelOne`, `evaluationPlanLevelTwoId`, `evaluationLevelTwo`, `evaluationPlanThreeId`, `evaluationLevelThree`, `whetherShowInMarksheet`, `lastUpdatedBy`, `programId`, `programName`, `batchId`, `batchName`, `periodId`, `periodName`, `sectionId`, `sectionName`, `remark`, `levelOnePrintName`, `levelTwoPrintName`, `levelThreePrintName`, `planPrintName`)
	select admission.id,admission.code, users.id, users.printName, method_plan.id, method_plan.evaluationPlanNumber,method_type.id,method_type.levelName,method_subType.id,method_subType.levelName,method.id, sequence_header.sequenceName, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, remark.remark, method_type.printNameInMarksheet,method_subType.printNameInMarksheet,method.printNameInMarksheet, method_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join sequence_header on method.evalSequenceId=sequence_header.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    union
    select admission.id,admission.code, users.id, users.printName, method_plan.id, method_plan.evaluationPlanNumber,method_type.id,method_type.levelName,method_subType.id,method_subType.levelName,null, null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, remark.remark, method_type.printNameInMarksheet,method_subType.printNameInMarksheet,null, method_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join sequence_header on method.evalSequenceId=sequence_header.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    union
    select admission.id,admission.code, users.id, users.printName, method_plan.id, method_plan.evaluationPlanNumber,method_type.id,method_type.levelName,null,null,null, null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, remark.remark, method_type.printNameInMarksheet,null,null, method_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join sequence_header on method.evalSequenceId=sequence_header.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    union
    select admission.id,admission.code, users.id, users.printName, method_plan.id, method_plan.evaluationPlanNumber,null,null,null,null,null, null, true, 1, program.id, program.programNameToBePrint, batch.id, batch.printName, period.id, period.printName, section.id, section.alternateName, remark.remark, null,null,null, method_plan.printNameInMarksheet
	from evaluation_student_remark remark
	left join evaluation_sequence method on remark.evalSequenceId=method.id
	left join sequence_header on method.evalSequenceId=sequence_header.id
	left join evaluation_plan_level_two method_subType on method.evalPlanLevelTwoId=method_subType.id
	left join evaluation_plan_level_one method_type on method_subType.evalPlanLevelOneId=method_type.id
	left join evaluation_plan method_plan on method_type.evaluationPlanId=method_plan.id
	join admission on remark.admissionId=admission.id
	join users on admission.studentId=users.id
	join prog_batch_period_config period on remark.periodId=period.id
	join batches batch on period.programBatchId=batch.id
	join programs program on batch.programId=program.id
	join sections section on remark.sectionId=section.id
    where remark.id=NEW.id
    ;
     else       
		UPDATE marksheet set remark=NEW.remark where courseVariantId is null
		and evaluationPlanThreeId=OLD.evalSequenceId
		and sectionId=OLD.sectionId
		and periodId=OLD.periodId and admissionId=OLD.admissionId and evaluationPlanLevelFourId IS NULL;
	end if;	
		END IF;

	set sql_safe_updates=1;
END IF;
END$$
DELIMITER ;