DELIMITER ;
CREATE TABLE `enquiry_contact_history` (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  `enquiryId` bigint(20) NOT NULL,
  `primaryeEmailId` varchar(100) DEFAULT NULL,
  `phoneNo` varchar(15) DEFAULT NULL,
  `phoneCountryCode` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `fk_enquiry_contact_history_personId_idx` (`enquiryId`),
  CONSTRAINT `fk_enquiry_contact_history_personId` FOREIGN KEY (`enquiryId`) REFERENCES `enquiry` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DELIMITER //
CREATE DEFINER=`root`@`localhost` TRIGGER enquiry_contact_history_after_insert_trigger 
   After INSERT ON enquiry 
   FOR EACH ROW 
BEGIN
     INSERT INTO enquiry_contact_history(enquiryId,primaryeEmailId,phoneNo,phoneCountryCode)
     VALUES(NEW.id,NEW.primaryeEmailId,NEW.phoneNo,NEW.phoneCountryCode);
END;//
DELIMITER ;
DELIMITER //
CREATE DEFINER=`root`@`localhost` TRIGGER enquiry_contact_history_after_update_trigger 
   After UPDATE ON enquiry 
   FOR EACH ROW 
BEGIN
	IF NEW.id = OLD.id and (NEW.primaryeEmailId<> OLD.primaryeEmailId or NEW.phoneNo <> OLD.phoneNo or NEW.phoneCountryCode <> OLD.phoneCountryCode)
	THEN
     INSERT INTO enquiry_contact_history(enquiryId,primaryeEmailId,phoneNo,phoneCountryCode)
     VALUES(NEW.id,NEW.primaryeEmailId,NEW.phoneNo,NEW.phoneCountryCode);
     END IF;
END;//
DELIMITER ;