DROP view IF EXISTS `manage_target_view`;

CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `root`@`localhost` 
    SQL SECURITY DEFINER
VIEW `manage_target_view` AS
    SELECT 
        `academyloc5_`.`id` AS `ACADEMY_LOCATION_ID`,
        `this_`.`enrolmentTarget` AS `enrollmentTarget`,
        `this_`.`enrolmentPreviousYear` AS `enrollmentPreYear`,
        `program1_`.`programName` AS `programName`,
        `this_`.`enquiryTarget` AS `enquiryTarget`,
        `this_`.`applicationTarget` AS `applicationTarget`,
        `programgro4_`.`groupName` AS `programGroupName`,
        `intakeyear3_`.`id` AS `intakeYearId`,
        `this_`.`buildingCapacitySpecialist` AS `buildingCapacitySpecialist`,
        `batch2_`.`id` AS `batchId`,
        `batch2_`.`batchName` AS `batchName`,
        `programgro4_`.`id` AS `programGroupId`,
        `this_`.`revisedBudget` AS `revisedBudget`,
        `managingdi7_`.`printName` AS `managingDirectorName`,
        `managingdi7_`.`id` AS `managingDirectorId`,
        `academyloc5_`.`displayName` AS `academyLocationDisplayName`,
        `program1_`.`id` AS `PROGRAM_ID`,
        `academy6_`.`academyName` AS `academyName`,
        `intakeyear3_`.`itemCode` AS `intakeYear`,
        `this_`.`enrolmentBudget` AS `enrolmentBudget`,
        `this_`.`buildingCapacity` AS `buildingCapacity`
    FROM
        ((((((((((`manage_target` `this_`
        LEFT JOIN `academy_location` `academyloc5_` ON ((`this_`.`academyLocationId` = `academyloc5_`.`id`)))
        LEFT JOIN `academies` `academy6_` ON ((`academyloc5_`.`academyId` = `academy6_`.`id`)))
        LEFT JOIN `batches` `batch2_` ON ((`this_`.`batchId` = `batch2_`.`id`)))
        LEFT JOIN `intake_year` `intakeyear3_` ON ((`batch2_`.`intakeYearId` = `intakeyear3_`.`id`)))
        LEFT JOIN `users` `managingdi7_` ON ((`this_`.`managingDirectorId` = `managingdi7_`.`id`)))
        LEFT JOIN `parents` `managingdi7_1_` ON ((`managingdi7_`.`id` = `managingdi7_1_`.`userId`)))
        LEFT JOIN `staffs` `managingdi7_2_` ON ((`managingdi7_`.`id` = `managingdi7_2_`.`userId`)))
        LEFT JOIN `students` `managingdi7_3_` ON ((`managingdi7_`.`id` = `managingdi7_3_`.`userId`)))
        LEFT JOIN `programs` `program1_` ON ((`this_`.`programId` = `program1_`.`id`)))
        LEFT JOIN `program_group` `programgro4_` ON ((`this_`.`programGroupId` = `programgro4_`.`id`)))