-- For degree_classification
CREATE TABLE `degree_classification` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `programMarkingType` VARCHAR(45) NOT NULL,
  `classificationName` VARCHAR(255) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `degree_classification_lastUpdatedBy` (`lastUpdatedBy`),
  UNIQUE INDEX `classificationName_UNIQUE` (`classificationName` ASC),
  CONSTRAINT `degree_classification_lastUpdatedBy` 
  	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`));

-- For degree_classification_remark
CREATE TABLE `degree_classification_remark` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `degreeClassificationId` BIGINT(20) NOT NULL,
  `CGPAOrPercentageRangeFrom` DOUBLE NOT NULL,
  `CGPAOrPercentageRangeTo` DOUBLE NOT NULL,
  `remarks` VARCHAR(255) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `degree_classification_remark_lastUpdatedBy` (`lastUpdatedBy`),
  INDEX `fk_degree_classification_remark_1_idx` (`degreeClassificationId` ASC),
  CONSTRAINT `fk_degree_classification_remark_1`
    FOREIGN KEY (`degreeClassificationId`)
    REFERENCES `degree_classification` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `degree_classification_remark_lastUpdatedBy` 
  	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`));

-- For degree_classification_batch_mapping
CREATE TABLE `degree_classification_batch_mapping` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `degreeClassificationId` BIGINT(20) NOT NULL,
  `batchId` BIGINT(20) NOT NULL,
  `academyLocationId` BIGINT(20) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `degree_classification_batch_mapping_lastUpdatedBy` (`lastUpdatedBy`),
  UNIQUE INDEX `degree_classification_batch_mapping_batchId_UNIQUE` (`batchId` ASC),
  INDEX `fk_degree_classification_batch_mapping_1_idx` (`batchId` ASC),
  INDEX `fk_degree_classification_batch_mapping_2_idx` (`degreeClassificationId` ASC),
  INDEX `fk_degree_classification_batch_mapping_3_idx` (`academyLocationId` ASC),
  CONSTRAINT `fk_degree_classification_batch_mapping_1`
    FOREIGN KEY (`batchId`)
    REFERENCES `batches` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_degree_classification_batch_mapping_2`
    FOREIGN KEY (`degreeClassificationId`)
    REFERENCES `degree_classification` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_degree_classification_batch_mapping_3`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `degree_classification_batch_mapping_lastUpdatedBy` 
  	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`));
