set sql_safe_updates=0;

SET @enqDtProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ENQUIRY_FOLLOWUP_REMINDER_RECIPIENTS');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
		T1.id AS ID,
		T2.code AS ENQUIRY_NO,
		T5.emailId AS EMAIL_ID,
		T5.firstName AS FIRST_NAME,
		T5.lastName AS LAST_NAME,
		T5.mobileCountryCode AS MOBILE_CODE,
		T5.mobileNumber AS MOBILE_NO,
		(Case when T6.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
		when T6.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
		else CONCAT(org.orgUrl, '/', T6.logoUrl)end) as LOGO_URL
	FROM
		enq_followup T1
			LEFT OUTER JOIN
		enquiry T2 ON T2.id = T1.enquiryId
			LEFT OUTER JOIN
		users T3 ON T3.id = T1.assignTo
			LEFT OUTER JOIN
		staffs T4 ON T4.userId = T3.id
			LEFT OUTER JOIN
		persons T5 ON T5.id = T4.personId
			LEFT OUTER JOIN
		academy_location T6 on T6.id=T2.academyLocationId
				LEFT JOIN
		organizations org on org.id = (select max(id) from organizations)
	WHERE
		T1.id IN (namedParams)",`jsonString`='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "code",
            "resultKey": "ENQUIRY_NO",
            "displayCode": "",
            "displayOrder": 1
        },
		 {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
		 {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 4
        }
    ]
}' WHERE `dataProviderId`=@enqDtProviderId;
		
SET @msgTemplateConfigId=(select id from msg_template_config where sysMsgEventId =(select id from system_msg_event where code='Enquiry Followup Reminder'));

UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Dear $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Follow-up to Enquiry No.&nbsp;$recipientData[&quot;ENQUIRY_NO&quot;] is due today.</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"/></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE msgTemplateConfigId=@msgTemplateConfigId and msgDeliveryModeId in (1,4);

set sql_safe_updates=1;
