DELIMITER $$

DROP PROCEDURE IF EXISTS add_report_template $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE add_report_template()

BEGIN
  
	-- Insert new record in report_template table, if it doesn't already exist
	IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'VELOCITY_IB_GRADE_1_3_REPORT_CARDS_2020' )) THEN
    
	-- Insert Query 
    INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
	VALUES ( '2', 'VELOCITY_IB_GRADE_1_3_REPORT_CARDS_2020', 'IB-Grade 1-3-Report Cards-2020', 'VELOCITY_IB_GRADE_1_3_REPORT_CARDS_2020.png', 'CommonReport_Velocity_I_III_MARKSHEET.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VELOCITY_IB_GRADE_1_3_REPORT_CARDS_2020.jasper', 'AcademiaLogo.png');

  END IF;

	-- Insert new record in report_template table, if it doesn't already exist
	IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'VELOCITY_IB_GRADE_4_REPORT_CARD_2020' )) THEN
    
	-- Insert Query 
    INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
	VALUES ( '2', 'VELOCITY_IB_GRADE_4_REPORT_CARD_2020', 'IB-Grade 4-Report Card-2020', 'VELOCITY_IB_GRADE_4_REPORT_CARD_2020.png', 'CommonReport_Velocity_I_III_MARKSHEET.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VELOCITY_IB_GRADE_4_REPORT_CARD_2020.jasper', 'AcademiaLogo.png');

  END IF;
	  
	-- Insert new record in report_template table, if it doesn't already exist
	IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'VELOCITY_IB_UNIT_OF_INQUIRY_REPORT_TEMPLATE' )) THEN
    
	-- Insert Query 
    INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
	VALUES ( '2', 'VELOCITY_IB_UNIT_OF_INQUIRY_REPORT_TEMPLATE', 'IB-Unit of Inquiry Report Template', 'VELOCITY_IB_UNIT_OF_INQUIRY_REPORT_TEMPLATE.png', 'CommonReport_Velocity_I_III_MARKSHEET.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VELOCITY_IB_UNIT_OF_INQUIRY_REPORT_TEMPLATE.jasper', 'AcademiaLogo.png');

  END IF;
  
	-- Insert new record in report_template table, if it doesn't already exist
	IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'VELOCITY_IB_GRADE_5_7_REPORT_CARD_2020' )) THEN
    
	-- Insert Query 
    INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
	VALUES ( '2', 'VELOCITY_IB_GRADE_5_7_REPORT_CARD_2020', 'IB-Grade 5-7-Report Card-2020', 'VELOCITY_IB_GRADE_5_7_REPORT_CARD_2020.png', 'CommonReport_Velocity_I_III_MARKSHEET.jasper', 'EVALUATION_TYPE', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'VELOCITY_IB_GRADE_5_7_REPORT_CARD_2020.jasper', 'AcademiaLogo.png');

  END IF;

END $$

-- Execute the stored procedure
CALL add_report_template() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS add_report_template $$
 
DELIMITER ;