DELIMITER $$

DROP PROCEDURE IF EXISTS V202001022036__AlterColumnPlacmentCampus $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001022036__AlterColumnPlacmentCampus()

BEGIN
 
 -- Add the email_address column to the email table, if it doesn't already exist
 IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='placement_campus'
 AND column_name ='whetherAllowed')) THEN
 
  ALTER TABLE `placement_campus`
   ADD COLUMN `whetherAllowed` BIT(1) NULL DEFAULT b'1' AFTER `whetherDocumentRequired`;

 END IF;

END $$

-- Execute the stored procedure
CALL V202001022036__AlterColumnPlacmentCampus() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001022036__AlterColumnPlacmentCampus $$

DELIMITER ;