DELIMITER $$

DROP PROCEDURE IF EXISTS form_field_info_eligibilityCriteria $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE form_field_info_eligibilityCriteria()

BEGIN
  
   -- Insert new record in email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM form_field_info WHERE formAliasName='programbatchesform' and formFieldName='eligibilityCriteria')) THEN
    
	INSERT INTO `form_field_info` 
	(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, 
	`formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
	VALUES ('programbatchesform', 'eligibilityCriteria', 'eligibilityCriteria', 'textarea', 0, 0, 1, now(), 'Eligibility Criteria', 'Batch', 'Create and View', 'Eligibility Criteria', 0);


  END IF;

END $$

-- Execute the stored procedure
CALL form_field_info_eligibilityCriteria() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS form_field_info_eligibilityCriteria $$
 
DELIMITER ;