DELIMITER $$

DROP PROCEDURE IF EXISTS UpdateMsgtempForEventAssignEvent $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE UpdateMsgtempForEventAssignEvent()

BEGIN
  set sql_safe_updates=0;
  -- Add the email_address column to the email table, if it doesn't already exist
  IF EXISTS ((SELECT id FROM msg_template_config WHERE `code`='Event Assign Template')) THEN

SET @msgTemplateConfig=((SELECT id FROM msg_template_config WHERE `code`='Event Assign Template'));

UPDATE `msg_template` SET `subjectLine` = 'You have been invited in Event!', `msgContent`='Dear $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;], $templateData["ORGANIZERNAME"] has created a new event near you: $templateData["eventName"] You can check the details in My events section. Thank You!' WHERE `msgTemplateConfigId`=@msgTemplateConfig and msgDeliveryModeId = 6;

END IF;
set sql_safe_updates=1;

END $$

-- Execute the stored procedure
CALL UpdateMsgtempForEventAssignEvent() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS UpdateMsgtempForEventAssignEvent $$
 
DELIMITER ;