DELIMITER $$

DROP PROCEDURE IF EXISTS STUDENT_FEE_PAYER_DETAILS $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE STUDENT_FEE_PAYER_DETAILS()

BEGIN
  
  -- Insert new record in email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'STUDENT_FEE_PAYER_DETAILS' and  objectName ='PERSON')) THEN
    
	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PERSON','STUDENT_FEE_PAYER_DETAILS','Student Fee Payer Details','Student Fee Payer Details',now(),1);

  END IF;

END $$

-- Execute the stored procedure
CALL STUDENT_FEE_PAYER_DETAILS() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS STUDENT_FEE_PAYER_DETAILS $$
 
DELIMITER ;