DELIMITER $$

DROP PROCEDURE IF EXISTS V202001111543__CurrencyExchangeRateAssociationUITranslation $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001111543__CurrencyExchangeRateAssociationUITranslation()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='UPDATE_EXCHANGE_CURRENCY_MASTER_MSG')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','UPDATE_EXCHANGE_CURRENCY_MASTER_MSG','Currency Exchange Rate updated successfully','Currency Exchange Rate updated successfully',now(),1);
  END IF;
  
    IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='ADD_EXCHANGE_CURRENCY_MASTER_MSG')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','ADD_EXCHANGE_CURRENCY_MASTER_MSG','Currency Exchange Rate added successfully','Currency Exchange Rate added successfully',now(),1);
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='UPDATE_CURRENCY_ASSOCIATION_MASTER_MSG')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','UPDATE_CURRENCY_ASSOCIATION_MASTER_MSG','Currency Association updated successfully','Currency Association updated successfully',now(),1);
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='TRANSLATIONS' and keyName='ADD_CURRENCY_ASSOCIATION_MASTER_MSG')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','ADD_CURRENCY_ASSOCIATION_MASTER_MSG','Currency Association added successfully','Currency Association added successfully',now(),1);
  END IF;

END $$

-- Execute the stored procedure
CALL V202001111543__CurrencyExchangeRateAssociationUITranslation() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001111543__CurrencyExchangeRateAssociationUITranslation $$
 
DELIMITER ;