DELIMITER $$

DROP PROCEDURE IF EXISTS V202001151612__CreateCurrencyExchangeHistoryTable $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001151612__CreateCurrencyExchangeHistoryTable()

BEGIN
  
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='currency_exchange_history' )) THEN
    
CREATE TABLE `currency_exchange_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `fromCurrencyId` bigint(20) NOT NULL,
  `toCurrencyId` bigint(20) NOT NULL,
  `exchangeRate` double(20,2) NOT NULL,
  `applicableFrom` date NOT NULL,
  `applicableTill` date NOT NULL,
  `currencyExchangeId` bigint(20) NOT NULL,
  `changedTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_currency_exchange_history_fromCurrencyToCurrency_idx` (`fromCurrencyId`),
  KEY `fk_currency_exchange_history_toCurrecytoCurrencyt_idx` (`toCurrencyId`),
  KEY `fk_currency_exchange_history_lastUpdateToUsers_idx` (`lastUpdatedBy`),
  KEY `fk_currency_exchange_history_currencyExIdtoCurrencyExchange_idx` (`currencyExchangeId`),
  CONSTRAINT `fk_currency_exchange_history_currencyExIdtoCurrencyExchange` FOREIGN KEY (`currencyExchangeId`) REFERENCES `currency_exchange` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_currency_exchange_history_fromCurrencyToCurrency` FOREIGN KEY (`fromCurrencyId`) REFERENCES `currency` (`id`),
  CONSTRAINT `fk_currency_exchange_history_lastUpdateToUsers` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_currency_exchange_history_toCurrecytoCurrencyt` FOREIGN KEY (`toCurrencyId`) REFERENCES `currency` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
  END IF;

END $$

-- Execute the stored procedure
CALL V202001151612__CreateCurrencyExchangeHistoryTable() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001151612__CreateCurrencyExchangeHistoryTable $$
 
DELIMITER ;