DELIMITER $$

DROP PROCEDURE IF EXISTS V202001151613__CreateCurrencySettlementTable $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001151613__CreateCurrencySettlementTable()

BEGIN
  

  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='currency_settlement' )) THEN
    
CREATE TABLE `currency_settlement` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `invoiceCurrencyId` bigint(20) NOT NULL,
  `receiptCurrencyId` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_currency_settlement_invoiceCurrencyToCurrency_idx` (`invoiceCurrencyId`),
  KEY `fk_currency_settlement_receiptCurrencyToCurrency_idx` (`receiptCurrencyId`),
  CONSTRAINT `fk_currency_settlement_invoiceCurrencyToCurrency` FOREIGN KEY (`invoiceCurrencyId`) REFERENCES `currency` (`id`),
  CONSTRAINT `fk_currency_settlement_receiptCurrencyToCurrency` FOREIGN KEY (`receiptCurrencyId`) REFERENCES `currency` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  END IF;

END $$

-- Execute the stored procedure
CALL V202001151613__CreateCurrencySettlementTable() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001151613__CreateCurrencySettlementTable $$
 
DELIMITER ;