DELIMITER $$

DROP PROCEDURE IF EXISTS V202001170638__EntryPersonGenderId $$

CREATE PROCEDURE V202001170638__EntryPersonGenderId()

BEGIN

  IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='persons' 
  AND column_name='genderId')) THEN

    SET SQL_SAFE_UPDATES = 0;

	Update persons as T1 INNER JOIN gender as T2 ON (T1.gender = T2.itemCode)
	SET T1.genderId = T2.id 
	WHERE T1.gender IS NOT NULL;
    
	SET SQL_SAFE_UPDATES = 1;
	
  END IF;

END $$

CALL V202001170638__EntryPersonGenderId $$

DROP PROCEDURE IF EXISTS V202001170638__EntryPersonGenderId $$

DELIMITER ;